/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.TimerTaskBase;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.sql.SQLException;
import java.util.TimerTask;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.mgmt.impl.DataSourceDeployer;
import org.sourceid.saml20.domain.mgmt.impl.DataSourceManagerImpl;
import org.sourceid.saml20.domain.mgmt.impl.SecretManagerConnectionFactory;

public class DBCPDataSourceDeployer
extends DataSourceDeployer {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConfigStore store = ConfigStoreFarm.getConfig("org.sourceid.saml20.domain.mgmt.impl.DBCPDataSourceDeployer");

    public DBCPDataSourceDeployer(DataSourceManagerImpl dataSourceManager) throws Exception {
        super(dataSourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deployDatasource(JdbcDataSource jdbcDataSource) {
        BasicDataSource existingDS = null;
        try {
            InitialContext ic = new InitialContext();
            BasicDataSource ds = new BasicDataSource();
            if (!jdbcDataSource.getId().equals("PFIndexDS")) {
                ds.setJmxName("org.apache.dbcp:DataSource.Id=" + jdbcDataSource.getId() + ",DataSource.Name=" + jdbcDataSource.getDsName());
            }
            if (SecretReferenceUtil.isSecretReference((String)jdbcDataSource.getPassword())) {
                ds.setConnectionFactoryClassName(SecretManagerConnectionFactory.class.getName());
            }
            ds.setUrl(this.replaceSystemProperties(jdbcDataSource.getConnectionUrlForNode()));
            if (StringUtils.isNotBlank((String)jdbcDataSource.getUserName())) {
                ds.setUsername(jdbcDataSource.getUserName());
            }
            if (StringUtils.isNotBlank((String)jdbcDataSource.getPassword())) {
                ds.setPassword(jdbcDataSource.getPassword());
            }
            if (!StringUtils.isEmpty((String)jdbcDataSource.getCheckValidConnectionSql())) {
                ds.setValidationQuery(jdbcDataSource.getCheckValidConnectionSql());
            }
            if (jdbcDataSource.getBlockingTimeoutMillis() >= -1) {
                ds.setMaxWaitMillis((long)jdbcDataSource.getBlockingTimeoutMillis());
            }
            if (jdbcDataSource.getMinPoolSize() >= 0) {
                ds.setMinIdle(jdbcDataSource.getMinPoolSize());
                ds.setInitialSize(jdbcDataSource.getMinPoolSize());
            }
            if (jdbcDataSource.getMaxPoolSize() >= 0) {
                ds.setMaxIdle(jdbcDataSource.getMaxPoolSize());
                ds.setMaxTotal(jdbcDataSource.getMaxPoolSize());
            }
            if (jdbcDataSource.getIdleTimeoutMinutes() >= 0) {
                long limitInMilliseconds = (long)jdbcDataSource.getIdleTimeoutMinutes() * 60L * 1000L;
                ds.setTimeBetweenEvictionRunsMillis(limitInMilliseconds);
                if (this.isCloseIdleConnectionsLowerThanMinPoolSize()) {
                    ds.setMinEvictableIdleTimeMillis(limitInMilliseconds);
                } else {
                    ds.setMinEvictableIdleTimeMillis(-1L);
                    ds.setSoftMinEvictableIdleTimeMillis(limitInMilliseconds);
                    ds.setTestWhileIdle(this.isTestWhileIdleEnabled());
                }
                ds.setNumTestsPerEvictionRun(Math.max(jdbcDataSource.getMaxPoolSize() - jdbcDataSource.getMinPoolSize(), jdbcDataSource.getMinPoolSize()));
            }
            String datasourceName = jdbcDataSource.getJndiName();
            try {
                existingDS = (BasicDataSource)ic.lookup(datasourceName);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            ic.rebind(datasourceName, (Object)ds);
            this.log.debug((Object)("Deployed datasource: " + datasourceName));
            try {
                Class.forName(jdbcDataSource.getDriverClass());
            }
            catch (Exception e1) {
                this.log.error((Object)("Error initializing Database Connection pool. " + e1.getMessage()));
                this.log.debug((Object)e1);
            }
            if (existingDS != null) {
                this.closeDataSource((DataSource)existingDS);
            }
        }
        catch (NamingException e) {
            this.log.error((Object)("Problem with datasource deployment. " + e.getMessage()));
            this.log.debug((Object)e);
        }
        finally {
            if (existingDS != null) {
                this.closeDataSource((DataSource)existingDS);
            }
        }
    }

    @Override
    public void undeployDatasource(String jndiName) {
        try {
            InitialContext ic = new InitialContext();
            BasicDataSource d = (BasicDataSource)ic.lookup(jndiName);
            this.closeDataSource((DataSource)d);
            ic.unbind(jndiName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Override
    protected void closeDataSource(final DataSource ds2) {
        TimerTaskBase timerTask = new TimerTaskBase(){

            @Override
            public void doTask() {
                BasicDataSource ds = (BasicDataSource)ds2;
                if (ds != null) {
                    try {
                        ds.close();
                    }
                    catch (SQLException e) {
                        this.log.error((Object)("Unable to close data source connection: " + e.getMessage()));
                    }
                }
            }
        };
        this.timer.schedule((TimerTask)timerTask, 10000L);
    }

    private boolean isCloseIdleConnectionsLowerThanMinPoolSize() {
        return this.store.getBooleanValue("CloseIdleConnectionsBelowMinPoolSize", false);
    }

    private boolean isTestWhileIdleEnabled() {
        return this.store.getBooleanValue("TestIdleConnections", true);
    }
}

