/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.x2006.x07.dnToIdpMappings.DnToIdpMappingsDocument;
import com.pingidentity.x2006.x07.dnToIdpMappings.DnToIdpMappingsType;
import com.pingidentity.x2006.x07.dnToIdpMappings.MapType;
import com.pingidentity.x2006.x07.dnToIdpMappings.MappingsType;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.DNtoIdPMappings;
import org.sourceid.saml20.domain.DNtoIdpMap;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.DNtoIdPMappingsManager;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;

public class DNtoIdPMappingsManagerImpl
extends ConfigManagerBase
implements DNtoIdPMappingsManager,
AutoReloadable {
    private static final String XML_FILE_NAME = "pingfederate-dn-to-idp-mappings.xml";
    private DNtoIdPMappings idpMappings;

    public DNtoIdPMappingsManagerImpl() {
        this.loadConfig();
    }

    @Override
    public synchronized void save(DNtoIdPMappings mappings) {
        List<DNtoIdpMap> subjectMapList;
        DnToIdpMappingsDocument doc = DnToIdpMappingsDocument.Factory.newInstance();
        DnToIdpMappingsType mappingsType = doc.addNewDnToIdpMappings();
        mappingsType.setDefaultIdp(mappings.getDefaultIdp());
        List<DNtoIdpMap> issuerMapList = mappings.getIssuerDNMapList();
        if (!issuerMapList.isEmpty()) {
            MappingsType issuerMappingsType = mappingsType.addNewIssuerMappings();
            for (DNtoIdpMap map : issuerMapList) {
                MapType maptype = issuerMappingsType.addNewMap();
                maptype.setDn(map.getDn());
                maptype.setIdp(map.getIdpId());
            }
        }
        if (!(subjectMapList = mappings.getSubjectDNMapList()).isEmpty()) {
            MappingsType subjectMappingsType = mappingsType.addNewSubjectMappings();
            for (DNtoIdpMap map : subjectMapList) {
                MapType maptype = subjectMappingsType.addNewMap();
                maptype.setDn(map.getDn());
                maptype.setIdp(map.getIdpId());
            }
        }
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), XML_FILE_NAME, (XmlObject)doc);
            auditLoggerScope.log(AdminAuditLogger.Component.ATTRIBUTE_REQUESTOR, AdminAuditLogger.Event.MODIFY);
        }
        this.loadConfig();
    }

    private synchronized void loadConfig() {
        this.idpMappings = DNtoIdPMappingsManagerImpl.getMappings(this.xmlLoader, this.sysDirInfo);
    }

    static DNtoIdPMappings getMappings(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        DNtoIdpMap idpMap;
        List<DNtoIdpMap> list;
        DnToIdpMappingsDocument doc;
        DNtoIdPMappings idpMappings = new DNtoIdPMappings();
        String dataDir = sysDirInfo.getDataDirectory();
        try {
            doc = (DnToIdpMappingsDocument)xmlLoader.load(dataDir, XML_FILE_NAME);
        }
        catch (ConfigurationException e) {
            doc = DnToIdpMappingsDocument.Factory.newInstance();
            doc.addNewDnToIdpMappings();
        }
        DnToIdpMappingsType dnToIdpMappingsType = doc.getDnToIdpMappings();
        MappingsType issuerMappings = dnToIdpMappingsType.getIssuerMappings();
        MappingsType subjectMappings = dnToIdpMappingsType.getSubjectMappings();
        if (issuerMappings != null) {
            MapType[] issuerMapArray = issuerMappings.getMapArray();
            list = idpMappings.getIssuerDNMapList();
            for (MapType map : issuerMapArray) {
                idpMap = new DNtoIdpMap(map.getDn(), map.getIdp());
                list.add(idpMap);
            }
        }
        if (subjectMappings != null) {
            MapType[] subjectMapArray = subjectMappings.getMapArray();
            list = idpMappings.getSubjectDNMapList();
            for (MapType map : subjectMapArray) {
                idpMap = new DNtoIdpMap(map.getDn(), map.getIdp());
                list.add(idpMap);
            }
        }
        idpMappings.setDefaultIdp(dnToIdpMappingsType.getDefaultIdp());
        return idpMappings;
    }

    @Override
    public synchronized DNtoIdPMappings get(boolean useCached) {
        return useCached ? this.idpMappings : DNtoIdPMappingsManagerImpl.getMappings(this.xmlLoader, this.sysDirInfo);
    }

    @Override
    public boolean isConnectionInUseByMapping(IdpConnection conn) {
        return !this.getDNUsingConnection(conn).isEmpty();
    }

    @Override
    public List<String> getDNUsingConnection(IdpConnection conn) {
        ArrayList<String> dnList = new ArrayList<String>();
        for (DNtoIdpMap l : this.idpMappings.getIssuerDNMapList()) {
            if (!conn.getName().equals(l.getIdpName())) continue;
            dnList.add(l.getDn());
        }
        for (DNtoIdpMap l : this.idpMappings.getSubjectDNMapList()) {
            if (!conn.getName().equals(l.getIdpName())) continue;
            dnList.add(l.getDn());
        }
        return dnList;
    }
}

