/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.SimpleFileUtil;
import com.pingidentity.configservice.SysDirInfo;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.LocalTime;
import org.joda.time.format.ISODateTimeFormat;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DataArchiveBackup {
    private final Log log = LogFactory.getLog(this.getClass());
    private ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
    public static final String ARCHIVE_DIR = "archive";
    private Timer timer;

    public void cancelBackup() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void scheduleBackup() {
        if (this.config.getBooleanValue("ScheduledBackupEnabled", true)) {
            this.scheduleDataArchiveBackup();
        }
    }

    private void scheduleDataArchiveBackup() {
        Date scheduledDate = null;
        LocalTime localTime = ISODateTimeFormat.timeParser().parseLocalTime(this.config.getStringValue("BackupTime", "00:00:00"));
        scheduledDate = !localTime.toDateTimeToday().isAfterNow() ? localTime.toDateTimeToday().plusDays(1).toDate() : localTime.toDateTimeToday().toDate();
        this.timer = new Timer(this.getClass().getName() + " timer", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    DataArchiveBackup.this.backupDataArchive();
                }
                catch (IOException e) {
                    DataArchiveBackup.this.log.error((Object)"Backup creation failed", (Throwable)e);
                }
            }
        }, scheduledDate, 86400000L);
        this.log.debug((Object)("Data archive backup scheduled for: '" + localTime.getHourOfDay() + ":" + localTime.getMinuteOfHour() + ":" + localTime.getSecondOfMinute() + "'"));
    }

    public void backupDataArchive() throws IOException {
        MgmtFactory.getMediator().reloadConfigChangeDate();
        if (this.hasDataConfigChangedSinceLastBackup()) {
            this.log.debug((Object)"Data config has changed since last backup, backing up.");
            File backupFile = MgmtFactory.getMediator().backup();
            this.log.debug((Object)("Data archive backup complete. Archive located at: '" + backupFile.getAbsolutePath() + "'"));
        } else {
            this.log.debug((Object)"Data archive hasn't changed since last backup, skipping backup.");
        }
    }

    private boolean hasDataConfigChangedSinceLastBackup() {
        File dir = new File(this.sysDirInfo.getDataDirectory(), ARCHIVE_DIR);
        File[] files = dir.listFiles();
        if (files != null) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file, File file1) {
                    long l = file1.lastModified() - file.lastModified();
                    return Long.signum(l);
                }
            });
            return files.length == 0 || files.length > 0 && files[0].lastModified() < MgmtFactory.getMediator().getConfigChangeDate(false).getTime();
        }
        return true;
    }

    public File backupConfig(byte[] zippedConfig) {
        File[] files;
        File dir = new File(this.sysDirInfo.getDataDirectory(), ARCHIVE_DIR);
        String formatPattern = "MM-dd-yyyy.kk.mm.ss";
        formatPattern = this.config.getStringValue("DateFormatPattern", formatPattern);
        SimpleDateFormat format = new SimpleDateFormat(formatPattern);
        String dateStr = format.format(new Date());
        File archive = new File(dir, "data-" + dateStr + ".zip");
        this.writeFile(archive, zippedConfig);
        int maxOldFiles = this.config.getIntValue("MaxOldArchiveFiles", 25);
        if (dir != null && (files = dir.listFiles()) != null && files.length > maxOldFiles) {
            this.sortFilesByTimestampDescending(files);
            for (int index = 0; index < files.length - maxOldFiles; ++index) {
                if (files[index].delete()) continue;
                this.log.info((Object)("unable to delete old archive file: " + files[index]));
            }
        }
        return archive;
    }

    private void sortFilesByTimestampDescending(File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File file, File file1) {
                long l = file.lastModified() - file1.lastModified();
                return Long.signum(l);
            }
        });
    }

    private void writeFile(File file, byte[] content) {
        this.log.debug((Object)("Writing file: " + file));
        SimpleFileUtil.writeFileSilent(file, content);
    }

    public boolean isBackupOnAdminLogin() {
        return this.config.getBooleanValue("BackupOnAdminLogin", true);
    }
}

