/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.upgrade.DataDirectoryMigrator;
import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.PingFederateDirectoryInfo;
import com.pingidentity.common.upgrade.Utils;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.FileHandlingException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.common.upgrade.exception.UnsupportedUpgradeVersionException;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.SimpleFileUtil;
import com.pingidentity.common.util.zip.UnzipUtil;
import com.pingidentity.configservice.ConfigUpdateCoordinator;
import com.pingidentity.configservice.ConfigUpdateType;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.jwk.MasterKeySet;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.monitoring.ThreadPoolExhaustionService;
import com.pingidentity.reencryption.KeyInUseHandler;
import com.pingidentity.reencryption.PFEncryptionFilter;
import com.pingidentity.reencryption.ReencryptUtils;
import com.pingidentity.reencryption.ReencryptionTarget;
import com.pingidentity.reencryption.Replacement;
import com.pingidentity.reencryption.ValueReencryptor;
import com.pingidentity.reencryption.filescanner.FileScanner;
import com.pingidentity.sdk.notification.NotificationEventType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.common.VersionUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.DataUpgradeConfigUtils;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.mgmt.DataDirectoryManager;
import org.sourceid.mgmt.InstanceMetadataManager;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.DataDeployerManager;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProvider;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProviderManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.ReplicationStateManager;
import org.sourceid.saml20.domain.mgmt.TimerTaskManager;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.DataValidator;
import org.sourceid.saml20.domain.mgmt.impl.DeploymentOption;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;

public class DataDeployer {
    public static final String DEPLOYER_DIR = "drop-in-deployer";
    public static final String DATA_ZIP_FILE = "data.zip";
    public static final String ARCHIVE_DIR = "archive";
    public static final String CONFIG_STORE_FORCE_IMPORT_NAME = "ForceImport";
    private static final String DATA_UPGRADE_FAILED = "Failed to perform data upgrade, please check the server logs for more information.";
    private static final String PF_JWK = "pf.jwk";
    private static final String CONFIG_STORE_FOLDER_NAME = "config-store";
    private static final Log log = LogFactory.getLog(DataDeployer.class);
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private final SysDirInfo sysDirInfo = MgmtFactory.getSysDirInfo();
    private final NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
    private final Mediator mediator = MgmtFactory.getMediator();
    private final DeltaReplicationProviderManager replProviderManager = MgmtFactory.getDeltaReplicationProviderManager();
    private final AdminUserManager nativeAdminUserManager = MgmtFactory.getNativeAdminUserManager();
    private final MasterKeySet masterKeySet = MgmtFactory.getMasterKeySet();
    private final ReplicationStateManager replicationStateManager = MgmtFactory.getReplicationStateManager();
    private final TimerTaskManager timerTaskManager = MgmtFactory.getTimerTaskManager();
    private final ClientManager clientManager = MgmtFactory.getClientManager();
    private final InstanceMetadataManager instanceMetadataManager = MgmtFactory.getInstanceMetadataManager();
    private final AdminNodeConfigManager adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();
    private final DataDeployerManager dataDeployerManager = MgmtFactory.getDataDeployerManager();
    private final DataDirectoryManager dataDirectoryManager = MgmtFactory.getDataDirectoryManager();
    private final boolean isForceImport = this.config.getBooleanValue("ForceImport", true);

    public DeployDataResult attemptDeployData() {
        DeployArchiveResult result;
        File zippedDataFile;
        block17: {
            String archiveFileName;
            block16: {
                zippedDataFile = this.getZippedDataFile();
                if (!zippedDataFile.exists()) {
                    return DeployDataResult.NOTHING_TO_DEPLOY;
                }
                log.info((Object)("Deploying: " + zippedDataFile));
                Map<String, byte[]> map = Collections.emptyMap();
                try {
                    map = UnzipUtil.unzip(zippedDataFile);
                }
                catch (IOException e) {
                    log.error((Object)"Problem writing data", (Throwable)e);
                }
                archiveFileName = FilesUtils.removeZipExtension((String)zippedDataFile.getName());
                boolean forceUnsupportedImport = this.config.getBooleanValue("ForceUnsupportedImport", false);
                boolean reencryptArchive = this.config.getBooleanValue("ReencryptArchive", false);
                result = this.deployArchive(map, archiveFileName, this.isForceImport(), forceUnsupportedImport, reencryptArchive, null);
                if (!result.isSuccess()) break block16;
                switch (result.getType()) {
                    case UPGRADE: {
                        log.info((Object)String.format("Upgrade from config archive \"%s\" completed successfully.", archiveFileName));
                        break block17;
                    }
                    case IMPORT: {
                        log.info((Object)"Config archive import completed successfully.");
                        break block17;
                    }
                    default: {
                        log.error((Object)("Unknown deploy archive result type: " + result.getType()));
                        return DeployDataResult.FAILURE;
                    }
                }
            }
            switch (result.getType()) {
                case UPGRADE: {
                    if (!result.getUpgradeErrors().isEmpty()) break;
                    if (!result.getValidationErrors().isEmpty()) {
                        if (this.isForceImport()) {
                            log.info((Object)String.format("Upgrade from config archive \"%s\" completed successfully.", archiveFileName));
                            result = DeployArchiveResult.createSuccessResult(DeployArchiveType.UPGRADE);
                            break;
                        }
                        log.error((Object)"Data integrity validation failed during upgrade. Please address the issues below and retry.");
                        for (String validationError : result.validationErrors) {
                            log.error((Object)validationError);
                        }
                        break;
                    }
                    throw new RuntimeException("This condition should never happen");
                }
                case IMPORT: {
                    break;
                }
                default: {
                    log.error((Object)("Unknown deploy archive result type: " + result.getType()));
                    return DeployDataResult.FAILURE;
                }
            }
        }
        try {
            this.replicateAfterDropInDeploy(result);
        }
        catch (IOException e) {
            log.error((Object)"Problem encountered trying to replicate after successful drop-in deployment. Please address the issue and retry replication.", (Throwable)e);
        }
        AdminAuditLogger.log(AdminAuditLogger.Component.DEPLOYER, AdminAuditLogger.Event.DEPLOY, zippedDataFile.getName());
        SimpleFileUtil.renameWithDateExt(zippedDataFile);
        return result.isSuccess() ? DeployDataResult.SUCCESS : DeployDataResult.FAILURE;
    }

    private void replicateAfterDropInDeploy(DeployArchiveResult result) throws IOException {
        if (this.shouldReplicateAfterDeploy()) {
            if (result.isSuccess()) {
                log.info((Object)"Replicating after successful drop-in deployment.");
                this.mediator.publishConfig();
            } else {
                log.warn((Object)"Skipping replication due to drop-in deployment process failure.");
            }
        }
    }

    public boolean shouldReplicateAfterDeploy() {
        boolean isActivePassiveConsoleEnabled = this.adminNodeConfigManager.isEnabled();
        boolean isDistributable = this.mediator.isDistributable();
        boolean isConsole = this.mediator.isConsole();
        boolean isActiveConsole = this.adminNodeConfigManager.isActiveNode();
        log.debug((Object)("isDistributable: " + isDistributable + ", isActivePassiveConsoleEnabled: " + isActivePassiveConsoleEnabled + ", isConsole: " + isConsole + ", isActiveConsole: " + isActiveConsole));
        if (!isDistributable) {
            log.debug((Object)"shouldReplicateAfterDeploy(): false. PF is not running as a cluster.");
            return false;
        }
        boolean replicateAfterDropInDeployEnabled = MgmtFactory.getConfigReplicationService().isReplicateAfterDropInDeploy();
        log.debug((Object)("replicateAfterDropInDeployEnabled: " + replicateAfterDropInDeployEnabled));
        if (!replicateAfterDropInDeployEnabled) {
            log.debug((Object)"shouldReplicateAfterDeploy(): false. Replication after drop-in deploy is not enabled.");
            return false;
        }
        if (!isActivePassiveConsoleEnabled && !isConsole) {
            log.debug((Object)"shouldReplicateAfterDeploy(): false. Active-passive console is disabled and this node is not a console node.");
            return false;
        }
        if (isActivePassiveConsoleEnabled && !isActiveConsole) {
            log.debug((Object)"shouldReplicateAfterDeploy(): false. Active-passive console is enabled and this is not an active node.");
            return false;
        }
        log.debug((Object)"shouldReplicateAfterDeploy(): true.");
        return true;
    }

    private void deployToFilesystem(String directory, Map<String, byte[]> archiveToImport) throws IOException {
        log.debug((Object)"Deploying archive to file system");
        boolean exceptionWritingFile = false;
        archiveToImport.remove("archive-metadata");
        archiveToImport.remove("instance/metadata.xml");
        for (Map.Entry<String, byte[]> archiveFile : archiveToImport.entrySet()) {
            if (this.isValidFilePath(directory, archiveFile.getKey())) {
                File file = new File(directory, archiveFile.getKey());
                if (archiveFile.getValue().length <= 0) continue;
                try {
                    this.writeFile(file, archiveFile.getValue());
                }
                catch (IOException e) {
                    exceptionWritingFile = true;
                    log.error((Object)("Cannot write file: " + file.getAbsolutePath()), (Throwable)e);
                }
                continue;
            }
            String msg = String.format("Skipped extracting '%s' entry from the data archive. Normalized file path does not match with '%s' base path.", archiveFile.getKey(), directory);
            log.warn((Object)msg);
        }
        if (exceptionWritingFile) {
            throw new IOException("error writing file(s)");
        }
    }

    private void writeFile(File file, byte[] content) throws IOException {
        log.trace((Object)("Writing file: " + file));
        SimpleFileUtil.writeFile(file, content);
    }

    private File getZippedDataFile() {
        return new File(this.getDeployerDir(), DATA_ZIP_FILE);
    }

    private File getDeployerDir() {
        return new File(this.sysDirInfo.getDataDirectory(), DEPLOYER_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> deployAndValidate(Map<String, byte[]> archiveToImport, boolean forceImport, boolean reencrypt, boolean forceUnsupportedImport, String fileName, AdministrativeUser userMakingRequest) {
        try {
            ConfigUpdateCoordinator.getInstance().setUpdateInProgress(ConfigUpdateType.FULL_CONFIG_RELOAD);
            HashMap<String, AdministrativeUser> origUsers = new HashMap<String, AdministrativeUser>(this.nativeAdminUserManager.getUsersMap());
            NotificationSettings originalNotificationSettings = this.notificationMgr.getNotificationSettings();
            String origAdminAccChgNotificationPublisherId = originalNotificationSettings.getNotificationPublisherAccountChanges();
            NotificationSenderPluginInstance origAdminAccChgNotificationPublisher = NotificationSupportHelper.getNotificationPublisherForAuditLogDiff(origAdminAccChgNotificationPublisherId);
            List<String> retList = this.deployAndValidate2(archiveToImport, forceImport, reencrypt, forceUnsupportedImport);
            if (retList.isEmpty() || forceImport) {
                Object adminAuditMessage = fileName;
                if (reencrypt) {
                    adminAuditMessage = (String)adminAuditMessage + ", reencrypted";
                }
                AdminAuditLogger.log(AdminAuditLogger.Component.CONFIG_ARCHIVE, AdminAuditLogger.Event.IMPORT, (String)adminAuditMessage);
                NotificationSettings settings = this.notificationMgr.getNotificationSettings();
                HashMap<String, AdministrativeUser> latestUsers = new HashMap<String, AdministrativeUser>(this.nativeAdminUserManager.getUsersMap());
                NotificationSupportHelper.auditLogAdminAccountsNotificationPublisher(originalNotificationSettings.isEnableAccountChangesNotification(), origAdminAccChgNotificationPublisher);
                this.logAndNotifySensitiveChanges(userMakingRequest, origUsers, latestUsers, originalNotificationSettings, settings);
            }
            List<String> list = retList;
            return list;
        }
        finally {
            ConfigUpdateCoordinator.getInstance().clearUpdateInProgress();
        }
    }

    public void logAndNotifySensitiveChanges(AdministrativeUser userMakingRequest, Map<String, AdministrativeUser> origUsers, Map<String, AdministrativeUser> latestUsers, NotificationSettings origNotificationSettings, NotificationSettings latestNotificationSettings) {
        this.notifyIfNotifyFlagIsSwitchingOff(userMakingRequest, origUsers, latestUsers, origNotificationSettings, latestNotificationSettings);
        this.logAndNotifyAdminUserChanges(userMakingRequest, origUsers, latestUsers, origNotificationSettings, latestNotificationSettings);
    }

    private void notifyIfNotifyFlagIsSwitchingOff(AdministrativeUser userMakingRequest, Map<String, AdministrativeUser> origUsers, Map<String, AdministrativeUser> latestUsers, NotificationSettings originalNotificationSettings, NotificationSettings settings) {
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        if (notificationSupportHelper.isNotifyFlagSwitchingOff(originalNotificationSettings.isEnableAccountChangesNotification(), settings.isEnableAccountChangesNotification())) {
            notificationSupportHelper.sendNotificationsChangeEmail(settings, userMakingRequest, latestUsers, origUsers, settings.getNotificationPublisherAccountChanges(), NotificationEventType.ADMIN_ACCOUNT_CHANGE_NOTIFICATION_OFF, "Notify administrator of account changes");
        }
    }

    private void logAndNotifyAdminUserChanges(AdministrativeUser userMakingRequest, Map<String, AdministrativeUser> origUsers, Map<String, AdministrativeUser> latestUsers, NotificationSettings origNotificationSettings, NotificationSettings settings) {
        origUsers = new HashMap<String, AdministrativeUser>(origUsers);
        latestUsers = new HashMap<String, AdministrativeUser>(latestUsers);
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        Iterator<Map.Entry<String, AdministrativeUser>> latestUsersIt = latestUsers.entrySet().iterator();
        while (latestUsersIt.hasNext()) {
            Map.Entry<String, AdministrativeUser> updatedUser = latestUsersIt.next();
            AdministrativeUser origUser = origUsers.remove(updatedUser.getKey());
            if (origUser == null) continue;
            if (!updatedUser.getValue().getHash().equals(origUser.getHash())) {
                AdminAuditLogger.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.MODIFY, "Password change detected for administrator '" + origUser.getUserName() + "'");
                if (origNotificationSettings.isEnableAccountChangesNotification()) {
                    notificationSupportHelper.sendPasswordChangeEmail(userMakingRequest, updatedUser.getValue(), settings);
                }
            }
            if (notificationSupportHelper.isUserEmailChanged(origUser, updatedUser.getValue())) {
                AdminAuditLogger.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.MODIFY, "Email change detected for administrator '" + origUser.getUserName() + "'");
                if (origNotificationSettings.isEnableAccountChangesNotification()) {
                    notificationSupportHelper.sendEmailChangeEmail(userMakingRequest, updatedUser.getValue(), origUser, settings);
                }
            }
            latestUsersIt.remove();
        }
        for (AdministrativeUser origUser : origUsers.values()) {
            AdminAuditLogger.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.DELETE, "Administrator '" + origUser.getUserName() + "' was deleted");
        }
        for (AdministrativeUser newUser : latestUsers.values()) {
            AdminAuditLogger.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.CREATE, "Administrator '" + newUser.getUserName() + "' was created");
        }
    }

    private List<String> deployAndValidate2(Map<String, byte[]> archiveToImport, boolean forceImport, boolean reencrypt, boolean forceUnsupportedImport) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!this.isValidArchive(archiveToImport)) {
            errorMessages.add("Invalid data archive.");
        } else {
            Object versionError = this.checkArchiveVersion(archiveToImport);
            if (versionError != null) {
                if (forceUnsupportedImport) {
                    versionError = (String)versionError + "Proceeding with archive deployment.";
                    log.warn(versionError);
                    AdminAuditLogger.log(AdminAuditLogger.Component.CONFIG_ARCHIVE, AdminAuditLogger.Event.IMPORT, (String)versionError);
                } else {
                    versionError = (String)versionError + "Halting archive deployment. To allow deployment of unsupported archives, set the value of the ForceUnsupportedImport configuration option in server/default/data/config-store/org.sourceid.saml20.domain.mgmt.impl.DataDeployer.xml to true.";
                    errorMessages.add((String)versionError);
                    for (String errorMessage : errorMessages) {
                        log.error((Object)errorMessage);
                    }
                    return errorMessages;
                }
            }
            archiveToImport.remove("archive-metadata");
            archiveToImport.remove("instance/metadata.xml");
            JsonWebKeySet oldKeySet = this.masterKeySet.getJsonWebKeySet();
            if (reencrypt) {
                try {
                    this.reencryptArchive(archiveToImport, oldKeySet);
                }
                catch (Exception e) {
                    errorMessages.add("Could not reencrypt data archive.");
                    log.error((Object)"Could not reencrypt data archive", (Throwable)e);
                }
            }
            byte[] originalConfig = this.backupAndResetData(errorMessages, reencrypt, false);
            if (errorMessages.isEmpty()) {
                archiveToImport.remove("config-store/com.pingidentity.draft.mgmt.DraftManagerImpl.xml");
                archiveToImport.remove("ping-ssl-client-trust-cas.jks");
                try {
                    this.deployToFilesystem(this.sysDirInfo.getDataDirectory(), archiveToImport);
                    this.mediator.reloadConfiguration();
                    this.reencryptInstanceFiles(oldKeySet);
                    this.mergeMasterKeySets(oldKeySet);
                }
                catch (Throwable t) {
                    errorMessages.add("Error while loading configuration. " + t.getMessage());
                    log.error((Object)"Error while loading configuration", t);
                }
                DataValidator dataValidator = new DataValidator();
                errorMessages.addAll(dataValidator.validate());
                boolean rollback = !errorMessages.isEmpty() && !forceImport;
                this.rollBackOrResetState(errorMessages, originalConfig, rollback);
            }
        }
        for (String errorMessage : errorMessages) {
            log.error((Object)errorMessage);
        }
        return errorMessages;
    }

    public void rollBackOrResetState(List<String> allErrors, byte[] originalConfig, boolean rollback) {
        try {
            this.finish(rollback, originalConfig);
        }
        catch (ConfigurationException t) {
            String message = "Error while " + (rollback ? "rolling back" : "deploying") + " configuration.";
            allErrors.add(message + " " + t.getMessage());
            log.error((Object)message, (Throwable)t);
        }
    }

    private byte[] backupAndResetData(List<String> allErrors, boolean reencrypt, boolean enableDataUpgrade) {
        byte[] originalConfig = new byte[]{};
        try {
            originalConfig = this.dataDirectoryManager.backup();
            allErrors.addAll(this.reset(false, reencrypt, enableDataUpgrade));
        }
        catch (IOException e) {
            log.error((Object)"Backup failed", (Throwable)e);
            allErrors.add("Backup failed. Please check the server logs.");
        }
        return originalConfig;
    }

    private List<String> performDataUpgrade(Map<String, byte[]> archiveToImport, String archiveFileName, Version sourcePFVersion, Version destPFVersion, JsonWebKeySet currentKeySet, boolean reencrypt) {
        log.info((Object)("Performing data upgrade for archive: " + archiveFileName + " from PingFederate version " + sourcePFVersion.toString() + " to version " + destPFVersion.toString()));
        ArrayList<String> errors = new ArrayList<String>();
        String sourcePFVersionPath = FilesUtils.removeZipExtension((String)archiveFileName) + File.separator + "archive-metadata";
        PingFederateDirectoryInfo dirInfo = PingFederateDirectoryInfo.getInstance();
        try {
            String destRootDir = this.sysDirInfo.getRootDir();
            dirInfo.setDestinationRootDir(destRootDir);
            String tempSourceDataDir = this.copyArchiveToTempDirectory(archiveToImport, destRootDir);
            String destDataDir = destRootDir + dirInfo.getRelativeDataDir();
            dirInfo.setHomeDir(this.sysDirInfo.getUpgradeDir());
            String referenceFilesDir = this.sysDirInfo.getUpgradeReferenceFilesDir();
            Version sourceReferencePFVersion = Utils.resolveClosestSupportedSourceVersion((Version)sourcePFVersion, (Version)destPFVersion, (String)referenceFilesDir, (String)sourcePFVersionPath);
            dirInfo.setSourcePFVersion(sourceReferencePFVersion.toString());
            Utils.unzipDefaultPFInstall((String)referenceFilesDir, (Version)sourceReferencePFVersion);
            DataDirectoryMigrator dataDirectoryMigrator = new DataDirectoryMigrator(tempSourceDataDir, destDataDir, sourcePFVersion.toString(), destPFVersion.toString(), dirInfo, null);
            dataDirectoryMigrator.migrateDataDirectory();
        }
        catch (IOException e) {
            errors.add(DATA_UPGRADE_FAILED);
            log.error((Object)String.format("Failed to perform data upgrade: %s", e.getMessage()));
            log.debug((Object)"Failed to perform data upgrade", (Throwable)e);
        }
        catch (FileHandlingException e) {
            errors.add(DATA_UPGRADE_FAILED);
            log.error((Object)String.format("Error unzipping default Pingfederate install: %s", e.getMessage()));
            log.debug((Object)"Error unzipping default Pingfederate install", (Throwable)e);
        }
        catch (UnsupportedUpgradeVersionException e) {
            errors.add(DATA_UPGRADE_FAILED);
            log.error((Object)String.format("Error finding closest supported source version or source version is not eligible for upgrade: %s", e.getMessage()));
            log.debug((Object)"Error finding closest supported source version or source version is not eligible for upgrade", (Throwable)e);
        }
        catch (MigrationException e) {
            errors.add(DATA_UPGRADE_FAILED);
            log.error((Object)String.format("Error migrating data directory: %s", e.getMessage()));
            log.debug((Object)"Error migrating data directory", (Throwable)e);
        }
        if (errors.isEmpty()) {
            try {
                if (!reencrypt) {
                    this.masterKeySet.reload();
                }
                this.mergeMasterKeySets(currentKeySet);
                this.reencryptInstanceFiles(currentKeySet);
                this.mediator.reloadConfiguration();
            }
            catch (Throwable t) {
                errors.add(DATA_UPGRADE_FAILED);
                log.error((Object)String.format("Error while reloading config. Unable to complete the  upgrade: %s", t.getMessage()));
                log.debug((Object)"Error while reloading config. Unable to complete the  upgrade", t);
            }
        }
        String pathname = this.sysDirInfo.getRootDir() + File.separator + "temp-source-data-archive";
        String absolutePath = Paths.get(pathname, new String[0]).normalize().toFile().getAbsolutePath();
        Utils.deleteFolder((File)new File(absolutePath));
        return errors;
    }

    private String copyArchiveToTempDirectory(Map<String, byte[]> archiveToImport, String tempDir) throws IOException {
        File targetDirectory = new File(tempDir + File.separator + "temp-source-data-archive");
        if (targetDirectory.exists()) {
            FileUtils.deleteDirectory((File)targetDirectory);
        }
        if (!targetDirectory.mkdirs()) {
            throw new IOException("Failed to create directory: " + targetDirectory.getAbsolutePath());
        }
        if (archiveToImport == null || archiveToImport.isEmpty()) {
            throw new IOException("No archive data found to deploy.");
        }
        try {
            this.deployToFilesystem(targetDirectory.getAbsolutePath(), archiveToImport);
        }
        catch (IOException e) {
            throw new IOException("Error extracting files to the filesystem", e);
        }
        return targetDirectory.getAbsolutePath();
    }

    public void finish(boolean rollback, byte[] originalConfig) {
        if (rollback) {
            this.dataDirectoryManager.restore(originalConfig);
            log.error((Object)"Errors were detected with the imported configuration.  Reverted back to the original configuration.");
        } else {
            this.replicationStateManager.clearReplicationState();
            this.timerTaskManager.scheduleTasks();
            ThreadPoolExhaustionService.getInstance().start();
            this.replProviderManager.getReplicationProviders().forEach(DeltaReplicationProvider::clearReplicationState);
            if (ModeSupport.isEngine()) {
                this.mediator.configurePlugins();
            }
        }
    }

    public List<String> reset(boolean bulkImport, boolean reencrypt, boolean enableDataUpgrade) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        File dataDefault = new File(this.sysDirInfo.getConfigDirectory(), "data-default.zip");
        if (!dataDefault.exists()) {
            errorMessages.add("The following file is required for data archive import but was not found: " + dataDefault.getAbsolutePath());
        } else {
            Map<Object, Object> dataDefaultMap = Collections.emptyMap();
            try {
                dataDefaultMap = UnzipUtil.unzip(dataDefault);
                log.info((Object)("Deploying: " + dataDefault));
            }
            catch (IOException e) {
                log.error((Object)"Problem writing data", (Throwable)e);
                errorMessages.add("An error was detected while loading the default data directory. See the server log for further details.");
            }
            if (errorMessages.isEmpty()) {
                this.clientManager.cleanOAuthIndexDirectoryAndDatabase();
                EnumSet<DeploymentOption> options = EnumSet.of(DeploymentOption.CLEAR_PROVIDER_DIRS);
                if (bulkImport) {
                    options.add(DeploymentOption.BULK_IMPORT);
                }
                if (reencrypt) {
                    options.add(DeploymentOption.REENCRYPT);
                }
                if (enableDataUpgrade) {
                    options.add(DeploymentOption.DATA_UPGRADE);
                }
                this.dataDirectoryManager.clearDataDirectory(options);
                for (String key : this.getPopulateExceptionsKeys(options)) {
                    dataDefaultMap.remove(key);
                }
                try {
                    this.deployToFilesystem(this.sysDirInfo.getDataDirectory(), dataDefaultMap);
                }
                catch (IOException e) {
                    log.error((Object)"Problem deploying data to data directory", (Throwable)e);
                    errorMessages.add("An error was detected while deploying to data directory. See the server log for further details.");
                }
            }
        }
        return errorMessages;
    }

    public boolean isValidArchive(Map<String, byte[]> archiveToImport) {
        boolean validArchive = false;
        for (String key : archiveToImport.keySet()) {
            if (!key.startsWith(CONFIG_STORE_FOLDER_NAME)) continue;
            validArchive = true;
            break;
        }
        return validArchive;
    }

    private List<String> getPopulateExceptionsKeys(EnumSet<DeploymentOption> deploymentOptions) {
        if (deploymentOptions.contains((Object)DeploymentOption.DATA_UPGRADE)) {
            return Collections.emptyList();
        }
        ArrayList<String> populateExceptions = new ArrayList<String>();
        populateExceptions.add("config-store/org.sourceid.saml20.domain.mgmt.impl.TargetResourceValidationMgrImpl.xml");
        if (deploymentOptions.contains((Object)DeploymentOption.BULK_IMPORT)) {
            populateExceptions.add("config-store/com.pingidentity.crypto.jwk.MasterKeySet.xml");
        }
        return populateExceptions;
    }

    private boolean isValidFilePath(String directory, String filePath) {
        if (Paths.get(filePath, new String[0]).isAbsolute()) {
            return false;
        }
        Path path = Paths.get(directory, new String[0]).resolve(filePath).normalize();
        return path.startsWith(Paths.get(directory, new String[0]).normalize());
    }

    private void reencryptArchive(Map<String, byte[]> archive, JsonWebKeySet oldKeySet) throws JoseException {
        log.info((Object)("Reencrypting data archive with key " + ((JsonWebKey)oldKeySet.getJsonWebKeys().get(0)).getKeyId()));
        ArrayList<ReencryptionTarget> targets = new ArrayList<ReencryptionTarget>();
        JsonWebKeySet decryptionKeySet = this.dataDeployerManager.getConfigEncryptionKeysFromArchive(archive);
        for (Map.Entry<String, byte[]> entry : archive.entrySet()) {
            String fileName = entry.getKey();
            FileScanner fileScanner = ReencryptUtils.getFileScanner(fileName, decryptionKeySet);
            if (fileScanner == null) continue;
            ValueReencryptor valueHandler = new ValueReencryptor();
            ReencryptionTarget reencryptionTarget = (ReencryptionTarget)fileScanner.scanData(fileName, entry.getValue(), valueHandler);
            if (!reencryptionTarget.hasAnyEncryptedFields()) continue;
            targets.add(reencryptionTarget);
        }
        if (!targets.isEmpty()) {
            for (ReencryptionTarget target : targets) {
                log.info((Object)("Reencrypting file " + target.getFileName()));
                byte[] data = archive.get(target.getFileName());
                String stringData = new String(data, StandardCharsets.UTF_8);
                for (Replacement replacement : target.getEncryptedFields()) {
                    String originalValue = replacement.getOriginalValue();
                    String replacementValue = replacement.getReplacementValue();
                    stringData = stringData.replace(originalValue, replacementValue);
                }
                byte[] newData = stringData.getBytes(StandardCharsets.UTF_8);
                archive.replace(target.getFileName(), newData);
            }
        }
        archive.remove(PF_JWK);
    }

    public void reencryptInstanceFiles(JsonWebKeySet oldKeySet) throws IOException {
        File instanceFolder = new File(this.sysDirInfo.getInstanceDataDirectory());
        String[] fileExtensions = PFEncryptionFilter.fileExtensions.toArray(new String[PFEncryptionFilter.fileExtensions.size()]);
        Collection instanceFiles = FileUtils.listFiles((File)instanceFolder, (String[])fileExtensions, (boolean)true);
        ArrayList<ReencryptionTarget> filesToReencrypt = new ArrayList<ReencryptionTarget>();
        for (File file : instanceFiles) {
            ValueReencryptor reencryptor;
            ReencryptionTarget reencryptionTarget;
            FileScanner fileScanner = ReencryptUtils.getFileScanner(file.getName(), oldKeySet);
            if (fileScanner == null) continue;
            KeyInUseHandler keyInUseHandler = new KeyInUseHandler();
            fileScanner.scanFile(file, keyInUseHandler);
            List keysUsed = (List)keyInUseHandler.getResult();
            if (keysUsed.isEmpty() || keysUsed.size() <= 1 && ((String)keysUsed.get(0)).equals(ReencryptUtils.getCurrentKeyId()) || !(reencryptionTarget = (ReencryptionTarget)fileScanner.scanFile(file, reencryptor = new ValueReencryptor())).hasAnyEncryptedFields()) continue;
            filesToReencrypt.add(reencryptionTarget);
        }
        ReencryptUtils.performReencryption(filesToReencrypt);
    }

    public void mergeMasterKeySets(JsonWebKeySet oldKeySet) {
        ArrayList keysInUse = new ArrayList();
        String pfHomeDir = this.sysDirInfo.getRootDir();
        Collection pfFiles = FileUtils.listFiles((File)new File(pfHomeDir), (IOFileFilter)PFEncryptionFilter.FILE_FILTER, (IOFileFilter)PFEncryptionFilter.ENGINE_FILTER);
        for (File file : pfFiles) {
            KeyInUseHandler valueHandler = new KeyInUseHandler();
            FileScanner fileScanner = ReencryptUtils.getFileScanner(file);
            if (fileScanner == null) continue;
            List keysUsedInFile = (List)fileScanner.scanFile(file, valueHandler);
            keysUsedInFile.forEach(keyId -> {
                if (!keysInUse.contains(keyId)) {
                    keysInUse.add(keyId);
                }
            });
        }
        JsonWebKeySet keysToAddBack = new JsonWebKeySet(new JsonWebKey[0]);
        for (JsonWebKey oldKey : oldKeySet.getJsonWebKeys()) {
            if (!keysInUse.contains(oldKey.getKeyId())) continue;
            keysToAddBack.addJsonWebKey(oldKey);
        }
        if (!keysToAddBack.getJsonWebKeys().isEmpty()) {
            this.masterKeySet.addJsonWebKeySet(keysToAddBack);
        }
    }

    private String checkArchiveVersion(Map<String, byte[]> archive) {
        String archiveVersion = Utils.getVersionFromConfigArchive(archive);
        Object errorMessage = null;
        if (!"Unknown".equals(archiveVersion)) {
            int comparisonResult = VersionUtil.compareProductMajorMinorVersions((String)archiveVersion, (String)PropertyInfo.getPingFederateVersion());
            if (comparisonResult != 0) {
                errorMessage = "The deployed configuration archive was generated from PingFederate version " + archiveVersion + ". Deploying this archive in the current version of PingFederate is not supported. ";
            }
        } else {
            errorMessage = "The deployed configuration archive was generated from an older version of PingFederate. Deploying this archive in the current version of PingFederate is not supported. ";
        }
        return errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeployArchiveResult deployUpgradeValidate(Map<String, byte[]> archiveToImport, String filename, boolean forceImport, boolean reencrypt, Version sourceVersion, Version currentVersion, AdministrativeUser userMakingRequest) {
        try {
            boolean isSuccessResult;
            ConfigUpdateCoordinator.getInstance().setUpdateInProgress(ConfigUpdateType.FULL_CONFIG_RELOAD);
            HashMap<String, AdministrativeUser> origUsers = new HashMap<String, AdministrativeUser>(this.nativeAdminUserManager.getUsersMap());
            NotificationSettings originalNotificationSettings = this.notificationMgr.getNotificationSettings();
            String origAdminAccChgNotificationPublisherId = originalNotificationSettings.getNotificationPublisherAccountChanges();
            NotificationSenderPluginInstance origAdminAccChgNotificationPublisher = NotificationSupportHelper.getNotificationPublisherForAuditLogDiff(origAdminAccChgNotificationPublisherId);
            DeployArchiveResult result = this.doDeployUpgradeValidate(archiveToImport, filename, forceImport, reencrypt, sourceVersion, currentVersion);
            boolean bl = isSuccessResult = result.isSuccess() || forceImport && result.getUpgradeErrors().isEmpty();
            if (isSuccessResult) {
                Object adminAuditMessage = filename;
                if (reencrypt) {
                    adminAuditMessage = (String)adminAuditMessage + ", reencrypted";
                }
                AdminAuditLogger.log(AdminAuditLogger.Component.CONFIG_ARCHIVE, AdminAuditLogger.Event.IMPORT, (String)adminAuditMessage);
                NotificationSettings settings = this.notificationMgr.getNotificationSettings();
                HashMap<String, AdministrativeUser> latestUsers = new HashMap<String, AdministrativeUser>(this.nativeAdminUserManager.getUsersMap());
                boolean enableAccountChangesNotification = originalNotificationSettings.isEnableAccountChangesNotification();
                NotificationSupportHelper.auditLogAdminAccountsNotificationPublisher(enableAccountChangesNotification, origAdminAccChgNotificationPublisher);
                this.logAndNotifySensitiveChanges(userMakingRequest, origUsers, latestUsers, originalNotificationSettings, settings);
                this.instanceMetadataManager.setDataVersion(currentVersion.toString());
            }
            DeployArchiveResult deployArchiveResult = result;
            return deployArchiveResult;
        }
        finally {
            ConfigUpdateCoordinator.getInstance().clearUpdateInProgress();
        }
    }

    private DeployArchiveResult doDeployUpgradeValidate(Map<String, byte[]> archiveToImport, String filename, boolean forceImport, boolean reencrypt, Version sourceVersion, Version currentVersion) {
        List<String> dataUpgradeErrors;
        ArrayList<String> allErrors;
        ArrayList<String> errorMessages = new ArrayList<String>();
        byte[] originalConfig = this.backupAndResetData(errorMessages, false, true);
        if (CollectionUtils.isNotEmpty(errorMessages)) {
            return DeployArchiveResult.createFailureResult(DeployArchiveType.UPGRADE, errorMessages, Collections.emptyList());
        }
        JsonWebKeySet oldKeySet = this.masterKeySet.getJsonWebKeySet();
        if (reencrypt) {
            try {
                this.reencryptArchive(archiveToImport, oldKeySet);
            }
            catch (Exception e) {
                errorMessages.add("Could not reencrypt data archive.");
                log.error((Object)"Could not reencrypt data archive", (Throwable)e);
                return DeployArchiveResult.createFailureResult(DeployArchiveType.UPGRADE, errorMessages, Collections.emptyList());
            }
        }
        if (!(allErrors = new ArrayList<String>(dataUpgradeErrors = this.performDataUpgrade(archiveToImport, filename, sourceVersion, currentVersion, oldKeySet, reencrypt))).isEmpty()) {
            log.error((Object)"Error while upgrading data directory.");
        }
        errorMessages.addAll(dataUpgradeErrors);
        if (CollectionUtils.isNotEmpty(errorMessages)) {
            this.rollBackOrResetState(errorMessages, originalConfig, true);
            return DeployArchiveResult.createFailureResult(DeployArchiveType.UPGRADE, errorMessages, Collections.emptyList());
        }
        DataValidator dataValidator = new DataValidator();
        List<String> importDataErrors = dataValidator.validate();
        if (!importDataErrors.isEmpty()) {
            if (!forceImport) {
                this.rollBackOrResetState(importDataErrors, originalConfig, true);
            }
            return DeployArchiveResult.createFailureResult(DeployArchiveType.UPGRADE, Collections.emptyList(), importDataErrors);
        }
        this.rollBackOrResetState(importDataErrors, originalConfig, false);
        this.instanceMetadataManager.setDataVersion(currentVersion.toString());
        return DeployArchiveResult.createSuccessResult(DeployArchiveType.UPGRADE);
    }

    public boolean isUpgradePossible(Map<String, byte[]> archiveMap) {
        boolean enableDataUpgrade = DataUpgradeConfigUtils.isEnableDataUpgrade();
        Version currentVersion = Utils.getCurrentPingFederateVersion();
        Version sourceVersion = Utils.getSourceVersionFromConfigArchive(archiveMap);
        return enableDataUpgrade && sourceVersion != null && currentVersion != null && Utils.eligibleForForceUpgrade((Version)sourceVersion, (Version)currentVersion);
    }

    public DeployArchiveResult deployArchive(Map<String, byte[]> archiveToImport, String filename, boolean forceImport, boolean forceUnsupportedImport, boolean reencrypt, AdministrativeUser currentUser) {
        Version currentVersion = Utils.getCurrentPingFederateVersion();
        Version sourceVersion = Utils.getSourceVersionFromConfigArchive(archiveToImport);
        boolean isDataUpgrade = DataUpgradeConfigUtils.isEnableDataUpgrade();
        if (!isDataUpgrade) {
            log.debug((Object)"Data upgrade is disabled, proceeding with normal import");
        } else {
            log.debug((Object)"Data upgrade is enabled, proceeding with data upgrade");
        }
        if (isDataUpgrade) {
            if (sourceVersion == null) {
                log.warn((Object)"Unable to determine the source version of the data archive. Proceeding with normal import.");
                isDataUpgrade = false;
            } else {
                log.debug((Object)("Source version of the data archive is " + sourceVersion));
            }
        }
        if (isDataUpgrade) {
            if (currentVersion == null) {
                log.warn((Object)"Unable to determine the current version of PingFederate. Proceeding with normal import.");
                isDataUpgrade = false;
            } else {
                log.debug((Object)("Current version of PingFederate is " + currentVersion));
            }
        }
        if (isDataUpgrade && sourceVersion.equals((Object)currentVersion)) {
            log.debug((Object)"The source version of the data archive is the same as the current version of PingFederate. Proceeding with normal import.");
            isDataUpgrade = false;
        }
        if (isDataUpgrade) {
            if (!Utils.eligibleForForceUpgrade((Version)sourceVersion, (Version)currentVersion)) {
                log.warn((Object)"The source version of the data archive is not eligible for upgrade. Proceeding with normal import.");
                isDataUpgrade = false;
            } else {
                log.debug((Object)"The source version of the data archive is eligible for upgrade. Proceeding with data upgrade.");
            }
        }
        if (isDataUpgrade) {
            return this.deployUpgradeValidate(archiveToImport, filename, forceImport, reencrypt, sourceVersion, currentVersion, currentUser);
        }
        List<String> errorMessages = this.deployAndValidate(archiveToImport, forceImport, reencrypt, forceUnsupportedImport, filename, currentUser);
        if (CollectionUtils.isNotEmpty(errorMessages)) {
            return DeployArchiveResult.createFailureResult(DeployArchiveType.IMPORT, Collections.emptyList(), errorMessages);
        }
        return DeployArchiveResult.createSuccessResult(DeployArchiveType.IMPORT);
    }

    public boolean isForceImport() {
        return this.isForceImport;
    }

    public static enum DeployDataResult {
        NOTHING_TO_DEPLOY,
        SUCCESS,
        FAILURE;

    }

    public static enum DeployArchiveType {
        IMPORT,
        UPGRADE;

    }

    public static class DeployArchiveResult {
        private final DeployArchiveType type;
        private final boolean success;
        private final List<String> upgradeErrors;
        private final List<String> validationErrors;

        private static DeployArchiveResult createSuccessResult(DeployArchiveType type) {
            return new DeployArchiveResult(type, true, Collections.emptyList(), Collections.emptyList());
        }

        private static DeployArchiveResult createFailureResult(DeployArchiveType type, List<String> upgradeErrors, List<String> validationErrors) {
            return new DeployArchiveResult(type, false, upgradeErrors, validationErrors);
        }

        private DeployArchiveResult(DeployArchiveType type, boolean success, List<String> upgradeErrors, List<String> validationErrors) {
            this.type = type;
            this.success = success;
            this.upgradeErrors = upgradeErrors;
            this.validationErrors = validationErrors;
        }

        public DeployArchiveType getType() {
            return this.type;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isNotSuccess() {
            return !this.isSuccess();
        }

        public List<String> getUpgradeErrors() {
            return this.upgradeErrors;
        }

        public List<String> getValidationErrors() {
            return this.validationErrors;
        }

        public List<String> getAllErrors() {
            ArrayList<String> allErrors = new ArrayList<String>();
            allErrors.addAll(this.upgradeErrors);
            allErrors.addAll(this.validationErrors);
            return allErrors;
        }
    }
}

