/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.crypto.jwk.MasterKeySet;
import com.pingidentity.sdk.key.MasterKeyEncryptor;
import com.pingidentity.sdk.key.MasterKeyEncryptorException;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.config.impl.xml.ConfigDocument;
import org.sourceid.config.impl.xml.ConfigType;
import org.sourceid.config.impl.xml.ItemType;
import org.sourceid.saml20.domain.mgmt.DataDeployerManager;

public class DataDeployerManagerImpl
implements DataDeployerManager {
    private static final String CONFIG_STORE_FOLDER_NAME = "config-store";
    private static final String MASTER_KEY_SET_FILE_NAME = MasterKeySet.class.getName() + ".xml";
    private static final Log log = LogFactory.getLog(DataDeployerManagerImpl.class);
    private final MasterKeyEncryptor masterKeyEncryptor;
    private final XmlLoader xmlLoader;

    public DataDeployerManagerImpl(MasterKeyEncryptor masterKeyEncryptor, XmlLoader xmlLoader) {
        this.masterKeyEncryptor = masterKeyEncryptor;
        this.xmlLoader = xmlLoader;
    }

    @Override
    public JsonWebKeySet getConfigEncryptionKeysFromArchive(Map<String, byte[]> archive) throws JoseException {
        byte[] decryptionKeySetBytes = archive.get("pf.jwk");
        byte[] masterKeySetConfigFile = archive.get("config-store/" + MASTER_KEY_SET_FILE_NAME);
        if (masterKeySetConfigFile != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(masterKeySetConfigFile);
            XmlObject load = this.xmlLoader.load(stream);
            if (load instanceof ConfigDocument) {
                ConfigDocument configDocument = (ConfigDocument)load;
                ConfigType configType = configDocument.getConfig();
                Map<String, String> items = Stream.of(configType.getItemArray()).collect(Collectors.toMap(ItemType::getName, XmlAnySimpleType::getStringValue));
                String jwkEncryptedStr = items.get("jwkEncrypted");
                if (Boolean.parseBoolean(jwkEncryptedStr)) {
                    try {
                        String masterKeySetId = items.get("keyId");
                        this.masterKeyEncryptor.initialize(masterKeySetId);
                        decryptionKeySetBytes = this.masterKeyEncryptor.decrypt(decryptionKeySetBytes);
                    }
                    catch (MasterKeyEncryptorException e) {
                        log.error((Object)("Error decrypting master key set, " + e.getMessage()));
                        log.debug((Object)"Error decrypting master key set", (Throwable)e);
                    }
                }
            } else {
                log.debug((Object)(MASTER_KEY_SET_FILE_NAME + " file is not a ConfigDocument type"));
            }
        } else {
            log.debug((Object)(MASTER_KEY_SET_FILE_NAME + " file not found in archive"));
        }
        return new JsonWebKeySet(new String(decryptionKeySetBytes, StandardCharsets.UTF_8));
    }
}

