/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.jolbox.bonecp.BoneCPDataSource;
import com.pingidentity.common.util.AdapterUtils;
import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.common.util.JDBCHelper;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.timers.DSEventTimer;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.config.xml.customds.CustomDataSources;
import com.pingidentity.config.xml.customds.CustomSource;
import com.pingidentity.config.xml.customds.CustomSourcesDocument;
import com.pingidentity.config.xml.ldapds.BinaryAttributesType;
import com.pingidentity.config.xml.ldapds.LdapGatewaySource;
import com.pingidentity.config.xml.ldapds.LdapSource;
import com.pingidentity.config.xml.ldapds.LdapSources;
import com.pingidentity.config.xml.ldapds.LdapSourcesDocument;
import com.pingidentity.config.xml.ldapds.LdapTagEntry;
import com.pingidentity.config.xml.ldapds.LdapTagList;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.crypto.Password;
import com.pingidentity.jdbc.DataSourceDeployerFactory;
import com.pingidentity.monitoring.ConnectionPoolMetrics;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import com.pingidentity.sources.ConfigurableDriver;
import com.pingidentity.sources.CustomDataSourceDriver;
import com.pingidentity.sources.SourceDescriptor;
import java.io.File;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import noNamespace.ConnectionTagEntry;
import noNamespace.ConnectionTagList;
import noNamespace.DataSourcesType;
import noNamespace.DatasourcesDocument;
import noNamespace.LocalTxDataSourceType;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.PasswordType;
import org.sourceid.config.ConfigurationException;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.datasource.info.LdapTypeNotFoundException;
import org.sourceid.saml20.domain.datasource.tag.JdbcInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.JdbcTagConfig;
import org.sourceid.saml20.domain.datasource.tag.LdapInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.LdapTagConfig;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;
import org.sourceid.saml20.domain.mgmt.impl.CustomDataSourceMgrConfigSupport;
import org.sourceid.saml20.domain.mgmt.impl.DataSourceDeployer;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginSupport;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.w3c.dom.Node;

public class DataSourceManagerImpl
extends ConfigManagerBase
implements DataSourceManager,
ServiceInformation,
AutoReloadable {
    private static final Log log = LogFactory.getLog(DataSourceManagerImpl.class);
    private static final String JDBC_XML_FILE_NAME = "pingfederate-jdbc-ds.xml";
    private static final String JDBC_XML_SAAS_FILE_NAME = "pf-saas-provisioning-log-ds.xml";
    private static final String JDBC_XML_DEFAULT_FILE_NAME = "pf-default-ds.xml";
    private static final String JDBC_XML_INDEX_FILE_NAME = "pf-index-ds.xml";
    private static final String LDAP_XML_FILE_NAME = "pingfederate-ldap-ds.xml";
    private static final String CUSTOM_XML_FILE_NAME = "pingfederate-custom-ds.xml";
    private static final String INDEX_DIRECTORY = "index";
    private static final String JNDI_NAME_BASE_JDBC = "JDBC";
    private static final String ID_BASE_LDAP = "LDAP";
    private static final String ID_BASE_Custom = "Other";
    public static final String CD_DESCRIPTOR_FILE_NAME = "custom-drivers";
    private static final String CD_DESCRIPTOR_NAME = "PF-INF/custom-drivers";
    private final Map<String, JdbcDataSource> jdbcSources = new HashMap<String, JdbcDataSource>();
    private final Map<String, LdapDataSource> ldapSources = new HashMap<String, LdapDataSource>();
    private final Map<String, CustomDataSource> customSources = new HashMap<String, CustomDataSource>();
    private final DataSourceDeployer dsDeployer;
    private final PluginSupport support = new PluginSupport();
    private final CustomDataSourceMgrConfigSupport configSupport = new CustomDataSourceMgrConfigSupport();
    private final Map<String, Date> datasourceToLastCheckedMap = new HashMap<String, Date>();
    private LdapDataSource sourceForDefaultSettings;

    public DataSourceManagerImpl() throws Exception {
        this.dsDeployer = new DataSourceDeployerFactory().getDataSourceDeployer(this);
        this.loadConfig();
    }

    public String getServiceName() {
        return "data-source-manager";
    }

    private synchronized void loadConfig() {
        this.loadJdbcSources();
        this.loadLdapSources();
        this.loadCustomAttributeSources();
    }

    @Override
    public synchronized void initializeJndiLookup() {
    }

    @Override
    public synchronized boolean isDataSourceNameInUse(String name, String id) {
        boolean isInUse = false;
        ArrayList<JdbcDataSource> dataSources = new ArrayList<JdbcDataSource>(this.jdbcSources.values());
        dataSources.addAll(this.ldapSources.values());
        for (DataSource dataSource : dataSources) {
            if (!name.equals(dataSource.getDescription())) continue;
            isInUse = !dataSource.getId().equals(id);
        }
        return isInUse;
    }

    @Override
    public synchronized Collection<JdbcDataSource> getJdbcDataSources() {
        return this.jdbcSources.values();
    }

    @Override
    public synchronized JdbcDataSource getJdbcDataSource(String dataSourceId) {
        return this.jdbcSources.get(dataSourceId);
    }

    @Override
    public synchronized void deployJdbcDataSources() {
    }

    @Override
    public synchronized void saveJdbcDataSource(JdbcDataSource dataSource) {
        log.debug((Object)("Saving JDBC DataSource " + dataSource.getJndiName() + "..."));
        String jndiName = dataSource.getJndiName();
        AdminAuditLogger.Event event = AdminAuditLogger.Event.MODIFY;
        if (StringUtils.isBlank((String)jndiName)) {
            jndiName = this.generateId(JNDI_NAME_BASE_JDBC);
            dataSource.setJndiName(jndiName);
            event = AdminAuditLogger.Event.CREATE;
        }
        dataSource.setId(jndiName);
        this.jdbcSources.put(jndiName, dataSource);
        dataSource.setAvailable(true);
        this.dsDeployer.redeploy(dataSource);
        dataSource.setLastModified((Calendar)new XmlCalendar(new Date()));
        this.doSaveDataSource(this::saveJdbcSources, event, dataSource.getJndiName());
        this.removeDataSourceFromTestCache(dataSource);
    }

    @Override
    public synchronized void deleteJdbcDataSource(JdbcDataSource dataSource) {
        if (this.jdbcSources.containsKey(dataSource.getJndiName())) {
            this.jdbcSources.remove(dataSource.getJndiName());
            dataSource.setAvailable(false);
            this.dsDeployer.undeployDatasource(dataSource.getJndiName());
            this.doSaveDataSource(this::saveJdbcSources, AdminAuditLogger.Event.DELETE, dataSource.getJndiName());
            this.removeDataSourceFromTestCache(dataSource);
        }
    }

    private synchronized void loadJdbcSources() {
        log.info((Object)"Initializing JNDI lookup");
        try {
            String dataDir = this.sysDirInfo.getDataDirectory();
            String deployDir = this.sysDirInfo.getDeployDirectory();
            DatasourcesDocument doc = (DatasourcesDocument)this.xmlLoader.load(dataDir, JDBC_XML_FILE_NAME);
            this.loadJdbcSources(doc, true, true, false);
            doc = (DatasourcesDocument)this.xmlLoader.load(deployDir, JDBC_XML_SAAS_FILE_NAME);
            this.deployDefaultJdbcSources(doc, true);
            doc = (DatasourcesDocument)this.xmlLoader.load(deployDir, JDBC_XML_DEFAULT_FILE_NAME);
            this.deployDefaultJdbcSources(doc, true);
            this.createIndexDirectory();
            doc = (DatasourcesDocument)this.xmlLoader.load(deployDir, JDBC_XML_INDEX_FILE_NAME);
            this.deployDefaultJdbcSources(doc, true);
        }
        catch (ConfigurationException ex) {
            log.info((Object)("Unable to load JDBC sources. " + ex.getMessage()));
            this.jdbcSources.clear();
        }
    }

    private void createIndexDirectory() {
        File indexDir = new File(this.sysDirInfo.getDataDirectory(), INDEX_DIRECTORY);
        if (!indexDir.exists() && !indexDir.mkdirs()) {
            throw new ConfigurationException("Failed to create directory " + indexDir);
        }
    }

    private synchronized void deployDefaultJdbcSources(DatasourcesDocument doc, boolean allowPlaintextPassword) {
        List<JdbcDataSource> jdbcDataSources = DataSourceManagerImpl.parseJdbcDataSourcesXml(doc, allowPlaintextPassword);
        for (JdbcDataSource jdbcDataSource : jdbcDataSources) {
            this.dsDeployer.deploy(jdbcDataSource);
        }
    }

    private synchronized void loadJdbcSources(DatasourcesDocument doc, boolean clearCurrentSources, boolean allowUpdate, boolean allowPlaintextPassword) {
        if (clearCurrentSources) {
            this.jdbcSources.clear();
        }
        List<JdbcDataSource> jdbcDataSources = DataSourceManagerImpl.parseJdbcDataSourcesXml(doc, allowPlaintextPassword);
        for (JdbcDataSource jdbcDataSource : jdbcDataSources) {
            String sourceId = jdbcDataSource.getJndiName();
            if (!allowUpdate && this.jdbcSources.containsKey(sourceId)) continue;
            this.jdbcSources.put(sourceId, jdbcDataSource);
        }
        if (jdbcDataSources.size() > 0) {
            this.dsDeployer.deploy();
        }
    }

    public static List<JdbcDataSource> parseJdbcDataSourcesXml(String xml, boolean allowPlaintextPassword) throws XmlException {
        return DataSourceManagerImpl.parseJdbcDataSourcesXml(DatasourcesDocument.Factory.parse((String)xml), allowPlaintextPassword);
    }

    private static List<JdbcDataSource> parseJdbcDataSourcesXml(DatasourcesDocument doc, boolean allowPlaintextPassword) {
        LocalTxDataSourceType[] datasources = doc.getDatasources().getLocalTxDatasourceArray();
        ArrayList<JdbcDataSource> jdbcDataSources = new ArrayList<JdbcDataSource>(datasources.length);
        for (LocalTxDataSourceType dsxml : datasources) {
            JdbcDataSource dsbean = DataSourceManagerImpl.parseJdbcDataSourceXml(dsxml, allowPlaintextPassword);
            jdbcDataSources.add(dsbean);
        }
        return jdbcDataSources;
    }

    private static JdbcDataSource parseJdbcDataSourceXml(LocalTxDataSourceType dsxml, boolean allowPlaintextPassword) {
        String dbType;
        String testSQL;
        BigInteger idleTimeout;
        BigInteger blockingTimeout;
        BigInteger maxSize;
        JdbcDataSource dsbean = new JdbcDataSource();
        dsbean.setId(dsxml.getJndiName());
        dsbean.setAvailable(true);
        dsbean.setJndiName(dsxml.getJndiName());
        if (dsxml.getName() == null) {
            dsbean.setDsName(DataSourceManagerImpl.createDefaultDsName(dsxml.getDescription(), dsxml.getUserName()));
        } else {
            dsbean.setDsName(dsxml.getName());
        }
        dsbean.setDescription(dsbean.getDsName());
        dsbean.setUserName(dsxml.getUserName());
        String passwordStr = DataSourceManagerImpl.checkLegacyProvisionerDsPassword(dsxml.getPassword());
        if (passwordStr == null && dsxml.getPassword() != null) {
            Password password = new Password(dsxml.getPassword(), allowPlaintextPassword || SecretReferenceUtil.isSecretReference((String)dsxml.getPassword()) ? PasswordType.CLEARTEXT : PasswordType.OBFUSCATED);
            passwordStr = password.getStrValue();
        }
        dsbean.setPassword(passwordStr);
        dsbean.setConnectionUrl(dsxml.getConnectionUrl());
        dsbean.setDriverClass(dsxml.getDriverClass());
        if (dsxml.isSetLastModified()) {
            dsbean.setLastModified(dsxml.getLastModified());
        }
        List tagEntries = Optional.of(dsxml).map(LocalTxDataSourceType::getConnectionTagList).map(ConnectionTagList::getTagEntryArray).map(Arrays::asList).orElse(new ArrayList());
        LinkedList<JdbcTagConfig> jdbcTagConfigList = new LinkedList<JdbcTagConfig>();
        for (ConnectionTagEntry tagEntry : tagEntries) {
            boolean isDefault = dsxml.getConnectionUrl().equals(tagEntry.getConnectionUrl());
            JdbcTagConfig tagConfig = new JdbcTagConfig(new JdbcInstanceIdentifier(tagEntry.getConnectionUrl()), tagEntry.getTags(), isDefault);
            jdbcTagConfigList.add(tagConfig);
        }
        dsbean.setJdbcTagConfigList(jdbcTagConfigList);
        BigInteger minSize = dsxml.getMinPoolSize();
        if (minSize != null) {
            dsbean.setMinPoolSize(minSize.intValue());
        }
        if ((maxSize = dsxml.getMaxPoolSize()) != null) {
            dsbean.setMaxPoolSize(maxSize.intValue());
        }
        if ((blockingTimeout = dsxml.getBlockingTimeoutMillis()) != null) {
            dsbean.setBlockingTimeoutMillis(blockingTimeout.intValue());
        }
        if ((idleTimeout = dsxml.getIdleTimeoutMinutes()) != null) {
            dsbean.setIdleTimeoutMinutes(idleTimeout.intValue());
        }
        if ((testSQL = dsxml.getCheckValidConnectionSql()) != null) {
            dsbean.setCheckValidConnectionSql(testSQL);
        }
        if ((dbType = dsxml.getPingDbType()) != null) {
            dsbean.setDatabaseType(dbType);
        }
        dsbean.setMaskAttributeValues(dsxml.getMaskAttributeValues());
        dsbean.setMultiValueAttributesAllowed(dsxml.getAllowMultiValueAttributes());
        return dsbean;
    }

    @Override
    public String exportJdbcSource(String instanceId) {
        JdbcDataSource dataSource = this.getJdbcDataSource(instanceId);
        if (dataSource != null) {
            return DataSourceManagerImpl.exportJdbcSource(dataSource);
        }
        log.warn((Object)("Unable to export JDBC source: " + instanceId + ". Data source not found."));
        return null;
    }

    public static String exportJdbcSource(JdbcDataSource dataSource) {
        DatasourcesDocument jdbcDataSourcesDoc = DatasourcesDocument.Factory.newInstance();
        DataSourcesType datasources = jdbcDataSourcesDoc.addNewDatasources();
        DataSourceManagerImpl.addDataSourceType(datasources, dataSource);
        return jdbcDataSourcesDoc.toString();
    }

    public static String exportJdbcSources(List<JdbcDataSource> jdbcDataSources) {
        DatasourcesDocument jdbcDataSourcesDoc = DatasourcesDocument.Factory.newInstance();
        DataSourcesType jdbcDatasourcesEl = jdbcDataSourcesDoc.addNewDatasources();
        for (JdbcDataSource jdbcDataSource : jdbcDataSources) {
            DataSourceManagerImpl.addDataSourceType(jdbcDatasourcesEl, jdbcDataSource);
        }
        return jdbcDataSourcesDoc.toString();
    }

    @Override
    public String exportJdbcSources() {
        DatasourcesDocument jdbcDataSourcesDoc = null;
        try {
            String dataDir = this.sysDirInfo.getDataDirectory();
            jdbcDataSourcesDoc = (DatasourcesDocument)this.xmlLoader.load(dataDir, JDBC_XML_FILE_NAME);
        }
        catch (ConfigurationException ex) {
            log.warn((Object)("Unable to load JDBC sources. " + ex.getMessage()));
        }
        return jdbcDataSourcesDoc == null ? null : jdbcDataSourcesDoc.toString();
    }

    @Override
    public void importJdbcSources(String xml, boolean allowUpdate) throws XmlException {
        if (StringUtils.isEmpty((String)xml)) {
            log.warn((Object)"JDBC sources not imported.  XML configuration was empty.");
        } else {
            Node node = XmlBeansUtil.parseToNode(xml);
            DatasourcesDocument doc = DatasourcesDocument.Factory.parse((Node)node);
            this.loadJdbcSources(doc, false, allowUpdate, false);
            this.saveJdbcSources();
        }
    }

    private synchronized void saveJdbcSources() {
        log.debug((Object)"Saving JDBC DataSources...");
        DatasourcesDocument doc = DatasourcesDocument.Factory.newInstance();
        DataSourcesType datasources = doc.addNewDatasources();
        for (JdbcDataSource dsbean : this.jdbcSources.values()) {
            DataSourceManagerImpl.addDataSourceType(datasources, dsbean);
        }
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), JDBC_XML_FILE_NAME, (XmlObject)doc);
    }

    private static String checkLegacyProvisionerDsPassword(String obfuscated) {
        if ("dezQ6UjcMUu35oG/nZD4cA==".equals(obfuscated)) {
            return "secretpass";
        }
        return null;
    }

    private static void addDataSourceType(DataSourcesType datasources, JdbcDataSource dsbean) {
        LocalTxDataSourceType dsxml = datasources.addNewLocalTxDatasource();
        String jndiName = dsbean.getJndiName();
        dsxml.setDescription(dsbean.getDescription());
        if (StringUtils.isBlank((String)dsbean.getDsName())) {
            String defaultName = DataSourceManagerImpl.createDefaultDsName(dsbean.getDescription(), dsbean.getUserName());
            dsbean.setDsName(defaultName);
        }
        dsxml.setName(dsbean.getDsName());
        dsxml.setJndiName(jndiName);
        dsxml.setUserName(dsbean.getUserName());
        dsxml.setPassword(SecretReferenceUtil.isSecretReference((String)dsbean.getPassword()) ? dsbean.getPassword() : FieldObfuscator.REAL.obfuscate(dsbean.getPassword()));
        dsxml.setConnectionUrl(dsbean.getConnectionUrl());
        dsxml.setDriverClass(dsbean.getDriverClass());
        if (dsbean.getLastModified() != null) {
            dsxml.setLastModified(dsbean.getLastModified());
        }
        ConnectionTagList dsxmlTagList = dsxml.addNewConnectionTagList();
        for (JdbcTagConfig tagConfig : dsbean.getJdbcTagConfigList()) {
            ConnectionTagEntry dsxmlTagEntry = dsxmlTagList.addNewTagEntry();
            dsxmlTagEntry.setConnectionUrl(tagConfig.getIdentifier().getJdbcUrl());
            dsxmlTagEntry.setTags(tagConfig.getTags());
        }
        dsxml.setMinPoolSize(BigInteger.valueOf(dsbean.getMinPoolSize()));
        dsxml.setMaxPoolSize(BigInteger.valueOf(dsbean.getMaxPoolSize()));
        dsxml.setBlockingTimeoutMillis(BigInteger.valueOf(dsbean.getBlockingTimeoutMillis()));
        dsxml.setIdleTimeoutMinutes(BigInteger.valueOf(dsbean.getIdleTimeoutMinutes()));
        if (!StringUtils.isBlank((String)dsbean.getCheckValidConnectionSql())) {
            dsxml.setCheckValidConnectionSql(dsbean.getCheckValidConnectionSql());
        }
        if (!StringUtils.isBlank((String)dsbean.getDatabaseType())) {
            dsxml.setPingDbType(dsbean.getDatabaseType());
        }
        dsxml.setMaskAttributeValues(dsbean.isMaskAttributeValues());
        dsxml.setAllowMultiValueAttributes(dsbean.isMultiValueAttributesAllowed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void test(JdbcDataSource jds, boolean redeploy) throws SecretManagerException, NamingException, SQLException {
        String jndiName = jds.getJndiName();
        if (StringUtils.isBlank((String)jndiName)) {
            jndiName = this.generateId(JNDI_NAME_BASE_JDBC);
            jds.setJndiName(jndiName);
        }
        if (redeploy) {
            JdbcDataSource savedDS = this.jdbcSources.get(jndiName);
            this.jdbcSources.put(jndiName, jds);
            this.dsDeployer.deploy(jds);
            try {
                this.testDatasourceConnectivity(jds);
            }
            finally {
                if (savedDS != null) {
                    this.jdbcSources.put(jndiName, savedDS);
                    this.dsDeployer.deploy(savedDS);
                } else {
                    this.jdbcSources.remove(jndiName);
                    this.dsDeployer.undeployDatasource(jndiName);
                }
            }
        } else {
            this.testDatasourceConnectivity(jds);
        }
    }

    private void testDatasourceConnectivity(JdbcDataSource jds) throws SecretManagerException, NamingException, SQLException {
        JDBCHelper.testConnection(jds, this);
    }

    private synchronized void loadLdapSources() {
        try {
            LdapSourcesDocument doc = (LdapSourcesDocument)this.xmlLoader.load(this.sysDirInfo.getDataDirectory(), LDAP_XML_FILE_NAME);
            this.loadLdapSources(doc, true, true);
        }
        catch (ConfigurationException e) {
            log.info((Object)("No LDAP sources are loaded. " + e.getMessage()));
            this.ldapSources.clear();
        }
    }

    private synchronized void loadLdapSources(LdapSourcesDocument doc, boolean clearCurrentSources, boolean allowUpdate) {
        if (clearCurrentSources) {
            this.ldapSources.clear();
        }
        for (LdapDataSource dsbean : DataSourceManagerImpl.parseLdapDataSourcesXml(doc)) {
            String sourceId = dsbean.getId();
            if (!allowUpdate && this.ldapSources.containsKey(sourceId)) continue;
            this.ldapSources.put(dsbean.getId(), dsbean);
        }
    }

    public static List<LdapDataSource> parseLdapDataSourcesXml(String xml) throws XmlException {
        return DataSourceManagerImpl.parseLdapDataSourcesXml(LdapSourcesDocument.Factory.parse((String)xml));
    }

    private static List<LdapDataSource> parseLdapDataSourcesXml(LdapSourcesDocument doc) {
        String ldapTypeDesc;
        LdapDataSource dsbean;
        LdapSource[] datasources = doc.getLdapSources().getLdapSourceArray();
        LdapGatewaySource[] gatewaySources = doc.getLdapSources().getLdapGatewaySourceArray();
        ArrayList<LdapDataSource> ldapDataSources = new ArrayList<LdapDataSource>(datasources.length + gatewaySources.length);
        for (LdapGatewaySource ldapGatewaySource : gatewaySources) {
            dsbean = new LdapDataSource();
            dsbean.setId(ldapGatewaySource.getId());
            dsbean.setHost(String.format("%s:%s:%s", ldapGatewaySource.getPingOneConnection(), ldapGatewaySource.getPingOneEnvironment(), ldapGatewaySource.getPingOneGateway()));
            dsbean.setPingOneConnection(ldapGatewaySource.getPingOneConnection());
            dsbean.setPingOneEnvironment(ldapGatewaySource.getPingOneEnvironment());
            dsbean.setPingOneGateway(ldapGatewaySource.getPingOneGateway());
            dsbean.setUseSSL(ldapGatewaySource.getUseSsl());
            dsbean.setDsName(ldapGatewaySource.getName());
            dsbean.setUseStartTLS(ldapGatewaySource.getUseStartTLS());
            try {
                dsbean.setLdapType(!StringUtils.isBlank((String)ldapGatewaySource.getLdapType()) ? LdapInfo.LdapType.canonicalName((String)ldapGatewaySource.getLdapType()) : LdapInfo.LdapType.Undefined);
            }
            catch (LdapTypeNotFoundException e) {
                log.warn((Object)("Could not find the LdapType for " + ldapGatewaySource.getLdapType() + ". Defaulting to the undefined type"));
                dsbean.setLdapType(LdapInfo.LdapType.Undefined);
            }
            ldapTypeDesc = !StringUtils.isBlank((String)ldapGatewaySource.getLdapTypeDesc()) ? ldapGatewaySource.getLdapTypeDesc() : LdapInfo.LdapType.Undefined.toString();
            dsbean.setLdapTypeDesc(ldapTypeDesc);
            dsbean.setDescription(dsbean.getDsName());
            dsbean.setMaskAttributeValues(ldapGatewaySource.getMaskAttributeValues());
            DataSourceManagerImpl.setBinaryAttributes(dsbean, ldapGatewaySource);
            if (ldapGatewaySource.isSetLastModified()) {
                dsbean.setLastModified(ldapGatewaySource.getLastModified());
            }
            ldapDataSources.add(dsbean);
        }
        for (LdapGatewaySource ldapGatewaySource : datasources) {
            dsbean = new LdapDataSource();
            dsbean.setId(ldapGatewaySource.getId());
            dsbean.setHost(ldapGatewaySource.getHost());
            dsbean.setUseSSL(ldapGatewaySource.getUseSsl());
            dsbean.setUseDnsSrvRecords(ldapGatewaySource.getUseDnsSrvRecords());
            dsbean.setUseAdReferral(ldapGatewaySource.getAdReferral());
            dsbean.setPrincipal(ldapGatewaySource.getPrincipal());
            dsbean.setAuthenticationMethod(ldapGatewaySource.getAuthenticationMeth());
            dsbean.setUseStartTLS(ldapGatewaySource.getUseStartTLS());
            if (ldapGatewaySource.getName() == null) {
                dsbean.setDsName(DataSourceManagerImpl.createDefaultDsName(ldapGatewaySource.getDescription(), ldapGatewaySource.getPrincipal()));
            } else {
                dsbean.setDsName(ldapGatewaySource.getName());
            }
            dsbean.setDescription(dsbean.getDsName());
            dsbean.setCredentials(SecretReferenceUtil.isSecretReference((String)ldapGatewaySource.getCredentials()) ? ldapGatewaySource.getCredentials() : FieldObfuscator.REAL.deobfuscate(ldapGatewaySource.getCredentials()));
            dsbean.setClientTlsCertificate(ldapGatewaySource.getClientTlsCertAlias());
            dsbean.setMaskAttributeValues(ldapGatewaySource.getMaskAttributeValues());
            try {
                dsbean.setLdapType(!StringUtils.isBlank((String)ldapGatewaySource.getLdapType()) ? LdapInfo.LdapType.canonicalName((String)ldapGatewaySource.getLdapType()) : LdapInfo.LdapType.Undefined);
            }
            catch (LdapTypeNotFoundException e) {
                log.warn((Object)("Could not find the LdapType for " + ldapGatewaySource.getLdapType() + ". Defaulting to the undefined type"));
                dsbean.setLdapType(LdapInfo.LdapType.Undefined);
            }
            ldapTypeDesc = !StringUtils.isBlank((String)ldapGatewaySource.getLdapTypeDesc()) ? ldapGatewaySource.getLdapTypeDesc() : LdapInfo.LdapType.Undefined.toString();
            dsbean.setLdapTypeDesc(ldapTypeDesc);
            List tagEntries = Optional.of(ldapGatewaySource).map(LdapSource::getLdapHostTagList).map(LdapTagList::getTagEntryArray).map(Arrays::asList).orElse(new ArrayList());
            LinkedList<LdapTagConfig> ldapTagConfigList = new LinkedList<LdapTagConfig>();
            for (LdapTagEntry tagEntry : tagEntries) {
                boolean isDefault = ldapGatewaySource.getHost().equals(tagEntry.getHost());
                LdapTagConfig tagConfig = new LdapTagConfig(new LdapInstanceIdentifier(tagEntry.getHost()), tagEntry.getTags(), isDefault);
                ldapTagConfigList.add(tagConfig);
            }
            dsbean.setLdapTagConfigList(ldapTagConfigList);
            DataSourceManagerImpl.setPoolOptions(dsbean, (LdapSource)ldapGatewaySource);
            DataSourceManagerImpl.setBinaryAttributes(dsbean, (LdapSource)ldapGatewaySource);
            if (ldapGatewaySource.isSetLastModified()) {
                dsbean.setLastModified(ldapGatewaySource.getLastModified());
            }
            ldapDataSources.add(dsbean);
        }
        return ldapDataSources;
    }

    private static String createDefaultDsName(String dataSourceIdentifier, String username) {
        return dataSourceIdentifier + " (" + username + ")";
    }

    private static void setBinaryAttributes(LdapDataSource dsbean, LdapSource dsxml) {
        BinaryAttributesType binaryAttributesType = dsxml.getBinaryAttributes();
        if (binaryAttributesType != null) {
            dsbean.setBinaryAttributes(new ArrayList<String>(Arrays.asList(binaryAttributesType.getBinaryAttributeArray())));
        }
    }

    private static void setBinaryAttributes(LdapDataSource dsbean, LdapGatewaySource dsxml) {
        BinaryAttributesType binaryAttributesType = dsxml.getBinaryAttributes();
        if (binaryAttributesType != null) {
            dsbean.setBinaryAttributes(new ArrayList<String>(Arrays.asList(binaryAttributesType.getBinaryAttributeArray())));
        }
    }

    private static void setPoolOptions(LdapDataSource dsbean, LdapSource dsxml) {
        int maxConn = dsxml.getMaxTotal() > dsxml.getMaxActive() ? dsxml.getMaxTotal() : dsxml.getMaxActive();
        if (maxConn <= dsxml.getMinIdle()) {
            maxConn = dsxml.getMinIdle();
        }
        dsbean.setTestOnBorrow(dsxml.getTestOnBorrow());
        dsbean.setTestOnReturn(dsxml.getTestOnReturn());
        dsbean.setCreateIfNecessary(dsxml.getCreateIfNecessary());
        dsbean.setRetryFailedOperations(dsxml.getRetryFailedOperations());
        dsbean.setMin(dsxml.getMinIdle());
        dsbean.setMax(maxConn);
        dsbean.setMaxWait(dsxml.getMaxWait());
        dsbean.setTimeBetweenEvictionRunsMillis(dsxml.getTimeBetweenEvictionRunsMillis());
        dsbean.setReadTimeoutMillis(dsxml.getReadTimeoutMillis());
        dsbean.setConnTimeoutMillis(dsxml.getConnTimeoutMillis());
        dsbean.setVerifyHost(dsxml.getVerifyHost());
        dsbean.setDnsTtlMillis(dsxml.getDnsTtlMillis());
        dsbean.setLdapDnsSrvPrefix(dsxml.getLdapDnsSrvPrefix());
        dsbean.setLdapsDnsSrvPrefix(dsxml.getLdapsDnsSrvPrefix());
    }

    @Override
    public final LdapDataSource getDefaultLdapDataSourceSettings() {
        if (this.sourceForDefaultSettings == null) {
            this.sourceForDefaultSettings = new LdapDataSource();
            LdapSource dsxml = LdapSource.Factory.newInstance();
            DataSourceManagerImpl.setPoolOptions(this.sourceForDefaultSettings, dsxml);
        }
        return this.sourceForDefaultSettings;
    }

    @Override
    public synchronized Collection<LdapDataSource> getLdapDataSources() {
        return this.ldapSources.values();
    }

    @Override
    public synchronized LdapDataSource getLdapDataSource(String dataSourceId) {
        return this.ldapSources.get(dataSourceId);
    }

    @Override
    public synchronized void saveLdapDataSource(LdapDataSource dataSource) {
        log.debug((Object)("Saving LDAP DataSource " + dataSource.getId() + "..."));
        String id = dataSource.getId();
        AdminAuditLogger.Event event = AdminAuditLogger.Event.MODIFY;
        if (StringUtils.isBlank((String)id)) {
            id = this.generateId(ID_BASE_LDAP);
            dataSource.setId(id);
            event = AdminAuditLogger.Event.CREATE;
        }
        this.ldapSources.put(id, dataSource);
        dataSource.setLastModified((Calendar)new XmlCalendar(new Date()));
        this.doSaveDataSource(this::saveLdapSources, event, dataSource.getId());
        this.removeDataSourceFromTestCache(dataSource);
    }

    @Override
    public synchronized void deleteLdapDataSource(LdapDataSource dataSource) {
        if (this.ldapSources.containsKey(dataSource.getId())) {
            this.ldapSources.remove(dataSource.getId());
            this.doSaveDataSource(this::saveLdapSources, AdminAuditLogger.Event.DELETE, dataSource.getId());
            this.removeDataSourceFromTestCache(dataSource);
        }
    }

    @Override
    public String exportLdapSource(String instanceId) {
        LdapDataSource dataSource = this.getLdapDataSource(instanceId);
        if (dataSource != null) {
            return DataSourceManagerImpl.exportLdapSource(dataSource);
        }
        log.warn((Object)("Unable to export LDAP source: " + instanceId + ". Data source not found."));
        return null;
    }

    public static String exportLdapSource(LdapDataSource dataSource) {
        LdapSourcesDocument ldapDataSourcesDoc = LdapSourcesDocument.Factory.newInstance();
        LdapSources datasources = ldapDataSourcesDoc.addNewLdapSources();
        if (dataSource.isGatewayEnabled()) {
            DataSourceManagerImpl.addLdapGatewaySourceType(datasources, dataSource);
        } else {
            DataSourceManagerImpl.addLdapSourceType(datasources, dataSource);
        }
        return ldapDataSourcesDoc.toString();
    }

    public static String exportLdapSources(List<LdapDataSource> ldapDataSources) {
        LdapSourcesDocument ldapDataSourcesDoc = LdapSourcesDocument.Factory.newInstance();
        LdapSources datasourcesEl = ldapDataSourcesDoc.addNewLdapSources();
        for (LdapDataSource ldapDataSource : ldapDataSources) {
            if (ldapDataSource.isGatewayEnabled()) {
                DataSourceManagerImpl.addLdapGatewaySourceType(datasourcesEl, ldapDataSource);
                continue;
            }
            DataSourceManagerImpl.addLdapSourceType(datasourcesEl, ldapDataSource);
        }
        return ldapDataSourcesDoc.toString();
    }

    @Override
    public String exportLdapSources() {
        LdapSourcesDocument ldapDataSourcesDoc = null;
        try {
            String dataDir = this.sysDirInfo.getDataDirectory();
            ldapDataSourcesDoc = (LdapSourcesDocument)this.xmlLoader.load(dataDir, LDAP_XML_FILE_NAME);
        }
        catch (ConfigurationException ex) {
            log.warn((Object)("No LDAP sources are loaded. " + ex.getMessage()));
        }
        return ldapDataSourcesDoc == null ? null : ldapDataSourcesDoc.toString();
    }

    @Override
    public void importLdapSources(String xml, boolean allowUpdate) throws XmlException {
        if (StringUtils.isEmpty((String)xml)) {
            log.warn((Object)"LDAP sources not imported.  XML configuration was empty.");
        } else {
            Node node = XmlBeansUtil.parseToNode(xml);
            LdapSourcesDocument doc = LdapSourcesDocument.Factory.parse((Node)node);
            this.loadLdapSources(doc, false, allowUpdate);
            this.saveLdapSources();
        }
    }

    private synchronized void saveLdapSources() {
        log.debug((Object)"Saving LDAP DataSources...");
        LdapSourcesDocument doc = LdapSourcesDocument.Factory.newInstance();
        LdapSources ldapSourcesType = doc.addNewLdapSources();
        for (LdapDataSource dsbean : this.ldapSources.values()) {
            if (dsbean.isGatewayEnabled()) {
                DataSourceManagerImpl.addLdapGatewaySourceType(ldapSourcesType, dsbean);
                continue;
            }
            DataSourceManagerImpl.addLdapSourceType(ldapSourcesType, dsbean);
        }
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), LDAP_XML_FILE_NAME, (XmlObject)doc);
    }

    private static void addLdapGatewaySourceType(LdapSources ldapSourcesType, LdapDataSource dsbean) {
        LdapGatewaySource dsxml = ldapSourcesType.addNewLdapGatewaySource();
        dsxml.setId(dsbean.getId());
        dsxml.setDescription(dsbean.getDescription());
        dsxml.setPingOneConnection(dsbean.getPingOneConnection());
        dsxml.setPingOneEnvironment(dsbean.getPingOneEnvironment());
        dsxml.setPingOneGateway(dsbean.getPingOneGateway());
        dsxml.setName(dsbean.getDsName());
        dsxml.setLdapType(dsbean.getLdapType().toString());
        dsxml.setLdapTypeDesc(dsbean.getLdapTypeDesc());
        dsxml.setMaskAttributeValues(dsbean.isMaskAttributeValues());
        dsxml.setUseSsl(dsbean.getUseSSL());
        dsxml.setUseStartTLS(dsbean.getUseStartTLS());
        if (dsbean.getLastModified() != null) {
            dsxml.setLastModified(dsbean.getLastModified());
        }
        if (dsbean.getBinaryAttributes() != null) {
            BinaryAttributesType binaryAttributesType = dsxml.addNewBinaryAttributes();
            for (String binaryAttribute : dsbean.getBinaryAttributes()) {
                binaryAttributesType.addBinaryAttribute(binaryAttribute);
            }
        }
    }

    private static void addLdapSourceType(LdapSources ldapSourcesType, LdapDataSource dsbean) {
        LdapSource dsxml = ldapSourcesType.addNewLdapSource();
        dsxml.setId(dsbean.getId());
        dsxml.setDescription(dsbean.getDescription());
        if (StringUtils.isBlank((String)dsbean.getDsName())) {
            String defaultName = DataSourceManagerImpl.createDefaultDsName(dsbean.getDescription(), dsbean.getPrincipal());
            dsbean.setDsName(defaultName);
        }
        dsxml.setName(dsbean.getDsName());
        dsxml.setHost(dsbean.getHost());
        dsxml.setUseSsl(dsbean.getUseSSL());
        dsxml.setPrincipal(dsbean.getPrincipal());
        dsxml.setCredentials(SecretReferenceUtil.isSecretReference((String)dsbean.getCredentials()) ? dsbean.getCredentials() : FieldObfuscator.REAL.obfuscate(dsbean.getCredentials()));
        dsxml.setClientTlsCertAlias(dsbean.getClientTlsCertificate());
        dsxml.setAuthenticationMeth(dsbean.getAuthenticationMethod());
        dsxml.setMaskAttributeValues(dsbean.isMaskAttributeValues());
        dsxml.setLdapType(dsbean.getLdapType().toString());
        dsxml.setLdapTypeDesc(dsbean.getLdapTypeDesc());
        dsxml.setUseDnsSrvRecords(dsbean.isUseDnsSrvRecords());
        dsxml.setAdReferral(dsbean.isUseAdReferral());
        if (dsbean.getLastModified() != null) {
            dsxml.setLastModified(dsbean.getLastModified());
        }
        dsxml.setUseStartTLS(dsbean.getUseStartTLS());
        LdapTagList dsxmlLdapTagList = dsxml.addNewLdapHostTagList();
        for (LdapTagConfig tagConfig : dsbean.getLdapTagConfigList()) {
            LdapTagEntry dsxmlLdapTagEntry = dsxmlLdapTagList.addNewTagEntry();
            dsxmlLdapTagEntry.setHost(tagConfig.getIdentifier().getHostname());
            dsxmlLdapTagEntry.setTags(tagConfig.getTags());
        }
        dsxml.setTestOnBorrow(dsbean.isTestOnBorrow());
        dsxml.setTestOnReturn(dsbean.isTestOnReturn());
        dsxml.setCreateIfNecessary(dsbean.isCreateIfNecessary());
        dsxml.setRetryFailedOperations(dsbean.isRetryFailedOperations());
        dsxml.setMinIdle(dsbean.getMin());
        dsxml.setMaxActive(dsbean.getMax());
        dsxml.setMaxWait(dsbean.getMaxWait());
        dsxml.setTimeBetweenEvictionRunsMillis(dsbean.getTimeBetweenEvictionRunsMillis());
        dsxml.setReadTimeoutMillis(dsbean.getReadTimeoutMillis());
        dsxml.setConnTimeoutMillis(dsbean.getConnTimeoutMillis());
        dsxml.setVerifyHost(dsbean.isVerifyHost());
        dsxml.setDnsTtlMillis(dsbean.getDnsTtlMillis());
        dsxml.setLdapDnsSrvPrefix(dsbean.getLdapDnsSrvPrefix());
        dsxml.setLdapsDnsSrvPrefix(dsbean.getLdapsDnsSrvPrefix());
        if (dsbean.getBinaryAttributes() != null) {
            BinaryAttributesType binaryAttributesType = dsxml.addNewBinaryAttributes();
            for (String binaryAttribute : dsbean.getBinaryAttributes()) {
                binaryAttributesType.addBinaryAttribute(binaryAttribute);
            }
        }
    }

    private synchronized void test(LdapDataSource ldapDS) throws NamingException, SecretManagerException {
        ldapDS.isConnectionSuccessful();
    }

    @Override
    public boolean isInUse(DataSource ds) {
        boolean inUse = false;
        if (ds != null) {
            inUse = InUseDetectionUtil.getInstance().isDataSourceInUse(ds);
        }
        return inUse;
    }

    @Override
    public Map<String, ConnectionPoolMetrics> getJdbcDataSourcesConnectionPoolMetrics() {
        HashMap<String, ConnectionPoolMetrics> results = new HashMap<String, ConnectionPoolMetrics>();
        for (JdbcDataSource ds : this.jdbcSources.values()) {
            try {
                InitialContext initialContext = new InitialContext();
                Object obj = initialContext.lookup(ds.getJndiName());
                if (obj instanceof BoneCPDataSource) {
                    log.debug((Object)"BoneCPDataSource is not supported for connection pool metrics. Please consider using DBCP instead. See the PingFederate Documentation for more information on converting to DBCP.");
                    continue;
                }
                BasicDataSource bds = (BasicDataSource)obj;
                if (bds == null) continue;
                results.put(ds.getId(), new ConnectionPoolMetrics(bds.getMaxTotal(), bds.getNumActive(), bds.getNumIdle(), ds.getMinPoolSize()));
            }
            catch (NamingException e) {
                log.debug((Object)("DataSource " + ds.getId() + " doesn't exist, no connection pool metrics found."));
            }
        }
        return results;
    }

    @Override
    public synchronized boolean test(DataSource ds) {
        try {
            this.test(ds, true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public synchronized void test(DataSource ds, boolean allowUseTestCache) throws NamingException, SecretManagerException, SQLException {
        String dataSourceId = ds.getId();
        Date lastTestDate = this.datasourceToLastCheckedMap.get(dataSourceId);
        if (!allowUseTestCache || this.isTestOutsideTimeoutPeriod(lastTestDate)) {
            if (ds instanceof JdbcDataSource) {
                boolean redeploy = !allowUseTestCache;
                this.test((JdbcDataSource)ds, redeploy);
            } else if (ds instanceof LdapDataSource) {
                this.test((LdapDataSource)ds);
            } else if (ds instanceof CustomDataSource) {
                this.test((CustomDataSource)ds);
            }
            if (dataSourceId != null) {
                Date now = new Date();
                this.datasourceToLastCheckedMap.put(dataSourceId, now);
            }
        }
    }

    private boolean isTestOutsideTimeoutPeriod(Date lastTestDate) {
        long timeoutInMilli = (long)MetaDataFactory.getLocalMetaData().getDataStoreValidationInterval() * 1000L;
        return lastTestDate == null || System.currentTimeMillis() - lastTestDate.getTime() > timeoutInMilli;
    }

    private synchronized void test(CustomDataSource cds) throws NamingException {
        if (cds.getDriver() == null) {
            this.loadCustomDataSourceDriver(cds);
        }
        try (DSEventTimer ignored = DSEventTimer.getOtherInstance(cds.getId(), cds.getName(), "test-connection", this);){
            if (!cds.getDriver().testConnection()) {
                throw new CommunicationException("Custom Datastore Test Connection Failed.");
            }
        }
    }

    synchronized void loadCustomAttributeSources() {
        try {
            String dataDir = this.sysDirInfo.getDataDirectory();
            CustomSourcesDocument doc = (CustomSourcesDocument)this.xmlLoader.load(dataDir, CUSTOM_XML_FILE_NAME);
            this.loadCustomAttributeSources(doc, true, true);
        }
        catch (ConfigurationException e) {
            log.info((Object)("No Custom Attribute sources are loaded. " + e.getMessage()));
            this.customSources.clear();
        }
    }

    private synchronized void loadCustomAttributeSources(CustomSourcesDocument doc, boolean clearCurrentSources, boolean allowUpdate) {
        if (clearCurrentSources) {
            this.customSources.clear();
        }
        for (CustomDataSource dsbean : DataSourceManagerImpl.parseCustomDataSourcesXml(doc)) {
            block4: {
                String sourceId = dsbean.getId();
                if (!allowUpdate && this.customSources.containsKey(sourceId)) continue;
                try {
                    PluginFipsStatus fipsStatus;
                    SourceDescriptor sourceDescriptor = this.getSourceDescriptor(dsbean.getDriverClassName());
                    dsbean.setGuiDescriptor((GuiConfigDescriptor)sourceDescriptor.getConfigurationGuiDescriptor());
                    this.loadCustomDataSourceDriver(dsbean);
                    if (!PropertyInfo.isBCFIPSMode() || (fipsStatus = AdapterUtils.getPluginFipsStatus(sourceDescriptor.getPluginClassName(), sourceDescriptor.getMetadata())) == PluginFipsStatus.COMPLIANT) break block4;
                    log.warn((Object)("'" + dsbean.getDescription() + "' FIPS status: " + fipsStatus + " (" + sourceDescriptor.getType() + ", " + sourceDescriptor.getPluginClassName() + ")"));
                }
                catch (ConfigurationException e) {
                    String errorMessage = "Unable to load Custom Datastore: '" + dsbean.getId() + "' " + e.getMessage();
                    log.error((Object)errorMessage);
                    log.debug((Object)errorMessage, (Throwable)e);
                    continue;
                }
            }
            this.customSources.put(dsbean.getId(), dsbean);
            this.configSupport.loadConf(dsbean);
        }
    }

    public static List<CustomDataSource> parseCustomDataSourcesXml(String xml) throws XmlException {
        return DataSourceManagerImpl.parseCustomDataSourcesXml(CustomSourcesDocument.Factory.parse((String)xml));
    }

    private static List<CustomDataSource> parseCustomDataSourcesXml(CustomSourcesDocument doc) {
        CustomSource[] datasources = doc.getCustomSources().getCustomSourceArray();
        ArrayList<CustomDataSource> customDataSources = new ArrayList<CustomDataSource>(datasources.length);
        for (CustomSource dsxml : datasources) {
            CustomDataSource dsbean = new CustomDataSource();
            dsbean.setId(dsxml.getId());
            dsbean.setDescription(dsxml.getDescription());
            dsbean.setDriverClassName(dsxml.getDriverClassName());
            dsbean.setMaskAttributeValues(dsxml.getMaskAttributeValues());
            customDataSources.add(dsbean);
        }
        return customDataSources;
    }

    @Override
    public synchronized Collection<CustomDataSource> getCustomDataSources() {
        return this.customSources.values();
    }

    @Override
    public synchronized CustomDataSource getCustomDataSource(String sourceId) {
        CustomDataSource customDataSource = this.customSources.get(sourceId);
        if (customDataSource == null && log.isErrorEnabled()) {
            log.error((Object)("Unable to load custom data source instance: " + sourceId));
        }
        return customDataSource;
    }

    @Override
    public synchronized void saveCustomDataSource(CustomDataSource dataSource) {
        String id = dataSource.getId();
        AdminAuditLogger.Event event = AdminAuditLogger.Event.MODIFY;
        if (StringUtils.isBlank((String)id)) {
            id = this.generateId(ID_BASE_Custom);
            dataSource.setId(id);
            event = AdminAuditLogger.Event.CREATE;
        }
        log.debug((Object)("Saving Custom Attribute Source " + dataSource.getId() + "..."));
        this.customSources.put(dataSource.getId(), dataSource);
        dataSource.setLastModified((Calendar)new XmlCalendar(new Date()));
        this.doSaveDataSource(this::saveCustomAttributeSources, event, dataSource.getId());
        this.removeDataSourceFromTestCache(dataSource);
        HttpConnectionPoolingManager.getInstance().removeClient(id);
    }

    @Override
    public synchronized void deleteCustomDataSource(CustomDataSource dataSource) {
        if (this.customSources.containsKey(dataSource.getId())) {
            this.customSources.remove(dataSource.getId());
            this.doSaveDataSource(this::saveCustomAttributeSources, AdminAuditLogger.Event.DELETE, dataSource.getId());
            this.configSupport.deleteConf(dataSource);
            this.removeDataSourceFromTestCache(dataSource);
            HttpConnectionPoolingManager.getInstance().removeClient(dataSource.getId());
        }
    }

    @Override
    public Collection<DataSource> getAllDataSources() {
        return Lists.newArrayList(Iterables.concat(this.getJdbcDataSources(), this.getLdapDataSources(), this.getCustomDataSources()).iterator());
    }

    @Override
    public DataSource getDataSource(String dataSourceId) {
        DataSource dataSource = this.getJdbcDataSource(dataSourceId);
        if (dataSource == null) {
            dataSource = this.getLdapDataSource(dataSourceId);
        }
        if (dataSource == null) {
            dataSource = this.getCustomDataSource(dataSourceId);
        }
        return dataSource;
    }

    @Override
    public void deleteDataSource(DataSource dataSource) {
        switch (DataSource.DSType.fromName(dataSource.getDataSourceType())) {
            case JDBC: {
                this.deleteJdbcDataSource((JdbcDataSource)dataSource);
                break;
            }
            case LDAP: {
                this.deleteLdapDataSource((LdapDataSource)dataSource);
                break;
            }
            case Other: {
                this.deleteCustomDataSource((CustomDataSource)dataSource);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data source type: " + dataSource.getDataSourceType());
            }
        }
    }

    @Override
    public void saveDataSource(DataSource dataSource) {
        switch (DataSource.DSType.fromName(dataSource.getDataSourceType())) {
            case JDBC: {
                this.saveJdbcDataSource((JdbcDataSource)dataSource);
                break;
            }
            case LDAP: {
                this.saveLdapDataSource((LdapDataSource)dataSource);
                break;
            }
            case Other: {
                this.saveCustomDataSource((CustomDataSource)dataSource);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data source type: " + dataSource.getDataSourceType());
            }
        }
        this.removeDataSourceFromTestCache(dataSource);
    }

    @Override
    public synchronized Collection<SourceDescriptor> discoverSourceDescriptors() {
        LinkedList<SourceDescriptor> descriptors = new LinkedList<SourceDescriptor>();
        Set<String> classNames = this.support.getInstalledClassNames(CD_DESCRIPTOR_NAME);
        for (String className : classNames) {
            CustomDataSourceDriver configurableAdapter = this.support.createInstance(className, CustomDataSourceDriver.class);
            if (configurableAdapter == null) continue;
            SourceDescriptor adapterDescriptor = configurableAdapter.getSourceDescriptor();
            if (adapterDescriptor == null) {
                String msg = configurableAdapter.getClass().getName() + " returned a null AdapterDescriptor";
                log.warn((Object)msg);
                String type = configurableAdapter.getClass().getName();
                adapterDescriptor = new SourceDescriptor((ConfigurableDriver)configurableAdapter, type);
            }
            descriptors.add(adapterDescriptor);
        }
        return descriptors;
    }

    @Override
    public synchronized void loadCustomDataSourceDriver(CustomDataSource attributeSource) {
        String driverClassName = attributeSource.getDriverClassName();
        CustomDataSourceDriver driver = this.support.createInstance(driverClassName, CustomDataSourceDriver.class);
        if (driver == null) {
            throw new ConfigurationException("Failed to load the driver with class name " + driverClassName);
        }
        AdapterConfigurationGuiDescriptor configGuiDesc = driver.getSourceDescriptor().getConfigurationGuiDescriptor();
        attributeSource.setGuiDescriptor((GuiConfigDescriptor)configGuiDesc);
        this.configSupport.loadConf(attributeSource);
        attributeSource.setDriver(driver);
    }

    @Override
    public synchronized SourceDescriptor getSourceDescriptor(String attributeSourceDriverClassName) {
        log.debug((Object)("Creating class " + attributeSourceDriverClassName));
        CustomDataSourceDriver driver = this.support.createInstance(attributeSourceDriverClassName, CustomDataSourceDriver.class);
        if (driver == null) {
            throw new ConfigurationException("Failed to load driver with class name " + attributeSourceDriverClassName);
        }
        SourceDescriptor sourceDescriptor = driver.getSourceDescriptor();
        return sourceDescriptor;
    }

    @Override
    public String exportCustomDataSource(String instanceId) {
        CustomDataSource dataSource = this.getCustomDataSource(instanceId);
        if (dataSource != null) {
            this.saveConfigurationGuiDescription(dataSource);
            return DataSourceManagerImpl.exportCustomDataSource(dataSource);
        }
        log.warn((Object)("Unable to export Custom source: " + instanceId + ". Data source not found."));
        return null;
    }

    @Override
    public synchronized String exportCustomDataSourceConfiguration(String instanceId) {
        CustomDataSource dsbean = this.customSources.get(instanceId);
        String customDataSourceConfiguration = null;
        if (dsbean != null) {
            customDataSourceConfiguration = this.configSupport.toXml(dsbean);
        }
        return customDataSourceConfiguration;
    }

    public static String exportCustomDataSource(CustomDataSource customDataSource) {
        CustomSourcesDocument customDataSourcesDoc = CustomSourcesDocument.Factory.newInstance();
        CustomDataSources datasources = customDataSourcesDoc.addNewCustomSources();
        DataSourceManagerImpl.addCustomSourceType(datasources, customDataSource);
        return customDataSourcesDoc.toString();
    }

    public static String exportCustomDataSources(List<CustomDataSource> customDataSources) {
        CustomSourcesDocument customDataSourcesDoc = CustomSourcesDocument.Factory.newInstance();
        CustomDataSources customDataSourcesEl = customDataSourcesDoc.addNewCustomSources();
        for (CustomDataSource customDataSource : customDataSources) {
            DataSourceManagerImpl.addCustomSourceType(customDataSourcesEl, customDataSource);
        }
        return customDataSourcesDoc.toString();
    }

    @Override
    public String exportCustomDataSources() {
        CustomSourcesDocument customDataSourcesDoc = null;
        try {
            String dataDir = this.sysDirInfo.getDataDirectory();
            customDataSourcesDoc = (CustomSourcesDocument)this.xmlLoader.load(dataDir, CUSTOM_XML_FILE_NAME);
        }
        catch (ConfigurationException ex) {
            log.warn((Object)("No Custom Attribute sources are loaded. " + ex.getMessage()));
        }
        return customDataSourcesDoc == null ? null : customDataSourcesDoc.toString();
    }

    @Override
    public synchronized void importCustomDataSource(String definitionXml, String guiDescriptionXml, boolean allowUpdate) throws XmlException {
        if (StringUtils.isEmpty((String)guiDescriptionXml)) {
            log.warn((Object)"Custom source not imported. guiDescriptionXml was empty.");
        } else if (StringUtils.isEmpty((String)definitionXml)) {
            log.warn((Object)"Custom source not imported. definitionXml was empty.");
        } else {
            Node node = XmlBeansUtil.parseToNode(definitionXml);
            CustomSourcesDocument doc = CustomSourcesDocument.Factory.parse((Node)node);
            List<CustomDataSource> customDataSources = DataSourceManagerImpl.parseCustomDataSourcesXml(doc);
            CustomDataSource definitionBean = customDataSources.get(0);
            PluginManagementSupport.PluginInstanceFactory instanceFactory = () -> {
                CustomDataSource pluginInstance = new CustomDataSource();
                pluginInstance.setId(definitionBean.getId());
                pluginInstance.setDescription(definitionBean.getDescription());
                pluginInstance.setDriverClassName(definitionBean.getDriverClassName());
                pluginInstance.setMaskAttributeValues(definitionBean.isMaskAttributeValues());
                this.loadCustomDataSourceDriver(pluginInstance);
                return pluginInstance;
            };
            CustomDataSource dsbean = (CustomDataSource)this.configSupport.parseXml(guiDescriptionXml, instanceFactory);
            if (this.customSources.get(dsbean.getId()) == null || allowUpdate) {
                this.customSources.put(dsbean.getId(), dsbean);
                this.saveCustomAttributeSources();
            }
        }
    }

    public List<CustomDataSource> getXmlCustomDataSources() {
        try {
            String dataDir = this.sysDirInfo.getDataDirectory();
            CustomSourcesDocument doc = (CustomSourcesDocument)this.xmlLoader.load(dataDir, CUSTOM_XML_FILE_NAME);
            return DataSourceManagerImpl.parseCustomDataSourcesXml(doc);
        }
        catch (ConfigurationException ex) {
            log.info((Object)("No Custom Attribute sources are loaded. " + ex.getMessage()));
            return Collections.emptyList();
        }
    }

    private synchronized void saveCustomAttributeSources() {
        log.debug((Object)"Saving Custom Attribute DataSources...");
        CustomSourcesDocument doc = CustomSourcesDocument.Factory.newInstance();
        CustomDataSources customSourcesType = doc.addNewCustomSources();
        for (CustomDataSource dsbean : this.customSources.values()) {
            DataSourceManagerImpl.addCustomSourceType(customSourcesType, dsbean);
            this.saveConfigurationGuiDescription(dsbean);
        }
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), CUSTOM_XML_FILE_NAME, (XmlObject)doc);
    }

    private static void addCustomSourceType(CustomDataSources customSourcesType, CustomDataSource dsbean) {
        CustomSource dsxml = customSourcesType.addNewCustomSource();
        dsxml.setId(dsbean.getId());
        dsxml.setDescription(dsbean.getDescription());
        dsxml.setDriverClassName(dsbean.getDriverClassName());
        dsxml.setMaskAttributeValues(dsbean.isMaskAttributeValues());
    }

    private synchronized void saveConfigurationGuiDescription(CustomDataSource dsbean) {
        SourceDescriptor sourceDescriptor = this.getSourceDescriptor(dsbean.getDriverClassName());
        dsbean.setGuiDescriptor((GuiConfigDescriptor)sourceDescriptor.getConfigurationGuiDescriptor());
        this.configSupport.saveConf(dsbean);
    }

    private void removeDataSourceFromTestCache(DataSource dataSource) {
        this.datasourceToLastCheckedMap.remove(dataSource.getId());
    }

    private void doSaveDataSource(SaveDataSource func, AdminAuditLogger.Event event, String message) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            func.save();
            auditLoggerScope.log(AdminAuditLogger.Component.DATA_STORE, event, message);
        }
    }

    @FunctionalInterface
    private static interface SaveDataSource {
        public void save();
    }
}

