/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.sdk.DescribablePlugin;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.impl.AdapterMgmtConfigSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginSupport;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.xmlbinding.adapterconf.AdapterConfigurationDocument;
import org.sourceid.saml20.xmlbinding.adapterconf.AdapterConfigurationType;
import org.sourceid.saml20.xmlbinding.adapterconf.ConfigType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeMappingType;

public class IdpAdapterMgmtConfigSupport
extends AdapterMgmtConfigSupport {
    @Override
    ConfigType constructConfigType(XmlObject document, ConfigurablePluginInstance pluginInstance) {
        AdapterConfigurationDocument adapterConfigDoc = (AdapterConfigurationDocument)document;
        AdapterConfigurationType adapterConfigurationType = adapterConfigDoc.getAdapterConfiguration();
        return this.constructConfigType((ConfigType)adapterConfigurationType, pluginInstance);
    }

    @Override
    public ConfigType constructConfigType(ConfigType adapterConfigurationType, ConfigurablePluginInstance pluginInstance) {
        if (pluginInstance instanceof IdpAuthnAdapterInstance) {
            AdapterConfigurationType adapterConfigType = (AdapterConfigurationType)adapterConfigurationType;
            IdpAuthnAdapterInstance idpAuthnAdapterInstance = (IdpAuthnAdapterInstance)pluginInstance;
            if (adapterConfigType.isSetAuthnCtxClassRef()) {
                idpAuthnAdapterInstance.setAuthnCtxClassRef(adapterConfigType.getAuthnCtxClassRef());
            }
            String[] uniqueKeyFieldArray = adapterConfigType.getUniqueKeyFieldArray();
            ArrayList<String> uniqueKeyFields = new ArrayList<String>(Arrays.asList(uniqueKeyFieldArray));
            idpAuthnAdapterInstance.setOwnUniqueKeyFields(uniqueKeyFields);
            idpAuthnAdapterInstance.setUniqueUserKeyAttribute(adapterConfigType.getUniqueUserKeyField());
            String[] maskedFieldArray = adapterConfigType.getMaskedFieldArray();
            HashSet<String> maskedFieldSet = new HashSet<String>(Arrays.asList(maskedFieldArray));
            idpAuthnAdapterInstance.setOwnMaskedFields(maskedFieldSet);
            Configuration configuration = idpAuthnAdapterInstance.getConfiguration();
            configuration.setMaskedAttrNames(maskedFieldSet);
            idpAuthnAdapterInstance.setOwnMaskOgnlValues(adapterConfigType.getMaskOgnlValues());
            idpAuthnAdapterInstance.setInheritingAttributeSettings(adapterConfigType.getIsInheritAttributeSettings());
            ConnectionUtil connectionUtil = new ConnectionUtil();
            idpAuthnAdapterInstance.setAttributeMapping(connectionUtil.getAttributeMapping(adapterConfigType.getAttributeMapping()));
            idpAuthnAdapterInstance.setInheritingAttributeMapping(adapterConfigType.getIsInheritAttributeMapping());
        }
        return adapterConfigurationType;
    }

    @Override
    public void saveConf(AuthnAdapterInstance authnAdapterInstance) {
        this.saveConf((IdpAuthnAdapterInstance)authnAdapterInstance);
    }

    public void saveConf(IdpAuthnAdapterInstance idpAuthnAdapterInstance) {
        AdapterConfigurationDocument adapterConfigDoc = AdapterConfigurationDocument.Factory.newInstance();
        AdapterConfigurationType adapterConfigType = this.addAdapterConfigType(adapterConfigDoc, idpAuthnAdapterInstance);
        this.saveConf(idpAuthnAdapterInstance, (ConfigType)adapterConfigType, (XmlObject)adapterConfigDoc);
    }

    private AdapterConfigurationType addAdapterConfigType(AdapterConfigurationDocument adapterConfigDoc, IdpAuthnAdapterInstance idpAuthnAdapterInstance) {
        AdapterConfigurationType adapterConfigType = adapterConfigDoc.addNewAdapterConfiguration();
        return this.fillInAdapterConfigType(idpAuthnAdapterInstance, adapterConfigType);
    }

    public AdapterConfigurationType fillInAdapterConfigType(IdpAuthnAdapterInstance idpAuthnAdapterInstance, AdapterConfigurationType adapterConfigType) {
        adapterConfigType.setAuthnCtxClassRef(idpAuthnAdapterInstance.getAuthnCtxClassRef());
        boolean inheritAttributeSettings = idpAuthnAdapterInstance.isInheritingAttributeSettings();
        adapterConfigType.setIsInheritAttributeSettings(inheritAttributeSettings);
        adapterConfigType.setIsInheritAttributeMapping(idpAuthnAdapterInstance.isInheritingAttributeMapping());
        if (!inheritAttributeSettings) {
            adapterConfigType.setMaskOgnlValues(idpAuthnAdapterInstance.getMaskOgnlValues());
            List<String> uniqueKeyFields = idpAuthnAdapterInstance.getUniqueKeyFields();
            String[] uniqueKeyFieldsArray = uniqueKeyFields.toArray(new String[uniqueKeyFields.size()]);
            adapterConfigType.setUniqueKeyFieldArray(uniqueKeyFieldsArray);
            Set<String> maskedFields = idpAuthnAdapterInstance.getMaskedFields();
            String[] masked = maskedFields.toArray(new String[maskedFields.size()]);
            adapterConfigType.setMaskedFieldArray(masked);
            adapterConfigType.setUniqueUserKeyField(idpAuthnAdapterInstance.getUniqueUserKeyAttribute());
        }
        if (!idpAuthnAdapterInstance.isInheritingAttributeMapping()) {
            AttributeMappingType attributeMappingType = adapterConfigType.addNewAttributeMapping();
            ConnectionUtil connectionUtil = new ConnectionUtil();
            connectionUtil.fillInAttributeMappingType(attributeMappingType, idpAuthnAdapterInstance.getAttributeMapping());
        }
        return adapterConfigType;
    }

    @Override
    public String toXml(AuthnAdapterInstance authnAdapterInstance) {
        IdpAuthnAdapterInstance idpAuthnAdapterInstance = (IdpAuthnAdapterInstance)authnAdapterInstance;
        String xml = "";
        if (idpAuthnAdapterInstance != null) {
            AdapterConfigurationDocument adapterConfigDoc = AdapterConfigurationDocument.Factory.newInstance();
            AdapterConfigurationType adapterConfigType = this.addAdapterConfigType(adapterConfigDoc, idpAuthnAdapterInstance);
            super.fillInDoc(idpAuthnAdapterInstance, (ConfigType)adapterConfigType);
            XmlOptions opts = XmlBeansUtil.getXmlOptions();
            opts.setSavePrettyPrint();
            xml = adapterConfigDoc.xmlText(opts);
        }
        return xml;
    }

    @Override
    public IdpAuthnAdapterInstance parseXml(String xml, String className) throws XmlException {
        IdpAuthnAdapterInstance idpAdapterInstance = null;
        if (xml != null) {
            ByteArrayInputStream inStream;
            idpAdapterInstance = new IdpAuthnAdapterInstance();
            PluginSupport pluginSupport = new PluginSupport();
            DescribablePlugin pluginImpl = pluginSupport.createInstance(className, DescribablePlugin.class);
            if (pluginImpl != null) {
                idpAdapterInstance.setDescriptor(pluginImpl.getPluginDescriptor());
            }
            try {
                inStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new XmlException((Throwable)e);
            }
            XmlObject document = this.xmlLoader.load(inStream);
            ConfigType configType = this.constructConfigType(document, (ConfigurablePluginInstance)idpAdapterInstance);
            this.loadConf(idpAdapterInstance, configType);
        }
        return idpAdapterInstance;
    }
}

