/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.KerberosContext;

public class KerberosContextManager {
    private Log log = LogFactory.getLog(this.getClass());
    private Map<String, KerberosContext> kerberosContextMap = new HashMap<String, KerberosContext>();

    private KerberosContextManager() {
    }

    public static KerberosContextManager getManager() {
        return KerberosContextHolder.instance;
    }

    public synchronized boolean isKerberosContextRegistered(String kerberosRealmName) {
        return this.kerberosContextMap.containsKey(kerberosRealmName);
    }

    public synchronized KerberosContext getKerberosContext(String kerberosRealmName) {
        KerberosContext kerberosContext = null;
        if (this.kerberosContextMap.containsKey(kerberosRealmName)) {
            kerberosContext = this.kerberosContextMap.get(kerberosRealmName);
            if (kerberosContext.checkLoginContext()) {
                this.log.debug((Object)("Using Kerberos Context for Domain/Realm: " + kerberosRealmName + " from cache."));
                return kerberosContext;
            }
            this.log.debug((Object)("Kerberos Context for Domain/Realm: " + kerberosRealmName + " expired, removing from cache."));
            this.kerberosContextMap.remove(kerberosRealmName);
            kerberosContext = null;
        }
        return kerberosContext;
    }

    public synchronized void addKerberosContext(KerberosContext kerberosContext) {
        if (kerberosContext != null && kerberosContext.checkLoginContext()) {
            this.log.debug((Object)("Adding Kerberos Context for Domain/Realm: " + kerberosContext.getKerberosRealm().getKerberosRealmName() + " to cache."));
            this.kerberosContextMap.put(kerberosContext.getKerberosRealm().getKerberosRealmName(), kerberosContext);
        }
    }

    public synchronized void clearAllContexts() {
        this.kerberosContextMap = new HashMap<String, KerberosContext>();
    }

    private static class KerberosContextHolder {
        public static final KerberosContextManager instance = new KerberosContextManager();

        private KerberosContextHolder() {
        }
    }
}

