/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.access.ExecutionContextManager;
import com.pingidentity.common.util.access.ExecutionPermissions;
import com.pingidentity.configservice.AbstractListenerRegistry;
import com.pingidentity.configservice.ConfigEventType;
import com.pingidentity.module.connection.ConnectionModuleGlobalConfiguration;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.ConnectionExpirationData;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.UrlToTargetMapping;
import org.sourceid.saml20.domain.UrlToTargetMappings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.LocalSettingsListener;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.local.IDPLocalPathMappings;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.SPLocalPathMappings;

public class LocalSettingsManagerImpl
implements LocalSettingsManager {
    private static final String PERMISSION_ERROR_MESSAGE = String.format("Current thread does not have the necessary permissions to execute this method. Please use %s instead", MetadataLocal.class.getName());
    private static final LocalSettingsListenerRegistry listenerRegistry = new LocalSettingsListenerRegistry();
    private final Object transactionLock = new Object();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final MetadataLocal localMetaData;

    public LocalSettingsManagerImpl(MetadataLocal localMetaData) {
        this.localMetaData = localMetaData;
    }

    private String getSafeApplicationURL(MetadataLocal metadata, String key) {
        try {
            return metadata.getApplicationURL(key);
        }
        catch (ConfigurationException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalSettings getLocalSettings() {
        ExecutionContextManager.checkExecutionPermission((ExecutionPermissions)ExecutionPermissions.LocalSettingsManager, (String)PERMISSION_ERROR_MESSAGE);
        this.rwLock.readLock().lock();
        try {
            LocalSettings localSettings = new LocalSettings();
            localSettings.setEntityId(this.localMetaData.getEntityId());
            localSettings.setBaseUrl(this.localMetaData.getBaseUrl());
            localSettings.setSaml1xId(this.localMetaData.getSaml1xId());
            localSettings.setWsfedRealm(this.localMetaData.getWsFedID());
            localSettings.setSaml1xSrcId(this.localMetaData.getSaml1xSrcId());
            localSettings.setDisableAutomaticConnectionValidation(this.localMetaData.getDisableAutomaticConnectionValidation());
            localSettings.setDataStoreValidationInterval(this.localMetaData.getDataStoreValidationInterval());
            localSettings.setRequestHeaderNameForCorrelationId(this.localMetaData.getRequestHeaderNameForCorrelationId());
            localSettings.setCustomGlobalHttpHeaderName(this.localMetaData.getCustomGlobalHttpHeaderName());
            localSettings.setClientIpHeaderIndex(this.localMetaData.getClientIpHeaderIndex());
            localSettings.setForwardedHostHeaderName(this.localMetaData.getForwardedHostHeaderName());
            localSettings.setForwardedHostHeaderIndex(this.localMetaData.getForwardedHostHeaderIndex());
            localSettings.setProxyTerminatesHttpsConns(this.localMetaData.isProxyTerminatesHttpsConns());
            if (this.localMetaData.getEnableClientCertAuth().isPresent()) {
                localSettings.setEnableClientCertAuth(this.localMetaData.getEnableClientCertAuth().get());
            } else if (StringUtils.isNotBlank((String)this.localMetaData.getClientCertSSLHeaderName()) || StringUtils.isNotBlank((String)this.localMetaData.getClientCertChainSSLHeaderName())) {
                localSettings.setEnableClientCertAuth(true);
            }
            if (StringUtils.isNotBlank((String)this.localMetaData.getClientCertEncodingFormat())) {
                LocalSettings.ClientCertEncodingFormat clientCertSslEncodingFormat = LocalSettings.ClientCertEncodingFormat.valueOf(this.localMetaData.getClientCertEncodingFormat());
                localSettings.setClientCertEncodingFormat(clientCertSslEncodingFormat);
            } else {
                localSettings.setClientCertEncodingFormat(LocalSettings.ClientCertEncodingFormat.APACHE_MOD_SSL);
            }
            localSettings.setClientCertSSLHeaderName(this.localMetaData.getClientCertSSLHeaderName());
            localSettings.setClientCertChainSSLHeaderName(this.localMetaData.getClientCertChainSSLHeaderName());
            localSettings.setMetadataSigningKeyAlias(this.localMetaData.getMetadataSigningKeyAlias());
            localSettings.setMetadataSigningAlgorithm(this.localMetaData.getMetadataSigningAlgorithm());
            localSettings.setMetadataSigningKeyMD5Fingerprint(this.localMetaData.getMetadataSigningKeyMD5Fingerprint());
            localSettings.setIdpErrMsg(this.localMetaData.getErrorPageMsg());
            localSettings.setIdpSloSuccessUrl(this.getSafeApplicationURL(this.localMetaData, "idp.after.slo"));
            localSettings.setConfirmSlo(this.localMetaData.isConfirmSlo());
            localSettings.setSingleSignOnServices(this.localMetaData.getSingleSignOnServices());
            localSettings.setIdpSingleLogoutServices(this.localMetaData.getIdpSingleLogoutServices());
            localSettings.setAttributeService(this.localMetaData.getAttributeService());
            localSettings.setSpSloSuccessUrl(this.getSafeApplicationURL(this.localMetaData, "sp.after.slo"));
            localSettings.setSpSsoSuccessUrl(this.getSafeApplicationURL(this.localMetaData, "sp.after.sso"));
            localSettings.setAssertionConsumerServices(this.localMetaData.getAssertionConsumerServices());
            localSettings.setSpSingleLogoutServices(this.localMetaData.getSpSingleLogoutServices());
            localSettings.setSpArtifactResolutionServices(this.localMetaData.getSpArtifactResolutionServices());
            localSettings.setIdpArtifactResolutionServices(this.localMetaData.getIdpArtifactResolutionServices());
            IDPLocalPathMappings idpLocalPathMappings = this.localMetaData.getIdpLocalPathMappings();
            localSettings.setIdpInitiateSsoPath(idpLocalPathMappings.getInitiateSSOPath());
            localSettings.setIdpInitiateSloPath(idpLocalPathMappings.getInitiateSLOPath());
            localSettings.setIdpWriteCdcPath(idpLocalPathMappings.getInitiateWriteCDC());
            SPLocalPathMappings spLocalPathMappings = this.localMetaData.getSpLocalPathMappings();
            localSettings.setSpInitiateSsoPath(spLocalPathMappings.getInitiateSSOPath());
            localSettings.setSpInitiateSloPath(spLocalPathMappings.getInitiateSLOPath());
            localSettings.setSpDefederatePath(spLocalPathMappings.getTerminateLocalLinksPath());
            localSettings.setSpStartAttrQueryPath(spLocalPathMappings.getInitiateAttributeQueryPath());
            localSettings.setContactInfo(this.localMetaData.getContactInfo());
            localSettings.setIdpDiscovery(this.localMetaData.getIdpDiscovery());
            ConnectionExpirationData metaExpirationData = new ConnectionExpirationData();
            if (this.localMetaData.getCacheDuration() != null) {
                metaExpirationData.setCacheGDuration(this.localMetaData.getCacheDuration());
            }
            localSettings.setConnectionExpirationData(metaExpirationData);
            ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
            localSettings.setConnectionModuleGlobalConfigurations(moduleSupport.getGlobalConfigurations());
            LocalSettings localSettings2 = localSettings;
            return localSettings2;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveLocalSettings(LocalSettings localSettings, AdminAuditLogger.Component component, String message) {
        this.rwLock.writeLock().lock();
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.localMetaData.setEntityId(localSettings.getEntityId());
            this.localMetaData.setBaseUrl(localSettings.getBaseUrl());
            this.localMetaData.setSaml1xId(localSettings.getSaml1xId());
            this.localMetaData.setWsFedID(localSettings.getWsfedRealm());
            this.localMetaData.setSaml1xSrcId(localSettings.getSaml1xSrcId());
            this.localMetaData.setDisableAutomaticConnectionValidation(localSettings.isDisableAutomaticConnectionValidation());
            this.localMetaData.setDataStoreValidationInterval(localSettings.getDataStoreValidationInterval());
            this.localMetaData.setRequestHeaderNameForCorrelationId(localSettings.getRequestHeaderNameForCorrelationId());
            this.localMetaData.setCustomGlobalHttpHeaderName(localSettings.getCustomGlobalHttpHeaderName());
            this.localMetaData.setClientIpHeaderIndex(localSettings.getClientIpHeaderIndex());
            this.localMetaData.setForwardedHostHeaderName(localSettings.getForwardedHostHeaderName());
            this.localMetaData.setForwardedHostHeaderIndex(localSettings.getForwardedHostHeaderIndex());
            this.localMetaData.setProxyTerminatesHttpsConns(localSettings.isProxyTerminatesHttpsConns());
            this.localMetaData.setMetadataSigningKeyAlias(localSettings.getMetadataSigningKeyAlias());
            this.localMetaData.setMetadataSigningAlgorithm(localSettings.getMetadataSigningAlgorithm());
            this.localMetaData.setMetadataSigningKeyMD5Fingerprint(localSettings.getMetadataSigningKeyMD5Fingerprint());
            this.localMetaData.setErrorPageMsg(localSettings.getIdpErrMsg());
            this.localMetaData.setConfirmSlo(localSettings.isConfirmSlo());
            this.localMetaData.setEnableClientCertAuth(localSettings.isEnableClientCertAuth());
            String clientCertSslEncodingFormat = localSettings.getClientCertEncodingFormat() != null ? localSettings.getClientCertEncodingFormat().toString() : LocalSettings.ClientCertEncodingFormat.APACHE_MOD_SSL.toString();
            this.localMetaData.setClientCertEncodingFormat(clientCertSslEncodingFormat);
            this.localMetaData.setClientCertSSLHeaderName(localSettings.getClientCertSSLHeaderName());
            this.localMetaData.setClientCertChainSSLHeaderName(localSettings.getClientCertChainSSLHeaderName());
            if (!StringUtils.isBlank((String)localSettings.getIdpSloSuccessUrl())) {
                this.localMetaData.setApplicationURL("idp.after.slo", localSettings.getIdpSloSuccessUrl(), true);
            } else {
                this.localMetaData.removeApplicationURL("idp.after.slo");
            }
            if (!StringUtils.isBlank((String)localSettings.getSpSloSuccessUrl())) {
                this.localMetaData.setApplicationURL("sp.after.slo", localSettings.getSpSloSuccessUrl(), true);
            } else {
                this.localMetaData.removeApplicationURL("sp.after.slo");
            }
            if (!StringUtils.isBlank((String)localSettings.getSpSsoSuccessUrl())) {
                this.localMetaData.setApplicationURL("sp.after.sso", localSettings.getSpSsoSuccessUrl(), true);
            } else {
                this.localMetaData.removeApplicationURL("sp.after.sso");
            }
            if (localSettings.getContactInfo() != null) {
                this.localMetaData.setContactInfo(localSettings.getContactInfo());
            }
            if (localSettings.getIdpDiscovery() != null) {
                this.localMetaData.setIdpDiscovery(localSettings.getIdpDiscovery());
            }
            if (localSettings.getConnectionExpirationData() != null) {
                ConnectionExpirationData connExpirationData = localSettings.getConnectionExpirationData();
                this.localMetaData.setCacheDuration(connExpirationData.getCacheGDuration());
            }
            this.localMetaData.save();
            this.saveModules(localSettings.getConnectionModuleGlobalConfigurations());
            this.notifySettingsSaved();
            auditLoggerScope.log(component, AdminAuditLogger.Event.MODIFY, message);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void saveLocalSettings(LocalSettings localSettings, AdminAuditLogger.Component component) {
        this.saveLocalSettings(localSettings, component, "");
    }

    @Override
    public void saveLocalSettings(LocalSettings localSettings) {
        this.saveLocalSettings(localSettings, AdminAuditLogger.Component.SERVER_SETTINGS);
    }

    private void saveModules(List<ConnectionModuleGlobalConfiguration> moduleGlobalConfigurations) {
        if (moduleGlobalConfigurations != null) {
            ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
            moduleSupport.saveGlobalConfigurations(moduleGlobalConfigurations);
        }
    }

    @Override
    public UrlToTargetMappings getUrlToAdapterMapping() {
        UrlToTargetMappings urlToAdapterMapping = new UrlToTargetMappings();
        urlToAdapterMapping.setMappings(this.localMetaData.getUrlToTargetMappings());
        return urlToAdapterMapping;
    }

    @Override
    public void saveUrlToAdapterMapping(UrlToTargetMappings urlToAdapterMapping) {
        UrlToTargetMappings existing = this.getUrlToAdapterMapping();
        this.localMetaData.setUrlToTargetMappings(urlToAdapterMapping.getMappings());
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.localMetaData.save();
            this.auditUrlToAdapterMapping(existing.getMappings(), urlToAdapterMapping.getMappings(), auditLoggerScope);
        }
    }

    private void auditUrlToAdapterMapping(List<UrlToTargetMapping> currentMapping, List<UrlToTargetMapping> newMapping, AuditLoggerScope auditLoggerScope) {
        int newMappingSize = newMapping.size();
        Collection deleted = CollectionUtils.removeAll(currentMapping, newMapping);
        Collection added = CollectionUtils.removeAll(newMapping, currentMapping);
        if (!deleted.isEmpty()) {
            deleted.forEach(item -> auditLoggerScope.log(AdminAuditLogger.Component.TARGET_URL, AdminAuditLogger.Event.DELETE, item.getUrl() + "," + item.getTargetType() + "," + item.getTargetId() + " | No New Mapping"));
        }
        if (!added.isEmpty()) {
            added.forEach(item -> auditLoggerScope.log(AdminAuditLogger.Component.TARGET_URL, AdminAuditLogger.Event.CREATE, "No Old Mapping | " + item.getUrl() + "," + item.getTargetType() + "," + item.getTargetId()));
        }
        boolean hasUpdates = false;
        if (currentMapping != null) {
            for (int i = 0; i < newMappingSize; ++i) {
                if (currentMapping.size() <= i || newMapping.get(i).equals(currentMapping.get(i)) || added.contains(newMapping.get(i)) || deleted.contains(newMapping.get(i))) continue;
                hasUpdates = true;
                auditLoggerScope.log(AdminAuditLogger.Component.TARGET_URL, AdminAuditLogger.Event.MODIFY, currentMapping.get(i).getUrl() + "," + currentMapping.get(i).getTargetType() + "," + currentMapping.get(i).getTargetId() + " | " + newMapping.get(i).getUrl() + "," + newMapping.get(i).getTargetType() + "," + newMapping.get(i).getTargetId());
            }
        }
        if (deleted.isEmpty() && added.isEmpty() && !hasUpdates) {
            auditLoggerScope.log(AdminAuditLogger.Component.TARGET_URL, AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public String exportLocalSettings() {
        return this.localMetaData.toXml();
    }

    @Override
    public void importLocalSettings(String xml) throws XmlException, ConfigurationException {
        if (!StringUtils.isEmpty((String)xml)) {
            this.localMetaData.importLocalSettings(xml);
        }
    }

    @Override
    public void addSettingsListener(LocalSettingsListener listener) {
        listenerRegistry.addListener(listener);
    }

    @Override
    public void removeSettingsListener(LocalSettingsListener listener) {
        listenerRegistry.removeListener(listener);
    }

    protected void notifySettingsSaved() {
        MgmtFactory.getSingleThreadedExecutor().execute(() -> listenerRegistry.notifyLocalSettingsSaved(this.getLocalSettings()));
    }

    @Override
    public Object getLock() {
        return this.transactionLock;
    }

    private static class LocalSettingsListenerRegistry
    extends AbstractListenerRegistry {
        private LocalSettingsListenerRegistry() {
        }

        public void addListener(LocalSettingsListener listener) {
            this.doAddListener(ConfigEventType.LOCAL_SETTINGS_UPDATED, listener, null);
        }

        public void removeListener(LocalSettingsListener listener) {
            this.doRemoveListener(ConfigEventType.LOCAL_SETTINGS_UPDATED, listener);
        }

        public void notifyLocalSettingsSaved(LocalSettings newSettings) {
            this.doNotifyListeners(ConfigEventType.LOCAL_SETTINGS_UPDATED, l -> l.onLocalSettingsSaved(newSettings));
        }
    }
}

