/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.configservice.impl.JaxbXmlLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.LogCategorySettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.LogSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LogSettingsManagerImpl
implements LogSettingsManager {
    private static final Log log = LogFactory.getLog(LogSettingsManagerImpl.class);
    private static final String CFG_ENABLED_CATEGORIES = "EnabledCategories";
    private static final String CFG_SHOW_LOG_SETTINGS_PAGE = "ShowLogSettingsPage";
    private static final String LOG_LEVEL_PROPERTY_PREFIX = "pf.log.level.";
    private static final ExecutorService reconfigurator = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "log4j reconfigurator"));
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("log-category-settings", true);
    private final ConfigStore hiddenConfigStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.domain.mgmt.impl.LogSettingsManagerImpl", false);
    private LogCategories logCategories = new LogCategories();
    private Map<String, String> enabledCategories = new HashMap<String, String>();
    private boolean log4j2Upgraded = this.checkLog4j2Upgraded();

    public LogSettingsManagerImpl() {
        this.loadConfig();
    }

    @Override
    public synchronized void reload() {
        Map<String, String> oldEnabledCategories = this.enabledCategories;
        this.loadConfig();
        if (!this.enabledCategories.equals(oldEnabledCategories)) {
            this.applyCategorySettings();
        }
    }

    @Override
    public synchronized void applyCategorySettings() {
        for (LogCategory category : this.logCategories.getCategories()) {
            LogLevel logLevel = category.getOffLevel();
            if (this.enabledCategories.containsKey(category.getId())) {
                logLevel = category.getOnLevel();
            }
            System.setProperty(this.makePropertyName(category.getId()), logLevel.name());
        }
        reconfigurator.execute(() -> {
            try {
                LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                loggerContext.reconfigure();
            }
            catch (Exception e) {
                log.error((Object)"Unexpected error reconfiguring log4j", (Throwable)e);
            }
        });
    }

    @Override
    public synchronized List<LogCategorySettings> getCategorySettings() {
        ArrayList<LogCategorySettings> result = new ArrayList<LogCategorySettings>();
        for (LogCategory logCategory : this.logCategories.getCategories()) {
            result.add(new LogCategorySettings(logCategory.getId(), logCategory.getName(), logCategory.getDescription(), this.enabledCategories.containsKey(logCategory.getId())));
        }
        return result;
    }

    @Override
    public synchronized void saveCategorySettings(List<LogCategorySettings> settingsList) {
        LinkedHashMap<String, String> newEnabledCategories = new LinkedHashMap<String, String>();
        for (LogCategorySettings settings : settingsList) {
            if (!settings.getEnabled()) continue;
            newEnabledCategories.put(settings.getId(), Boolean.TRUE.toString());
        }
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.configStore.setMapValue(CFG_ENABLED_CATEGORIES, newEnabledCategories);
            auditLoggerScope.log(AdminAuditLogger.Component.LOG_CATEGORY_SETTINGS, AdminAuditLogger.Event.MODIFY);
        }
        Map<String, String> oldCategories = this.enabledCategories;
        this.enabledCategories = newEnabledCategories;
        if (!this.enabledCategories.equals(oldCategories)) {
            this.applyCategorySettings();
        }
    }

    @Override
    public synchronized boolean isLog4j2Upgraded() {
        return this.log4j2Upgraded;
    }

    @Override
    public synchronized boolean isShowLogSettingsPage() {
        return this.hiddenConfigStore.getBooleanValue(CFG_SHOW_LOG_SETTINGS_PAGE, true);
    }

    private boolean checkLog4j2Upgraded() {
        File file = new File(MgmtFactory.getSysDirInfo().getConfigDirectory() + File.separator + "log4j2.xml");
        if (!file.exists()) {
            log.warn((Object)"log4j2.xml not found, could not determine if file has been upgraded");
            return true;
        }
        try {
            DocumentBuilder builder = XmlBeansUtil.getDocumentBuilder();
            Document doc = builder.parse(file);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate("/Configuration/Loggers/Logger", doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                String value;
                Node node = nodes.item(i);
                NamedNodeMap attributes = node.getAttributes();
                Node level = attributes.getNamedItem("level");
                if (level == null || !(value = level.getNodeValue()).startsWith("${sys:pf.log.level.")) continue;
                log.debug((Object)"log4j2.xml has been upgraded, log category settings will be applied at runtime");
                return true;
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            log.warn((Object)"Unexpected error scanning log4j2.xml, could not determine if file has been upgraded", (Throwable)e);
            return true;
        }
        log.warn((Object)"log4j2.xml has not been upgraded, log category settings will not be applied at runtime");
        return false;
    }

    private synchronized void loadConfig() {
        this.enabledCategories = this.configStore.getMapValue(CFG_ENABLED_CATEGORIES, Collections.emptyMap());
        File file = new File(this.getConfigFileName());
        if (file.exists()) {
            try {
                JaxbXmlLoader<Log4jCategories> loader = new JaxbXmlLoader<Log4jCategories>(Log4jCategories.class);
                Log4jCategories config = loader.load(MgmtFactory.getSysDirInfo().getConfigDirectory(), "log4j-categories.xml", true);
                this.logCategories = config.getLogCategories();
            }
            catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Unexpected error loading file log4j-categories.xml", e);
            }
        }
    }

    private String makePropertyName(String categoryId) {
        return LOG_LEVEL_PROPERTY_PREFIX + categoryId;
    }

    private String getConfigFileName() {
        String dataDirectory = MgmtFactory.getSysDirInfo().getConfigDirectory();
        return dataDirectory + File.separator + "log4j-categories.xml";
    }

    public static class LogCategory {
        private String id;
        private String name;
        private String description;
        private LogLevel offLevel = LogLevel.INFO;
        private LogLevel onLevel = LogLevel.INFO;

        @XmlAttribute
        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @XmlAttribute
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlAttribute
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @XmlAttribute
        public LogLevel getOffLevel() {
            return this.offLevel;
        }

        public void setOffLevel(LogLevel offLevel) {
            this.offLevel = offLevel;
        }

        @XmlAttribute
        public LogLevel getOnLevel() {
            return this.onLevel;
        }

        public void setOnLevel(LogLevel onLevel) {
            this.onLevel = onLevel;
        }
    }

    public static enum LogLevel {
        OFF,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        ALL;

    }

    public static class LogCategories {
        private List<LogCategory> categories = new ArrayList<LogCategory>();

        @XmlElement(name="category")
        public List<LogCategory> getCategories() {
            return this.categories;
        }

        public void setCategories(List<LogCategory> categories) {
            this.categories = categories;
        }
    }

    @XmlRootElement(name="log4jCategories")
    public static class Log4jCategories {
        private LogCategories logCategories = new LogCategories();

        public LogCategories getLogCategories() {
            return this.logCategories;
        }

        public void setLogCategories(LogCategories logCategories) {
            this.logCategories = logCategories;
        }
    }
}

