/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.MetadataUrlCertPair;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MetadataSource;
import org.sourceid.saml20.domain.mgmt.MetadataUpdateScheduleManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.MetadataUpdateTask;
import org.sourceid.saml20.domain.mgmt.impl.MetadataUpdateTaskHelper;
import org.sourceid.saml20.domain.util.MetadataImportException;

public class MetadataUpdateScheduleManagerImpl
implements MetadataUpdateScheduleManager {
    private ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
    private static final long DEFAULT_METADATA_REFRESH_DELAY = new Long(1440L);
    private MetadataUpdateTask connMetadataUpdateTask = null;
    private Timer metadataMgmtTimer = new Timer("MetadataReloader");
    private static final Log log = LogFactory.getLog(MetadataUpdateScheduleManagerImpl.class);
    private static String METADATA_REFRESH_DELAY_CONFIG_FIELD = "metadataRefreshDelay";
    private List<MetadataSource> metadataSources = new ArrayList<MetadataSource>();

    @Override
    public void saveMetadataRefreshDelay(Long metadataRefreshDelay) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.configStore.setLongValue(METADATA_REFRESH_DELAY_CONFIG_FIELD, metadataRefreshDelay);
            auditLoggerScope.log(AdminAuditLogger.Component.SERVER_SETTINGS, AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public Long getMetadataRefreshDelay() {
        Long metadataRefreshDelay = DEFAULT_METADATA_REFRESH_DELAY;
        try {
            metadataRefreshDelay = this.configStore.getLongValue(METADATA_REFRESH_DELAY_CONFIG_FIELD);
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        return metadataRefreshDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        if (MgmtFactory.getMediator().isConsole()) {
            log.debug((Object)"check for scheduler");
            MetadataUpdateScheduleManagerImpl metadataUpdateScheduleManagerImpl = this;
            synchronized (metadataUpdateScheduleManagerImpl) {
                if (this.connMetadataUpdateTask != null) {
                    this.connMetadataUpdateTask.cancel();
                    this.connMetadataUpdateTask = null;
                }
                this.startConnMetadataUpdateTask();
            }
        }
    }

    @Override
    public synchronized void addMetadataSource(MetadataSource newSource) {
        for (MetadataSource source : this.metadataSources) {
            if (!source.getId().equals(newSource.getId())) continue;
            return;
        }
        this.metadataSources.add(newSource);
    }

    @Override
    public synchronized void removeMetadataSource(String id) {
        Iterator<MetadataSource> iter = this.metadataSources.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getId().equals(id)) continue;
            iter.remove();
            break;
        }
    }

    @Override
    public synchronized Collection<MetadataSource> getMetadataSources() {
        ArrayList<MetadataSource> result = new ArrayList<MetadataSource>();
        result.addAll(this.metadataSources);
        for (MetadataUrlCertPair url : MgmtFactory.getMetadataUrlManager().getMetadataUrlPairs()) {
            result.add(new MetadataUrlSource(url));
        }
        return result;
    }

    private synchronized void startConnMetadataUpdateTask() {
        ConnectionManager connManager = MgmtFactory.getConnectionManager();
        this.connMetadataUpdateTask = this.makeConnMetadataUpdateTask("MetadataUpdateTask", connManager, this.metadataMgmtTimer);
        this.connMetadataUpdateTask.start();
    }

    private synchronized MetadataUpdateTask makeConnMetadataUpdateTask(String taskName, ConnectionManager connManager, Timer timer) {
        return new MetadataUpdateTask(taskName, timer);
    }

    protected class MetadataUrlSource
    implements MetadataSource {
        private MetadataUrlCertPair metadataUrl;

        public MetadataUrlSource(MetadataUrlCertPair url) {
            this.metadataUrl = url;
        }

        @Override
        public String getId() {
            return this.metadataUrl.getId();
        }

        @Override
        public String getUrl() {
            return this.metadataUrl.getUrl();
        }

        @Override
        public String getName() {
            return this.metadataUrl.getName();
        }

        @Override
        public Collection<ConnectionBase> getConnectionsUsingSource() {
            ArrayList<ConnectionBase> result = new ArrayList<ConnectionBase>();
            for (ConnectionBase conn : MgmtFactory.getConnectionManager().getFilteredConnections()) {
                if (!conn.isActive() || !conn.isEnableAutoMetadataUpdate() || conn.getMetadataUrlId() == null || !conn.getMetadataUrlId().equals(this.metadataUrl.getId())) continue;
                result.add(conn);
            }
            return result;
        }

        @Override
        public XmlObject getMetadataXml() throws MetadataImportException {
            return MetadataUpdateTaskHelper.getMetadataXml(this.metadataUrl);
        }

        @Override
        public boolean isEnableBrowserSsoComparison() {
            return true;
        }

        @Override
        public boolean isNotifyForDownloadErrors() {
            return true;
        }
    }
}

