/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.x2015.x01.updateMetadata.MetadataUpdateSettingsDocument;
import com.pingidentity.x2015.x01.updateMetadata.MetadataUpdateSettingsType;
import com.pingidentity.x2015.x01.updateMetadata.MetadataUpdateType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.MetadataUpdate;
import org.sourceid.saml20.domain.mgmt.MetadataUpdateSettingManager;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;

public class MetadataUpdateSettingManagerImpl
extends ConfigManagerBase
implements MetadataUpdateSettingManager,
AutoReloadable {
    private static Log log = LogFactory.getLog(MetadataUpdateSettingManagerImpl.class);
    private static final String PF_UPDATE_METADATA_SETTING_XML_FILE_NAME = "pingfederate-update-metadata.xml";
    private Map<String, MetadataUpdate> metadataUpdateMap = new HashMap<String, MetadataUpdate>();

    public MetadataUpdateSettingManagerImpl() {
        this.loadConfig();
    }

    private synchronized void loadConfig() {
        this.fillMetadataMap();
    }

    private MetadataUpdateSettingsDocument getDoc() {
        String dataDir = this.sysDirInfo.getLocalDataDirectory();
        return (MetadataUpdateSettingsDocument)this.xmlLoader.load(dataDir, PF_UPDATE_METADATA_SETTING_XML_FILE_NAME);
    }

    @Override
    public synchronized void saveMetadataUpdateSettings(MetadataUpdate metadataUpdate) {
        if (metadataUpdate == null || metadataUpdate != null && StringUtils.isEmpty((String)metadataUpdate.getConnectionId())) {
            return;
        }
        MetadataUpdateSettingsDocument metadataUpdateDoc = this.getDoc();
        MetadataUpdateSettingsType metadataSettingType = metadataUpdateDoc.getMetadataUpdateSettings();
        MetadataUpdateType[] metadataUpdataSettings = metadataSettingType.getMetadataUpdateTypeArray();
        ArrayList<MetadataUpdate> metadataUpdates = new ArrayList<MetadataUpdate>(metadataUpdataSettings.length + 1);
        String connId = metadataUpdate.getConnectionId();
        log.debug((Object)("Getting metadata settings for connection with connection id " + connId));
        for (MetadataUpdateType metadataUpdataSetting : metadataUpdataSettings) {
            if (connId.equals(metadataUpdataSetting.getConnectionId())) continue;
            MetadataUpdate metadata = this.generateMetadataUpdateValuesFromTypes(metadataUpdataSetting);
            metadataUpdates.add(metadata);
        }
        metadataUpdates.add(metadataUpdate);
        this.saveMetadataSettings(metadataUpdates);
    }

    @Override
    public synchronized MetadataUpdate getMetadataUpdateSettings(String connId) {
        if (StringUtils.isEmpty((String)connId)) {
            return null;
        }
        MetadataUpdate metadataUpdateSetting = this.metadataUpdateMap.get(connId);
        return metadataUpdateSetting;
    }

    @Override
    public synchronized boolean deleteMetadataUpdateSettings(String connId) {
        boolean deleted = false;
        if (StringUtils.isEmpty((String)connId)) {
            return false;
        }
        MetadataUpdateSettingsDocument metadataUpdateDoc = this.getDoc();
        MetadataUpdateSettingsType metadataSettingType = metadataUpdateDoc.getMetadataUpdateSettings();
        MetadataUpdateType[] metadataUpdataSettings = metadataSettingType.getMetadataUpdateTypeArray();
        ArrayList<MetadataUpdate> metadataUpdates = new ArrayList<MetadataUpdate>(metadataUpdataSettings.length);
        for (MetadataUpdateType metadataUpdataSetting : metadataUpdataSettings) {
            MetadataUpdate metadata = null;
            if (connId.equals(metadataUpdataSetting.getConnectionId())) {
                log.debug((Object)("Deleting metadata last metadata for connection with Id " + connId));
                deleted = true;
                continue;
            }
            metadata = this.generateMetadataUpdateValuesFromTypes(metadataUpdataSetting);
            metadataUpdates.add(metadata);
        }
        this.saveMetadataSettings(metadataUpdates);
        return deleted;
    }

    private void generateMetadataUpdateTypeValues(MetadataUpdate metadataUpdate, MetadataUpdateType metadataSettingType) {
        if (metadataUpdate != null && !StringUtils.isEmpty((String)metadataUpdate.getConnectionId())) {
            metadataSettingType.setConnectionId(metadataUpdate.getConnectionId());
            metadataSettingType.setLastUsedMetadata(metadataUpdate.getLastUsedMetadata());
            metadataSettingType.setErrorNotificationSent(metadataUpdate.isErrorNotificationSent());
        }
    }

    private MetadataUpdate generateMetadataUpdateValuesFromTypes(MetadataUpdateType metadataSettingType) {
        MetadataUpdate metadataUpdate = null;
        if (metadataSettingType != null && !StringUtils.isEmpty((String)metadataSettingType.getConnectionId())) {
            String connId = metadataSettingType.getConnectionId();
            String lastUsedMetadata = metadataSettingType.getLastUsedMetadata();
            metadataUpdate = new MetadataUpdate(connId);
            metadataUpdate.setLastUsedMetadata(lastUsedMetadata);
            metadataUpdate.setErrorNotificationSent(metadataSettingType.getErrorNotificationSent());
        }
        return metadataUpdate;
    }

    private void saveMetadataSettings(Collection<MetadataUpdate> metadataSettings) {
        MetadataUpdateSettingsDocument metadataUpdateDoc = MetadataUpdateSettingsDocument.Factory.newInstance();
        MetadataUpdateSettingsType medataSettingType = metadataUpdateDoc.addNewMetadataUpdateSettings();
        for (MetadataUpdate metadata : metadataSettings) {
            MetadataUpdateType metadataType = medataSettingType.addNewMetadataUpdateType();
            this.generateMetadataUpdateTypeValues(metadata, metadataType);
        }
        this.xmlLoader.save(this.sysDirInfo.getLocalDataDirectory(), PF_UPDATE_METADATA_SETTING_XML_FILE_NAME, (XmlObject)metadataUpdateDoc);
        this.fillMetadataMap();
    }

    private synchronized void fillMetadataMap() {
        MetadataUpdateType[] metadataUpdataSettings;
        this.metadataUpdateMap.clear();
        MetadataUpdateSettingsDocument metadataUpdateDoc = this.getDoc();
        MetadataUpdateSettingsType metadataSettingType = metadataUpdateDoc.getMetadataUpdateSettings();
        for (MetadataUpdateType metadataUpdataSetting : metadataUpdataSettings = metadataSettingType.getMetadataUpdateTypeArray()) {
            MetadataUpdate metadata = this.generateMetadataUpdateValuesFromTypes(metadataUpdataSetting);
            String key = metadata.getConnectionId();
            this.metadataUpdateMap.put(key, metadata);
        }
    }
}

