/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.sdk.notification.NotificationEventType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.MetadataUpdate;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.ReplicationRecord;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MetadataSource;
import org.sourceid.saml20.domain.mgmt.MetadataUpdateScheduleManager;
import org.sourceid.saml20.domain.mgmt.MetadataUpdateSettingManager;
import org.sourceid.saml20.domain.mgmt.MetadataUrlNotificationManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.MetadataUpdateTaskHelper;
import org.sourceid.saml20.domain.util.BrowserSsoCompareUtil;
import org.sourceid.saml20.domain.util.MetadataConnections;
import org.sourceid.saml20.domain.util.MetadataImportException;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;
import org.sourceid.saml20.domain.util.MetadataUpdateStatus;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;

public class MetadataUpdateTask {
    private static final Log log = LogFactory.getLog(MetadataUpdateTask.class);
    private static final long DEFAULT_SCHEDULER_DELAY = 86400000L;
    private static final String ENTITY_ID = "ENTITY_ID";
    public static final String UPDATED = "UPDATED";
    public static final String REPLICATED = "REPLICATED";
    public static final String OUT_OF_SYNC = "OUT_OF_SYNC";
    private static final String SP_IDP = "SP_IDP";
    private static final String METADATA_URL = "METADATA_URL";
    private static final String CONNECTION_NAME = "CONNECTION_NAME";
    private static final String METADATA_URL_NAME = "METADATA_URL_NAME";
    private static final String METADATA_URL_DOWNLOAD_FAIL_TEMPLATE = "message-template-metadata-url-notification.html";
    private static final String METADATA_URL_ENTITY_ID_MISSING_TEMPLATE = "message-template-metadata-url-entity-id-missing.html";
    private ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private MetadataUpdateScheduleManager metadataScheduleMgr = MgmtFactory.getMetadataUpdateScheduleManager();
    private MetadataUpdateSettingManager metadataSettingMgr = MgmtFactory.getMetadataUpdateSettingManager();
    private Mediator mediator = MgmtFactory.getMediator();
    private MetadataDirectory metadataDirectory = MgmtFactory.getMetadataDirectory();
    private String taskName;
    private Timer timer;
    private TimerTask timerTask;
    private volatile boolean cancelled = false;

    public MetadataUpdateTask(String taskName, Timer timer) {
        this.taskName = taskName;
        this.timer = timer;
    }

    public void start() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (MetadataUpdateTask.this.cancelled) {
                    return;
                }
                if (MgmtFactory.getMediator().isConsole()) {
                    MetadataUpdateTask.this.checkForUpdate();
                }
            }
        }, 0L);
    }

    private String makeLogMessage(String message) {
        return this.taskName + ": " + message;
    }

    protected void scheduleNextCheck() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    MetadataUpdateTask.this.checkForUpdate();
                }
                catch (Exception e) {
                    log.error((Object)("Error during Metadata Reloading. " + e));
                }
            }
        };
        long delay = 86400000L;
        delay = this.getUpdateDelay();
        this.timer.schedule(this.timerTask, delay);
    }

    private synchronized void checkForUpdate() {
        if (!MgmtFactory.getAdminNodeConfigManager().isEnabledAndPassiveNode()) {
            MetadataUrlNotificationManager metadataNotificationMgr = MgmtFactory.getMetadataUrlNotificationManager();
            for (MetadataSource metadataSource : MgmtFactory.getMetadataUpdateScheduleManager().getMetadataSources()) {
                try {
                    Collection<ConnectionBase> connsUsingMetadata = metadataSource.getConnectionsUsingSource();
                    if (connsUsingMetadata.isEmpty()) continue;
                    XmlObject metadataXml = metadataSource.getMetadataXml();
                    InputStream metadataStream = metadataXml.newInputStream();
                    try {
                        MetadataConnections metadataConnections = MetadataImportExportUtil.generateConnectionsFromMetadata(metadataStream, MetadataImportExportUtil.ImportExpectedConnectionType.ANY, null);
                        metadataNotificationMgr.saveNotificationStatus(metadataSource.getId(), false);
                        ArrayList<ConnectionBase> connectionsToReplicate = new ArrayList<ConnectionBase>();
                        for (ConnectionBase conn : connsUsingMetadata) {
                            try {
                                ConnectionBase metadataConnection = null;
                                try {
                                    metadataConnection = this.getMetadataConnection(metadataConnections, conn, metadataSource.getUrl());
                                    this.resetNotificationStatus(conn);
                                }
                                catch (MetadataImportException e) {
                                    if (metadataSource.isNotifyForDownloadErrors()) {
                                        this.notifyEntityIdNotFound(conn, metadataSource);
                                    }
                                    throw e;
                                }
                                String updateString = null;
                                Collection<String> updateComponentNames = MetadataUpdateTaskHelper.mergeConnection(conn, metadataConnection);
                                ArrayList<String> changes = new ArrayList();
                                if (metadataSource.isEnableBrowserSsoComparison()) {
                                    changes = BrowserSsoCompareUtil.compareBrowserSSOInfo(conn, metadataConnection);
                                }
                                boolean manualReplication = updateComponentNames.contains(Component.CONTACT_INFO.value);
                                if (updateComponentNames.size() > 0) {
                                    this.updateConnection(conn, metadataSource.getUrl(), manualReplication);
                                    updateString = this.getChangesString(updateComponentNames);
                                    if (this.mediator.isDistributable() && !updateComponentNames.isEmpty() && (updateComponentNames.contains(Component.ENCRYPTION_CERTIFICATE.value) || updateComponentNames.contains(Component.VERIFICATION_CERT.value))) {
                                        connectionsToReplicate.add(conn);
                                    }
                                }
                                this.handleNotification(metadataSource.getUrl(), conn, metadataConnection, updateString, changes, manualReplication);
                            }
                            catch (Exception e) {
                                log.error((Object)("Error updating " + conn.getRoleType() + " connection " + conn.getEntityId() + " from metadata URL " + metadataSource.getUrl()), (Throwable)e);
                            }
                        }
                        this.handleAutoReplication(connectionsToReplicate);
                    }
                    finally {
                        if (metadataStream == null) continue;
                        metadataStream.close();
                    }
                }
                catch (IOException | MetadataImportException e) {
                    boolean sentDownloadFailEmail;
                    NotificationSettings notificationSetting;
                    if (metadataSource.isNotifyForDownloadErrors() && (notificationSetting = this.getNotificationSettings()).isEnableEmailNotification() && !(sentDownloadFailEmail = metadataNotificationMgr.getMetadataNotificationStatus(metadataSource.getId()))) {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put(METADATA_URL, metadataSource.getUrl());
                        params.put(METADATA_URL_NAME, metadataSource.getName());
                        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
                        String notificationPublisher = notificationSetting.getNotificationPublisherMetadata();
                        notificationSupportHelper.publishNotification(notificationPublisher, METADATA_URL_DOWNLOAD_FAIL_TEMPLATE, notificationSetting.getMetadataEventTo(), params, NotificationEventType.SAML_METADATA_UPDATE_EVENT_FAILED.toString());
                        metadataNotificationMgr.saveNotificationStatus(metadataSource.getId(), true);
                    }
                    log.error((Object)("Error retrieving or validating metadata from " + metadataSource.getUrl()), (Throwable)e);
                }
            }
            log.debug((Object)"Metadata reload completed for all active connections, scheduling next reload task.");
        }
        this.scheduleNextCheck();
    }

    private void handleAutoReplication(List<ConnectionBase> connections) {
        if (connections != null && !connections.isEmpty()) {
            Collection<ReplicationRecord> records = this.metadataDirectory.createPartialReplicationRecords(connections);
            this.mediator.applyPartialReplicationRecords(records, this.metadataDirectory);
        }
    }

    private void notifyEntityIdNotFound(ConnectionBase conn, MetadataSource metadataSource) {
        NotificationSettings notifySettings = this.getNotificationSettings();
        if (notifySettings.isEnableEmailNotification()) {
            MetadataUpdate metadataUpdate = this.metadataSettingMgr.getMetadataUpdateSettings(conn.getId());
            if (metadataUpdate == null) {
                metadataUpdate = new MetadataUpdate(conn.getId());
            }
            if (!metadataUpdate.isErrorNotificationSent()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(SP_IDP, conn.getRoleType().toString());
                params.put(ENTITY_ID, conn.getEntityId());
                params.put(CONNECTION_NAME, conn.getName());
                params.put(METADATA_URL, metadataSource.getUrl());
                params.put(METADATA_URL_NAME, metadataSource.getName());
                NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
                String notificationPublisher = notifySettings.getNotificationPublisherMetadata();
                notificationSupportHelper.publishNotification(notificationPublisher, METADATA_URL_ENTITY_ID_MISSING_TEMPLATE, notifySettings.getMetadataEventTo(), params, NotificationEventType.SAML_METADATA_UPDATE_EVENT_ENTITY_ID_NOT_FOUND.toString());
                metadataUpdate.setErrorNotificationSent(true);
                this.metadataSettingMgr.saveMetadataUpdateSettings(metadataUpdate);
            }
        }
    }

    private void resetNotificationStatus(ConnectionBase conn) {
        MetadataUpdate metadataUpdate = this.metadataSettingMgr.getMetadataUpdateSettings(conn.getId());
        if (metadataUpdate != null) {
            metadataUpdate.setErrorNotificationSent(false);
            this.metadataSettingMgr.saveMetadataUpdateSettings(metadataUpdate);
        }
    }

    private ConnectionBase getMetadataConnection(MetadataConnections metadataConns, ConnectionBase existingConn, String metadataUrl) throws MetadataImportException {
        for (ConnectionBase metadataConn : metadataConns.getConnections()) {
            if (!StringUtils.equals((String)metadataConn.getEntityId(), (String)existingConn.getEntityId()) || !metadataConn.getRoleType().equals((Object)existingConn.getRoleType())) continue;
            MetadataImportExportUtil.updateConnectionProtocol(metadataConn, existingConn.getProtocol());
            return metadataConn;
        }
        throw new MetadataImportException("Metadata for the entity id " + existingConn.getEntityId() + " not found at " + metadataUrl);
    }

    private void updateConnection(ConnectionBase connectionBase, String metadataUrl, boolean manualReplication) {
        if (connectionBase instanceof SpConnection) {
            this.connectionManager.saveSpConnection((SpConnection)connectionBase, manualReplication, AdminAuditLogger.Event.UPDATE);
        } else {
            this.connectionManager.saveIdpConnection((IdpConnection)connectionBase, manualReplication, AdminAuditLogger.Event.UPDATE);
        }
        log.debug((Object)("Updating " + connectionBase.getRoleType() + " connection " + connectionBase.getEntityId() + " based on metadata located at " + metadataUrl));
    }

    private synchronized void handleNotification(String metadataUrl, ConnectionBase connection, ConnectionBase metadataConn, String updateComponentName, Collection<String> changes, boolean manualReplication) {
        NotificationSettings notificationSetting = this.getNotificationSettings();
        if (notificationSetting.isEnableEmailNotification()) {
            String lastMetadata;
            boolean sendNotification;
            MetadataUpdate metadataUpdate = this.metadataSettingMgr.getMetadataUpdateSettings(connection.getId());
            if (metadataUpdate == null) {
                metadataUpdate = new MetadataUpdate(connection.getId());
            }
            String templateFile = null;
            String entityId = connection.getEntityId();
            String connectionName = connection.getName();
            String spIdp = connection.getRoleType().toString();
            boolean updateConnectionHash = false;
            boolean updated = StringUtils.isNotBlank((String)updateComponentName);
            boolean outOfSync = changes.size() > 0;
            String outOfSyncChange = this.getChangesString(changes);
            String updatedMetadata = metadataUpdate.getLastUsedMetadata();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(SP_IDP, spIdp);
            params.put(ENTITY_ID, entityId);
            params.put(METADATA_URL, metadataUrl);
            params.put(CONNECTION_NAME, connectionName);
            if (updated && outOfSync) {
                updatedMetadata = metadataUpdate.toSha1(metadataConn);
                updateConnectionHash = true;
                templateFile = MetadataUpdateStatus.UPDATED_OUT_OF_SYNC.getTemplateName();
                params.put(UPDATED, updateComponentName);
                params.put(OUT_OF_SYNC, outOfSyncChange);
                params.put(REPLICATED, String.valueOf(!manualReplication));
            } else if (updated) {
                templateFile = MetadataUpdateStatus.UPDATED.getTemplateName();
                params.put(UPDATED, updateComponentName);
                params.put(REPLICATED, String.valueOf(!manualReplication));
            } else if (outOfSync && (sendNotification = metadataUpdate.isSendOutOfSyncNotification(lastMetadata = metadataUpdate.toSha1(metadataConn)))) {
                updatedMetadata = lastMetadata;
                updateConnectionHash = true;
                templateFile = MetadataUpdateStatus.OUT_OF_SYNC.getTemplateName();
                params.put(OUT_OF_SYNC, outOfSyncChange);
            }
            if (StringUtils.isNotBlank((String)templateFile) && (updated || outOfSync)) {
                try {
                    NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
                    String notificationPublisher = notificationSetting.getNotificationPublisherMetadata();
                    notificationSupportHelper.publishNotification(notificationPublisher, templateFile, notificationSetting.getMetadataEventTo(), params, NotificationEventType.SAML_METADATA_UPDATE_EVENT_UPDATED.toString());
                }
                catch (Exception e) {
                    updateConnectionHash = false;
                    log.debug((Object)"Error while sending a metadata email notification.");
                }
                if (updateConnectionHash) {
                    MetadataUpdate updatedMetadataSettings = new MetadataUpdate(metadataUpdate.getConnectionId());
                    updatedMetadataSettings.setLastUsedMetadata(updatedMetadata);
                    this.metadataSettingMgr.saveMetadataUpdateSettings(updatedMetadataSettings);
                }
            }
        }
    }

    private long getUpdateDelay() {
        long metadataUpdateDelayInMins = 86400000L;
        long configMetadataDelay = this.metadataScheduleMgr.getMetadataRefreshDelay();
        metadataUpdateDelayInMins = configMetadataDelay * 60L * 1000L;
        return metadataUpdateDelayInMins;
    }

    private NotificationSettings getNotificationSettings() {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings existingSettings = notificationMgr.getNotificationSettings();
        NotificationSettings settings = new NotificationSettings(existingSettings);
        settings.setTo(existingSettings.getMetadataEventTo());
        settings.setEnableEmailNotification(existingSettings.isEnableMetadataEventNotification());
        return settings;
    }

    private String getChangesString(Collection<String> changes) {
        String outOfSyncChange = null;
        StringBuilder outOfSyncChanges = new StringBuilder();
        for (String change : changes) {
            outOfSyncChanges.append("\n\t - ");
            outOfSyncChanges.append(change);
        }
        outOfSyncChange = outOfSyncChanges.toString();
        return outOfSyncChange;
    }

    public void cancel() {
        log.debug((Object)this.makeLogMessage("cancelling task"));
        this.cancelled = true;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (MetadataUpdateTask.this.timerTask != null) {
                    MetadataUpdateTask.this.timerTask.cancel();
                    MetadataUpdateTask.this.timerTask = null;
                }
            }
        }, 0L);
    }

    public static enum Component {
        CONTACT_INFO("Contact Information"),
        VERIFICATION_CERT("Signature Verification Certificate"),
        ENCRYPTION_CERTIFICATE("Encryption Certificate");

        private final String value;

        private Component(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

