/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.email.util.NotificationSupportHelper;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.NotificationMode;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;

public class NotificationManager
implements NotificationMgr {
    private ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
    private static final String ENABLE_EMAIL_NOTIFICATION = "EnableEmailNotification";
    private static final String ENABLE_EMAIL_PASSWORD_NOTIFICATION = "EnableEmailPasswordNotification";
    private static final String ENABLE_CERTIFICATE_EXPIRATION_NOTIFICATION = "EnableCertificateExpirationNotification";
    private static final String ENABLE_METADATA_EVENT_NOTIFICATION = "EnableMetadataEventNotification";
    private static final String ENABLE_THREAD_POOL_EXHAUSTION_NOTIFICATION = "EnableThreadPoolExhaustionNotification";
    private static final String SMTP_SERVER = "SMTPServer";
    private static final String TIMEOUT = "Timeout";
    private static final String RETRY_ATTEMPTS = "RetryAttempts";
    private static final String RETRY_DELAY = "RetryDelay";
    private static final String SMTP_PORT = "SMTPPort";
    private static final String SSL_SMTP_PORT = "SSLSMTPPort";
    private static final String USE_SSL = "UseSSL";
    private static final String USE_TLS = "UseTLS";
    private static final String VERIFY_HOSTNAME = "VerifyHostname";
    private static final String USE_DEBUGGING = "UseDebugging";
    private static final String NOTIFICATION_FROM = "NotificationFrom";
    private static final String NOTIFICATION_TO = "NotificationTo";
    private static final String NOTIFICATION_CERTIFICATE_EXPIRATION_TO = "NotificationCertificateExpirationTo";
    private static final String NOTIFICATION_LICENSING_EVENTS_TO = "NotificationLicensingEventsTo";
    private static final String NOTIFICATION_USER = "NotificationUser";
    private static final String NOTIFICATION_PASSWORD = "NotificationPassword";
    private static final String NOTIFICATION_CERT_INITIAL_EVENT = "NotificationCertInitialEvent";
    private static final String NOTIFICATION_CERT_FINAL_EVENT = "NotificationCertFinalEvent";
    private static final String NOTIFICATION_CERT_MODE = "NotificationCertMode";
    private static final String NOTIFICATION_METADATA_EVENT_TO = "NotificationMetadataEventsTo";
    private static final String NOTIFICATION_THREAD_POOL_EXHAUSTION_TO = "NotificationThreadPoolExhaustionTo";
    private static final String NOTIFICATION_THREAD_POOL_EXHAUSTION_THREAD_DUMP = "NotificationThreadPoolExhaustionThreadDump";
    private static final String NOTIFICATION_THREAD_POOL_EXHAUSTION_MODE = "NotificationThreadPoolExhaustionMode";
    private static final String SMS_PROVIDER_ACCOUNT_ID = "SmsProviderAccountId";
    private static final String SMS_PROVIDER_AUTH_TOKEN = "SmsProviderAuthToken";
    private static final String SMS_PROVIDER_FROM_NUMBER = "SmsProviderFromNumber";
    private static final String NOTIFICATION_PUBLISHER_LICENSING = "NotificationPublisherLicensing";
    private static final String NOTIFICATION_PUBLISHER_CERTIFICATES = "NotificationPublisherCertificates";
    private static final String NOTIFICATION_PUBLISHER_METADATA = "NotificationPublisherMetadata";
    private static final String NOTIFICATION_PUBLISHER_ACCOUNT_CHANGES = "NotificationPublisherAccountChanges";
    private static final String EXPIRING_CERT_UI_WARNING = "expiringCertUIWarning";
    private static final String EXPIRED_CERT_UI_WARNING = "expiredCertUIWarning";
    public static final String DEFAULT_EXPIRED_CERT_UI_WARNING = "14";
    public static final String DEFAULT_EXPIRING_CERT_UI_WARNING = "14";
    private static final String NOTIFICATION_PUBLISHER_THREAD_POOL_EXHAUSTION = "NotificationPublisherThreadPoolExhaustion";
    private static final String ENABLE_BULKHEAD_ALERTS_NOTIFICATION = "EnableBulkheadAlertsNotification";
    private static final String NOTIFICATION_BULKHEAD_ALERTS_TO = "NotificationBulkheadAlertsTo";
    private static final String NOTIFICATION_BULKHEAD_ALERTS_MODE = "NotificationBulkheadAlertsMode";
    private static final String NOTIFICATION_PUBLISHER_BULKHEAD_ALERTS = "NotificationPublisherBulkheadAlerts";
    private static final String NOTIFICATION_BULKHEAD_THREAD_DUMP = "NotificationBulkheadThreadDump";

    @Override
    public synchronized NotificationSettings getNotificationSettings() {
        String smtpServer = this.configStore.getStringValue(SMTP_SERVER, null);
        NotificationSettings settings = new NotificationSettings();
        settings.setEnableEmailNotification(this.configStore.getBooleanValue(ENABLE_EMAIL_NOTIFICATION, false));
        boolean acctChngsNotify = this.configStore.getBooleanValue(ENABLE_EMAIL_PASSWORD_NOTIFICATION, false);
        settings.setEnableAccountChangesNotification(acctChngsNotify);
        boolean certNotif = this.configStore.getBooleanValue(ENABLE_CERTIFICATE_EXPIRATION_NOTIFICATION, false);
        settings.setEnableCertificateExpirationNotification(certNotif);
        boolean metadataNotify = this.configStore.getBooleanValue(ENABLE_METADATA_EVENT_NOTIFICATION, false);
        settings.setEnableMetadataEventNotification(metadataNotify);
        boolean threadNotify = this.configStore.getBooleanValue(ENABLE_THREAD_POOL_EXHAUSTION_NOTIFICATION, true);
        settings.setEnableThreadPoolExhaustionNotification(threadNotify);
        settings.setSmtpServer(smtpServer);
        settings.setSmtpPort(this.configStore.getStringValue(SMTP_PORT, "25"));
        settings.setSslSmtpPort(this.configStore.getStringValue(SSL_SMTP_PORT, "465"));
        settings.setTimeout(this.configStore.getStringValue(TIMEOUT, ""));
        String emailRetry = this.configStore.getStringValue(RETRY_ATTEMPTS, "2");
        if (StringUtils.isBlank((String)emailRetry)) {
            settings.setEmailRetryAttempt("2");
        } else {
            settings.setEmailRetryAttempt(emailRetry);
        }
        String emailDelay = this.configStore.getStringValue(RETRY_DELAY, "2");
        if (StringUtils.isBlank((String)emailDelay)) {
            settings.setEmailRetryDelay("2");
        } else {
            settings.setEmailRetryDelay(emailDelay);
        }
        settings.setUseSSL(this.configStore.getBooleanValue(USE_SSL, false));
        settings.setUseTLS(this.configStore.getBooleanValue(USE_TLS, false));
        settings.setVerifyHostname(this.configStore.getBooleanValue(VERIFY_HOSTNAME, false));
        settings.setUseDebugging(this.configStore.getBooleanValue(USE_DEBUGGING, false));
        settings.setFrom(this.configStore.getStringValue(NOTIFICATION_FROM, ""));
        settings.setTo(this.configStore.getStringValue(NOTIFICATION_TO, ""));
        settings.setCertificateExpirationTo(this.configStore.getStringValue(NOTIFICATION_CERTIFICATE_EXPIRATION_TO, ""));
        settings.setLicensingEventTo(this.configStore.getStringValue(NOTIFICATION_LICENSING_EVENTS_TO, settings.getLicensingEventTo()));
        settings.setUser(this.configStore.getStringValue(NOTIFICATION_USER, null));
        settings.setCertInitialWarningEvent(this.configStore.getStringValue(NOTIFICATION_CERT_INITIAL_EVENT, ""));
        settings.setCertFinalWarningEvent(this.configStore.getStringValue(NOTIFICATION_CERT_FINAL_EVENT, ""));
        settings.setCertExpirationNotificationMode(NotificationMode.fromNotificationModeName(this.configStore.getStringValue(NOTIFICATION_CERT_MODE, "")));
        String obfuscatedPass = this.configStore.getStringValue(NOTIFICATION_PASSWORD, null);
        if (!StringUtils.isBlank((String)obfuscatedPass)) {
            settings.setPassword(FieldObfuscator.REAL.deobfuscate(obfuscatedPass));
        }
        settings.setMetadataEventTo(this.configStore.getStringValue(NOTIFICATION_METADATA_EVENT_TO, ""));
        settings.setThreadPoolExhaustionTo(this.configStore.getStringValue(NOTIFICATION_THREAD_POOL_EXHAUSTION_TO, ""));
        settings.setThreadPoolExhaustionThreadDump(this.configStore.getBooleanValue(NOTIFICATION_THREAD_POOL_EXHAUSTION_THREAD_DUMP, true));
        settings.setThreadPoolExhaustionNotificationMode(NotificationMode.fromNotificationModeName(this.configStore.getStringValue(NOTIFICATION_THREAD_POOL_EXHAUSTION_MODE, NotificationMode.LOGGING_ONLY.getNotificationModeName())));
        settings.setNotificationPublisherCertificates(this.configStore.getStringValue(NOTIFICATION_PUBLISHER_CERTIFICATES, ""));
        settings.setNotificationPublisherLicensing(this.configStore.getStringValue(NOTIFICATION_PUBLISHER_LICENSING, ""));
        settings.setNotificationPublisherMetadata(this.configStore.getStringValue(NOTIFICATION_PUBLISHER_METADATA, ""));
        settings.setNotificationPublisherAccountChanges(this.configStore.getStringValue(NOTIFICATION_PUBLISHER_ACCOUNT_CHANGES, ""));
        settings.setExpiringCertUIWarning(this.configStore.getStringValue(EXPIRING_CERT_UI_WARNING, "14"));
        settings.setExpiredCertThresholdUIWarning(this.configStore.getStringValue(EXPIRED_CERT_UI_WARNING, "14"));
        settings.setNotificationPublisherThreadPoolExhaustion(this.configStore.getStringValue(NOTIFICATION_PUBLISHER_THREAD_POOL_EXHAUSTION, ""));
        settings.setSmsAccountId(this.configStore.getStringValue(SMS_PROVIDER_ACCOUNT_ID, ""));
        String obfuscatedSmsAuthToken = this.configStore.getStringValue(SMS_PROVIDER_AUTH_TOKEN, null);
        if (!StringUtils.isBlank((String)obfuscatedSmsAuthToken)) {
            settings.setSmsAuthToken(FieldObfuscator.REAL.deobfuscate(obfuscatedSmsAuthToken));
        }
        settings.setSmsFromNumber(this.configStore.getStringValue(SMS_PROVIDER_FROM_NUMBER, ""));
        settings.setEnableBulkheadAlertNotification(this.configStore.getBooleanValue(ENABLE_BULKHEAD_ALERTS_NOTIFICATION, false));
        settings.setNotificationPublisherBulkheadAlerts(this.configStore.getStringValue(NOTIFICATION_PUBLISHER_BULKHEAD_ALERTS, ""));
        settings.setBulkheadAlertNotificationMode(NotificationMode.fromNotificationModeName(this.configStore.getStringValue(NOTIFICATION_BULKHEAD_ALERTS_MODE, NotificationMode.LOGGING_ONLY.getNotificationModeName())));
        settings.setBulkheadAlertsTo(this.configStore.getStringValue(NOTIFICATION_BULKHEAD_ALERTS_TO, ""));
        settings.setBulkheadThreadDump(this.configStore.getBooleanValue(NOTIFICATION_BULKHEAD_THREAD_DUMP, true));
        return settings;
    }

    @Override
    public synchronized void saveNotificationSettings(NotificationSettings notificationSettings) {
        if (notificationSettings != null) {
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                NotificationSettings existingNotificationSettings = this.getNotificationSettings();
                this.configStore.setBooleanValue(ENABLE_EMAIL_NOTIFICATION, notificationSettings.isEnableEmailNotification());
                boolean enableAccountChangesNotification = notificationSettings.isEnableAccountChangesNotification();
                this.configStore.setBooleanValue(ENABLE_EMAIL_PASSWORD_NOTIFICATION, enableAccountChangesNotification);
                boolean enableCertificateExpirationNotification = notificationSettings.isEnableCertificateExpirationNotification();
                this.configStore.setBooleanValue(ENABLE_CERTIFICATE_EXPIRATION_NOTIFICATION, enableCertificateExpirationNotification);
                boolean enableMetadataEventNotification = notificationSettings.isEnableMetadataEventNotification();
                this.configStore.setBooleanValue(ENABLE_METADATA_EVENT_NOTIFICATION, enableMetadataEventNotification);
                boolean enableThreadPoolExhaustionNotification = notificationSettings.isEnableThreadPoolExhaustionNotification();
                this.configStore.setBooleanValue(ENABLE_THREAD_POOL_EXHAUSTION_NOTIFICATION, enableThreadPoolExhaustionNotification);
                this.configStore.setStringValue(SMTP_SERVER, notificationSettings.getSmtpServer());
                this.configStore.setStringValue(SMTP_PORT, notificationSettings.getSmtpPort());
                this.configStore.setStringValue(SSL_SMTP_PORT, notificationSettings.getSslSmtpPort());
                this.configStore.setStringValue(TIMEOUT, notificationSettings.getTimeout());
                this.configStore.setStringValue(RETRY_ATTEMPTS, notificationSettings.getEmailRetryAttempt());
                this.configStore.setStringValue(RETRY_DELAY, notificationSettings.getEmailRetryDelay());
                this.configStore.setBooleanValue(USE_SSL, notificationSettings.isUseSSL());
                this.configStore.setBooleanValue(USE_TLS, notificationSettings.isUseTLS());
                this.configStore.setBooleanValue(VERIFY_HOSTNAME, notificationSettings.isVerifyHostname());
                this.configStore.setBooleanValue(USE_DEBUGGING, notificationSettings.isUseDebugging());
                this.configStore.setStringValue(NOTIFICATION_FROM, notificationSettings.getFrom());
                this.configStore.setStringValue(NOTIFICATION_TO, notificationSettings.getTo());
                this.configStore.setStringValue(NOTIFICATION_CERTIFICATE_EXPIRATION_TO, notificationSettings.getCertificateExpirationTo());
                this.configStore.setStringValue(NOTIFICATION_LICENSING_EVENTS_TO, notificationSettings.getLicensingEventTo());
                this.configStore.setStringValue(NOTIFICATION_CERT_INITIAL_EVENT, notificationSettings.getCertInitialWarningEvent());
                this.configStore.setStringValue(NOTIFICATION_CERT_FINAL_EVENT, notificationSettings.getCertFinalWarningEvent());
                this.configStore.setStringValue(NOTIFICATION_CERT_MODE, notificationSettings.getCertExpirationNotificationMode().getNotificationModeName());
                this.configStore.setStringValue(NOTIFICATION_USER, notificationSettings.getUser());
                this.configStore.setStringValue(NOTIFICATION_METADATA_EVENT_TO, notificationSettings.getMetadataEventTo());
                this.configStore.setStringValue(NOTIFICATION_THREAD_POOL_EXHAUSTION_TO, notificationSettings.getThreadPoolExhaustionTo());
                this.configStore.setBooleanValue(NOTIFICATION_THREAD_POOL_EXHAUSTION_THREAD_DUMP, notificationSettings.getThreadPoolExhaustionThreadDump());
                this.configStore.setStringValue(NOTIFICATION_THREAD_POOL_EXHAUSTION_MODE, notificationSettings.getThreadPoolExhaustionNotificationMode().getNotificationModeName());
                this.configStore.setStringValue(NOTIFICATION_PUBLISHER_CERTIFICATES, notificationSettings.getNotificationPublisherCertificates());
                this.configStore.setStringValue(NOTIFICATION_PUBLISHER_LICENSING, notificationSettings.getNotificationPublisherLicensing());
                this.configStore.setStringValue(NOTIFICATION_PUBLISHER_METADATA, notificationSettings.getNotificationPublisherMetadata());
                this.configStore.setStringValue(NOTIFICATION_PUBLISHER_ACCOUNT_CHANGES, notificationSettings.getNotificationPublisherAccountChanges());
                this.configStore.setStringValue(NOTIFICATION_PUBLISHER_THREAD_POOL_EXHAUSTION, notificationSettings.getNotificationPublisherThreadPoolExhaustion());
                this.configStore.setStringValue(SMS_PROVIDER_ACCOUNT_ID, notificationSettings.getSmsAccountId());
                String smsAuthToken = notificationSettings.getSmsAuthToken();
                if (!StringUtils.isBlank((String)smsAuthToken)) {
                    String obfuSmsAuthToken = FieldObfuscator.REAL.obfuscate(smsAuthToken);
                    this.configStore.setStringValue(SMS_PROVIDER_AUTH_TOKEN, obfuSmsAuthToken);
                } else {
                    this.configStore.setStringValue(SMS_PROVIDER_AUTH_TOKEN, smsAuthToken);
                }
                this.configStore.setStringValue(SMS_PROVIDER_FROM_NUMBER, notificationSettings.getSmsFromNumber());
                String password = notificationSettings.getPassword();
                if (!StringUtils.isBlank((String)password)) {
                    String obfuPass = FieldObfuscator.REAL.obfuscate(password);
                    this.configStore.setStringValue(NOTIFICATION_PASSWORD, obfuPass);
                } else {
                    this.configStore.setStringValue(NOTIFICATION_PASSWORD, password);
                }
                this.configStore.setStringValue(EXPIRING_CERT_UI_WARNING, notificationSettings.getExpiringCertUIWarning());
                this.configStore.setStringValue(EXPIRED_CERT_UI_WARNING, notificationSettings.getExpiredCertThresholdUIWarning());
                this.configStore.setBooleanValue(ENABLE_BULKHEAD_ALERTS_NOTIFICATION, notificationSettings.isEnableBulkheadAlertNotification());
                this.configStore.setStringValue(NOTIFICATION_PUBLISHER_BULKHEAD_ALERTS, notificationSettings.getNotificationPublisherBulkheadAlerts());
                this.configStore.setStringValue(NOTIFICATION_BULKHEAD_ALERTS_TO, notificationSettings.getBulkheadAlertsTo());
                this.configStore.setStringValue(NOTIFICATION_BULKHEAD_ALERTS_MODE, notificationSettings.getBulkheadAlertsNotificationMode().getNotificationModeName());
                this.configStore.setBooleanValue(NOTIFICATION_BULKHEAD_THREAD_DUMP, notificationSettings.getBulkheadThreadDump());
                auditLoggerScope.log(AdminAuditLogger.Component.NOTIFICATION_SETTINGS, AdminAuditLogger.Event.MODIFY);
                String existingNotificationPublisher = existingNotificationSettings.getNotificationPublisherAccountChanges();
                String updatedNotificationPublisher = notificationSettings.getNotificationPublisherAccountChanges();
                NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
                if (notificationSupportHelper.isNotificationPublisherChanged(existingNotificationPublisher, updatedNotificationPublisher)) {
                    auditLoggerScope.log(AdminAuditLogger.Component.ADMIN_CHANGES_NOTIFICATION_PUBLISHER, AdminAuditLogger.Event.MODIFY, String.format("Notification Publisher used for notifying of administrative account changes has changed from '%s' to '%s'.", StringUtils.isBlank((String)existingNotificationPublisher) ? "Default" : existingNotificationPublisher, StringUtils.isBlank((String)updatedNotificationPublisher) ? "Default" : updatedNotificationPublisher));
                }
            }
        }
    }
}

