/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.oauth20.registration.DynamicClientRegistrationPlugin;
import java.util.Collection;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.OAuthDynamicClientRegistrationPluginInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.OAuthDynamicClientRegistrationPluginManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;

public class OAuthDynamicClientRegistrationPluginManagerImpl
implements OAuthDynamicClientRegistrationPluginManager,
AutoReloadable {
    private final PluginManagementSupport pluginMgmtSupport = new PluginManagementSupport("dynamic-client-registration", AdminAuditLogger.Component.OAUTH_CLIENT_REGISTRATION_POLICIES);
    public static final String BASE_NAME = "dynamic-client-registration";

    public OAuthDynamicClientRegistrationPluginManagerImpl(Mediator mediator) {
        this.pluginMgmtSupport.setPluginInstanceFactory(this::newInstance);
    }

    public void finishInit() {
        this.pluginMgmtSupport.loadInstanceCaches();
        this.pluginMgmtSupport.earlyLoadConfigurations();
    }

    @Override
    public Collection<PluginDescriptor> getInstalledDescriptors() {
        return this.pluginMgmtSupport.getInstalledPluginDescriptors();
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.pluginMgmtSupport.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<OAuthDynamicClientRegistrationPluginInstance> getInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getPluginInstances();
        return instances;
    }

    @Override
    public OAuthDynamicClientRegistrationPluginInstance getInstance(String instanceId) {
        return (OAuthDynamicClientRegistrationPluginInstance)this.pluginMgmtSupport.getPluginInstance(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        OAuthDynamicClientRegistrationPluginInstance savingInstance = (OAuthDynamicClientRegistrationPluginInstance)instance;
        this.pluginMgmtSupport.savePluginInstance(savingInstance);
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.deletePluginInstance(instance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.isPluginInUseInternally(pluginId) || this.isPluginInUseExternally(pluginId);
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        return false;
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
        return clientSetting.getPolicyPlugins().contains(pluginId);
    }

    @Override
    public OAuthDynamicClientRegistrationPluginInstance newInstance() {
        return new OAuthDynamicClientRegistrationPluginInstance();
    }

    @Override
    public void loadConfigurations() {
        this.pluginMgmtSupport.loadConfigurations();
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return false;
    }

    @Override
    public boolean supportsDefaultInstance() {
        return false;
    }

    @Override
    public OAuthDynamicClientRegistrationPluginInstance getDefaultInstance() {
        return null;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
    }

    @Override
    public DynamicClientRegistrationPlugin getPolicyPlugin(String instanceId) {
        return (DynamicClientRegistrationPlugin)this.pluginMgmtSupport.getPlugin(instanceId);
    }

    @Override
    public Collection<OAuthDynamicClientRegistrationPluginInstance> getVirtualInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getVirtualPlugins();
        return instances;
    }
}

