/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.pingcommons.crypto.IDGenerator;
import com.pingidentity.x2018.x01.systemKeys.SystemKeyType;
import com.pingidentity.x2018.x01.systemKeys.SystemKeysDocument;
import com.pingidentity.x2018.x01.systemKeys.SystemKeysType;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PFInternalTokenSettingsManager;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;
import org.sourceid.token.PFInternalTokenSetting;
import org.sourceid.token.jwt.PFInternalJwtTokenSettings;
import org.sourceid.token.jwt.SystemKey;

public class PFInternalJwtTokenSettingsManagerImpl
extends ConfigManagerBase
implements PFInternalTokenSettingsManager,
AutoReloadable {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final int KEY_LENGTH = 32;
    private static final String PF_INTERNAL_JWT_TOKEN_SETTING_XML_FILE_NAME = "pingfederate-system-keys.xml";
    private static final String ALGORITHM_TYPE = "encryptionAlgorithm";
    private String algType = null;
    private PFInternalTokenSetting jwkTokenKeySettings = null;

    public PFInternalJwtTokenSettingsManagerImpl() {
        ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
        this.algType = config.getStringValue(ALGORITHM_TYPE, "A128CBC-HS256");
        this.loadConfig();
    }

    @Override
    public synchronized void init() {
    }

    private synchronized void loadConfig() {
        SystemKeysDocument systemKeysDoc = this.getDoc();
        SystemKeysType systemKeys = systemKeysDoc.getSystemKeys();
        SystemKeyType currentKey = systemKeys.getCurrentKey();
        SystemKey current = this.getKey(currentKey);
        SystemKeyType previousKey = systemKeys.getPreviousKey();
        SystemKey previous = this.getKey(previousKey);
        SystemKeyType pendingKey = systemKeys.getPendingKey();
        SystemKey pending = this.getKey(pendingKey);
        this.jwkTokenKeySettings = new PFInternalJwtTokenSettings(this.algType, current, previous, pending);
        if (MgmtFactory.getMediator().isConsole()) {
            this.generateInitialKeys();
        }
    }

    private SystemKey getKey(SystemKeyType systemKey) {
        if (systemKey != null && StringUtils.isNotBlank((String)systemKey.getKey())) {
            Calendar time = systemKey.getGeneratedTime();
            String key = systemKey.getKey();
            Date creationTime = time.getTime();
            return new SystemKey(key, creationTime);
        }
        return null;
    }

    private SystemKeyType getXmlKey(SystemKey systemKey) {
        if (systemKey != null && systemKey.getKey() != null && systemKey.getCreationDate() != null) {
            SystemKeyType xmlSystemKeyType = SystemKeyType.Factory.newInstance();
            Calendar time = Calendar.getInstance();
            time.setTime(systemKey.getCreationDate());
            xmlSystemKeyType.setKey(systemKey.getKey());
            xmlSystemKeyType.setGeneratedTime(time);
            return xmlSystemKeyType;
        }
        return null;
    }

    private SystemKeysDocument getDoc() {
        String dataDir = this.sysDirInfo.getDataDirectory();
        return (SystemKeysDocument)this.xmlLoader.load(dataDir, PF_INTERNAL_JWT_TOKEN_SETTING_XML_FILE_NAME);
    }

    @Override
    public synchronized void savePFInternalTokenSettings(PFInternalTokenSetting pFInternalTokenSetting) {
        this.log.debug((Object)"Saving System Keys.");
        SystemKeysDocument systemKeysDoc = this.getDoc();
        SystemKeyType currentKey = this.getXmlKey(pFInternalTokenSetting.getCurrentKey());
        SystemKeyType pendingKey = this.getXmlKey(pFInternalTokenSetting.getPendingKey());
        SystemKeyType previousKey = this.getXmlKey(pFInternalTokenSetting.getPreviousKey());
        SystemKeysType systemKeys = systemKeysDoc.getSystemKeys();
        systemKeys.setCurrentKey(currentKey);
        systemKeys.setPendingKey(pendingKey);
        systemKeys.setPreviousKey(previousKey);
        this.saveSystemKeys(systemKeysDoc);
    }

    private synchronized void saveSystemKeys(SystemKeysDocument systemKeysDoc) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), PF_INTERNAL_JWT_TOKEN_SETTING_XML_FILE_NAME, (XmlObject)systemKeysDoc);
            auditLoggerScope.log(AdminAuditLogger.Component.SYSTEM_KEYS, AdminAuditLogger.Event.ROTATE);
        }
        this.loadConfig();
    }

    @Override
    public PFInternalTokenSetting getPFInternalTokenSettings() {
        return this.jwkTokenKeySettings;
    }

    private synchronized void generateInitialKeys() {
        if (this.jwkTokenKeySettings == null || this.jwkTokenKeySettings.getCurrentKey() == null && this.jwkTokenKeySettings.getPendingKey() == null) {
            this.log.debug((Object)"Generating Initial System Keys.");
            PFInternalJwtTokenSettings initialSettings = new PFInternalJwtTokenSettings(this.generateSystemKey(), null, this.generateSystemKey());
            this.savePFInternalTokenSettings(initialSettings);
        }
    }

    @Override
    public SystemKey generateSystemKey() {
        byte[] secret = IDGenerator.generateBytes((int)32);
        String key = Obfuscator.obfuscateBinary(secret);
        return new SystemKey(key, new Date());
    }
}

