/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.gui.PasswordCredentialValidatorFieldDescriptor;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class PasswordCredentialValidatorManagerImpl
implements PasswordCredentialValidatorManager,
AutoReloadable {
    private final PluginManagementSupport pluginMgmtSupport;
    private final AuthzServerManager authzServerMgr = MgmtFactory.getAuthzServerManager();
    public static final String BASE_NAME = "password-credential-validators";

    public PasswordCredentialValidatorManagerImpl() {
        this.pluginMgmtSupport = new PluginManagementSupport(BASE_NAME, AdminAuditLogger.Component.PCV);
        this.pluginMgmtSupport.setPluginInstanceFactory(this::newInstance);
    }

    public void finishInit() {
        this.pluginMgmtSupport.loadInstanceCaches();
        this.pluginMgmtSupport.earlyLoadConfigurations();
    }

    @Override
    public Collection<PluginDescriptor> getInstalledDescriptors() {
        Collection<PluginDescriptor> descriptors = this.pluginMgmtSupport.getInstalledPluginDescriptors();
        return descriptors;
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.pluginMgmtSupport.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<PasswordCredentialValidatorInstance> getInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getPluginInstances();
        return instances;
    }

    @Override
    public PasswordCredentialValidatorInstance getInstance(String instanceId) {
        return (PasswordCredentialValidatorInstance)this.pluginMgmtSupport.getPluginInstance(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.savePluginInstance(instance);
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.deletePluginInstance(instance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.isPluginInUseInternally(pluginId) || this.isPluginInUseExternally(pluginId);
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        return !InUseDetectionUtil.getInstance().getPCVInstancesUsingResource(this.getInstances(), PluginManagementSupport.PluginManagementType.PCV, pluginId).isEmpty();
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        AuthzServerManager authSvrMgr = MgmtFactory.getAuthzServerManager();
        ConfigurablePluginInstance pcvInstance = authSvrMgr.getAdminWebServicePcv();
        boolean isUsedByAuthSvr = pcvInstance != null && pcvInstance.getId().equals(pluginId);
        return isUsedByAuthSvr || this.getPluginToUserKeyAttrMappingsUsingId(pluginId).size() > 0 || this.mappedInPlugin(MgmtFactory.getIdpAdapterManager(), pluginId) || this.mappedInPlugin(MgmtFactory.getTokenProcessorManager(), pluginId) || this.inUseByCibaRequestHandlingPolicies(pluginId);
    }

    private boolean inUseByCibaRequestHandlingPolicies(String pluginId) {
        Map<String, CibaServerPolicy.RequestHandlingPolicy> policies = MgmtFactory.getCibaServerPolicyManager().getCibaServerPolicy().getRequestHandlingPolicies();
        for (CibaServerPolicy.RequestHandlingPolicy policy : policies.values()) {
            if (!pluginId.equals(policy.getUserCodePcvId())) continue;
            return true;
        }
        return false;
    }

    private boolean mappedInPlugin(PluginManager<?, ?> pluginMgr, String pluginId) {
        for (ConfigurablePluginInstance instance : pluginMgr.getInstances()) {
            if (!instance.getGuiDescriptor().getAllDescriptorTypesInUse().contains(PasswordCredentialValidatorFieldDescriptor.class) || instance.getConfiguration().getTable("Credential Validators") == null) continue;
            for (Row row : instance.getConfiguration().getTable("Credential Validators").getRows()) {
                if (!row.getField("Password Credential Validator Instance").getValue().equals(pluginId)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<PluginToUserKeyAttrMapping> getPluginToUserKeyAttrMappingsUsingId(String id) {
        Collection<PluginToUserKeyAttrMapping> mappings = this.authzServerMgr.getPwdCredValidatorToUserKeyMappings();
        ArrayList<PluginToUserKeyAttrMapping> mappingsUsingId = new ArrayList<PluginToUserKeyAttrMapping>();
        for (PluginToUserKeyAttrMapping mapping : mappings) {
            if (!id.equals(mapping.getSourcePluginId())) continue;
            mappingsUsingId.add(mapping);
        }
        return mappingsUsingId;
    }

    @Override
    public PasswordCredentialValidatorInstance newInstance() {
        return new PasswordCredentialValidatorInstance();
    }

    @Override
    public void loadConfigurations() {
        this.pluginMgmtSupport.loadConfigurations();
    }

    @Override
    public PasswordCredentialValidator getValidator(String instanceId) {
        return (PasswordCredentialValidator)this.pluginMgmtSupport.getPlugin(instanceId);
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return true;
    }

    @Override
    public boolean supportsDefaultInstance() {
        return false;
    }

    @Override
    public PasswordCredentialValidatorInstance getDefaultInstance() {
        return null;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
    }

    @Override
    public Collection<PasswordCredentialValidatorInstance> getVirtualInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getVirtualPlugins();
        return instances;
    }
}

