/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.impl.JaxbXmlLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.ParserConfigurationException;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.ServiceUsageInfo;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PingOneConnectionsManager;
import org.xml.sax.SAXException;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class PingOneConnectionsManagerImpl
implements PingOneConnectionsManager,
AutoReloadable {
    private static final String PINGONE_CONNECTIONS_FILE = "ping-one-connections.xml";
    private Map<String, PingOneConnection> connectionsById = new HashMap<String, PingOneConnection>();

    public PingOneConnectionsManagerImpl() {
        this.loadConfig();
    }

    @Override
    public synchronized Collection<PingOneConnection> getAllConnections() {
        return this.connectionsById.values();
    }

    @Override
    public synchronized PingOneConnection getConnection(String connectionId) {
        return this.connectionsById.get(connectionId);
    }

    @Override
    public synchronized void saveConnection(PingOneConnection connection) {
        if (connection.getId() == null) {
            connection.setId(IDGenerator.rndAlphaNumeric(22));
        }
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            AdminAuditLogger.Event saveEvent = this.connectionsById.containsKey(connection.getId()) ? AdminAuditLogger.Event.MODIFY : AdminAuditLogger.Event.CREATE;
            this.connectionsById.put(connection.getId(), connection);
            this.saveConfig();
            scope.log(AdminAuditLogger.Component.PINGONE_CONNECTION, saveEvent, connection.getId());
        }
    }

    @Override
    public synchronized void deleteConnection(String connectionId) {
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            PingOneConnection removed = this.connectionsById.remove(connectionId);
            if (removed != null) {
                this.saveConfig();
                scope.log(AdminAuditLogger.Component.PINGONE_CONNECTION, AdminAuditLogger.Event.DELETE, connectionId);
            }
        }
    }

    @Override
    public synchronized boolean isConnectionIdInUse(String connectionId) {
        throw new NotImplementedException();
    }

    @Override
    public synchronized ServiceUsageInfo getConnectionInUseInfo(String connectionId) {
        return null;
    }

    private synchronized void loadConfig() {
        File file = new File(this.getStorageFileName());
        if (file.exists()) {
            JaxbXmlLoader<PingOneConnectionsConfig> loader = new JaxbXmlLoader<PingOneConnectionsConfig>(PingOneConnectionsConfig.class);
            try {
                PingOneConnectionsConfig config = loader.load(MgmtFactory.getSysDirInfo().getDataDirectory(), PINGONE_CONNECTIONS_FILE);
                this.connectionsById.clear();
                for (PingOneConnection connection : config.getConnections()) {
                    String encryptedCredential = connection.getEncryptedCredential();
                    String plainTextCredential = Obfuscator.deobfuscate(encryptedCredential);
                    connection.setCredential(plainTextCredential);
                    this.connectionsById.put(connection.getId(), connection);
                }
            }
            catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Unexpected error deserializing config from file", e);
            }
        }
    }

    private void saveConfig() {
        PingOneConnectionsConfig config = new PingOneConnectionsConfig();
        config.setConnections(this.connectionsById.values());
        try {
            JaxbXmlLoader<PingOneConnectionsConfig> loader = new JaxbXmlLoader<PingOneConnectionsConfig>(PingOneConnectionsConfig.class);
            loader.save(MgmtFactory.getSysDirInfo().getDataDirectory(), PINGONE_CONNECTIONS_FILE, config);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unexpected error serializing config to file", e);
        }
    }

    private String getStorageFileName() {
        String dataDirectory = MgmtFactory.getSysDirInfo().getDataDirectory();
        return dataDirectory + File.separator + PINGONE_CONNECTIONS_FILE;
    }

    @XmlRootElement
    public static class PingOneConnectionsConfig {
        private Collection<PingOneConnection> connections = new ArrayList<PingOneConnection>();

        public Collection<PingOneConnection> getConnections() {
            return this.connections;
        }

        public void setConnections(Collection<PingOneConnection> connections) {
            this.connections = connections;
        }
    }
}

