/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.crypto.PkCert;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.sourceid.saml20.domain.mgmt.SslServerPkCertManager;

public abstract class PingX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private volatile Map<String, PkCert> pkCertMap;
    private volatile List<X509ExtendedKeyManager> keyManagers;

    protected PingX509ExtendedKeyManager() {
        this.reload();
    }

    public void reload() {
        this.setPkCerts(this.getSslServerPkCertManager().getActiveServerPkCerts());
        this.keyManagers = this.getSslServerPkCertManager().getKeyManagers();
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        ArrayList<String> result = new ArrayList<String>();
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            String[] aliases = keyManager.getServerAliases(s, principals);
            if (aliases == null) continue;
            result.addAll(Arrays.asList(aliases));
        }
        return result.isEmpty() ? null : result.toArray(new String[result.size()]);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseServerAlias(s, principals, socket);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            X509Certificate[] chain = keyManager.getCertificateChain(s);
            if (chain == null || chain.length <= 0) continue;
            return chain;
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        PkCert pkCert = this.getPkCert(s);
        if (pkCert != null) {
            return pkCert.getPrivateKey();
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseEngineServerAlias(keyType, issuers, engine);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        throw new UnsupportedOperationException();
    }

    protected abstract SslServerPkCertManager getSslServerPkCertManager();

    protected void setPkCerts(Set<PkCert> pkCerts) {
        HashMap<String, PkCert> newPkCertMap = new HashMap<String, PkCert>();
        pkCerts.forEach(pkCert -> newPkCertMap.put(pkCert.getAlias(), (PkCert)pkCert));
        this.pkCertMap = newPkCertMap;
    }

    protected PkCert getPkCert(String alias) {
        return this.pkCertMap.get(alias);
    }
}

