/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.crypto.AWSCloudHSMUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.KeyAlgorithmInfo;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.CoreConfig;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.mgmt.impl.CertModifiedTimeTracker;

public abstract class PkCertManagerBase
implements PkCertManager,
AutoReloadable {
    protected static final String FIPS_KEY = "pf.hsm.mode";
    protected static final String NCIPHER_MODE = "ncipher";
    protected Log log = LogFactory.getLog(this.getClass());
    protected ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
    protected CoreConfig coreConfig = MgmtFactory.getCoreConfig();
    protected CertificateService certService = MgmtFactory.getCertificateService();
    protected DSignRotationSettingsManager dSignRotationManager = MgmtFactory.getDSignRotationSettingsManager();
    private static final Set<String> hsmTypes = new HashSet<String>();
    private Map<String, PkCert> pkcertCache;

    protected PkCertManagerBase() {
        this.buildPkCertsCacheIfNecessary();
    }

    @Override
    public synchronized PkCert findBySerialNumber(String serialNumber) {
        BigInteger serial = new BigInteger(serialNumber);
        Set<PkCert> allCerts = this.getPkCerts();
        for (PkCert cert : allCerts) {
            if (!cert.getX509Certificate().getSerialNumber().equals(serial)) continue;
            return cert;
        }
        return null;
    }

    @Override
    public synchronized PkCert findByThumbprint(String thumbprint) {
        Set<PkCert> allCerts = this.getPkCerts();
        for (PkCert cert : allCerts) {
            if (!thumbprint.equals(cert.getBase64FingerPrint(HashAlgorithm.SHA1))) continue;
            return cert;
        }
        return null;
    }

    @Override
    public boolean isInUse(PkCert pkCert) {
        if (pkCert == null || pkCert.getId() == null) {
            return false;
        }
        return this.isInUseById(pkCert.getId());
    }

    @Override
    public boolean deletePkCert(PkCert certToDelete) {
        if (certToDelete == null || certToDelete.getId() == null) {
            return false;
        }
        return this.deletePkCertById(certToDelete.getId());
    }

    protected abstract KeyStore getKeystore();

    protected abstract String getPrivateKeyPassword(String var1);

    protected abstract void setPrivateKeyPassword(String var1, String var2);

    protected abstract void writeKeyStore(KeyStore var1);

    protected Map<String, PkCert> getPkCertCache() {
        return this.pkcertCache;
    }

    protected void setPkCertCache(Map<String, PkCert> keysAndCerts) {
        this.pkcertCache = keysAndCerts;
    }

    protected KeyStore getHSMKeystore() {
        return null;
    }

    protected String getHSMKeystoreName() {
        return null;
    }

    protected String getHSMPrivateKeyPassword(String alias) {
        return null;
    }

    protected void setHSMPrivateKeyPassword(String alias, String password) {
    }

    protected void writeHSMKeyStore(KeyStore keystore) {
    }

    public static String generateNewAlias() {
        return IDGenerator.rndStr(25, IDGenerator.LOWER_ALPHA_NUMERICS);
    }

    protected String getSequenceName() {
        return this.getClass().getName();
    }

    @Override
    public synchronized void savePkCerts(Set<PkCert> pkCerts) {
        if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode()) {
            this.saveLocalPkCerts(pkCerts);
        } else if (PropertyInfo.isHSMHybrid()) {
            HashSet<PkCert> localCerts = new HashSet<PkCert>();
            HashSet<PkCert> hsmCerts = new HashSet<PkCert>();
            for (PkCert pkCert : pkCerts) {
                if (pkCert.isStoredOnHSM() == null || pkCert.isStoredOnHSM().booleanValue()) {
                    hsmCerts.add(pkCert);
                    continue;
                }
                localCerts.add(pkCert);
            }
            this.saveLocalPkCerts(localCerts);
            this.saveHSMPkCerts(hsmCerts);
        } else {
            this.saveHSMPkCerts(pkCerts);
        }
    }

    private void saveLocalPkCerts(Set<PkCert> pkCerts) {
        this.savePkCerts(true, pkCerts);
    }

    private void saveHSMPkCerts(Set<PkCert> pkCerts) {
        this.savePkCerts(false, pkCerts);
    }

    private void savePkCerts(boolean localKeystore, Set<PkCert> pkCerts) {
        boolean retry = false;
        KeyStore keystore = null;
        do {
            if (keystore == null) {
                keystore = localKeystore ? this.getKeystore() : this.getHSMKeystore();
            }
            try {
                this.deleteCerts(keystore, pkCerts);
                this.addCerts(keystore, pkCerts);
                retry = false;
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new ConfigurationException(e);
            }
            catch (Exception e) {
                if (NCIPHER_MODE.equalsIgnoreCase(System.getProperty(FIPS_KEY)) && !retry) {
                    this.log.warn((Object)("Error occured while saving certs.  HSM may have failed.  Retrying.  Error Message=" + e.getMessage()));
                    this.certService.reload();
                    this.clearAllCaches();
                    retry = true;
                    continue;
                }
                throw new RuntimeException(e);
            }
        } while (retry);
    }

    protected void addCerts(KeyStore keystore, Set<PkCert> pkCerts) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.addCerts(keystore, pkCerts, null);
    }

    protected void addCerts(KeyStore keystore, Set<PkCert> pkCerts, String password) throws KeyStoreException {
        boolean saveKeystore = false;
        for (PkCert pkCert : pkCerts) {
            if (StringUtils.isBlank((String)pkCert.getAlias())) {
                pkCert.setAlias(this.certService.buildAlias());
            }
            boolean isAwsCloudHSM = "CloudHSM".equals(keystore.getType());
            boolean canSave = pkCert.isNewlySigned();
            boolean bl = canSave = canSave || keystore.getCertificate(pkCert.getAlias()) == null;
            if (isAwsCloudHSM) {
                this.buildPkCertsCacheIfNecessary();
                boolean bl2 = canSave = canSave || !this.getPkCertCache().containsKey(pkCert.getAlias());
            }
            if (canSave) {
                this.log.debug((Object)("add cert " + pkCert.getAlias()));
                String passPhrase = password;
                if (passPhrase == null) {
                    passPhrase = IDGenerator.rndAlphaNumeric(22);
                }
                if (this.isLocalKeystore(keystore)) {
                    this.setPrivateKeyPassword(pkCert.getAlias(), passPhrase);
                } else {
                    this.setHSMPrivateKeyPassword(pkCert.getAlias(), passPhrase);
                }
                if (!this.isLocalKeystore(keystore) && PropertyInfo.getHSMMode() == PropertyInfo.HSM_MODE.AWSCLOUDHSM) {
                    AWSCloudHSMUtil.importPkCert(keystore, pkCert, passPhrase);
                } else {
                    keystore.setKeyEntry(pkCert.getAlias(), pkCert.getPrivateKey(), passPhrase.toCharArray(), pkCert.getChain());
                }
                saveKeystore = true;
            } else {
                this.log.info((Object)("not saving cert " + pkCert.getAlias() + " since it is not new or changed"));
            }
            CertModifiedTimeTracker.trackCertModifiedTime(pkCert.getAlias());
        }
        if (saveKeystore) {
            if (this.isLocalKeystore(keystore)) {
                this.writeKeyStore(keystore);
            } else {
                this.writeHSMKeyStore(keystore);
            }
            this.clearAllCaches();
        }
    }

    protected void deleteCerts(KeyStore store, Set<PkCert> certs) throws KeyStoreException {
        boolean saveKeystore = false;
        String keystoreName = this.isLocalKeystore(store) ? null : this.getHSMKeystoreName();
        ArrayList<String> aliases = Collections.list(this.certService.getAliases(keystoreName, store));
        for (String alias : aliases) {
            if (this.setContainsAlias(alias, certs) || !store.isKeyEntry(alias)) continue;
            if (store.getType().equals("CloudHSM")) {
                PkCert cert = this.getPkCert(alias);
                AWSCloudHSMUtil.deletePkCert(cert);
            } else {
                store.deleteEntry(alias);
            }
            CertModifiedTimeTracker.deleteCertModifiedTime(alias);
            saveKeystore = true;
            if (this.isLocalKeystore(store)) {
                this.setPrivateKeyPassword(alias, null);
            } else {
                this.setHSMPrivateKeyPassword(alias, null);
            }
            this.log.debug((Object)("remove cert " + alias));
            this.dSignRotationManager.deleteRotationSettingForAlias(alias);
        }
        if (saveKeystore) {
            if (this.isLocalKeystore(store)) {
                this.writeKeyStore(store);
            } else {
                this.writeHSMKeyStore(store);
            }
            this.clearAllCaches();
        }
    }

    protected boolean setContainsAlias(String alias, Set<? extends Cert> certs) {
        for (Cert cert : certs) {
            if (!alias.equals(cert.getAlias())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized PkCert getPkCert(String alias) {
        if (alias == null) {
            return null;
        }
        this.buildPkCertsCacheIfNecessary();
        return this.getPkCertCache().get(alias);
    }

    @Override
    public synchronized Set<PkCert> getPkCerts() {
        this.buildPkCertsCacheIfNecessary();
        return new HashSet<PkCert>(this.getPkCertCache().values());
    }

    private void buildPkCertsCacheIfNecessary() {
        Map<String, PkCert> keysAndCerts = this.getPkCertCache();
        if (keysAndCerts == null || keysAndCerts.isEmpty()) {
            keysAndCerts = new ConcurrentHashMap<String, PkCert>();
            if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() || PropertyInfo.isHSMHybrid()) {
                keysAndCerts.putAll(this.buildPkCertsCache(true));
            }
            if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode()) {
                keysAndCerts.putAll(this.buildPkCertsCache(false));
            }
            this.setPkCertCache(keysAndCerts);
        }
    }

    private Map<String, PkCert> buildPkCertsCache(boolean localKeystore) {
        boolean retry = false;
        KeyStore keystore = null;
        HashMap<String, PkCert> keysAndCerts = new HashMap<String, PkCert>();
        do {
            if (keystore == null) {
                keystore = localKeystore ? this.getKeystore() : this.getHSMKeystore();
            }
            try {
                ArrayList<String> aliases = Collections.list(this.certService.getAliases(this.getHSMKeystoreName(), keystore));
                for (String alias : aliases) {
                    if (!keystore.isKeyEntry(alias)) continue;
                    try {
                        PkCert pkCert = this.getPkCert(keystore, alias);
                        if (pkCert == null || pkCert.getPrivateKey() == null || pkCert.getX509Certificate() == null) continue;
                        keysAndCerts.put(alias, pkCert);
                    }
                    catch (KeyStoreException kse) {
                        this.log.error((Object)("Unable to get PkCert with alias '" + alias + "'"), (Throwable)kse);
                    }
                }
                retry = false;
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new ConfigurationException(e);
            }
            catch (Exception e) {
                if (NCIPHER_MODE.equalsIgnoreCase(System.getProperty(FIPS_KEY)) && !retry) {
                    this.log.warn((Object)("Error occured while getting pk certs.  HSM may have failed.  Retrying.  Error Message=" + e.getMessage()));
                    this.certService.reload();
                    this.clearAllCaches();
                    retry = true;
                    continue;
                }
                throw new RuntimeException(e);
            }
        } while (retry);
        this.logCertAliasesWithInvalidKeyAlgorithm(keysAndCerts);
        return keysAndCerts;
    }

    private PkCert getPkCert(KeyStore keystore, String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Certificate[] certificateChain = keystore.getCertificateChain(alias);
        X509Certificate[] x509Certificates = this.convertToX509(certificateChain);
        String privateKeyPassword = this.isLocalKeystore(keystore) ? this.getPrivateKeyPassword(alias) : this.getHSMPrivateKeyPassword(alias);
        if (privateKeyPassword == null) {
            throw new KeyStoreException("No password found for key alias: " + alias);
        }
        Key key = keystore.getKey(alias, privateKeyPassword.toCharArray());
        PrivateKey privateKey = (PrivateKey)key;
        PkCert pkCert = new PkCert(alias, x509Certificates, privateKey);
        if (PropertyInfo.isHSMHybrid()) {
            pkCert.setStoredOnHSM(!this.isLocalKeystore(keystore));
        }
        return pkCert;
    }

    protected X509Certificate[] convertToX509(Certificate[] certificateChain) {
        X509Certificate[] x509Certificates = new X509Certificate[certificateChain.length];
        for (int i = 0; i < certificateChain.length; ++i) {
            x509Certificates[i] = (X509Certificate)certificateChain[i];
        }
        return x509Certificates;
    }

    public synchronized void clearCaches() {
        this.setPkCertCache(null);
    }

    protected synchronized void clearAllCaches() {
        this.clearCaches();
    }

    @Override
    public synchronized boolean deletePkCertById(String id) {
        Set<PkCert> oldCerts = this.getPkCerts();
        HashSet<PkCert> newCerts = new HashSet<PkCert>();
        boolean found = false;
        for (PkCert cert : oldCerts) {
            if (cert.getId().equals(id)) {
                found = true;
                this.dSignRotationManager.deleteRotationSettingForAlias(id);
                continue;
            }
            newCerts.add(cert);
        }
        if (found) {
            this.savePkCerts(newCerts);
        }
        return found;
    }

    @Override
    public synchronized void savePkCert(PkCert newCert) {
        HashSet<PkCert> certs = new HashSet<PkCert>(this.getPkCerts());
        if (newCert.getAlias() != null) {
            Iterator iterator = certs.iterator();
            while (iterator.hasNext()) {
                PkCert current = (PkCert)iterator.next();
                if (!newCert.getAlias().equals(current.getAlias())) continue;
                iterator.remove();
            }
        }
        certs.add(newCert);
        this.savePkCerts(certs);
    }

    protected boolean isLocalKeystore(KeyStore keystore) {
        return !hsmTypes.contains(keystore.getType());
    }

    private void logCertAliasesWithInvalidKeyAlgorithm(Map<String, PkCert> keysAndCertsByAlias) {
        Map<String, KeyAlgorithmInfo> availableAlgos = this.certService.getKeyAlgorithmInfos();
        for (Map.Entry<String, PkCert> entry : keysAndCertsByAlias.entrySet()) {
            String alias = entry.getKey();
            PkCert cert = entry.getValue();
            String pkCertPublicKeyAlgorithmName = cert.getPublicKeyAlgorithm();
            List<Object> validKeySizes = new ArrayList();
            boolean unknownKeyAlgorithm = !availableAlgos.containsKey(cert.getPublicKeyAlgorithm());
            boolean invalidKeySize = false;
            if (!unknownKeyAlgorithm) {
                validKeySizes = availableAlgos.get(pkCertPublicKeyAlgorithmName).getKeySizes();
                boolean bl = invalidKeySize = validKeySizes != null && !validKeySizes.contains(cert.getPublicKeySize());
            }
            if (!unknownKeyAlgorithm && !invalidKeySize) continue;
            this.log.warn((Object)("Loaded certificate with ID \"" + alias + "\" uses the key algorithm: " + pkCertPublicKeyAlgorithmName + " " + cert.getPublicKeySize() + ". Supported key sizes for this algorithm in the current configuration are as follows: " + validKeySizes + "."));
        }
    }

    static {
        if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode()) {
            hsmTypes.add("Luna");
            hsmTypes.add("nCipher.sworld");
            hsmTypes.add("CloudHSM");
            hsmTypes.add("BCFKS");
        }
    }
}

