/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.crypto.HashedPassword;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.HashedField;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.xmlbinding.adapterconf.ConfigType;
import org.sourceid.saml20.xmlbinding.adapterconf.FieldType;
import org.sourceid.saml20.xmlbinding.adapterconf.FieldsType;
import org.sourceid.saml20.xmlbinding.adapterconf.RowType;
import org.sourceid.saml20.xmlbinding.adapterconf.TableType;
import org.sourceid.saml20.xmlbinding.adapterconf.TablesType;

public class PluginConfigUtil {
    public static final String INSTANCE_ID_FIELD_NAME = "com.pingidentity.plugin.instanceid";
    private Log log = LogFactory.getLog(this.getClass());

    Configuration toConfiguration(ConfigurablePluginInstance instance, ConfigType configType, GuiConfigDescriptor guiConfDesc) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Field> advancedFields = new ArrayList<Field>();
        if (instance.getId() != null) {
            String instanceId = instance.getId();
            if (instance.isConnectionBasedPlugin() && instance.getParentId() != null) {
                instanceId = instance.getParentId();
            }
            advancedFields.add(new Field(INSTANCE_ID_FIELD_NAME, instanceId));
        }
        ArrayList<Table> tables = new ArrayList<Table>();
        ArrayList<FieldDescriptor> allFields = new ArrayList<FieldDescriptor>(guiConfDesc.getFields());
        allFields.addAll(guiConfDesc.getAdvancedFields());
        SensitiveFields sensitiveFieldNames = this.getSensitiveFieldNames(allFields);
        for (FieldType fieldType : configType.getFields().getFieldArray()) {
            Field field = this.getField(fieldType, sensitiveFieldNames);
            fields.add(field);
        }
        SensitiveFields sensitiveAdvFieldNames = this.getSensitiveFieldNames(guiConfDesc.getAdvancedFields());
        for (FieldType fieldType : configType.getAdvancedFields().getFieldArray()) {
            Field field = this.getField(fieldType, sensitiveAdvFieldNames);
            advancedFields.add(field);
        }
        for (FieldDescriptor fieldDescriptor : guiConfDesc.getAdvancedFields()) {
            Field field = this.findField(fields, fieldDescriptor.getName());
            if (field == null) continue;
            advancedFields.add(field);
        }
        Map<String, SensitiveFields> sensitiveTableFieldNames = this.getSensitiveTableFieldNamesMap(guiConfDesc);
        for (TableType tableType : configType.getTables().getTableArray()) {
            SensitiveFields sensitiveRowFieldNames = sensitiveTableFieldNames.get(tableType.getName());
            ArrayList<Row> rowsOnTable = new ArrayList<Row>();
            for (RowType rowType : tableType.getRowArray()) {
                ArrayList<Field> fieldsOnRow = new ArrayList<Field>();
                for (FieldType fieldType : rowType.getFieldArray()) {
                    Field field = this.getField(fieldType, sensitiveRowFieldNames);
                    fieldsOnRow.add(field);
                }
                Row row = new Row(fieldsOnRow, rowType.getDefaultRow());
                rowsOnTable.add(row);
            }
            Table table = new Table(tableType.getName(), rowsOnTable);
            tables.add(table);
        }
        Configuration configuration = new Configuration(fields, tables, advancedFields);
        configuration.setId(instance.getId());
        return configuration;
    }

    private Field findField(List<Field> fields, String name) {
        for (Field field : fields) {
            if (StringUtils.isBlank((String)name) || !name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public void fillConfigType(String name, Configuration configuration, GuiConfigDescriptor guiConfDesc, ConfigType configType) {
        configType.setName(name);
        FieldsType fieldsType = configType.addNewFields();
        FieldsType advancedFieldsType = configType.addNewAdvancedFields();
        TablesType tablesType = configType.addNewTables();
        if (configuration != null) {
            ArrayList<FieldDescriptor> allFields = new ArrayList<FieldDescriptor>(guiConfDesc.getFields());
            allFields.addAll(guiConfDesc.getAdvancedFields());
            SensitiveFields sensitiveFieldNames = this.getSensitiveFieldNames(allFields);
            for (Object field : configuration.getFields()) {
                this.setFieldTypeValue(fieldsType.addNewField(), (Field)field, sensitiveFieldNames);
            }
            SensitiveFields sensitiveAdvFieldNames = this.getSensitiveFieldNames(guiConfDesc.getAdvancedFields());
            for (Field field : configuration.getAdvancedFields().getFields()) {
                this.setFieldTypeValue(advancedFieldsType.addNewField(), field, sensitiveAdvFieldNames);
            }
            Map<String, SensitiveFields> sensitiveTableFieldNames = this.getSensitiveTableFieldNamesMap(guiConfDesc);
            for (Table table : configuration.getTables()) {
                TableType tableType = tablesType.addNewTable();
                tableType.setName(table.getName());
                SensitiveFields sensitiveRowFieldNames = sensitiveTableFieldNames.get(table.getName());
                for (Row row : table.getRows()) {
                    RowType rowType = tableType.addNewRow();
                    rowType.setDefaultRow(row.isDefaultRow());
                    for (Field field : row.getFields()) {
                        this.setFieldTypeValue(rowType.addNewField(), field, sensitiveRowFieldNames);
                    }
                }
            }
        }
    }

    private Field getField(FieldType fieldType, SensitiveFields sensitiveFieldNames) {
        Field field;
        Set<Object> hashedFieldNames;
        Set<Object> encryptedFieldNames;
        if (sensitiveFieldNames == null) {
            encryptedFieldNames = Collections.emptySet();
            hashedFieldNames = Collections.emptySet();
        } else {
            encryptedFieldNames = sensitiveFieldNames.getEncryptedFieldNames();
            hashedFieldNames = sensitiveFieldNames.getHashedFieldNames();
        }
        String name = fieldType.getName();
        String value = fieldType.getStringValue();
        if (encryptedFieldNames.contains(name) && !StringUtils.isBlank((String)value)) {
            try {
                value = FieldObfuscator.REAL.deobfuscate(value);
            }
            catch (ObfuscationException oe) {
                this.log.error((Object)("There was a problem deobfuscating the value for the field: " + name));
            }
            field = new Field(name, value);
        } else if (hashedFieldNames.contains(name)) {
            try {
                String clearTextValue = Obfuscator.deobfuscate(value);
                value = HashedPassword.fromClearText(clearTextValue).toEncodedText();
            }
            catch (Exception exception) {
                // empty catch block
            }
            field = new HashedField(name, value, null);
        } else {
            field = new Field(name, value);
        }
        return field;
    }

    private Map<String, SensitiveFields> getSensitiveTableFieldNamesMap(GuiConfigDescriptor guiConfigDesc) {
        HashMap<String, SensitiveFields> sensitiveTableFieldNames = new HashMap<String, SensitiveFields>();
        for (TableDescriptor tableDescriptor : guiConfigDesc.getTables()) {
            SensitiveFields sensitiveRowFieldNames = this.getSensitiveFieldNames(tableDescriptor.getRowFields());
            sensitiveTableFieldNames.put(tableDescriptor.getName(), sensitiveRowFieldNames);
        }
        return sensitiveTableFieldNames;
    }

    private SensitiveFields getSensitiveFieldNames(List<FieldDescriptor> fields) {
        HashSet<String> encryptedFieldNames = new HashSet<String>();
        HashSet<String> hashedFieldNames = new HashSet<String>();
        for (FieldDescriptor fieldDescriptor : fields) {
            if (fieldDescriptor instanceof TextFieldDescriptor) {
                TextFieldDescriptor textFieldDescriptor = (TextFieldDescriptor)fieldDescriptor;
                if (!textFieldDescriptor.isEncrypted()) continue;
                encryptedFieldNames.add(textFieldDescriptor.getName());
                continue;
            }
            if (!(fieldDescriptor instanceof HashedTextFieldDescriptor)) continue;
            hashedFieldNames.add(fieldDescriptor.getName());
        }
        return new SensitiveFields(encryptedFieldNames, hashedFieldNames);
    }

    private void setFieldTypeValue(FieldType fieldType, Field field, SensitiveFields sensitiveFieldNames) {
        HashedField hashedField;
        Set<Object> hashedFieldNames;
        Set<Object> encryptedFieldNames;
        if (sensitiveFieldNames == null) {
            encryptedFieldNames = Collections.emptySet();
            hashedFieldNames = Collections.emptySet();
        } else {
            encryptedFieldNames = sensitiveFieldNames.getEncryptedFieldNames();
            hashedFieldNames = sensitiveFieldNames.getHashedFieldNames();
        }
        String value = "";
        if (!StringUtils.isBlank((String)field.getValue())) {
            value = field.getValue();
            if (encryptedFieldNames.contains(field.getName())) {
                value = FieldObfuscator.REAL.obfuscate(value);
            }
        }
        if (hashedFieldNames.contains(field.getName()) && field instanceof HashedField && (hashedField = (HashedField)field).getPlainTextValue() != null) {
            value = HashedPassword.fromClearText(hashedField.getPlainTextValue()).toEncodedText();
        }
        String name = field.getName();
        fieldType.setName(name);
        fieldType.setStringValue(value);
    }

    private class SensitiveFields {
        private final Set<String> encryptedFieldNames;
        private final Set<String> hashedFieldNames;

        public SensitiveFields(Set<String> encryptedNames, Set<String> hashedNames) {
            this.encryptedFieldNames = encryptedNames;
            this.hashedFieldNames = hashedNames;
        }

        public Set<String> getEncryptedFieldNames() {
            return this.encryptedFieldNames;
        }

        public Set<String> getHashedFieldNames() {
            return this.hashedFieldNames;
        }
    }
}

