/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.adapter.virtual.VirtualAuthnAdapter;
import com.pingidentity.adapter.virtual.VirtualAuthnAdapterInstance;
import com.pingidentity.common.util.AdapterUtils;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.localidentity.LocalIdentityAdapter;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.DescribablePlugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.PluginMgmtConfigSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginSupport;
import org.sourceid.saml20.xmlbinding.adapterconf.ConfigType;

public class PluginManagementSupport {
    private static final Log log = LogFactory.getLog(PluginManagementSupport.class);
    private final String descriptorFileName;
    private final ConfigStore configStore;
    private final String classMapKey;
    private final String parentMapKey;
    private final String defaultKey;
    private final PluginSupport support = new PluginSupport();
    private final PluginMgmtConfigSupport configSupport;
    private PluginInstanceFactory pluginInstanceFactory = new PluginInstanceFactory(){

        @Override
        public ConfigurablePluginInstance constructPluginInstance() {
            return new BasePluginInstance();
        }
    };
    private final Map<String, ConfigurablePlugin> livePluginsMap = new HashMap<String, ConfigurablePlugin>();
    private boolean nonConnectionBasedInstanceCacheLoaded = false;
    private boolean connectionBasedInstanceCacheLoaded = false;
    private boolean virtualInstanceCacheLoaded = false;
    private boolean lipCacheLoaded = false;
    private final Map<String, ConfigurablePluginInstance> connectionBasedInstanceCache = new CaseInsensitiveMap();
    private final Map<String, ConfigurablePluginInstance> nonConnectionBasedInstanceCache = new CaseInsensitiveMap();
    private final Map<String, ConfigurablePluginInstance> virtualInstanceCache = new CaseInsensitiveMap();
    private final Map<String, ConfigurablePluginInstance> localIdentityInstanceCache = new CaseInsensitiveMap();
    private final Map<String, Map<String, ConfigurablePluginInstance>> connectionToConnBasedInstanceCache = new HashMap<String, Map<String, ConfigurablePluginInstance>>();
    private PluginManagementType pluginManagementType = PluginManagementType.NON_CONNECTION_BASED;
    private final AdminAuditLogger.Component adminAuditLoggerComponent;

    public PluginManagementSupport(String baseName, AdminAuditLogger.Component adminAuditLoggerComponent) {
        this(baseName, new PluginMgmtConfigSupport(baseName), adminAuditLoggerComponent);
    }

    public PluginManagementSupport(String baseName, PluginMgmtConfigSupport cfgSupport, AdminAuditLogger.Component adminAuditLoggerComponent) {
        this(baseName, cfgSupport, false, adminAuditLoggerComponent);
    }

    public PluginManagementSupport(String baseName, PluginMgmtConfigSupport cfgSupport, boolean supportsDefaultInstance, AdminAuditLogger.Component adminAuditLoggerComponent) {
        this("PF-INF/" + baseName, baseName, cfgSupport, baseName, baseName + "-parents", supportsDefaultInstance ? baseName + "-default" : null, adminAuditLoggerComponent);
    }

    public PluginManagementSupport(String descFileName, String configFileName, PluginMgmtConfigSupport cfgSupport, String classMapKey, String parentMapKey, String defaultKey, AdminAuditLogger.Component adminAuditLoggerComponent) {
        this.descriptorFileName = descFileName;
        this.configStore = ConfigStoreFarm.getConfig(configFileName, true);
        this.classMapKey = classMapKey;
        this.parentMapKey = parentMapKey;
        this.defaultKey = defaultKey;
        this.configSupport = cfgSupport;
        this.adminAuditLoggerComponent = adminAuditLoggerComponent;
    }

    public synchronized void clearInstanceCaches() {
        this.livePluginsMap.clear();
        this.clearNonConnectionBasedInstanceCache();
        this.clearConnectionBasedInstanceCache();
        this.clearVirtualInstanceCache();
        this.clearLipInstanceCache();
    }

    public synchronized void loadInstanceCaches() {
        this.loadNonConnectionBasedInstanceCache();
        this.loadConnectionBasedInstanceCache();
        this.loadVirtualInstanceCache();
    }

    public synchronized boolean isDuplicateInstanceId(String instanceId) {
        Map map = this.configStore.getMapValue(this.classMapKey, new HashMap());
        HashSet instanceIds = new HashSet(map.keySet());
        instanceIds.addAll(this.getConnectionBasedInstanceCache().keySet());
        instanceIds.addAll(this.getVirtualInstanceCache().keySet());
        for (String key : instanceIds) {
            if (instanceId == null || !instanceId.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public synchronized Collection<PluginDescriptor> getInstalledPluginDescriptors() {
        LinkedList<PluginDescriptor> descriptors = new LinkedList<PluginDescriptor>();
        Set<String> classNames = this.support.getInstalledClassNames(this.descriptorFileName);
        for (String className : classNames) {
            DescribablePlugin describablePlugin;
            if (this.isVirtualAdapter(className) || (describablePlugin = this.support.createInstance(className, DescribablePlugin.class)) == null) continue;
            PluginDescriptor pluginDescriptor = describablePlugin.getPluginDescriptor();
            if (pluginDescriptor != null) {
                descriptors.add(pluginDescriptor);
                continue;
            }
            String name = describablePlugin.getClass().getName();
            String msg = name + " returned a null Descriptor so cannot be registered with the system";
            log.warn((Object)msg);
        }
        return descriptors;
    }

    public synchronized <T> Collection<T> getPluginsOfType(Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        Collection<PluginDescriptor> installedDescriptors = this.getInstalledPluginDescriptors();
        for (PluginDescriptor descriptor : installedDescriptors) {
            String className = descriptor.getPluginClassName();
            T plugin = this.support.createInstance(className, type, false);
            if (plugin == null) continue;
            result.add(plugin);
        }
        return result;
    }

    public synchronized Collection<ConfigurablePluginInstance> getPluginInstances() {
        this.loadNonConnectionBasedInstanceCache();
        this.loadConnectionBasedInstanceCache();
        ArrayList<ConfigurablePluginInstance> result = new ArrayList<ConfigurablePluginInstance>();
        result.addAll(this.nonConnectionBasedInstanceCache.values());
        result.addAll(this.connectionBasedInstanceCache.values());
        return result;
    }

    public synchronized Collection<ConfigurablePluginInstance> getNonConnectionBasedPlugins() {
        return Collections.unmodifiableCollection(this.getNonConnectionBasedInstanceCache().values());
    }

    private Map<String, ConfigurablePluginInstance> getNonConnectionBasedInstanceCache() {
        this.loadNonConnectionBasedInstanceCache();
        return this.nonConnectionBasedInstanceCache;
    }

    private Map<String, ConfigurablePluginInstance> getConnectionBasedInstanceCache() {
        this.loadConnectionBasedInstanceCache();
        return this.connectionBasedInstanceCache;
    }

    private Map<String, Map<String, ConfigurablePluginInstance>> getConnectionToConnBasedInstanceCache() {
        this.loadConnectionBasedInstanceCache();
        return this.connectionToConnBasedInstanceCache;
    }

    public synchronized Collection<ConfigurablePluginInstance> getVirtualPlugins() {
        this.loadVirtualInstanceCache();
        return Collections.unmodifiableCollection(this.virtualInstanceCache.values());
    }

    private Map<String, ConfigurablePluginInstance> getVirtualInstanceCache() {
        this.loadVirtualInstanceCache();
        return this.virtualInstanceCache;
    }

    public synchronized ConfigurablePluginInstance getPluginInstance(String instanceId) {
        this.loadNonConnectionBasedInstanceCache();
        this.loadConnectionBasedInstanceCache();
        this.loadVirtualInstanceCache();
        this.loadLipCache();
        ConfigurablePluginInstance result = this.nonConnectionBasedInstanceCache.get(instanceId);
        if (result != null) {
            return result;
        }
        result = this.connectionBasedInstanceCache.get(instanceId);
        if (result != null) {
            return result;
        }
        result = this.virtualInstanceCache.get(instanceId);
        if (result != null) {
            return result;
        }
        result = this.localIdentityInstanceCache.get(instanceId);
        if (result != null) {
            return result;
        }
        if (instanceId != null && log.isErrorEnabled()) {
            log.error((Object)("Unable to load " + this.adminAuditLoggerComponent + " plugin instance: " + instanceId));
        }
        return null;
    }

    private synchronized void loadLipCache() {
        if (!this.lipCacheLoaded && this.pluginManagementType == PluginManagementType.IDP_ADAPTER) {
            this.localIdentityInstanceCache.putAll(MgmtFactory.getLocalIdentityProfileManager().getProfiles().stream().map(lip -> this.getInstance(lip.getId(), LocalIdentityAdapter.class.getName())).filter(Objects::nonNull).collect(Collectors.toMap(ConfigurablePluginInstance::getId, Function.identity())));
            this.lipCacheLoaded = true;
        }
    }

    public synchronized ConfigurablePluginInstance getPluginInstanceForConnection(String instanceId, String connectionId) {
        ConfigurablePluginInstance instance;
        Map<String, ConfigurablePluginInstance> map = this.getConnectionToConnBasedInstanceCache().get(connectionId);
        if (map != null && (instance = map.get(instanceId)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading connection based plugin: " + instance.getId()));
            }
            return instance;
        }
        return this.getPluginInstance(instanceId);
    }

    public synchronized ConfigurablePluginInstance getDefaultInstance() {
        String defaultInstanceId = this.getDefaultInstanceId();
        if (defaultInstanceId == null) {
            return null;
        }
        return this.getPluginInstance(defaultInstanceId);
    }

    public synchronized ConfigurablePlugin getDefaultPlugin() {
        String defaultInstanceId = this.getDefaultInstanceId();
        if (defaultInstanceId == null) {
            return null;
        }
        return this.getPlugin(defaultInstanceId);
    }

    public synchronized String getDefaultInstanceId() {
        if (this.defaultKey == null) {
            return null;
        }
        return this.configStore.getStringValue(this.defaultKey, null);
    }

    public synchronized void setDefaultInstance(String instanceId) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.setDefaultInstance(instanceId, auditLoggerScope);
        }
    }

    protected synchronized void setDefaultInstance(String instanceId, AuditLoggerScope auditLoggerScope) {
        ConfigurablePluginInstance currentDefault = this.getDefaultInstance();
        if (currentDefault != null) {
            currentDefault.setDefaultInstance(false);
        }
        this.configStore.setStringValue(this.defaultKey, instanceId);
        ConfigurablePluginInstance instance = this.getPluginInstance(instanceId);
        instance.setDefaultInstance(true);
        this.savePluginInstance(instance, "Default instance modified to " + instanceId, auditLoggerScope);
    }

    public synchronized boolean pluginHasConnectionBasedOverride(String instanceId, String connectionId) {
        ConfigurablePluginInstance instance;
        Map<String, ConfigurablePluginInstance> map = this.getConnectionToConnBasedInstanceCache().get(connectionId);
        return map != null && (instance = map.get(instanceId)) != null;
    }

    public synchronized void savePluginInstance(ConfigurablePluginInstance instance) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.savePluginInstance(instance, instance.getName(), auditLoggerScope);
        }
    }

    protected synchronized void savePluginInstance(ConfigurablePluginInstance instance, String message, AuditLoggerScope auditLoggerScope) {
        this.clearNonConnectionBasedInstanceCache();
        Map classMap = this.configStore.getMapValue(this.classMapKey, new HashMap());
        String instanceId = instance.getId();
        String existingValue = classMap.put(instanceId, instance.getDescriptor().getPluginClassName());
        instance.setLastModified((Calendar)new XmlCalendar(new Date()));
        this.configSupport.saveConf(instance);
        auditLoggerScope.log(this.adminAuditLoggerComponent, existingValue != null ? AdminAuditLogger.Event.MODIFY : AdminAuditLogger.Event.CREATE, message);
        String parentId = instance.getParentId();
        if (this.parentMapKey != null) {
            Map parentMap = this.configStore.getMapValue(this.parentMapKey, new HashMap());
            if (parentId != null) {
                parentMap.put(instanceId, parentId);
                this.configStore.setMapValue(this.parentMapKey, parentMap);
            } else if (parentMap.containsKey(instanceId)) {
                parentMap.remove(instanceId);
                this.configStore.setMapValue(this.parentMapKey, parentMap);
            }
        }
        this.configStore.setMapValue(this.classMapKey, classMap);
        if (this.defaultKey != null && instance.isDefaultInstance()) {
            this.configStore.setStringValue(this.defaultKey, instance.getId());
        }
        this.livePluginsMap.clear();
        this.getPlugin(instanceId);
    }

    public synchronized void deletePluginInstance(ConfigurablePluginInstance instance) {
        this.clearNonConnectionBasedInstanceCache();
        Map map = this.configStore.getMapValue(this.classMapKey, new HashMap());
        String instanceId = instance.getId();
        map.remove(instanceId);
        this.livePluginsMap.remove(instanceId);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.configSupport.deleteConf(instance);
            auditLoggerScope.log(this.adminAuditLoggerComponent, AdminAuditLogger.Event.DELETE, instanceId);
            Map parentMap = this.configStore.getMapValue(this.parentMapKey, new HashMap());
            parentMap.remove(instanceId);
            this.configStore.setMapValue(this.parentMapKey, parentMap);
            this.configStore.setMapValue(this.classMapKey, map);
            if (this.defaultKey != null && instance.getId().equals(this.configStore.getStringValue(this.defaultKey, null))) {
                this.configStore.setStringValue(this.defaultKey, null);
            }
        }
    }

    private synchronized Collection<ConfigurablePluginInstance> createInstances() {
        LinkedList<ConfigurablePluginInstance> instances = new LinkedList<ConfigurablePluginInstance>();
        Map map = this.configStore.getMapValue(this.classMapKey, new HashMap());
        for (Map.Entry entry : map.entrySet()) {
            String className;
            String instanceId = (String)entry.getKey();
            ConfigurablePluginInstance instance = this.getInstance(instanceId, className = (String)entry.getValue());
            if (instance == null) continue;
            if (this.defaultKey != null && instanceId.equals(this.configStore.getStringValue(this.defaultKey, null))) {
                instance.setDefaultInstance(true);
            }
            instances.add(instance);
        }
        return instances;
    }

    public synchronized void loadConfigurations() {
        log.debug((Object)("Configuring plugins (" + this.descriptorFileName + ")"));
        for (ConfigurablePluginInstance instance : this.getPluginInstances()) {
            this.getPlugin(instance.getId());
        }
        log.debug((Object)("Finished configuring plugins (" + this.descriptorFileName + ")"));
    }

    public synchronized void earlyLoadConfigurations() {
        log.debug((Object)("Configuring plugins that support early create-and-configure (" + this.descriptorFileName + ")"));
        for (ConfigurablePluginInstance instance : this.getPluginInstances()) {
            Object earlyCreateAndConfigure = instance.getDescriptor().getMetadata().get("EarlyCreateAndConfigure");
            if (!Boolean.TRUE.equals(earlyCreateAndConfigure)) continue;
            this.getPlugin(instance.getId());
        }
        log.debug((Object)("Finished configuring plugins that support early create-and-configure (" + this.descriptorFileName + ")"));
    }

    private synchronized void clearNonConnectionBasedInstanceCache() {
        this.nonConnectionBasedInstanceCache.clear();
        this.nonConnectionBasedInstanceCacheLoaded = false;
    }

    private synchronized void clearConnectionBasedInstanceCache() {
        this.connectionBasedInstanceCache.clear();
        this.connectionToConnBasedInstanceCache.clear();
        this.connectionBasedInstanceCacheLoaded = false;
    }

    public synchronized void clearVirtualInstanceCache() {
        this.virtualInstanceCache.clear();
        this.virtualInstanceCacheLoaded = false;
    }

    public synchronized void clearLipInstanceCache() {
        this.localIdentityInstanceCache.clear();
        this.lipCacheLoaded = false;
    }

    private synchronized void loadVirtualInstanceCache() {
        if (!(this.pluginManagementType != PluginManagementType.IDP_ADAPTER && this.pluginManagementType != PluginManagementType.SP_ADAPTER || this.virtualInstanceCacheLoaded)) {
            log.debug((Object)(this.getPluginMgmtTypeString() + ": loading virtual instance cache"));
            PluginSupport ps = new PluginSupport();
            Set<String> spAdapters = ps.getInstalledClassNames(this.descriptorFileName);
            for (String spAdapterClassName : spAdapters) {
                if (!this.isVirtualAdapter(spAdapterClassName)) continue;
                try {
                    VirtualAuthnAdapter virtualAdapter = (VirtualAuthnAdapter)Class.forName(spAdapterClassName).newInstance();
                    Set<VirtualAuthnAdapterInstance> virtualAdapterInstances = virtualAdapter.getAdapterInstances();
                    for (VirtualAuthnAdapterInstance virtualInstance : virtualAdapterInstances) {
                        ConfigurablePluginInstance instance = this.getInstance(virtualInstance.getAdapterId(), spAdapterClassName);
                        if (instance == null) continue;
                        instance.setName(virtualInstance.getAdapterName());
                        instance.setVirtualInstance(true);
                        if (instance instanceof AuthnAdapterInstance) {
                            ((AuthnAdapterInstance)instance).setAllowedApcs(virtualInstance.getAllowedApcs());
                        }
                        this.virtualInstanceCache.put(instance.getId(), instance);
                        log.debug((Object)(this.getPluginMgmtTypeString() + ": added instance " + instance.getId() + " to cache, size=" + this.virtualInstanceCache.size()));
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                }
            }
            this.virtualInstanceCacheLoaded = true;
            log.debug((Object)(this.getPluginMgmtTypeString() + ": finished loading virtual instance cache"));
        }
    }

    private boolean isVirtualAdapter(String classNameString) {
        boolean isVirtualAdapter = false;
        try {
            Class<?> theClass = Class.forName(classNameString);
            isVirtualAdapter = Arrays.asList(theClass.getInterfaces()).contains(VirtualAuthnAdapter.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return isVirtualAdapter;
    }

    private synchronized void loadNonConnectionBasedInstanceCache() {
        if (!this.nonConnectionBasedInstanceCacheLoaded) {
            log.debug((Object)(this.getPluginMgmtTypeString() + ": loading non-conn-based instance cache"));
            Collection<ConfigurablePluginInstance> instances = this.createInstances();
            for (ConfigurablePluginInstance instance : instances) {
                this.nonConnectionBasedInstanceCache.put(instance.getId(), instance);
                log.debug((Object)(this.getPluginMgmtTypeString() + ": added instance " + instance.getId() + " to cache, size=" + this.nonConnectionBasedInstanceCache.size()));
            }
            this.nonConnectionBasedInstanceCacheLoaded = true;
            log.debug((Object)(this.getPluginMgmtTypeString() + ": finished loading non-conn-based instance cache"));
        }
    }

    private synchronized void loadConnectionBasedInstanceCache() {
        if (!this.connectionBasedInstanceCacheLoaded) {
            if (this.pluginManagementType == PluginManagementType.SP_ADAPTER || this.pluginManagementType == PluginManagementType.TOKEN_GENERATOR) {
                log.debug((Object)(this.getPluginMgmtTypeString() + ": loading conn-based instance cache"));
                for (IdpConnection idpConn : MgmtFactory.getMetadataDirectory().getIdpConnectionsWithConnBasedPluginOverrides()) {
                    this.addConnBasedInstancesToCache(idpConn);
                }
                log.debug((Object)(this.getPluginMgmtTypeString() + ": finished loading conn-based instance cache"));
            }
            if (this.pluginManagementType == PluginManagementType.IDP_ADAPTER || this.pluginManagementType == PluginManagementType.TOKEN_PROCESSOR) {
                log.debug((Object)(this.getPluginMgmtTypeString() + ": loading conn-based instance cache"));
                for (SpConnection spConn : MgmtFactory.getMetadataDirectory().getSpConnectionsWithConnBasedPluginOverrides()) {
                    this.addConnBasedInstancesToCache(spConn);
                }
                log.debug((Object)(this.getPluginMgmtTypeString() + ": finished loading conn-based instance cache"));
            }
            this.connectionBasedInstanceCacheLoaded = true;
        }
    }

    public synchronized void reloadConnBasedInstances(ConnectionBase conn) {
        if (this.connectionBasedInstanceCacheLoaded) {
            this.removeConnBasedInstancesFromCache(conn.getEntityId());
            this.addConnBasedInstancesToCache(conn);
        }
    }

    public synchronized void removeConnBasedInstances(ConnectionBase conn) {
        if (this.connectionBasedInstanceCacheLoaded) {
            this.removeConnBasedInstancesFromCache(conn.getEntityId());
        }
    }

    private synchronized void addConnBasedInstancesToCache(ConnectionBase conn) {
        Collection<ConfigurablePluginInstance> connBasedInstances = conn.getConnBasedPluginOverrides(this.pluginManagementType);
        if (!connBasedInstances.isEmpty()) {
            log.debug((Object)(this.getPluginMgmtTypeString() + ": adding conn-based instances to cache for " + conn.getRoleType() + " connection " + conn.getEntityId()));
            for (ConfigurablePluginInstance instance : connBasedInstances) {
                this.addConnBasedInstanceToCache(instance);
            }
        }
    }

    private synchronized void addConnBasedInstanceToCache(ConfigurablePluginInstance instance) {
        this.connectionBasedInstanceCache.put(instance.getId(), instance);
        Map<String, ConfigurablePluginInstance> map = this.connectionToConnBasedInstanceCache.get(instance.getConnectionId());
        if (map == null) {
            map = new HashMap<String, ConfigurablePluginInstance>();
        }
        map.put(instance.getParentId(), instance);
        this.connectionToConnBasedInstanceCache.put(instance.getConnectionId(), map);
        log.debug((Object)(this.getPluginMgmtTypeString() + ": added conn-based instance " + instance.getId() + " to cache, size=" + this.connectionBasedInstanceCache.size()));
    }

    private synchronized void removeConnBasedInstancesFromCache(String entityId) {
        Map<String, ConfigurablePluginInstance> map = this.connectionToConnBasedInstanceCache.get(entityId);
        if (map == null) {
            return;
        }
        for (ConfigurablePluginInstance instance : map.values()) {
            this.connectionBasedInstanceCache.remove(instance.getId());
            this.livePluginsMap.remove(instance.getId());
            log.debug((Object)(this.getPluginMgmtTypeString() + ": removed conn-based instance " + instance.getId() + " (entityId=" + entityId + ") from cache, size=" + this.connectionBasedInstanceCache.size()));
        }
        this.connectionToConnBasedInstanceCache.remove(entityId);
    }

    public synchronized ConfigurablePlugin getPluginForConnection(String instanceId, String connectionId) {
        ConfigurablePluginInstance instance = this.getPluginInstanceForConnection(instanceId, connectionId);
        if (instance != null) {
            instanceId = instance.getId();
        }
        return this.getPlugin(instanceId);
    }

    public synchronized ConfigurablePlugin getPlugin(String instanceId) {
        Configuration configuration;
        PluginDescriptor descriptor;
        PluginFipsStatus fipsStatus;
        ConfigurablePlugin plugin = this.livePluginsMap.get(instanceId);
        if (plugin != null) {
            return plugin;
        }
        Map map = this.configStore.getMapValue(this.classMapKey, Collections.EMPTY_MAP);
        String className = (String)map.get(instanceId);
        ConfigurablePluginInstance configurablePluginInstance = this.getNonConnectionBasedInstanceCache().get(instanceId);
        if (className == null && this.pluginManagementType != PluginManagementType.NON_CONNECTION_BASED && (configurablePluginInstance = this.getConnectionBasedInstanceCache().get(instanceId)) != null) {
            className = (String)map.get(configurablePluginInstance.getParentId());
        }
        if (className == null && (configurablePluginInstance = this.getVirtualInstanceCache().get(instanceId)) != null) {
            className = configurablePluginInstance.getDescriptor().getPluginClassName();
        }
        if (configurablePluginInstance == null) {
            log.warn((Object)("Failed to find plugin instance with ID " + instanceId));
            return null;
        }
        if (className == null) {
            log.warn((Object)("Failed to determine class name for plugin instance ID " + instanceId));
            return null;
        }
        String logName = instanceId + " (" + className + ")";
        plugin = this.support.createInstance(className, ConfigurablePlugin.class);
        if (plugin == null) {
            log.warn((Object)("Unable to configure " + logName + " because instance came back null"));
            return null;
        }
        if (PropertyInfo.isBCFIPSMode() && (fipsStatus = AdapterUtils.getPluginFipsStatus(className, (descriptor = configurablePluginInstance.getDescriptor()).getMetadata())) != PluginFipsStatus.COMPLIANT) {
            log.warn((Object)("'" + configurablePluginInstance.getName() + "' FIPS status: " + fipsStatus + " (" + descriptor.getType() + ", " + descriptor.getPluginClassName() + ")"));
        }
        if ((configuration = configurablePluginInstance.getRuntimeCompositeConfiguration()) == null) {
            configuration = new Configuration();
        }
        try {
            log.info((Object)("Configuring plugin " + logName));
            plugin.configure(configuration);
            if (plugin instanceof VirtualAuthnAdapter) {
                ((VirtualAuthnAdapter)plugin).setAdapterId(instanceId);
            }
        }
        catch (Throwable t) {
            String msg = "Unexpected exception thrown attempting to configure plugin: " + logName;
            log.error((Object)msg, t);
        }
        this.livePluginsMap.put(instanceId, plugin);
        return plugin;
    }

    private ConfigurablePluginInstance getInstance(String instanceId, String implClassName) {
        String parentId = null;
        if (this.parentMapKey != null) {
            Map parentMap = this.configStore.getMapValue(this.parentMapKey, Collections.EMPTY_MAP);
            parentId = (String)parentMap.get(instanceId);
        }
        ConfigurablePluginInstance configurablePluginInstance = this.pluginInstanceFactory.constructPluginInstance();
        configurablePluginInstance.setId(instanceId);
        DescribablePlugin pluginImpl = this.support.createInstance(implClassName, DescribablePlugin.class);
        if (pluginImpl != null) {
            configurablePluginInstance.setParentId(parentId);
            configurablePluginInstance.setDescriptor(pluginImpl.getPluginDescriptor());
            this.configSupport.loadConf(configurablePluginInstance);
            return configurablePluginInstance;
        }
        if (log.isErrorEnabled()) {
            log.error((Object)("Unable to load plugin instance: " + instanceId + " of type: " + implClassName));
        }
        return null;
    }

    public <T extends ConfigurablePluginInstance> T createInstanceFromConfigType(String instanceId, ConfigType configType, String parentId, String connectionId) {
        ConfigurablePluginInstance configurablePluginInstance = this.pluginInstanceFactory.constructPluginInstance();
        configurablePluginInstance.setId(instanceId);
        Map map = this.configStore.getMapValue(this.classMapKey, new HashMap());
        String implClassName = (String)map.get(parentId);
        DescribablePlugin pluginImpl = this.support.createInstance(implClassName, DescribablePlugin.class);
        if (pluginImpl != null) {
            configurablePluginInstance.setParentId(parentId);
            configurablePluginInstance.setConnectionId(connectionId);
            configurablePluginInstance.setDescriptor(pluginImpl.getPluginDescriptor());
            if (configType.isSetLastModified()) {
                configurablePluginInstance.setLastModified(configType.getLastModified());
            }
            this.configSupport.loadConnectionBasedConf(configurablePluginInstance, configType);
            return (T)configurablePluginInstance;
        }
        return null;
    }

    public void setPluginInstanceFactory(PluginInstanceFactory pluginInstanceFactory) {
        this.pluginInstanceFactory = pluginInstanceFactory;
    }

    public ConfigStore getConfigStore() {
        return this.configStore;
    }

    public PluginMgmtConfigSupport getConfigSupport() {
        return this.configSupport;
    }

    public Map<String, ConfigurablePluginInstance> getConnOverrideInstances(String connectionId) {
        Map<String, ConfigurablePluginInstance> map = this.getConnectionToConnBasedInstanceCache().get(connectionId);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public PluginManagementType getPluginManagementType() {
        return this.pluginManagementType;
    }

    public void setPluginManagementType(PluginManagementType pluginManagementType) {
        this.pluginManagementType = pluginManagementType;
    }

    public List<ConfigurablePluginInstance> getCBPOInstances(String instanceId) {
        Collection<Map<String, ConfigurablePluginInstance>> parentIdToCBPOInstanceMaps = this.getConnectionToConnBasedInstanceCache().values();
        ArrayList<ConfigurablePluginInstance> instances = new ArrayList<ConfigurablePluginInstance>();
        for (Map<String, ConfigurablePluginInstance> parentIdToCBPOInstanceMap : parentIdToCBPOInstanceMaps) {
            ConfigurablePluginInstance instance = parentIdToCBPOInstanceMap.get(instanceId);
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    private String getPluginMgmtTypeString() {
        return this.pluginManagementType == null ? "(null)" : this.pluginManagementType.toString();
    }

    public static interface PluginInstanceFactory {
        public ConfigurablePluginInstance constructPluginInstance();
    }

    public static enum PluginManagementType {
        IDP_ADAPTER,
        SP_ADAPTER,
        TOKEN_PROCESSOR,
        TOKEN_GENERATOR,
        ADAPTER_SELECTOR,
        IDENTITY_STORE_PROVISIONER,
        PCV,
        CLIENT_REGISTRATION,
        NOTIFICATION_SENDER,
        ACCESS_TOKEN_MANAGEMENT,
        OOB_AUTH_PLUGIN,
        SECRET_MANAGER,
        AUTHORIZATION_DETAIL_PROCESSOR,
        CAPTCHA_PROVIDER,
        NON_CONNECTION_BASED;

    }
}

