/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.impl.PluginConfigUtil;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.xmlbinding.adapterconf.AttributeHolderType;
import org.sourceid.saml20.xmlbinding.adapterconf.ConfigType;
import org.sourceid.saml20.xmlbinding.adapterconf.ExtendedAttributeAdditionalPropertyItemType;
import org.sourceid.saml20.xmlbinding.adapterconf.ExtendedAttributeAdditionalPropertyType;
import org.sourceid.saml20.xmlbinding.adapterconf.ExtendedContractAttributesType;
import org.sourceid.saml20.xmlbinding.adapterconf.PluginConfigurationDocument;

public class PluginMgmtConfigSupport {
    private static final String CONFIG_FILE_POSTFIX = ".xml";
    SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
    XmlLoader xmlLoader = GlobalRegistry.getService(XmlLoader.class);
    PluginConfigUtil configUtil = new PluginConfigUtil();
    private String configSubDirectory;

    public PluginMgmtConfigSupport(String configSubDirectory) {
        this.configSubDirectory = configSubDirectory;
    }

    public void deleteConf(ConfigurablePluginInstance pluginInstance) {
        this.xmlLoader.delete(this.getDir(), this.getFileName(pluginInstance));
    }

    String getFileName(ConfigurablePluginInstance pluginInstance) {
        StringBuilder sb = new StringBuilder();
        sb.append(pluginInstance.getId());
        sb.append(CONFIG_FILE_POSTFIX);
        return sb.toString();
    }

    String getDir() {
        StringBuffer sb = new StringBuffer(this.sysDirInfo.getDataDirectory());
        sb.append(File.separator);
        sb.append(this.configSubDirectory);
        return sb.toString();
    }

    public void saveConf(ConfigurablePluginInstance pluginInstance) {
        PluginConfigurationDocument document = PluginConfigurationDocument.Factory.newInstance();
        ConfigType configType = document.addNewPluginConfiguration();
        this.saveConf(pluginInstance, configType, (XmlObject)document);
    }

    public void fillInDoc(ConfigurablePluginInstance pluginInstance, ConfigType configType) {
        String name = pluginInstance.getName();
        Configuration configuration = pluginInstance.getConfiguration();
        GuiConfigDescriptor descriptor = pluginInstance.getGuiDescriptor();
        boolean isInheritingExtendedAttrs = pluginInstance.isInheritingExtendedContractAttributes();
        configType.setIsInheritExtendedContractAttributes(isInheritingExtendedAttrs);
        if (pluginInstance.getLastModified() != null) {
            configType.setLastModified(pluginInstance.getLastModified());
        }
        this.configUtil.fillConfigType(name, configuration, descriptor, configType);
        if (!isInheritingExtendedAttrs) {
            Set<String> multiValuedContractAttributes;
            Set<String> extendedAttrs = pluginInstance.getExtendedContractAttributes();
            if (extendedAttrs != null) {
                ExtendedContractAttributesType extendedContractAttrsType = configType.addNewExtendedContractAttributes();
                for (String attrName : extendedAttrs) {
                    extendedContractAttrsType.addAttributeName(attrName);
                }
            }
            if (configType.getExtendedAttributesAdditionalProperties() == null) {
                configType.setExtendedAttributesAdditionalProperties(configType.addNewExtendedAttributesAdditionalProperties());
            }
            if ((multiValuedContractAttributes = pluginInstance.getOwnMultiValuedContractAttributes()) != null) {
                int index = 0;
                ExtendedAttributeAdditionalPropertyItemType[] attributeItemArray = new ExtendedAttributeAdditionalPropertyItemType[multiValuedContractAttributes.size()];
                for (String attrName : multiValuedContractAttributes) {
                    ExtendedAttributeAdditionalPropertyItemType itemType = configType.getExtendedAttributesAdditionalProperties().addNewItem();
                    itemType.setKey(attrName);
                    AttributeHolderType value = itemType.addNewValue();
                    value.setMultiValued(true);
                    itemType.setValue(value);
                    attributeItemArray[index++] = itemType;
                }
                configType.getExtendedAttributesAdditionalProperties().setItemArray(attributeItemArray);
            }
        }
    }

    void saveConf(ConfigurablePluginInstance pluginInstance, ConfigType configType, XmlObject document) {
        this.fillInDoc(pluginInstance, configType);
        this.xmlLoader.save(this.getDir(), this.getFileName(pluginInstance), document);
    }

    Configuration toConfiguration(ConfigType configType, ConfigurablePluginInstance instance) {
        GuiConfigDescriptor guiDescriptor = instance.getGuiDescriptor();
        return this.configUtil.toConfiguration(instance, configType, guiDescriptor);
    }

    public void loadConf(ConfigurablePluginInstance pluginInstance) {
        pluginInstance.setConfiguration(new Configuration());
        String dir = this.getDir();
        String fileName = this.getFileName(pluginInstance);
        if (this.xmlLoader.xmlExists(dir, fileName)) {
            XmlObject document = this.xmlLoader.load(dir, fileName);
            ConfigType configType = this.constructConfigType(document, pluginInstance);
            this.loadConf(pluginInstance, configType);
        }
    }

    ConfigType constructConfigType(XmlObject document, ConfigurablePluginInstance pluginInstance) {
        PluginConfigurationDocument adapterConfigDoc = (PluginConfigurationDocument)document;
        return adapterConfigDoc.getPluginConfiguration();
    }

    ConfigType constructConfigType(ConfigType configType, ConfigurablePluginInstance pluginInstance) {
        return configType;
    }

    void loadConnectionBasedConf(ConfigurablePluginInstance pluginInstance, ConfigType configType) {
        configType = this.constructConfigType(configType, pluginInstance);
        this.loadConf(pluginInstance, configType);
    }

    void loadConf(ConfigurablePluginInstance pluginInstance, ConfigType configType) {
        Configuration configuration = this.toConfiguration(configType, pluginInstance);
        pluginInstance.setConfiguration(configuration);
        pluginInstance.setName(configType.getName());
        boolean isInheritingContract = configType.getIsInheritExtendedContractAttributes();
        pluginInstance.setInheritingExtendedContractAttributes(isInheritingContract);
        if (configType.isSetLastModified()) {
            pluginInstance.setLastModified(configType.getLastModified());
        }
        if (!isInheritingContract && configType.isSetExtendedContractAttributes()) {
            String[] attributeNameArray = configType.getExtendedContractAttributes().getAttributeNameArray();
            HashSet<String> additionalAttributeNames = new HashSet<String>(Arrays.asList(attributeNameArray));
            this.removeDuplicateExtendedAttributes(pluginInstance, additionalAttributeNames);
            configuration.setAdditionalAttrNames(additionalAttributeNames);
            pluginInstance.setExtendedContractAttributes(additionalAttributeNames);
            ExtendedAttributeAdditionalPropertyType attrAdditionalProps = configType.getExtendedAttributesAdditionalProperties();
            HashSet<String> multiValuedContractAttributes = new HashSet<String>();
            if (attrAdditionalProps != null) {
                ExtendedAttributeAdditionalPropertyItemType[] propItemArray = attrAdditionalProps.getItemArray();
                for (int index = 0; index < propItemArray.length; ++index) {
                    if (!propItemArray[index].getValue().getMultiValued()) continue;
                    multiValuedContractAttributes.add(propItemArray[index].getKey());
                }
            }
            configuration.setMultiValuedAttributes(multiValuedContractAttributes);
            pluginInstance.setMultiValuedContractAttributes(multiValuedContractAttributes);
        }
    }

    private void removeDuplicateExtendedAttributes(ConfigurablePluginInstance pluginInstance, Set<String> additionalAttributeNames) {
        Set coreContracts;
        PluginDescriptor pluginDescriptor = pluginInstance.getDescriptor();
        if (pluginDescriptor != null && (coreContracts = pluginDescriptor.getAttributeContractSet()) != null) {
            for (String coreContract : coreContracts) {
                if (!additionalAttributeNames.contains(coreContract)) continue;
                additionalAttributeNames.remove(coreContract);
            }
        }
    }

    public String toXml(ConfigurablePluginInstance pluginInstance) {
        String xml = "";
        if (pluginInstance != null) {
            PluginConfigurationDocument document = PluginConfigurationDocument.Factory.newInstance();
            ConfigType configType = document.addNewPluginConfiguration();
            this.fillInDoc(pluginInstance, configType);
            XmlOptions opts = XmlBeansUtil.getXmlOptions();
            opts.setSavePrettyPrint();
            xml = document.xmlText(opts);
        }
        return xml;
    }

    public ConfigurablePluginInstance parseXml(String xml, PluginManagementSupport.PluginInstanceFactory pluginInstanceFactory) throws XmlException {
        ConfigurablePluginInstance pluginInstance = pluginInstanceFactory.constructPluginInstance();
        this.parseXml(xml, pluginInstance);
        return pluginInstance;
    }

    public void parseXml(String xml, ConfigurablePluginInstance pluginInstance) {
        if (xml != null) {
            ByteArrayInputStream inStream;
            try {
                inStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            XmlObject document = this.xmlLoader.load(inStream);
            ConfigType configType = this.constructConfigType(document, pluginInstance);
            this.loadConf(pluginInstance, configType);
        }
    }
}

