/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.pingidentity.common.util.zip.UnzipUtil;
import com.pingidentity.configservice.Reloadable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.ReplicationArchive;
import org.sourceid.saml20.domain.ReplicationData;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProvider;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProviderManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.ReplicationStateManager;

public class ReplicationStateManagerImpl
implements ReplicationStateManager,
Reloadable {
    private static final Log log = LogFactory.getLog(ReplicationStateManagerImpl.class);
    private static final String REPLICATION_STATE_FILENAME = "replication-state.json";
    private static final String LICENSE_FILENAME = "published.lic";
    private static final String CORE_ARCHIVE_FILENAME = "core.data.zip";
    private static final String BASE_DELTA_ARCHIVE_FILENAME = "base.delta.zip";
    private static final String UNREPLICATED_CHANGES_FILENAME = "unreplicated-changes.json";
    private static final String DELTA_ARCHIVE_RETENTION_PERIOD_HOURS = "DeltaArchiveRetentionPeriodHours";
    private static final String DELTA_ARCHIVE_MERGE_CHECK_INTERVAL_HOURS = "DeltaArchiveMergeCheckIntervalHours";
    private static final String DELTA_ARCHIVE_MIN_DATA_TO_MERGE_KB = "DeltaArchiveMinDataToMergeKB";
    private ObjectMapper objectMapper;
    private ReplicationState replState;
    private ReplicationData replData;
    private boolean configProfileValidForReplication = false;
    private ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.domain.mgmt.impl.ReplicationStateManagerImpl");
    private Timer deltaArchiveMergeCheckTimer;
    private TimerTask deltaArchiveMergeCheckTask;
    private UnreplicatedChangesInfo unreplicatedChangesInfo;

    public ReplicationStateManagerImpl() {
        MgmtFactory.getMediator().registerForReloadEvents(this);
        this.scheduleDeltaArchiveMergeCheck();
        this.objectMapper = this.makeObjectMapper();
        this.createReplDirectoryIfNecessary();
        this.loadReplicationState();
        this.loadUnreplicatedInfo();
    }

    @Override
    public synchronized void reload() {
        this.scheduleDeltaArchiveMergeCheck();
    }

    protected synchronized void scheduleDeltaArchiveMergeCheck() {
        if (this.deltaArchiveMergeCheckTimer == null) {
            this.deltaArchiveMergeCheckTimer = new Timer("DeltaArchiveMergeChecker", true);
        }
        if (this.deltaArchiveMergeCheckTask != null) {
            this.deltaArchiveMergeCheckTask.cancel();
        }
        double mergeCheckIntervalHours = this.configStore.getDoubleValue(DELTA_ARCHIVE_MERGE_CHECK_INTERVAL_HOURS, 1.0);
        long mergeCheckIntervalMillis = (long)(mergeCheckIntervalHours * 60.0 * 60.0 * 1000.0);
        this.deltaArchiveMergeCheckTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ReplicationStateManagerImpl.this.checkMergeDeltaArchivesIntoBase();
                }
                catch (Throwable t) {
                    log.error((Object)"Error in thread responsible for merging delta archives into base", t);
                }
                finally {
                    ReplicationStateManagerImpl.this.scheduleDeltaArchiveMergeCheck();
                }
            }
        };
        log.debug((Object)("Scheduling delta archive merge check in " + mergeCheckIntervalMillis + " milliseconds"));
        this.deltaArchiveMergeCheckTimer.schedule(this.deltaArchiveMergeCheckTask, mergeCheckIntervalMillis);
    }

    @Override
    public synchronized void clearReplicationState() {
        log.debug((Object)"Clearing replication state");
        this.replData = null;
        this.configProfileValidForReplication = false;
        File replDir = new File(MgmtFactory.getSysDirInfo().getReplicationDirectory());
        if (replDir.exists()) {
            try {
                FileUtils.cleanDirectory((File)replDir);
            }
            catch (IOException e) {
                throw new ConfigurationException("Error cleaning directory " + replDir, e);
            }
        }
        this.loadReplicationState();
    }

    @Override
    public synchronized String getConfigProfileId() {
        return this.replState.getConfigProfileId();
    }

    @Override
    public synchronized Date getConfigTimestamp() {
        return this.replState.getConfigTimestamp();
    }

    @Override
    public synchronized Date getAutomaticConfigTimeStamp() {
        return this.replState.getAutomaticConfigTimeStamp();
    }

    @Override
    public synchronized Date getConfigSyncTimestamp() {
        return this.replState.getConfigSyncTimestamp();
    }

    @Override
    public synchronized String getConfigSyncProfileId() {
        return this.replState.getConfigSyncProfileId();
    }

    @Override
    public synchronized void saveConfigSyncProfileInfo(String id, Date timestamp) {
        this.replState.setConfigSyncProfileId(id);
        this.replState.setConfigSyncTimestamp(timestamp);
        this.saveReplicationState(false);
    }

    @Override
    public synchronized boolean hasValidReplicationData() {
        this.getReplicationData();
        return this.replData.getCoreArchive() != null && this.replData.getBaseDeltaArchive() != null && (this.replData.getLatestArchiveTimestamp().equals(this.replState.getConfigTimestamp()) || this.replData.getLatestArchiveTimestamp().equals(this.replState.getAutomaticConfigTimeStamp()));
    }

    @Override
    public synchronized ReplicationData getReplicationData() {
        if (this.replData == null) {
            this.loadReplicationData();
        }
        return this.replData;
    }

    @Override
    public synchronized ReplicationData getReplicationData(String configProfileId, Date startTime) {
        this.getReplicationData();
        ReplicationData dataToReturn = new ReplicationData(this.replData);
        if (!this.hasValidReplicationData()) {
            return dataToReturn;
        }
        if (dataToReturn.getConfigProfileId().equals(configProfileId)) {
            if (startTime != null && !startTime.before(dataToReturn.getBaseDeltaArchive().getTimestamp())) {
                dataToReturn.setBaseDeltaArchive(null);
            }
            ArrayList<ReplicationArchive> archivesToRemove = new ArrayList<ReplicationArchive>();
            for (ReplicationArchive deltaArchive : dataToReturn.getDeltaArchives()) {
                if (startTime == null || startTime.before(deltaArchive.getTimestamp())) continue;
                archivesToRemove.add(deltaArchive);
            }
            dataToReturn.getDeltaArchives().removeAll(archivesToRemove);
            ArrayList<ReplicationArchive> selectiveArchivesToRemove = new ArrayList<ReplicationArchive>();
            for (ReplicationArchive selectiveArchive : dataToReturn.getSelectiveArchives()) {
                if (startTime == null || startTime.before(selectiveArchive.getTimestamp())) continue;
                selectiveArchivesToRemove.add(selectiveArchive);
            }
            dataToReturn.getSelectiveArchives().removeAll(selectiveArchivesToRemove);
        }
        return dataToReturn;
    }

    @Override
    public synchronized void mergeReplicationData(ReplicationData dataToMerge) {
        this.getReplicationData();
        if (!dataToMerge.getConfigProfileId().equals(this.replState.getConfigProfileId()) && dataToMerge.getBaseDeltaArchive() == null) {
            log.debug((Object)"Incoming replication data has different config profile ID, but does not include base archive -- discarding");
            return;
        }
        if (dataToMerge.getLicense() != null) {
            try {
                log.debug((Object)"Updating saved license");
                Files.write(this.getPublishedLicenseFile().toPath(), dataToMerge.getLicense(), new OpenOption[0]);
                this.replData.setLicense(dataToMerge.getLicense());
            }
            catch (IOException e) {
                throw new ConfigurationException("Error writing to file " + this.getPublishedLicenseFile(), e);
            }
        }
        if (dataToMerge.getCoreArchive() != null) {
            this.saveCoreArchive(dataToMerge.getCoreArchive());
        }
        if (dataToMerge.getBaseDeltaArchive() != null) {
            this.deleteAllDeltaArchives();
            this.deleteAllSelectiveArchives();
            this.saveBaseDeltaArchive(dataToMerge.getBaseDeltaArchive());
        }
        for (ReplicationArchive delta : dataToMerge.getDeltaArchives()) {
            if (this.replData.getDeltaArchives().stream().anyMatch(archive -> archive.getTimestamp().equals(delta.getTimestamp()))) continue;
            this.saveDeltaArchive(delta);
        }
        for (ReplicationArchive selective : dataToMerge.getSelectiveArchives()) {
            if (!this.replData.getSelectiveArchives().stream().noneMatch(archive -> archive.getTimestamp().equals(selective.getTimestamp()))) continue;
            this.saveSelectiveArchive(selective);
        }
        this.replData.setConfigProfileId(dataToMerge.getConfigProfileId());
        this.replData.setConfigTimestamp(dataToMerge.getConfigTimestamp());
        this.replData.setAutomaticConfigTimeStamp(dataToMerge.getAutomaticConfigTimeStamp());
        this.updateReplStateFromReplData();
        this.saveReplicationState(true);
        this.setConfigProfileValidForReplication(true);
    }

    @Override
    public synchronized boolean isConfigProfileValidForReplication() {
        return this.configProfileValidForReplication;
    }

    @Override
    public synchronized void setConfigProfileValidForReplication(boolean configProfileValidForReplication) {
        log.debug((Object)("Setting flag to indicate local config profile is" + (configProfileValidForReplication ? " " : " not ") + "valid for replication"));
        this.configProfileValidForReplication = configProfileValidForReplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkMergeDeltaArchivesIntoBase() {
        Thread.currentThread().setPriority(3);
        try {
            log.debug((Object)"Checking for delta archives to be merged into base archive");
            ReplicationArchive baseDeltaArchive = null;
            ArrayList<ReplicationArchive> deltaArchivesToMerge = new ArrayList<ReplicationArchive>();
            ArrayList<ReplicationArchive> selectiveArchivesToMerge = new ArrayList<ReplicationArchive>();
            ReplicationStateManagerImpl replicationStateManagerImpl = this;
            synchronized (replicationStateManagerImpl) {
                this.getReplicationData();
                baseDeltaArchive = this.replData.getBaseDeltaArchive();
                long currentTime = this.getCurrentTimeMillis();
                for (ReplicationArchive archive2 : this.replData.getDeltaArchives()) {
                    if (archive2.getTimestamp().getTime() + this.getDeltaArchiveRetentionPeriodMillis() >= currentTime) continue;
                    deltaArchivesToMerge.add(archive2);
                }
                for (ReplicationArchive archive2 : this.replData.getSelectiveArchives()) {
                    if (archive2.getTimestamp().getTime() + this.getDeltaArchiveRetentionPeriodMillis() >= currentTime) continue;
                    selectiveArchivesToMerge.add(archive2);
                }
            }
            if (baseDeltaArchive == null) {
                return;
            }
            Optional<Integer> deltaTotalSize = deltaArchivesToMerge.stream().map(archive -> archive.getData().length).reduce(Integer::sum);
            Optional<Integer> selectiveTotalSize = selectiveArchivesToMerge.stream().map(archive -> archive.getData().length).reduce(Integer::sum);
            int totalSizeBytes = deltaTotalSize.orElse(0) + selectiveTotalSize.orElse(0);
            if ((long)totalSizeBytes < this.getDeltaArchiveMinDataToMergeBytes()) {
                log.debug((Object)("Total size of archives available to merge (" + totalSizeBytes + " bytes) is less than threshold, nothing will be merged"));
                return;
            }
            ArrayList<ReplicationArchive> allArchivesToMerge = new ArrayList<ReplicationArchive>();
            allArchivesToMerge.addAll(deltaArchivesToMerge);
            allArchivesToMerge.addAll(selectiveArchivesToMerge);
            byte[] newBase = ReplicationStateManagerImpl.mergeDeltaArchivesIntoBase(baseDeltaArchive, allArchivesToMerge);
            ReplicationStateManagerImpl replicationStateManagerImpl2 = this;
            synchronized (replicationStateManagerImpl2) {
                block19: {
                    this.getReplicationData();
                    if (baseDeltaArchive.equals(this.replData.getBaseDeltaArchive())) break block19;
                    log.debug((Object)"Base delta archive has changed, aborting merge of delta archives into base");
                    return;
                }
                Optional<Long> lastDeltaTimestamp = Stream.concat(deltaArchivesToMerge.stream(), selectiveArchivesToMerge.stream()).map(archive -> archive.getTimestamp().getTime()).reduce(Long::max);
                ReplicationArchive newBaseArchive = new ReplicationArchive(newBase, new Date(lastDeltaTimestamp.get()));
                this.saveBaseDeltaArchive(newBaseArchive);
                for (ReplicationArchive deltaArchive : deltaArchivesToMerge) {
                    this.deleteDeltaArchive(deltaArchive);
                }
                for (ReplicationArchive selectiveArchive : selectiveArchivesToMerge) {
                    this.deleteSelectiveArchive(selectiveArchive);
                }
                this.updateReplStateFromReplData();
                this.saveReplicationState(true);
            }
        }
        finally {
            Thread.currentThread().setPriority(5);
        }
    }

    protected synchronized void reloadCachedData() {
        this.replData = null;
        this.loadReplicationState();
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public void addUnreplicatedData(String type, String newName, String newId) {
        this.addUnreplicatedData(type, null, null, newName, newId);
    }

    @Override
    public void addUnreplicatedData(String type, String oldName, String oldId, String newName, String newId) {
        UnpreplicatedChange newChange = new UnpreplicatedChange(type, oldName, oldId, newName, newId);
        this.unreplicatedChangesInfo.addUnreplicatedChange(newChange);
        this.saveUnreplicatedInfo();
    }

    @Override
    public List<UnpreplicatedChange> getUnreplicatedData() {
        return Collections.unmodifiableList(this.unreplicatedChangesInfo.getUnreplicatedChanges());
    }

    @Override
    public void clearUnreplicatedData() {
        this.unreplicatedChangesInfo = new UnreplicatedChangesInfo();
        this.saveUnreplicatedInfo();
    }

    private static byte[] mergeDeltaArchivesIntoBase(ReplicationArchive baseArchive, List<ReplicationArchive> deltaArchives) {
        try {
            Object key;
            DeltaReplicationProviderManager replProviderManager = MgmtFactory.getDeltaReplicationProviderManager();
            if (log.isDebugEnabled()) {
                List timestamps = deltaArchives.stream().map(archive -> archive.getTimestamp().toString()).collect(Collectors.toList());
                String timestampsStr = StringUtils.join(timestamps, (String)",");
                log.debug((Object)("Merging delta archives with timestamps [" + timestampsStr + "] into base archive"));
            }
            HashMap<Object, byte[]> aggregateDelta = new HashMap<Object, byte[]>();
            HashMap<Object, byte[]> unmergedPartialEntries = new HashMap<Object, byte[]>();
            for (ReplicationArchive deltaArchive : deltaArchives) {
                Map<String, byte[]> deltaArchiveMap = UnzipUtil.unzip(new ByteArrayInputStream(deltaArchive.getData()));
                for (Map.Entry<String, byte[]> entry : deltaArchiveMap.entrySet()) {
                    key = entry.getKey();
                    byte[] value = entry.getValue();
                    DeltaReplicationProvider provider = replProviderManager.getReplicationProviderByPartialEntryId((String)key);
                    if (provider != null) {
                        String id = provider.extractIdFromEntryId((String)key);
                        key = provider.getManagedDirectoryName() + "/" + id;
                        byte[] existingConnection = (byte[])aggregateDelta.get(key);
                        if (existingConnection != null) {
                            value = provider.mergePartialEntry(value, existingConnection);
                            aggregateDelta.put(key, value);
                            continue;
                        }
                        unmergedPartialEntries.put(key, value);
                        continue;
                    }
                    unmergedPartialEntries.remove(key);
                    aggregateDelta.put(key, value);
                }
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try (ZipOutputStream outStream = new ZipOutputStream(result);){
                try (ZipInputStream inStream = new ZipInputStream(new ByteArrayInputStream(baseArchive.getData()));){
                    ZipEntry entry = null;
                    while ((entry = inStream.getNextEntry()) != null) {
                        byte[] data = IOUtils.toByteArray((InputStream)inStream);
                        if (unmergedPartialEntries.containsKey(entry.getName()) && !aggregateDelta.containsKey(entry.getName())) {
                            key = entry.getName();
                            DeltaReplicationProvider provider = replProviderManager.getReplicationProviderByEntryId((String)key);
                            if (provider != null) {
                                byte[] partialEntry = (byte[])unmergedPartialEntries.remove(key);
                                data = provider.mergePartialEntry(partialEntry, data);
                            }
                        } else if (aggregateDelta.containsKey(entry.getName())) {
                            data = (byte[])aggregateDelta.remove(entry.getName());
                        }
                        if (data.length <= 0) continue;
                        outStream.putNextEntry(new ZipEntry(entry.getName()));
                        outStream.write(data);
                    }
                }
                for (Map.Entry remaining : aggregateDelta.entrySet()) {
                    if (((byte[])remaining.getValue()).length <= 0) continue;
                    outStream.putNextEntry(new ZipEntry((String)remaining.getKey()));
                    outStream.write((byte[])remaining.getValue());
                }
            }
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new ConfigurationException("Unexpected error merging delta archives into base", e);
        }
    }

    private void updateReplStateFromReplData() {
        this.replState.setConfigProfileId(this.replData.getConfigProfileId());
        this.replState.setConfigTimestamp(this.replData.getConfigTimestamp());
        this.replState.setAutomaticConfigTimeStamp(this.replData.getAutomaticConfigTimeStamp());
        this.replState.setCoreArchiveInfo(null);
        if (this.replData.getCoreArchive() != null) {
            this.replState.setCoreArchiveInfo(new ArchiveInfo(CORE_ARCHIVE_FILENAME, this.replData.getCoreArchive().getTimestamp()));
        }
        this.replState.setBaseArchiveInfo(null);
        if (this.replData.getBaseDeltaArchive() != null) {
            this.replState.setBaseArchiveInfo(new ArchiveInfo(BASE_DELTA_ARCHIVE_FILENAME, this.replData.getBaseDeltaArchive().getTimestamp()));
        }
        this.replState.getDeltaArchiveInfos().clear();
        for (ReplicationArchive archive : this.replData.getDeltaArchives()) {
            this.replState.getDeltaArchiveInfos().add(this.infoFromReplArchive(archive));
        }
        this.replState.getSelectiveArchiveInfos().clear();
        for (ReplicationArchive archive : this.replData.getSelectiveArchives()) {
            this.replState.getSelectiveArchiveInfos().add(new ArchiveInfo(this.makeSelectiveArchiveName(archive), archive.getTimestamp(), false, true));
        }
    }

    private void loadReplicationData() {
        ReplicationData data = new ReplicationData(this.replState.getConfigProfileId(), this.replState.getConfigTimestamp());
        data.setAutomaticConfigTimeStamp(this.replState.getAutomaticConfigTimeStamp());
        try {
            ArchiveInfo baseInfo;
            ArchiveInfo coreInfo = this.replState.getCoreArchiveInfo();
            if (coreInfo != null) {
                ReplicationArchive coreArchive = this.replArchiveFromInfo(coreInfo);
                data.setCoreArchive(coreArchive);
            }
            if ((baseInfo = this.replState.getBaseArchiveInfo()) != null) {
                ReplicationArchive baseArchive = this.replArchiveFromInfo(baseInfo);
                data.setBaseDeltaArchive(baseArchive);
            }
            for (ArchiveInfo deltaInfo : this.replState.getDeltaArchiveInfos()) {
                ReplicationArchive deltaArchive = this.replArchiveFromInfo(deltaInfo);
                data.getDeltaArchives().add(deltaArchive);
            }
            for (ArchiveInfo selectiveInfo : this.replState.getSelectiveArchiveInfos()) {
                ReplicationArchive selectiveArchive = this.replArchiveFromInfo(selectiveInfo);
                data.getSelectiveArchives().add(selectiveArchive);
            }
        }
        catch (ReplicationStateException e) {
            log.error((Object)"Error loading replication data", (Throwable)e);
            this.replState.clearArchiveInfos();
            this.saveReplicationState(true);
            data = new ReplicationData(this.replState.getConfigProfileId(), this.replState.getConfigTimestamp());
        }
        File licenseFile = this.getPublishedLicenseFile();
        if (licenseFile.exists()) {
            try {
                byte[] licenseBytes = Files.readAllBytes(licenseFile.toPath());
                data.setLicense(licenseBytes);
            }
            catch (IOException e) {
                log.error((Object)("Error reading file " + licenseFile), (Throwable)e);
            }
        }
        this.replData = data;
    }

    private ReplicationArchive replArchiveFromInfo(ArchiveInfo info) throws ReplicationStateException {
        File file = new File(this.getAbsolutePath(info.getFileName()));
        if (!file.exists()) {
            throw new ReplicationStateException("Archive not found: " + info.getFileName());
        }
        try {
            log.debug((Object)("Loading replication archive " + info.getFileName()));
            byte[] data = Files.readAllBytes(file.toPath());
            return new ReplicationArchive(data, info.getTimestamp(), info.isPartial());
        }
        catch (IOException e) {
            throw new ReplicationStateException("Error reading file " + file, e);
        }
    }

    private ArchiveInfo infoFromReplArchive(ReplicationArchive archive) {
        return new ArchiveInfo(this.makeDeltaArchiveName(archive), archive.getTimestamp(), archive.isPartial(), archive.isSelective());
    }

    private void saveCoreArchive(ReplicationArchive archive) {
        this.saveArchive(archive, CORE_ARCHIVE_FILENAME);
        this.replData.setCoreArchive(archive);
    }

    private void saveDeltaArchive(ReplicationArchive archive) {
        this.saveArchive(archive, this.makeDeltaArchiveName(archive));
        this.replData.getDeltaArchives().add(archive);
        this.replData.getDeltaArchives().sort(Comparator.comparing(ReplicationArchive::getTimestamp));
    }

    private void saveSelectiveArchive(ReplicationArchive archive) {
        this.saveArchive(archive, this.makeSelectiveArchiveName(archive));
        this.replData.getSelectiveArchives().add(archive);
        this.replData.getSelectiveArchives().sort(Comparator.comparing(ReplicationArchive::getTimestamp));
    }

    private void saveBaseDeltaArchive(ReplicationArchive archive) {
        this.saveArchive(archive, BASE_DELTA_ARCHIVE_FILENAME);
        this.replData.setBaseDeltaArchive(archive);
    }

    private void saveArchive(ReplicationArchive archive, String filename) {
        File file = new File(this.getAbsolutePath(filename));
        try {
            log.debug((Object)("Saving archive " + file));
            Files.write(file.toPath(), archive.getData(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing file " + file, e);
        }
    }

    private String makeDeltaArchiveName(ReplicationArchive archive) {
        return this.makeArchiveName(archive, "delta");
    }

    private String makeSelectiveArchiveName(ReplicationArchive archive) {
        return this.makeArchiveName(archive, "selective");
    }

    private String makeArchiveName(ReplicationArchive archive, String prefix) {
        String formatPattern = "MM-dd-yyyy.HH.mm.ss.SSS";
        SimpleDateFormat format = new SimpleDateFormat(formatPattern);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return prefix + "-" + format.format(archive.getTimestamp()) + ".zip";
    }

    private void deleteAllDeltaArchives() {
        log.debug((Object)"Deleting all delta archives");
        File baseDeltaArchive = new File(this.getAbsolutePath(BASE_DELTA_ARCHIVE_FILENAME));
        if (baseDeltaArchive.exists() && !baseDeltaArchive.delete()) {
            throw new ConfigurationException("Failed to delete file " + baseDeltaArchive);
        }
        this.replData.setBaseDeltaArchive(null);
        for (File file : FileUtils.listFiles((File)new File(MgmtFactory.getSysDirInfo().getReplicationDirectory()), (IOFileFilter)new WildcardFileFilter("delta-*.zip"), null)) {
            if (file.delete()) continue;
            throw new ConfigurationException("Failed to delete file " + file);
        }
        this.replData.getDeltaArchives().clear();
    }

    private void deleteDeltaArchive(ReplicationArchive archive) {
        File file = new File(this.getAbsolutePath(this.makeDeltaArchiveName(archive)));
        if (file.exists() && !file.delete()) {
            throw new ConfigurationException("Failed to delete file " + file);
        }
        this.replData.getDeltaArchives().remove(archive);
    }

    private void deleteAllSelectiveArchives() {
        log.debug((Object)"Deleting all selective archives");
        for (File file : FileUtils.listFiles((File)new File(MgmtFactory.getSysDirInfo().getReplicationDirectory()), (IOFileFilter)new WildcardFileFilter("selective-*.zip"), null)) {
            if (file.delete()) continue;
            throw new ConfigurationException("Failed to delete file " + file);
        }
        this.replData.getSelectiveArchives().clear();
    }

    private void deleteSelectiveArchive(ReplicationArchive archive) {
        File file = new File(this.getAbsolutePath(this.makeSelectiveArchiveName(archive)));
        if (file.exists() && !file.delete()) {
            throw new ConfigurationException("Failed to delete file " + file);
        }
        this.replData.getSelectiveArchives().remove(archive);
    }

    private void createReplDirectoryIfNecessary() {
        File replDir = new File(MgmtFactory.getSysDirInfo().getReplicationDirectory());
        if (!replDir.exists() && !replDir.mkdirs()) {
            throw new ConfigurationException("Failed to create directory " + replDir);
        }
    }

    private void loadReplicationState() {
        this.replState = new ReplicationState();
        File replStateFile = this.getReplStateFile();
        if (replStateFile.exists()) {
            try {
                this.replState = (ReplicationState)this.objectMapper.readValue(replStateFile, ReplicationState.class);
            }
            catch (IOException e) {
                log.error((Object)("Error loading file " + replStateFile), (Throwable)e);
            }
        }
    }

    private void saveReplicationState(boolean logAtDebugLevel) {
        String message = "Saving replication state, configProfileId=" + this.replState.getConfigProfileId() + ", configTimestamp=" + this.replState.getConfigTimestamp() + ", configSyncProfileId=" + this.replState.getConfigSyncProfileId() + ", configSyncTimestamp=" + this.replState.getConfigSyncTimestamp();
        if (logAtDebugLevel) {
            log.debug((Object)message);
        } else {
            log.trace((Object)message);
        }
        File replStateFile = this.getReplStateFile();
        try {
            this.objectMapper.writeValue(replStateFile, (Object)this.replState);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error saving file " + replStateFile, e);
        }
    }

    private void loadUnreplicatedInfo() {
        this.unreplicatedChangesInfo = new UnreplicatedChangesInfo();
        File unreplicatedChangesFile = this.getUnreplicatedChangesFile();
        if (unreplicatedChangesFile.exists()) {
            try {
                this.unreplicatedChangesInfo = (UnreplicatedChangesInfo)this.objectMapper.readValue(unreplicatedChangesFile, UnreplicatedChangesInfo.class);
            }
            catch (IOException e) {
                log.error((Object)("Error loading file " + unreplicatedChangesFile), (Throwable)e);
            }
        }
    }

    private void saveUnreplicatedInfo() {
        File unreplicatedChangesFile = this.getUnreplicatedChangesFile();
        try {
            this.objectMapper.writeValue(unreplicatedChangesFile, (Object)this.unreplicatedChangesInfo);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error saving file " + unreplicatedChangesFile, e);
        }
    }

    private File getPublishedLicenseFile() {
        return new File(this.getAbsolutePath(LICENSE_FILENAME));
    }

    private File getReplStateFile() {
        return new File(this.getAbsolutePath(REPLICATION_STATE_FILENAME));
    }

    private File getUnreplicatedChangesFile() {
        return new File(this.getAbsolutePath(UNREPLICATED_CHANGES_FILENAME));
    }

    private ObjectMapper makeObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return mapper;
    }

    protected long getDeltaArchiveRetentionPeriodMillis() {
        double hours = this.configStore.getDoubleValue(DELTA_ARCHIVE_RETENTION_PERIOD_HOURS, 168.0);
        return (long)(hours * 60.0 * 60.0 * 1000.0);
    }

    protected long getDeltaArchiveMinDataToMergeBytes() {
        return this.configStore.getLongValue(DELTA_ARCHIVE_MIN_DATA_TO_MERGE_KB, 100L) * 1024L;
    }

    private String getAbsolutePath(String filename) {
        return new File(MgmtFactory.getSysDirInfo().getReplicationDirectory(), filename).getAbsolutePath();
    }

    protected static class ReplicationStateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ReplicationStateException() {
        }

        public ReplicationStateException(String message) {
            super(message);
        }

        public ReplicationStateException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class UnpreplicatedChange {
        private String type;
        private String oldName;
        private String oldId;
        private String newName;
        private String newId;
        private Date timestamp;

        public UnpreplicatedChange(String type, String oldName, String oldId, String newName, String newId) {
            this.type = type;
            this.oldName = oldName;
            this.oldId = oldId;
            this.newName = newName;
            this.newId = newId;
            this.timestamp = new Date();
        }

        public String getOldName() {
            return this.oldName;
        }

        public void setOldName(String oldName) {
            this.oldName = oldName;
        }

        public String getOldId() {
            return this.oldId;
        }

        public void setOldId(String oldId) {
            this.oldId = oldId;
        }

        public String getNewName() {
            return this.newName;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public String getNewId() {
            return this.newId;
        }

        public void setNewId(String newId) {
            this.newId = newId;
        }

        public Date getTimestamp() {
            if (this.timestamp == null) {
                return null;
            }
            return new Date(this.timestamp.getTime());
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp == null ? null : new Date(timestamp.getTime());
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    protected static class UnreplicatedChangesInfo {
        private List<UnpreplicatedChange> unreplicatedChanges = new ArrayList<UnpreplicatedChange>();

        public List<UnpreplicatedChange> getUnreplicatedChanges() {
            return this.unreplicatedChanges;
        }

        public void setUnreplicatedChanges(List<UnpreplicatedChange> unreplicatedChanges) {
            this.unreplicatedChanges = unreplicatedChanges;
        }

        public void addUnreplicatedChange(UnpreplicatedChange newChange) {
            this.unreplicatedChanges.add(newChange);
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    protected static class ArchiveInfo {
        private String fileName;
        private Date timestamp;
        private boolean partial;
        private boolean selective;

        public ArchiveInfo() {
        }

        public ArchiveInfo(String fileName, Date timestamp) {
            this(fileName, timestamp, false, false);
        }

        public ArchiveInfo(String fileName, Date timestamp, boolean partial, boolean selective) {
            this.fileName = fileName;
            this.timestamp = timestamp;
            this.partial = partial;
            this.selective = selective;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public Date getTimestamp() {
            if (this.timestamp == null) {
                return null;
            }
            return new Date(this.timestamp.getTime());
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp == null ? null : new Date(timestamp.getTime());
        }

        public boolean isPartial() {
            return this.partial;
        }

        public void setPartial(boolean partial) {
            this.partial = partial;
        }

        public boolean isSelective() {
            return this.selective;
        }

        public void setSelective(boolean selective) {
            this.selective = selective;
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    protected static class ReplicationState {
        private String configProfileId;
        private Date configTimestamp;
        private Date automaticConfigTimeStamp;
        private String configSyncProfileId;
        private Date configSyncTimestamp;
        private ArchiveInfo coreArchiveInfo;
        private ArchiveInfo baseArchiveInfo;
        private List<ArchiveInfo> deltaArchiveInfos = new ArrayList<ArchiveInfo>();
        private List<ArchiveInfo> selectiveArchiveInfos = new ArrayList<ArchiveInfo>();

        public String getConfigProfileId() {
            if (this.configProfileId == null) {
                this.configProfileId = IDGenerator.rndAlphaNumeric(25);
            }
            return this.configProfileId;
        }

        public void setConfigProfileId(String id) {
            this.configProfileId = id;
        }

        public Date getConfigTimestamp() {
            return this.configTimestamp;
        }

        public void setConfigTimestamp(Date configTimestamp) {
            this.configTimestamp = configTimestamp;
        }

        public Date getAutomaticConfigTimeStamp() {
            return this.automaticConfigTimeStamp;
        }

        public void setAutomaticConfigTimeStamp(Date automaticConfigTimeStamp) {
            this.automaticConfigTimeStamp = automaticConfigTimeStamp;
        }

        public Date getConfigSyncTimestamp() {
            return this.configSyncTimestamp;
        }

        public void setConfigSyncTimestamp(Date configSyncTimestamp) {
            this.configSyncTimestamp = configSyncTimestamp;
        }

        public String getConfigSyncProfileId() {
            if (this.configSyncProfileId == null) {
                this.configSyncProfileId = IDGenerator.rndAlphaNumeric(25);
            }
            return this.configSyncProfileId;
        }

        public void setConfigSyncProfileId(String id) {
            this.configSyncProfileId = id;
        }

        public ArchiveInfo getCoreArchiveInfo() {
            return this.coreArchiveInfo;
        }

        public void setCoreArchiveInfo(ArchiveInfo coreArchiveInfo) {
            this.coreArchiveInfo = coreArchiveInfo;
        }

        public ArchiveInfo getBaseArchiveInfo() {
            return this.baseArchiveInfo;
        }

        public void setBaseArchiveInfo(ArchiveInfo baseArchiveInfo) {
            this.baseArchiveInfo = baseArchiveInfo;
        }

        public List<ArchiveInfo> getDeltaArchiveInfos() {
            return this.deltaArchiveInfos;
        }

        public void setDeltaArchiveInfos(List<ArchiveInfo> infos) {
            this.deltaArchiveInfos = infos;
        }

        public List<ArchiveInfo> getSelectiveArchiveInfos() {
            return this.selectiveArchiveInfos;
        }

        public void setSelectiveArchiveInfos(List<ArchiveInfo> infos) {
            this.selectiveArchiveInfos = infos;
        }

        public void clearArchiveInfos() {
            this.coreArchiveInfo = null;
            this.baseArchiveInfo = null;
            this.deltaArchiveInfos = new ArrayList<ArchiveInfo>();
            this.selectiveArchiveInfos = new ArrayList<ArchiveInfo>();
        }
    }
}

