/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.crypto.OCSPCheckerSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.RevocationSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.RevocationManager;

public class RevocationManagerImpl
implements RevocationManager,
AutoReloadable {
    private static final String CONFIG = "revocation-checking-config";
    ConfigStore config = ConfigStoreFarm.getConfig("revocation-checking-config");
    private static final String CONFIG_NOT_FOUND = "The configuration for 'revocation-checking-config' cannot be found.  Unable to load the CRL and OCSP information into the Administration UI.";
    private static final Log log = LogFactory.getLog(RevocationManagerImpl.class);

    @Override
    public synchronized void saveRevocationSettings(RevocationSettings settings) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.save(settings);
            auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE_REVOCATION, AdminAuditLogger.Event.MODIFY);
        }
    }

    private synchronized void save(RevocationSettings settings) {
        if (this.config != null) {
            this.config.setBooleanValue("OCSP-enable", settings.isOcspEnabled());
            this.config.setBooleanValue("OCSP-requester-add-nonce", settings.isOcspRequesterAddNonce());
            this.config.setStringValue("OCSP-responder-URL", settings.getOcspResponderUrl());
            if (settings.getOcspResponderCertAlias() != null) {
                this.config.setStringValue("OCSP-responder-cert-alias", settings.getOcspResponderCertAlias());
            }
            if (settings.getOcspActionOnResponderUnavailable() != null) {
                this.config.setStringValue("OCSP-action-on-responder-unavailable", settings.getOcspActionOnResponderUnavailable());
            }
            if (settings.getOcspActionOnStatusUnknown() != null) {
                this.config.setStringValue("OCSP-action-on-status-unknown", settings.getOcspActionOnStatusUnknown());
            }
            if (settings.getOcspActionOnUnsuccessfulResponse() != null) {
                this.config.setStringValue("OCSP-action-on-unsuccessful-response", settings.getOcspActionOnUnsuccessfulResponse());
            }
            if (settings.getOcspThisUpdateGracePeriod() != null) {
                this.config.setStringValue("OCSP-thisupdate-grace-period", settings.getOcspThisUpdateGracePeriod());
            }
            if (settings.getOcspNextUpdateGracePeriod() != null) {
                this.config.setStringValue("OCSP-nextupdate-grace-period", settings.getOcspNextUpdateGracePeriod());
            }
            if (settings.getOcspResponseCachePeriod() != null) {
                this.config.setStringValue("OCSP-response-cache-period", settings.getOcspResponseCachePeriod());
            }
            if (settings.getOcspConnectionTimeoutSecs() != null) {
                this.config.setStringValue("OCSP-connection-timeout-secs", settings.getOcspConnectionTimeoutSecs());
            }
            this.config.setBooleanValue("crl-enable", settings.isCrlEnabled());
            this.config.setBooleanValue("treat-non-retrievable-crl-as-revoked", settings.isTreatNonRetrievableCrlAsRevoked());
            if (settings.getNextRetryMinsWhenResolveFailed() != null) {
                this.config.setStringValue("next-retry-minutes-when-resolve-failed", settings.getNextRetryMinsWhenResolveFailed());
            }
            if (settings.getNextRetryMinsWhenNextUpdateInPast() != null) {
                this.config.setStringValue("next-retry-minutes-when-next-update-is-in-the-past", settings.getNextRetryMinsWhenNextUpdateInPast());
            }
            this.config.setBooleanValue("verify-crl-signature", settings.isVerifyCrlSignature());
            if (settings.getProxyHost() != null) {
                this.config.setStringValue("proxy-host", settings.getProxyHost());
            }
            if (settings.getProxyPort() != null) {
                this.config.setStringValue("proxy-port", settings.getProxyPort());
            }
        } else {
            log.error((Object)CONFIG_NOT_FOUND);
        }
    }

    @Override
    public synchronized RevocationSettings getRevocationSettings() {
        if (this.config != null) {
            RevocationSettings settings = new RevocationSettings();
            settings.setOcspEnabled(this.config.getBooleanValue("OCSP-enable", false));
            settings.setOcspResponderUrl(this.config.getStringValue("OCSP-responder-URL", null));
            settings.setOcspResponderCertAlias(this.config.getStringValue("OCSP-responder-cert-alias", ""));
            settings.setOcspThisUpdateGracePeriod(this.config.getStringValue("OCSP-thisupdate-grace-period", "5"));
            settings.setOcspNextUpdateGracePeriod(this.config.getStringValue("OCSP-nextupdate-grace-period", "5"));
            settings.setOcspConnectionTimeoutSecs(this.config.getStringValue("OCSP-connection-timeout-secs", "5"));
            settings.setOcspResponseCachePeriod(this.config.getStringValue("OCSP-response-cache-period", "48"));
            settings.setOcspActionOnStatusUnknown(this.config.getStringValue("OCSP-action-on-status-unknown", OCSPCheckerSupport.ACTION.FAIL.toString()));
            settings.setOcspActionOnUnsuccessfulResponse(this.config.getStringValue("OCSP-action-on-unsuccessful-response", OCSPCheckerSupport.ACTION.FAIL.toString()));
            settings.setOcspActionOnResponderUnavailable(this.config.getStringValue("OCSP-action-on-responder-unavailable", OCSPCheckerSupport.ACTION.CONTINUE.toString()));
            settings.setOcspRequesterAddNonce(this.config.getBooleanValue("OCSP-requester-add-nonce", false));
            settings.setCrlEnabled(this.config.getBooleanValue("crl-enable", true));
            settings.setTreatNonRetrievableCrlAsRevoked(this.config.getBooleanValue("treat-non-retrievable-crl-as-revoked", true));
            settings.setNextRetryMinsWhenResolveFailed(this.config.getStringValue("next-retry-minutes-when-resolve-failed", "1440"));
            settings.setNextRetryMinsWhenNextUpdateInPast(this.config.getStringValue("next-retry-minutes-when-next-update-is-in-the-past", "60"));
            settings.setVerifyCrlSignature(this.config.getBooleanValue("verify-crl-signature", true));
            settings.setProxyHost(this.config.getStringValue("proxy-host", ""));
            settings.setProxyPort(this.config.getStringValue("proxy-port", "0"));
            return settings;
        }
        log.error((Object)CONFIG_NOT_FOUND);
        return null;
    }
}

