/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.secretmanager.SecretManager;
import java.util.Collection;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SecretManagerInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.SecretManagerPluginManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class SecretManagerPluginManagerImpl
implements SecretManagerPluginManager,
AutoReloadable {
    public static final String BASE_NAME = "secret-managers";
    private final PluginManagementSupport pluginMgmtSupport = new PluginManagementSupport("secret-managers", AdminAuditLogger.Component.SECRET_MANAGER);

    public SecretManagerPluginManagerImpl(Mediator mediator) {
        this.pluginMgmtSupport.setPluginInstanceFactory(this::newInstance);
    }

    @Override
    public SecretManager getSecretManager(String instanceId) {
        return (SecretManager)this.pluginMgmtSupport.getPlugin(instanceId);
    }

    public void finishInit() {
        this.pluginMgmtSupport.loadInstanceCaches();
        this.pluginMgmtSupport.earlyLoadConfigurations();
    }

    @Override
    public Collection<PluginDescriptor> getInstalledDescriptors() {
        return this.pluginMgmtSupport.getInstalledPluginDescriptors();
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.pluginMgmtSupport.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<SecretManagerInstance> getInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getPluginInstances();
        return instances;
    }

    @Override
    public SecretManagerInstance getInstance(String instanceId) {
        return (SecretManagerInstance)this.pluginMgmtSupport.getPluginInstance(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        SecretManagerInstance savingInstance = (SecretManagerInstance)instance;
        this.pluginMgmtSupport.savePluginInstance(savingInstance);
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.deletePluginInstance(instance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.isPluginInUseInternally(pluginId) || this.isPluginInUseExternally(pluginId);
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        return this.getInstances().stream().anyMatch(instance -> instance.getParentId() != null && instance.getParentId().equals(pluginId));
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        return !InUseDetectionUtil.getInstance().getDataSourceInstancesUsingResource(PluginManagementSupport.PluginManagementType.SECRET_MANAGER, pluginId).isEmpty();
    }

    @Override
    public SecretManagerInstance newInstance() {
        return new SecretManagerInstance();
    }

    @Override
    public void loadConfigurations() {
        this.pluginMgmtSupport.loadConfigurations();
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return true;
    }

    @Override
    public boolean supportsDefaultInstance() {
        return false;
    }

    @Override
    public SecretManagerInstance getDefaultInstance() {
        return null;
    }

    @Override
    public Collection<SecretManagerInstance> getVirtualInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getVirtualPlugins();
        return instances;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
    }
}

