/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.sdk.secretmanager.SecretInfo;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.SecretManagerPluginManager;

public class SecretReferenceHelper {
    private static final Log log = LogFactory.getLog(SecretReferenceHelper.class);
    private static final SecretManagerPluginManager secretManager = MgmtFactory.getSecretManagerPluginManager();
    private final String secretManagerId;
    private final String secretId;

    public SecretReferenceHelper(String secretReference) {
        String secretManagerId = SecretReferenceUtil.getSecretManagerId((String)secretReference);
        if (StringUtils.isBlank((String)secretManagerId)) {
            throw new IllegalArgumentException("Unable to parse secret reference.");
        }
        if (secretManager.getSecretManager(secretManagerId) == null) {
            throw new IllegalArgumentException("Invalid Secret Manager Id: " + secretManagerId);
        }
        this.secretManagerId = secretManagerId;
        this.secretId = SecretReferenceUtil.getSecretId((String)secretReference);
    }

    public Credentials getSecretInfo(String username) throws SecretManagerException {
        return this.getSecretInfo(username, new HashMap<String, Object>());
    }

    public Credentials getSecretInfo(String username, Map<String, Object> inParams) throws SecretManagerException {
        String updatedUsername;
        SecretInfo secretInfo;
        HashMap<String, Object> inParamsForCall = new HashMap<String, Object>(inParams);
        if (username != null) {
            inParamsForCall.put("Username", username);
        }
        try {
            secretInfo = secretManager.getSecretManager(this.secretManagerId).getSecretInfo(this.secretId, inParamsForCall);
            AttributeValue usernameAttribute = (AttributeValue)secretInfo.getAttributes().get((Object)"Username");
            String string = updatedUsername = usernameAttribute == null ? null : usernameAttribute.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Obtained credentials from secret manager: " + this.secretManagerId + "; Attributes: " + secretInfo.getAttributes().keySet()));
            }
        }
        catch (SecretManagerException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Problem getting secret " + this.secretId + " from secret manager: " + this.secretManagerId), (Throwable)e);
            }
            throw e;
        }
        if (StringUtils.isBlank((String)updatedUsername)) {
            return new Credentials(username, secretInfo.getSecret());
        }
        return new Credentials(updatedUsername, secretInfo.getSecret());
    }

    public static class Credentials {
        private final String username;
        private final String secret;

        public Credentials(String username, String secret) {
            this.username = username;
            this.secret = secret;
        }

        public String getUsername() {
            return this.username;
        }

        public String getSecret() {
            return this.secret;
        }
    }
}

