/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.ConfigEventListener;
import com.pingidentity.configservice.Reloadable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.AuthnAdapterDescriptor;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.domain.Searchable;
import org.sourceid.util.domain.filter.ContainsCriteriaFilter;
import org.sourceid.util.domain.filter.ItemMultiValue;

public class SpAdapterManagerImpl
implements SpAdapterManager,
AutoReloadable {
    private static final Comparator<AuthnAdapterInstance> COMPARE_BY_NAME_DOWN = (adapter1, adapter2) -> adapter1.getName().compareToIgnoreCase(adapter2.getName());
    AdapterManager adapterMgr = MgmtFactory.getAdapterManager();

    @Override
    public Collection<AuthnAdapterDescriptor> getInstalledDescriptors() {
        return this.adapterMgr.getInstalledSpAuthnAdapterDescriptors();
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.adapterMgr.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<AuthnAdapterInstance> getInstances() {
        return this.adapterMgr.getSpAuthnAdapterInstances();
    }

    @Override
    public Collection<AuthnAdapterInstance> getNonConnectionBasedInstances() {
        return this.adapterMgr.getSpAuthnAdapterNonConnectionBasedInstances();
    }

    @Override
    public Collection<AuthnAdapterInstance> searchNonConnectionBasedInstances(Integer page, Integer numberPerPage, String filter) {
        SearchCriteria searchCriteria2;
        Searchable searchable = searchCriteria -> {
            ContainsCriteriaFilter<AuthnAdapterInstance> instanceFilter = new ContainsCriteriaFilter<AuthnAdapterInstance>(c -> new ItemMultiValue<AuthnAdapterInstance, String>((AuthnAdapterInstance)c, (K[])new String[]{c.getId(), c.getName()}));
            List adapters = this.getNonConnectionBasedInstances().parallelStream().collect(Collectors.toList());
            String query = searchCriteria.getQuery();
            Collection searchResults = instanceFilter.doFilter(query, adapters);
            if (searchCriteria.getStartIndex() >= searchResults.size()) {
                return new SearchResult(searchCriteria.getStartIndex(), Collections.emptyList());
            }
            searchResults = searchResults.parallelStream().sorted(COMPARE_BY_NAME_DOWN).collect(Collectors.toList());
            if (searchCriteria.getItemsRequested() == -1) {
                return new SearchResult(0, new ArrayList(searchResults));
            }
            int fromIndex = searchCriteria.getStartIndex();
            int toIndex = searchCriteria.getStartIndex() + searchCriteria.getItemsRequested() >= searchResults.size() ? searchResults.size() : searchCriteria.getStartIndex() + searchCriteria.getItemsRequested();
            return new SearchResult(searchCriteria.getStartIndex(), new ArrayList(searchResults).subList(fromIndex, toIndex));
        };
        if (page == null) {
            searchCriteria2 = new SearchCriteria.Builder().query(filter).build();
        } else {
            int fromIndex = (page - 1) * numberPerPage;
            searchCriteria2 = new SearchCriteria.Builder(fromIndex, numberPerPage).query(filter).build();
        }
        SearchResult adaptersSearchResult = searchable.search(searchCriteria2);
        return adaptersSearchResult.getResults();
    }

    @Override
    public AuthnAdapterInstance getInstance(String instanceId) {
        return this.adapterMgr.getSpAuthnAdapterInstance(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        this.adapterMgr.saveSpAuthnAdapterInstance(instance);
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.adapterMgr.deleteSpAuthnAdapterInstance(instance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.adapterMgr.isSpAuthnAdapterInstanceInUse(pluginId);
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        return this.adapterMgr.isSpAuthnAdapterInstanceInUseInternally(pluginId);
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        return this.adapterMgr.isSpAuthnAdapterInstanceInUseExternally(pluginId);
    }

    @Override
    public AuthnAdapterInstance newInstance() {
        return new AuthnAdapterInstance();
    }

    @Override
    public void loadConfigurations() {
        this.adapterMgr.loadSpAdapterConfigurations();
    }

    @Override
    public void registerForReloadEvents(Reloadable reloadable) {
        this.adapterMgr.registerForSpReloadEvents(reloadable);
    }

    @Override
    public void registerForConfigEvents(ConfigEventListener listener) {
        this.adapterMgr.registerForConfigEvents(listener);
    }

    @Override
    public void reload() {
        this.adapterMgr.reloadSpAdapters();
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return true;
    }

    @Override
    public AuthnAdapterInstance getInstanceWithConnectionOverride(String instanceId, String connectionId) {
        return this.adapterMgr.getSpAuthnAdapterInstanceWithConnectionOverride(instanceId, connectionId);
    }

    @Override
    public List<AuthnAdapterInstance> getCBPOInstances(String instanceId) {
        return this.adapterMgr.getSpCBPOInstances(instanceId);
    }

    @Override
    public boolean supportsDefaultInstance() {
        return false;
    }

    @Override
    public AuthnAdapterInstance getDefaultInstance() {
        return null;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
    }

    @Override
    public Collection<AuthnAdapterInstance> getVirtualInstances() {
        return this.adapterMgr.getSpAuthnAdapterVirtualInstances();
    }
}

