/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.jetty.JettyXMLConfigRegistry;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.domain.mgmt.AdminSslServerPkCertManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.SslServerPkCertManager;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.domain.mgmt.impl.PingX509ExtendedKeyManager;
import org.sourceid.saml20.domain.mgmt.impl.PkCertManagerBase;
import org.sourceid.saml20.domain.mgmt.impl.RuntimeSslServerKeyManager;
import org.sourceid.util.Defense;

public class SslServerPkCertManagerImpl
extends PkCertManagerBase
implements SslServerPkCertManager {
    private static final String KEY_ACTIVE_ALIAS = "ActiveServerAlias";
    private static final String KEY_ACTIVE_ALIASES = "ActiveServerAliases";
    private static final String DEFAULT_ACTIVE_ALIAS = "DefaultActiveServerAlias";
    public static final String TEMP_KEYSTORE_PASSWORD = UUID.randomUUID().toString();
    private List<X509ExtendedKeyManager> keyManagers;
    private KeyStore localActiveCertKeyStore;
    private KeyStore hsmActiveCertKeyStore;

    public SslServerPkCertManagerImpl() {
        this.configStore = ConfigStoreFarm.getConfig(SslServerPkCertManagerImpl.class.getName());
    }

    @Override
    protected void clearAllCaches() {
        this.clearCaches();
        MgmtFactory.getAdminSslServerPkCertManager().clearCaches();
    }

    @Override
    protected KeyStore getKeystore() {
        return this.certService.getSslServerKeystore();
    }

    @Override
    protected KeyStore getHSMKeystore() {
        return this.certService.getSslServerHSMKeystore();
    }

    @Override
    protected String getHSMKeystoreName() {
        return PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode() ? this.coreConfig.getSslServerHSMKeystoreName() : null;
    }

    @Override
    protected String getPrivateKeyPassword(String alias) {
        return this.coreConfig.getSslServerPrivateKeyPassword(alias);
    }

    @Override
    protected String getHSMPrivateKeyPassword(String alias) {
        return this.coreConfig.getSslServerHSMPrivateKeyPassword(alias);
    }

    @Override
    protected void setPrivateKeyPassword(String alias, String password) {
        this.coreConfig.setSslServerPrivateKeyPassword(alias, password);
    }

    @Override
    protected void setHSMPrivateKeyPassword(String alias, String password) {
        this.coreConfig.setSslServerHSMPrivateKeyPassword(alias, password);
    }

    @Override
    protected void writeKeyStore(KeyStore keystore) {
        this.certService.writeSslServerKeystore(keystore);
    }

    @Override
    protected void writeHSMKeyStore(KeyStore keystore) {
        this.certService.writeSslServerHSMKeystore(keystore);
    }

    protected String getDefaultAlias() {
        return DEFAULT_ACTIVE_ALIAS;
    }

    protected String getActiveAlias() {
        return KEY_ACTIVE_ALIAS;
    }

    protected EffectiveAlias getEffectiveActiveAlias() {
        EffectiveAlias effectiveAlias = new EffectiveAlias(KEY_ACTIVE_ALIAS, EffectiveAliasType.STRING);
        List<String> svrCertAliases = this.configStore.getListValue(KEY_ACTIVE_ALIASES, null);
        if (svrCertAliases != null) {
            effectiveAlias = new EffectiveAlias(KEY_ACTIVE_ALIASES, EffectiveAliasType.LIST);
        }
        return effectiveAlias;
    }

    protected String getActiveAliases() {
        return KEY_ACTIVE_ALIASES;
    }

    @Override
    public synchronized void setActiveServerPkCert(PkCert activePkCert) {
        this.setActiveServerPkCerts(Collections.singleton(activePkCert));
    }

    @Override
    public synchronized void setActiveServerPkCerts(Set<PkCert> activePkCerts) {
        if (activePkCerts == null || activePkCerts.isEmpty()) {
            throw new IllegalArgumentException("cannot set active pk cert to null");
        }
        Set<PkCert> pkCerts = this.getPkCerts();
        for (PkCert activePkCert : activePkCerts) {
            if (!StringUtils.isBlank((String)activePkCert.getAlias())) continue;
            pkCerts.remove(activePkCert);
            pkCerts.add(activePkCert);
        }
        this.savePkCerts(pkCerts);
        try {
            ArrayList<String> aliases = new ArrayList<String>();
            for (PkCert activePkCert : activePkCerts) {
                aliases.add(activePkCert.getAlias());
            }
            this.configStore.setListValue(this.getActiveAliases(), aliases);
            this.configStore.setStringValue(this.getActiveAlias(), null);
            this.reloadSslProviders();
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public synchronized Set<PkCert> getActiveServerPkCerts() {
        HashSet<PkCert> activePkCerts = new HashSet<PkCert>();
        if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() || PropertyInfo.isHSMHybrid()) {
            activePkCerts.addAll(this.getActiveServerPkCerts(true));
        }
        if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode()) {
            activePkCerts.addAll(this.getActiveServerPkCerts(false));
        }
        return activePkCerts;
    }

    private synchronized Set<PkCert> getActiveServerPkCerts(boolean localKeyStore) {
        try {
            ArrayList<String> activeAliases = new ArrayList<String>();
            EffectiveAlias effectiveAlias = this.getEffectiveActiveAlias();
            if (EffectiveAliasType.LIST == effectiveAlias.effectiveAliasType) {
                activeAliases.addAll(this.configStore.getListValue(effectiveAlias.alias, Collections.emptyList()));
            } else {
                String alias = this.configStore.getStringValue(effectiveAlias.alias, null);
                if (StringUtils.isNotEmpty((String)alias)) {
                    activeAliases.add(alias);
                }
            }
            boolean localActiveServerPkCerts = false;
            boolean hsmActiveServerPkCerts = false;
            if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() || PropertyInfo.isHSMHybrid()) {
                for (String alias : activeAliases) {
                    localActiveServerPkCerts = this.hasActiveServerPkCert(this.getKeystore(), alias);
                    if (!localActiveServerPkCerts) continue;
                    break;
                }
            }
            if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode()) {
                for (String alias : activeAliases) {
                    hsmActiveServerPkCerts = this.hasActiveServerPkCert(this.getHSMKeystore(), alias);
                    if (!hsmActiveServerPkCerts) continue;
                    break;
                }
            }
            if (!localActiveServerPkCerts && !hsmActiveServerPkCerts) {
                throw new ConfigurationException("No server certificate configured for alias : " + String.join((CharSequence)",", activeAliases));
            }
            HashSet<PkCert> activeCerts = new HashSet<PkCert>();
            for (String alias : activeAliases) {
                PkCert pkCert = this.getPkCert(alias);
                boolean add = localKeyStore && (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() && pkCert.isStoredOnHSM() == null || pkCert.isStoredOnHSM() == false);
                if (!(add |= !localKeyStore && (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode() && pkCert.isStoredOnHSM() == null || pkCert.isStoredOnHSM() != false))) continue;
                activeCerts.add(this.getPkCert(alias));
            }
            return activeCerts;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public synchronized boolean hasActiveServerPkCert() {
        try {
            boolean localKeystore = false;
            boolean hsmKeystore = false;
            String activeAlias = this.configStore.getStringValue(this.getActiveAlias(), null);
            ArrayList<String> activeAliases = new ArrayList<String>();
            if (activeAlias != null) {
                activeAliases.add(activeAlias);
            } else {
                activeAliases.addAll(this.configStore.getListValue(this.getActiveAliases()));
            }
            if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() || PropertyInfo.isHSMHybrid()) {
                for (String alias : activeAliases) {
                    localKeystore |= this.hasActiveServerPkCert(this.getKeystore(), alias);
                }
            }
            if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode()) {
                for (String alias : activeAliases) {
                    hsmKeystore |= this.hasActiveServerPkCert(this.getHSMKeystore(), alias);
                }
            }
            return localKeystore || hsmKeystore;
        }
        catch (NoSuchValueException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public synchronized boolean isCreateServerPkCertOnEngineNode() {
        return this.configStore.getBooleanValue("AutoCreateCertOnEngineNode", true);
    }

    @Override
    public synchronized PkCert getDefaultActiveServerPkCert() {
        String defaultAlias = this.configStore.getStringValue(this.getDefaultAlias(), null);
        if (defaultAlias != null) {
            return this.getPkCert(defaultAlias);
        }
        EffectiveAlias effectiveAlias = this.getEffectiveActiveAlias();
        if (effectiveAlias.effectiveAliasType == EffectiveAliasType.STRING) {
            String alias = this.configStore.getStringValue(effectiveAlias.alias, null);
            return this.getPkCert(alias);
        }
        List<String> aliases = this.configStore.getListValue(effectiveAlias.alias, new ArrayList<String>());
        if (!aliases.isEmpty()) {
            String alias = aliases.get(0);
            return this.getPkCert(alias);
        }
        throw new ConfigurationException("No default SSL Server certificate defined.");
    }

    @Override
    public synchronized void setDefaultActiveServerPkCert(PkCert cert) {
        Defense.notNull(cert, "The default active cert cannot be null");
        this.configStore.setStringValue(this.getDefaultAlias(), cert.getAlias());
    }

    protected boolean hasActiveServerPkCert(KeyStore keystore, String activeAlias) {
        try {
            if (!keystore.containsAlias(activeAlias) || !keystore.isKeyEntry(activeAlias)) {
                return false;
            }
        }
        catch (KeyStoreException e) {
            throw new ConfigurationException(e);
        }
        return true;
    }

    @Override
    public synchronized List<X509ExtendedKeyManager> getKeyManagers() {
        if (this.keyManagers == null) {
            this.reloadKeyManagers();
        }
        return this.keyManagers;
    }

    protected synchronized void reloadSslContextFactories() {
        if (!ModeSupport.isEngine()) {
            return;
        }
        try {
            if (!"-1".equals(PropertyInfo.getRuntimeHttpsPort())) {
                this.log.debug((Object)"Reloading primary runtime SSL context factory");
                SslContextFactory primarySslContextFactory = (SslContextFactory)JettyXMLConfigRegistry.getInstance().getObject("primarySSLContextFactory");
                this.reloadContextFactory(primarySslContextFactory);
                this.log.debug((Object)"Finished reloading primary runtime SSL context factory");
            }
            if (!"-1".equals(PropertyInfo.getSecondaryRuntimeHttpsPort())) {
                this.log.debug((Object)"Reloading secondary runtime SSL context factory");
                SslContextFactory secondarySslContextFactory = (SslContextFactory)JettyXMLConfigRegistry.getInstance().getObject("secondarySSLContextFactory");
                this.reloadContextFactory(secondarySslContextFactory);
                this.log.debug((Object)"Finished reloading secondary runtime SSL context factory");
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected synchronized void reloadContextFactory(SslContextFactory sslContextFactory) {
        if (sslContextFactory == null) {
            return;
        }
        try {
            List<KeyStore> keyStores = this.getActiveCertKeystores();
            sslContextFactory.reload(factory -> {
                factory.setKeyStores(keyStores);
                factory.setKeyStorePassword(TEMP_KEYSTORE_PASSWORD);
                factory.setCertAlias(this.getDefaultActiveServerPkCert().getAlias());
            });
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public synchronized List<KeyStore> getActiveCertKeystores() {
        ArrayList<KeyStore> keyStores = new ArrayList<KeyStore>();
        if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() || PropertyInfo.isHSMHybrid()) {
            keyStores.add(this.getActiveCertKeystore(true));
        }
        if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode()) {
            keyStores.add(this.getActiveCertKeystore(false));
        }
        return keyStores;
    }

    private synchronized KeyStore getActiveCertKeystore(boolean localKeyStore) {
        if (localKeyStore && this.localActiveCertKeyStore != null) {
            return this.localActiveCertKeyStore;
        }
        if (!localKeyStore && this.hsmActiveCertKeyStore != null) {
            return this.hsmActiveCertKeyStore;
        }
        try {
            boolean useDummyPrivateKey;
            this.log.debug((Object)("Creating " + (localKeyStore ? "local" : "HSM") + " active cert keystore"));
            String keyStoreType = localKeyStore || PropertyInfo.getHSMMode() == PropertyInfo.HSM_MODE.LUNA || PropertyInfo.getHSMMode() == PropertyInfo.HSM_MODE.AWSCLOUDHSM ? KeyStore.getDefaultType() : this.certService.getKeystoreType();
            KeyStore tempKeyStore = KeyStore.getInstance(keyStoreType);
            tempKeyStore.load(null, TEMP_KEYSTORE_PASSWORD.toCharArray());
            Set<PkCert> activeCerts = this.getActiveServerPkCerts(localKeyStore);
            PrivateKey dummyRSAPrivateKey = null;
            PrivateKey dummyECPrivateKey = null;
            boolean bl = useDummyPrivateKey = !localKeyStore && (PropertyInfo.HSM_MODE.LUNA == PropertyInfo.getHSMMode() || PropertyInfo.HSM_MODE.AWSCLOUDHSM == PropertyInfo.getHSMMode());
            if (useDummyPrivateKey) {
                dummyRSAPrivateKey = new PkCert.Builder().cn("dummyRSA").ou("Development").o("PingIdentity").l("Denver").st("CO").c("US").validDays(3653).keyAlgo("RSA").keySize(2048).isHSMProvider(false).certificateType(CertificateGenerator.CertificateType.sslServerCerts).build().getPrivateKey();
                dummyECPrivateKey = new PkCert.Builder().cn("dummyEC").ou("Development").o("PingIdentity").l("Denver").st("CO").c("US").validDays(3653).keyAlgo("EC").keySize(256).isHSMProvider(false).certificateType(CertificateGenerator.CertificateType.sslServerCerts).build().getPrivateKey();
            }
            for (PkCert activeCert : activeCerts) {
                PrivateKey privateKey = activeCert.getPrivateKey();
                Certificate[] chain = activeCert.getChain();
                if (useDummyPrivateKey) {
                    privateKey = "RSA".equals(activeCert.getPublicKeyAlgorithm()) ? dummyRSAPrivateKey : dummyECPrivateKey;
                }
                tempKeyStore.setKeyEntry(activeCert.getAlias(), privateKey, TEMP_KEYSTORE_PASSWORD.toCharArray(), chain);
            }
            if (localKeyStore) {
                this.localActiveCertKeyStore = tempKeyStore;
            } else {
                this.hsmActiveCertKeyStore = tempKeyStore;
            }
            this.log.debug((Object)("Created " + (localKeyStore ? "local" : "HSM") + " active cert keystore"));
            return tempKeyStore;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ConfigurationException(e);
        }
    }

    private synchronized void reloadKeyManagers() {
        this.log.debug((Object)"Reloading key managers");
        ArrayList<X509ExtendedKeyManager> newKeyManagers = new ArrayList<X509ExtendedKeyManager>();
        try {
            if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() || PropertyInfo.isHSMHybrid()) {
                newKeyManagers.add(this.createX509ExtendedKeyManager(true));
            }
            if (PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode()) {
                newKeyManagers.add(this.createX509ExtendedKeyManager(false));
            }
            this.keyManagers = newKeyManagers;
            this.log.debug((Object)"Finished reloading key managers");
        }
        catch (ConfigurationException e) {
            this.log.error((Object)"Error reloading key managers", (Throwable)e);
        }
    }

    private synchronized X509ExtendedKeyManager createX509ExtendedKeyManager(boolean localKeyStore) {
        try {
            KeyStore tempKeyStore = this.getActiveCertKeystore(localKeyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(SecurityProviderUtil.getKeyManagerFactoryAlgorithm(), SecurityProviderUtil.getSunJSSEProviderOrEquivalent());
            keyManagerFactory.init(tempKeyStore, TEMP_KEYSTORE_PASSWORD.toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            return (X509ExtendedKeyManager)keyManagers[0];
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public boolean isInUseById(String id) {
        if (id == null) {
            return false;
        }
        SslServerPkCertManager sslServerPcm = MgmtFactory.getSslServerPkCertManager();
        AdminSslServerPkCertManager adminSslServerPcm = MgmtFactory.getAdminSslServerPkCertManager();
        HashSet<PkCert> certs = new HashSet<PkCert>();
        certs.addAll(sslServerPcm.getActiveServerPkCerts());
        certs.addAll(adminSslServerPcm.getActiveServerPkCerts());
        for (PkCert cert : certs) {
            if (!id.equals(cert.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void reloadSslProviders() {
        this.localActiveCertKeyStore = null;
        this.hsmActiveCertKeyStore = null;
        this.reloadKeyManagers();
        this.getExtendedKeyManager().reload();
        this.reloadSslContextFactories();
    }

    protected PingX509ExtendedKeyManager getExtendedKeyManager() {
        return RuntimeSslServerKeyManager.getInstance();
    }

    static enum EffectiveAliasType {
        STRING,
        LIST;

    }

    static class EffectiveAlias {
        private String alias;
        private EffectiveAliasType effectiveAliasType;

        EffectiveAlias(String alias, EffectiveAliasType effectiveAliasType) {
            this.alias = alias;
            this.effectiveAliasType = effectiveAliasType;
        }
    }
}

