/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.configservice.AutoReloadable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.domain.RedirectValidationUriAllowlistEntry;
import org.sourceid.saml20.domain.RedirectValidationWhitelistEntry;
import org.sourceid.saml20.domain.UrlWhitelistEntry;
import org.sourceid.saml20.domain.WhitelistData;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.domain.validation.RedirectValidationHelper;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.util.BaseUrlUtil;

public class TargetResourceValidationMgrImpl
implements TargetResourceValidationMgr,
AutoReloadable {
    private Log log = LogFactory.getLog(this.getClass());
    private ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private MetadataLocal localMetadata;
    private List<RedirectValidationWhitelistEntry> whitelistEntries;
    private List<RedirectValidationUriAllowlistEntry> uriAllowlistEntries;
    static final String WHITELIST = "whitelist";
    static final String URI_ALLOWLIST = "uriAllowlist";
    private static final String WILDCARD = "*";
    private static final String ENABLE_VALIDATION_TARGET_RESOURCE_SSO = "enable-validation";
    private static final String ENABLE_VALIDATION_TARGET_RESOURCE_SLO_AND_OTHER = "enable-validation-target-resource-slo";
    private static final String ENABLE_VALIDATION_INERROR_RESOURCE = "enable-validation-inerror-resource";
    private static final String ENABLE_VALIDATION_WREPLY_SLO = "enable-validation-wreply-slo";
    private static final String ENABLE_VALIDATION_TARGET_RESOURCE_IDP_DISCOVERY = "enable-validation-target-resource-idp-discovery";
    @Deprecated
    private static final String REQUIRE_HTTPS = "require-https";
    private static final String DELIMITER = "|";

    @Override
    public List<RedirectValidationWhitelistEntry> getExtendedWhitelist() {
        ArrayList<RedirectValidationWhitelistEntry> result = new ArrayList<RedirectValidationWhitelistEntry>();
        List<String> whitelist = this.getWhitelist();
        for (String whitelistLine : whitelist) {
            String[] components = whitelistLine.split("\\|");
            if (components.length <= 0) continue;
            String validDomain = components[0];
            String validPath = "";
            boolean allowQueryAndFragment = true;
            boolean isRequireHttps = true;
            if (this.isRequireHttps() != null) {
                isRequireHttps = this.isRequireHttps();
            }
            boolean isTargetResourceSSO = true;
            boolean isTargetResourceSLO = false;
            boolean isInErrorResource = false;
            boolean isIdpDiscovery = false;
            if (components.length > 1) {
                validPath = components[1];
            }
            if (components.length > 2) {
                allowQueryAndFragment = Boolean.parseBoolean(components[2]);
            }
            if (components.length > 3) {
                isRequireHttps = Boolean.parseBoolean(components[3]);
            }
            if (components.length > 4) {
                isTargetResourceSSO = Boolean.parseBoolean(components[4]);
            }
            if (components.length > 5) {
                isTargetResourceSLO = Boolean.parseBoolean(components[5]);
            }
            if (components.length > 6) {
                isInErrorResource = Boolean.parseBoolean(components[6]);
            }
            if (components.length > 7) {
                isIdpDiscovery = Boolean.parseBoolean(components[7]);
            }
            result.add(new RedirectValidationWhitelistEntry(validDomain, validPath, allowQueryAndFragment, isRequireHttps, isTargetResourceSSO, isTargetResourceSLO, isInErrorResource, isIdpDiscovery));
        }
        return result;
    }

    @Override
    public void setExtendedWhitelist(List<RedirectValidationWhitelistEntry> entries) {
        ArrayList<String> whitelistLines = new ArrayList<String>();
        for (RedirectValidationWhitelistEntry entry : entries) {
            String validDomain = entry.getValidDomain() != null ? entry.getValidDomain() : "";
            String validPath = entry.getValidPath() != null ? entry.getValidPath() : "";
            whitelistLines.add(validDomain + DELIMITER + validPath + DELIMITER + entry.isAllowQueryAndFragment() + DELIMITER + entry.isRequireHttps() + DELIMITER + entry.isTargetResourceSSO() + DELIMITER + entry.isTargetResourceSLO() + DELIMITER + entry.isInErrorResource() + DELIMITER + entry.isIdpDiscovery());
        }
        this.setWhitelist(whitelistLines);
    }

    @Override
    public List<RedirectValidationUriAllowlistEntry> getExtendedUriAllowlist() {
        ArrayList<RedirectValidationUriAllowlistEntry> result = new ArrayList<RedirectValidationUriAllowlistEntry>();
        List<String> allowlist = this.getUriAllowlist();
        for (String allowlistLine : allowlist) {
            String[] components = allowlistLine.split("\\|");
            if (components.length <= 0) continue;
            String validUri = components[0];
            boolean allowQueryAndFragment = false;
            boolean isTargetResourceSSO = false;
            boolean isTargetResourceSLO = false;
            boolean isInErrorResource = false;
            boolean isIdpDiscovery = false;
            if (components.length > 1) {
                allowQueryAndFragment = Boolean.parseBoolean(components[1]);
            }
            if (components.length > 2) {
                isTargetResourceSSO = Boolean.parseBoolean(components[2]);
            }
            if (components.length > 3) {
                isTargetResourceSLO = Boolean.parseBoolean(components[3]);
            }
            if (components.length > 4) {
                isInErrorResource = Boolean.parseBoolean(components[4]);
            }
            if (components.length > 5) {
                isIdpDiscovery = Boolean.parseBoolean(components[5]);
            }
            result.add(new RedirectValidationUriAllowlistEntry(validUri, allowQueryAndFragment, isTargetResourceSSO, isTargetResourceSLO, isInErrorResource, isIdpDiscovery));
        }
        return result;
    }

    @Override
    public void setExtendedUriAllowlist(List<RedirectValidationUriAllowlistEntry> entries) {
        ArrayList<String> uriAllowlistLines = new ArrayList<String>();
        for (RedirectValidationUriAllowlistEntry entry : entries) {
            uriAllowlistLines.add(entry.getValidUri() + DELIMITER + entry.isAllowQueryAndFragment() + DELIMITER + entry.isTargetResourceSSO() + DELIMITER + entry.isTargetResourceSLO() + DELIMITER + entry.isInErrorResource() + DELIMITER + entry.isIdpDiscovery());
        }
        this.setUriAllowlist(uriAllowlistLines);
    }

    @Override
    public boolean isEnableValidationTargetResourceSSO() {
        return this.config.getBooleanValue(ENABLE_VALIDATION_TARGET_RESOURCE_SSO, false);
    }

    @Override
    public void setEnableValidationTargetResourceSSO(boolean enableValidationTargetResourceSSO) {
        this.config.setBooleanValue(ENABLE_VALIDATION_TARGET_RESOURCE_SSO, enableValidationTargetResourceSSO);
        this.clearCache();
    }

    @Override
    public boolean isEnableValidationTargetResourceSLOAndOther() {
        return this.config.getBooleanValue(ENABLE_VALIDATION_TARGET_RESOURCE_SLO_AND_OTHER, false);
    }

    @Override
    public void setEnableValidationTargetResourceSLOAndOther(boolean enableValidationTargetResourceSLOAndSlo) {
        this.config.setBooleanValue(ENABLE_VALIDATION_TARGET_RESOURCE_SLO_AND_OTHER, enableValidationTargetResourceSLOAndSlo);
        this.clearCache();
    }

    @Override
    public boolean isEnableValidationInErrorResource() {
        return this.config.getBooleanValue(ENABLE_VALIDATION_INERROR_RESOURCE, false);
    }

    @Override
    public void setEnableValidationInErrorResource(boolean enableValidationInErrorResource) {
        this.config.setBooleanValue(ENABLE_VALIDATION_INERROR_RESOURCE, enableValidationInErrorResource);
        this.clearCache();
    }

    @Override
    public boolean isEnableValidationWreplySLO() {
        return this.config.getBooleanValue(ENABLE_VALIDATION_WREPLY_SLO, false);
    }

    @Override
    public void setEnableValidationWreplySLO(boolean enableValidationWreplySLO) {
        this.config.setBooleanValue(ENABLE_VALIDATION_WREPLY_SLO, enableValidationWreplySLO);
        this.clearCache();
    }

    @Override
    public boolean isEnableValidationTargetResourceIdpDiscovery() {
        return this.config.getBooleanValue(ENABLE_VALIDATION_TARGET_RESOURCE_IDP_DISCOVERY, false);
    }

    @Override
    public void setEnableValidationTargetResourceIdpDiscovery(boolean enableValidationTargetResourceIdpDiscovery) {
        this.config.setBooleanValue(ENABLE_VALIDATION_TARGET_RESOURCE_IDP_DISCOVERY, enableValidationTargetResourceIdpDiscovery);
        this.clearCache();
    }

    @Override
    public Boolean isRequireHttps() {
        Boolean isRequireHttps;
        try {
            isRequireHttps = this.config.getBooleanValue(REQUIRE_HTTPS);
        }
        catch (NoSuchValueException e) {
            isRequireHttps = null;
        }
        return isRequireHttps;
    }

    @Override
    public List<String> validateDomain(String entry) {
        ArrayList<String> errors = new ArrayList<String>();
        String errorMsg = "Please provide a valid domain name or IP address.  Domain names may start with *. to indicate a wildcard.";
        String wildcardSequence = "*.";
        if (entry.startsWith(wildcardSequence)) {
            entry = entry.substring(wildcardSequence.length());
        }
        try {
            URI uri = new URI("http://" + entry);
            if (!entry.equals(uri.getHost())) {
                errors.add(errorMsg);
            }
        }
        catch (URISyntaxException e) {
            errors.add(errorMsg);
        }
        return errors;
    }

    @Override
    public List<String> validatePath(String path, boolean allowQueryAndFragment) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!StringUtils.isBlank((String)path)) {
            if (!path.startsWith("/")) {
                errors.add("Path must begin with a '/' character.");
            } else {
                try {
                    URI uri = new URI("http://www.test.com" + path);
                    if (allowQueryAndFragment && (uri.getQuery() != null || uri.getFragment() != null)) {
                        errors.add("You have specified that the Target Resource can include an arbitrary query or fragment. Please remove the specific query or fragment part from the provided path.");
                    }
                }
                catch (URISyntaxException e) {
                    errors.add("The path is invalid. Please include only characters that are permitted in the path component of a URI.");
                }
            }
            if (path.contains(WILDCARD)) {
                errors.add("Wildcards ('*') are not permitted in the path.");
            }
        }
        return errors;
    }

    protected List<String> getWhitelist() {
        try {
            return this.config.getListValue(WHITELIST);
        }
        catch (NoSuchValueException e) {
            return new LinkedList<String>();
        }
    }

    protected void setWhitelist(List<String> whitelist) {
        this.config.setListValue(WHITELIST, whitelist);
        this.clearCache();
    }

    protected List<String> getUriAllowlist() {
        try {
            return this.config.getListValue(URI_ALLOWLIST);
        }
        catch (NoSuchValueException e) {
            return new LinkedList<String>();
        }
    }

    protected void setUriAllowlist(List<String> allowList) {
        this.config.setListValue(URI_ALLOWLIST, allowList);
        this.clearCache();
    }

    @Override
    public void validateTargetResourceSso(String applicationURL, String connDefaultTarget, String defaultUrlName) throws InvalidRedirectValidationException {
        WhitelistData wldata = new WhitelistData();
        if (this.isEnableValidationTargetResourceSSO() && StringUtils.isNotBlank((String)applicationURL)) {
            String defaultTarget = this.localMetadata.getApplicationURL(defaultUrlName);
            if (defaultTarget != null) {
                wldata.getDefaultURLs().add(defaultTarget);
            }
            if (connDefaultTarget != null) {
                wldata.getDefaultURLs().add(connDefaultTarget);
            }
            List<RedirectValidationWhitelistEntry> allEntries = this.getWhitelistEntries();
            ArrayList<UrlWhitelistEntry> targetResourceSsoEntries = new ArrayList<UrlWhitelistEntry>();
            for (RedirectValidationWhitelistEntry entry : allEntries) {
                if (!entry.isTargetResourceSSO()) continue;
                targetResourceSsoEntries.add(entry);
            }
            this.addInternalEndpointEntries(targetResourceSsoEntries);
            wldata.setEntries(targetResourceSsoEntries);
            List<RedirectValidationUriAllowlistEntry> allUriAllowListEntries = this.getUriAllowlistEntries();
            ArrayList<RedirectValidationUriAllowlistEntry> targetResourceSsoUriAllowlistEntries = new ArrayList<RedirectValidationUriAllowlistEntry>();
            for (RedirectValidationUriAllowlistEntry entry : allUriAllowListEntries) {
                if (!entry.isTargetResourceSSO()) continue;
                targetResourceSsoUriAllowlistEntries.add(entry);
            }
            wldata.setRedirectValidationUriAllowlistEntries(targetResourceSsoUriAllowlistEntries);
            RedirectValidationHelper redirectValidationHelper = new RedirectValidationHelper();
            redirectValidationHelper.validate(wldata, applicationURL);
        }
    }

    @Override
    public void validateTargetResourceSloAndOther(String applicationURL, String defaultUrlName) throws InvalidRedirectValidationException {
        WhitelistData wldata = new WhitelistData();
        if (this.isEnableValidationTargetResourceSLOAndOther() && StringUtils.isNotBlank((String)applicationURL)) {
            String defaultTarget = this.localMetadata.getApplicationURL(defaultUrlName);
            if (defaultTarget != null) {
                wldata.getDefaultURLs().add(defaultTarget);
            }
            List<RedirectValidationWhitelistEntry> allEntries = this.getWhitelistEntries();
            ArrayList<UrlWhitelistEntry> targetResourceSloEntries = new ArrayList<UrlWhitelistEntry>();
            for (RedirectValidationWhitelistEntry entry : allEntries) {
                if (!entry.isTargetResourceSLO()) continue;
                targetResourceSloEntries.add(entry);
            }
            this.addInternalEndpointEntries(targetResourceSloEntries);
            wldata.setEntries(targetResourceSloEntries);
            List<RedirectValidationUriAllowlistEntry> allUriAllowListEntries = this.getUriAllowlistEntries();
            ArrayList<RedirectValidationUriAllowlistEntry> targetResourceSloUriAllowlistEntries = new ArrayList<RedirectValidationUriAllowlistEntry>();
            for (RedirectValidationUriAllowlistEntry entry : allUriAllowListEntries) {
                if (!entry.isTargetResourceSLO()) continue;
                targetResourceSloUriAllowlistEntries.add(entry);
            }
            wldata.setRedirectValidationUriAllowlistEntries(targetResourceSloUriAllowlistEntries);
            RedirectValidationHelper redirectValidationHelper = new RedirectValidationHelper();
            redirectValidationHelper.validate(wldata, applicationURL);
        }
    }

    @Override
    public List<String> validateUri(String uriString) {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isEmpty((String)uriString)) {
            errors.add("Please provide a valid URI.");
        } else {
            try {
                URI uri = new URI(uriString);
                if (!uri.isAbsolute()) {
                    errors.add("The specified URI must be absolute.");
                }
                if (uri.getFragment() != null) {
                    errors.add("URI cannot have a fragment.");
                }
            }
            catch (URISyntaxException e) {
                errors.add("URI syntax is invalid.");
            }
        }
        return errors;
    }

    private void addInternalEndpointEntries(List<UrlWhitelistEntry> entries) {
        String baseUrlHost = this.getBaseUrlHost();
        String basePath = PropertyInfo.getContextPath();
        String path = basePath != null && !"/".equals(basePath) ? basePath + "/pf/idprofile.ping" : "/pf/idprofile.ping";
        RedirectValidationWhitelistEntry entry = new RedirectValidationWhitelistEntry(baseUrlHost, path, true, false, true, true, false);
        entries.add(entry);
        String pathVerifyEmailEndpoint = basePath != null && !"/".equals(basePath) ? basePath + "/pf/id/verification.ping" : "/pf/id/verification.ping";
        RedirectValidationWhitelistEntry entryVerifyEmailEndpoint = new RedirectValidationWhitelistEntry(baseUrlHost, pathVerifyEmailEndpoint, true, false, true, true, false);
        entries.add(entryVerifyEmailEndpoint);
    }

    protected String getBaseUrlHost() {
        try {
            return new URL(BaseUrlUtil.getCurrentBaseUrl(this.localMetadata.getBaseUrl())).getHost();
        }
        catch (MalformedURLException e) {
            this.log.warn((Object)"There was an error when converting the virtual host from the request to a URL object.  The PF base url will be used.");
            return this.localMetadata.getBaseURL().getHost();
        }
    }

    @Override
    public void validateInErrorResource(String inErrorResource) throws InvalidRedirectValidationException {
        WhitelistData wldata = new WhitelistData();
        if (this.isEnableValidationInErrorResource() && StringUtils.isNotBlank((String)inErrorResource)) {
            List<RedirectValidationWhitelistEntry> allEntries = this.getWhitelistEntries();
            ArrayList<UrlWhitelistEntry> inErrorResourceEntries = new ArrayList<UrlWhitelistEntry>();
            for (RedirectValidationWhitelistEntry entry : allEntries) {
                if (!entry.isInErrorResource()) continue;
                inErrorResourceEntries.add(entry);
            }
            wldata.setEntries(inErrorResourceEntries);
            List<RedirectValidationUriAllowlistEntry> allUriAllowListEntries = this.getUriAllowlistEntries();
            ArrayList<RedirectValidationUriAllowlistEntry> inErrorResourceUriAllowlistEntries = new ArrayList<RedirectValidationUriAllowlistEntry>();
            for (RedirectValidationUriAllowlistEntry entry : allUriAllowListEntries) {
                if (!entry.isInErrorResource()) continue;
                inErrorResourceUriAllowlistEntries.add(entry);
            }
            wldata.setRedirectValidationUriAllowlistEntries(inErrorResourceUriAllowlistEntries);
            RedirectValidationHelper redirectValidationHelper = new RedirectValidationHelper();
            redirectValidationHelper.validate(wldata, inErrorResource);
        }
    }

    @Override
    public void validateTargetResourceIdpDiscovery(String targetResource) throws InvalidRedirectValidationException {
        WhitelistData wldata = new WhitelistData();
        if (this.isEnableValidationTargetResourceIdpDiscovery() && StringUtils.isNotBlank((String)targetResource)) {
            List<RedirectValidationWhitelistEntry> allEntries = this.getWhitelistEntries();
            ArrayList<UrlWhitelistEntry> idpDiscoveryEntries = new ArrayList<UrlWhitelistEntry>();
            for (RedirectValidationWhitelistEntry entry : allEntries) {
                if (!entry.isIdpDiscovery()) continue;
                idpDiscoveryEntries.add(entry);
            }
            wldata.setEntries(idpDiscoveryEntries);
            List<RedirectValidationUriAllowlistEntry> allUriAllowListEntries = this.getUriAllowlistEntries();
            ArrayList<RedirectValidationUriAllowlistEntry> idpDiscoveryUriAllowlistEntries = new ArrayList<RedirectValidationUriAllowlistEntry>();
            for (RedirectValidationUriAllowlistEntry entry : allUriAllowListEntries) {
                if (!entry.isIdpDiscovery()) continue;
                idpDiscoveryUriAllowlistEntries.add(entry);
            }
            wldata.setRedirectValidationUriAllowlistEntries(idpDiscoveryUriAllowlistEntries);
            RedirectValidationHelper redirectValidationHelper = new RedirectValidationHelper();
            redirectValidationHelper.validate(wldata, targetResource);
        }
    }

    public synchronized List<RedirectValidationWhitelistEntry> getWhitelistEntries() {
        if (this.whitelistEntries == null || this.whitelistEntries.isEmpty()) {
            List<RedirectValidationWhitelistEntry> entries = this.getExtendedWhitelist();
            this.setEntryList(entries);
        }
        return this.whitelistEntries;
    }

    public synchronized List<RedirectValidationUriAllowlistEntry> getUriAllowlistEntries() {
        if (this.uriAllowlistEntries == null || this.uriAllowlistEntries.isEmpty()) {
            List<RedirectValidationUriAllowlistEntry> entries = this.getExtendedUriAllowlist();
            this.setUriEntryList(entries);
        }
        return this.uriAllowlistEntries;
    }

    synchronized void setDomainList(List<String> validDomains, boolean isTargetResourceSSO, boolean isTargetResourceSLO, boolean isInErrorResource, boolean requireHttps, boolean isIdpDiscovery) {
        ArrayList<RedirectValidationWhitelistEntry> entries = new ArrayList<RedirectValidationWhitelistEntry>();
        for (String validDomain : validDomains) {
            entries.add(new RedirectValidationWhitelistEntry(validDomain, "", true, requireHttps, isTargetResourceSSO, isTargetResourceSLO, isInErrorResource, isIdpDiscovery));
        }
        this.setEntryList(entries);
    }

    synchronized void setEntryList(List<RedirectValidationWhitelistEntry> entries) {
        this.whitelistEntries = new ArrayList<RedirectValidationWhitelistEntry>();
        this.whitelistEntries.addAll(entries);
    }

    synchronized void setUriEntryList(List<RedirectValidationUriAllowlistEntry> entries) {
        this.uriAllowlistEntries = new ArrayList<RedirectValidationUriAllowlistEntry>();
        this.uriAllowlistEntries.addAll(entries);
    }

    public void setLocalMetadata(MetadataLocal localMetadata) {
        this.localMetadata = localMetadata;
    }

    public synchronized void clearCache() {
        this.whitelistEntries = null;
        this.uriAllowlistEntries = null;
    }

    @Override
    public ConfigStore getConfig() {
        return this.config;
    }

    @Override
    public boolean isIdpDiscoveryAndCommonDomainClient() {
        return this.localMetadata.getEnableIdpDiscovery() && this.localMetadata.getIdpDiscovery().isIdpCommonDomainClient();
    }
}

