/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.TimerTaskBase;
import com.pingidentity.crypto.ExpirationNotifier;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.token.AccessGrantCleaner;
import org.sourceid.saml20.domain.mgmt.AuthnSessionPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TimerTaskManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.util.api.filesystem.ConnectionImporter;
import org.sourceid.saml20.metadata.IndexDbConsistencyChecker;
import org.sourceid.saml20.service.session.StoredSessionCleaner;
import org.sourceid.saml20.service.session.data.SessionStorageManager;

public class TimerTaskManagerImpl
implements TimerTaskManager {
    private static final String BASE_FILE_NAME = "timer-intervals";
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConfigStore timerconfig = ConfigStoreFarm.getConfig("timer-intervals");
    private final Timer timer = new Timer(this.getClass().getName() + " timer", true);
    private volatile ExpirationNotifier expirationNotifierTask = new ExpirationNotifier();
    private volatile AccessGrantCleaner accessGrantCleanerTask = new AccessGrantCleaner();
    private volatile TimerTaskBase dataZipTimerTask = MgmtFactory.getMediator().getDataZipTimerTask();
    private volatile ConnectionImporter connectionImporter = new ConnectionImporter();
    private volatile StoredSessionCleaner storedSessionCleaner = new StoredSessionCleaner();
    private volatile IndexDbConsistencyChecker indexDbConsistencyChecker = new IndexDbConsistencyChecker();
    private final Mediator mediator;
    private final AuthzServerManager authzServerManager;
    private final AuthnSessionPolicyManager authnSessionPolicyManager;
    private final SessionStorageManager sessionStorageManager;

    public TimerTaskManagerImpl(Mediator mediator, AuthzServerManager authzServerManager, AuthnSessionPolicyManager authnSessionPolicyManager, SessionStorageManager sessionStorageManager) {
        this.mediator = mediator;
        this.authzServerManager = authzServerManager;
        this.authnSessionPolicyManager = authnSessionPolicyManager;
        this.sessionStorageManager = sessionStorageManager;
    }

    @Override
    public void scheduleTasks() {
        this.checkIntervalAndSchedule(this.expirationNotifierTask, "CertExpirationNotifierTimerInterval", 0L, 43200000L, () -> {
            this.expirationNotifierTask = new ExpirationNotifier();
            return this.expirationNotifierTask;
        });
        if (this.mediator.isConsole()) {
            this.checkIntervalAndSchedule(this.indexDbConsistencyChecker, "IndexDbConsistencyCheckInterval", 0L, 300000L, () -> {
                this.indexDbConsistencyChecker = new IndexDbConsistencyChecker();
                return this.indexDbConsistencyChecker;
            });
            if (this.authzServerManager.isEnableOAuth()) {
                this.checkIntervalAndSchedule(this.accessGrantCleanerTask, "AccessGrantCleanerInterval", 86400000L, () -> {
                    this.accessGrantCleanerTask = new AccessGrantCleaner();
                    return this.accessGrantCleanerTask;
                });
            }
        }
        this.checkIntervalAndSchedule(this.dataZipTimerTask, "ConfigArchiveDeployTimerInterval", 5000L, () -> {
            this.dataZipTimerTask = this.mediator.getDataZipTimerTask();
            return this.dataZipTimerTask;
        });
        this.checkIntervalAndSchedule(this.connectionImporter, "ConnectionImportTimerInterval", 5000L, () -> {
            this.connectionImporter = new ConnectionImporter();
            return this.connectionImporter;
        });
        if (this.mediator.isConsole() && this.authnSessionPolicyManager.isAnyStoredSessionEnabled() && this.sessionStorageManager.supportsBatchCleanup()) {
            this.checkIntervalAndSchedule(this.storedSessionCleaner, "StoredSessionCleanerInterval", TimeUnit.HOURS.toMillis(24L), () -> {
                this.storedSessionCleaner = new StoredSessionCleaner();
                return this.storedSessionCleaner;
            });
        }
    }

    private void checkIntervalAndSchedule(TimerTaskBase timerTaskBase, String keyName, long defaultInterval, TaskCreator taskCreator) {
        this.checkIntervalAndSchedule(timerTaskBase, keyName, -1L, defaultInterval, taskCreator);
    }

    private void checkIntervalAndSchedule(TimerTaskBase timerTaskBase, String keyName, long delay, long defaultInterval, TaskCreator taskCreator) {
        long actualDelay;
        long interval = this.timerconfig.getLongValue(keyName, defaultInterval);
        long l = actualDelay = delay < 0L ? interval : delay;
        if (!timerTaskBase.isScheduled()) {
            this.schedule(timerTaskBase, actualDelay, interval, keyName);
        } else if (interval != timerTaskBase.getCurrentInterval()) {
            timerTaskBase.cancel();
            timerTaskBase = taskCreator.newTimerTask();
            this.schedule(timerTaskBase, actualDelay, interval, keyName);
        }
    }

    private void schedule(TimerTaskBase timerTask, long delay, long interval, String keyname) {
        this.log.debug((Object)(keyname + " value=" + interval));
        String fileName = "timer-intervals.xml";
        if (interval > 0L) {
            this.log.info((Object)("Starting " + timerTask + " at interval of " + interval + "ms as indicated by " + keyname + " in " + fileName));
            this.timer.schedule((TimerTask)timerTask, delay, interval);
            timerTask.setCurrentInterval(interval);
        } else {
            this.log.info((Object)("Not starting " + timerTask + " because interval for " + keyname + " was less than 1 in " + fileName));
        }
    }

    private static interface TaskCreator {
        public TimerTaskBase newTimerTask();
    }
}

