/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.VirtualHostNamesManager;

public class VirtualHostNamesMgrImpl
implements VirtualHostNamesManager,
AutoReloadable {
    private static final String DOMAIN_NAMES_KEY = "domain-names";
    private static final String CONFIG_STORE_NAME = "virtual-host-names";
    private ConfigStore configStore = ConfigStoreFarm.getConfig("virtual-host-names");
    private Set<String> hostnames;

    public VirtualHostNamesMgrImpl() {
        this.loadConfig();
    }

    @Override
    public synchronized List<String> getHostNames() {
        List<String> defaultValue = Collections.emptyList();
        List<String> namesList = this.configStore.getListValue(DOMAIN_NAMES_KEY, defaultValue);
        return new ArrayList<String>(namesList);
    }

    @Override
    public synchronized void setHostNames(List<String> names) {
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            this.configStore.setListValue(DOMAIN_NAMES_KEY, new ArrayList<String>(names));
            this.loadConfig();
            scope.log(AdminAuditLogger.Component.VIRTUAL_HOSTNAMES, AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized Set<String> getHostNameSet() {
        return this.hostnames;
    }

    private synchronized void loadConfig() {
        List<String> hostNamesList = this.getHostNames();
        this.hostnames = new HashSet<String>();
        for (String name : hostNamesList) {
            this.hostnames.add(name.toLowerCase());
        }
        this.hostnames = Collections.unmodifiableSet(this.hostnames);
    }
}

