/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.proxy;

import com.pingidentity.monitoring.ConnectionPoolMetrics;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sources.SourceDescriptor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.xmlbeans.XmlException;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;

public class CopyingDSMgrProxy
implements DataSourceManager {
    private final DataSourceManager dataSourceManager;

    public CopyingDSMgrProxy(DataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
    }

    @Override
    public boolean isDataSourceNameInUse(String name, String id) {
        return this.dataSourceManager.isDataSourceNameInUse(name, id);
    }

    @Override
    public synchronized void initializeJndiLookup() {
        this.dataSourceManager.initializeJndiLookup();
    }

    @Override
    public Collection<JdbcDataSource> getJdbcDataSources() {
        Collection<JdbcDataSource> liveDataSources = this.dataSourceManager.getJdbcDataSources();
        ArrayList<JdbcDataSource> copy = new ArrayList<JdbcDataSource>(liveDataSources.size());
        for (JdbcDataSource jds : liveDataSources) {
            copy.add(this.getJdbcDataSource(jds.getId()));
        }
        return copy;
    }

    @Override
    public JdbcDataSource getJdbcDataSource(String dataSourceId) {
        JdbcDataSource ds = this.dataSourceManager.getJdbcDataSource(dataSourceId);
        return ds != null ? ds.getClone() : null;
    }

    @Override
    public void saveJdbcDataSource(JdbcDataSource dataSource) {
        this.dataSourceManager.saveJdbcDataSource(dataSource);
    }

    @Override
    public void deleteJdbcDataSource(JdbcDataSource dataSource) {
        this.dataSourceManager.deleteJdbcDataSource(dataSource);
    }

    @Override
    public Collection<LdapDataSource> getLdapDataSources() {
        Collection<LdapDataSource> liveDataSources = this.dataSourceManager.getLdapDataSources();
        ArrayList<LdapDataSource> copy = new ArrayList<LdapDataSource>(liveDataSources.size());
        for (LdapDataSource lds : liveDataSources) {
            copy.add(this.getLdapDataSource(lds.getId()));
        }
        return copy;
    }

    @Override
    public LdapDataSource getLdapDataSource(String dataSourceId) {
        LdapDataSource ldapDataSource = this.dataSourceManager.getLdapDataSource(dataSourceId);
        return ldapDataSource != null ? ldapDataSource.getClone() : null;
    }

    @Override
    public void saveLdapDataSource(LdapDataSource dataSource) {
        this.dataSourceManager.saveLdapDataSource(dataSource);
    }

    @Override
    public void deleteLdapDataSource(LdapDataSource dataSource) {
        this.dataSourceManager.deleteLdapDataSource(dataSource);
    }

    @Override
    public boolean isInUse(DataSource ds) {
        return this.dataSourceManager.isInUse(ds);
    }

    @Override
    public Map<String, ConnectionPoolMetrics> getJdbcDataSourcesConnectionPoolMetrics() {
        return this.dataSourceManager.getJdbcDataSourcesConnectionPoolMetrics();
    }

    @Override
    public boolean test(DataSource ds) {
        return this.dataSourceManager.test(ds);
    }

    @Override
    public void test(DataSource ds, boolean allowTestCacheUse) throws NamingException, SecretManagerException, SQLException {
        this.dataSourceManager.test(ds, allowTestCacheUse);
    }

    @Override
    public Collection<CustomDataSource> getCustomDataSources() {
        return this.dataSourceManager.getCustomDataSources();
    }

    @Override
    public CustomDataSource getCustomDataSource(String sourceId) {
        return this.dataSourceManager.getCustomDataSource(sourceId);
    }

    @Override
    public void saveCustomDataSource(CustomDataSource dataSource) {
        this.dataSourceManager.saveCustomDataSource(dataSource);
    }

    @Override
    public void deleteCustomDataSource(CustomDataSource dataSource) {
        this.dataSourceManager.deleteCustomDataSource(dataSource);
    }

    @Override
    public Collection<DataSource> getAllDataSources() {
        return this.dataSourceManager.getAllDataSources();
    }

    @Override
    public DataSource getDataSource(String dataSourceId) {
        DataSource dataSource = this.getJdbcDataSource(dataSourceId);
        if (dataSource == null) {
            dataSource = this.getLdapDataSource(dataSourceId);
        }
        if (dataSource == null) {
            dataSource = this.getCustomDataSource(dataSourceId);
        }
        return dataSource;
    }

    @Override
    public void deleteDataSource(DataSource dataSource) {
        this.dataSourceManager.deleteDataSource(dataSource);
    }

    @Override
    public void saveDataSource(DataSource dataSource) {
        this.dataSourceManager.saveDataSource(dataSource);
    }

    @Override
    public Collection<SourceDescriptor> discoverSourceDescriptors() {
        return this.dataSourceManager.discoverSourceDescriptors();
    }

    @Override
    public SourceDescriptor getSourceDescriptor(String attributeSourceDriverClassName) {
        return this.dataSourceManager.getSourceDescriptor(attributeSourceDriverClassName);
    }

    @Override
    public void loadCustomDataSourceDriver(CustomDataSource attributeSource) {
        this.dataSourceManager.loadCustomDataSourceDriver(attributeSource);
    }

    @Override
    public String exportJdbcSources() {
        return this.dataSourceManager.exportJdbcSources();
    }

    @Override
    public String exportJdbcSource(String instanceId) {
        return this.dataSourceManager.exportJdbcSource(instanceId);
    }

    @Override
    public String exportLdapSources() {
        return this.dataSourceManager.exportLdapSources();
    }

    @Override
    public String exportLdapSource(String instanceId) {
        return this.dataSourceManager.exportLdapSource(instanceId);
    }

    @Override
    public String exportCustomDataSources() {
        return this.dataSourceManager.exportCustomDataSources();
    }

    @Override
    public String exportCustomDataSource(String instanceId) {
        return this.dataSourceManager.exportCustomDataSource(instanceId);
    }

    @Override
    public String exportCustomDataSourceConfiguration(String instanceId) {
        return this.dataSourceManager.exportCustomDataSourceConfiguration(instanceId);
    }

    @Override
    public void importCustomDataSource(String definitionXml, String guiDescriptionXml, boolean allowUpdate) throws XmlException {
        this.dataSourceManager.importCustomDataSource(definitionXml, guiDescriptionXml, allowUpdate);
    }

    @Override
    public Collection<CustomDataSource> getXmlCustomDataSources() {
        return this.dataSourceManager.getXmlCustomDataSources();
    }

    @Override
    public void importJdbcSources(String xml, boolean allowUpdate) throws XmlException {
        this.dataSourceManager.importJdbcSources(xml, allowUpdate);
    }

    @Override
    public void importLdapSources(String xml, boolean allowUpdate) throws XmlException {
        this.dataSourceManager.importLdapSources(xml, allowUpdate);
    }

    @Override
    public LdapDataSource getDefaultLdapDataSourceSettings() {
        return this.dataSourceManager.getDefaultLdapDataSourceSettings();
    }

    @Override
    public void deployJdbcDataSources() {
        this.dataSourceManager.deployJdbcDataSources();
    }
}

