/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.scim;

import java.io.Serializable;
import java.util.Collections;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.IdentityStoreProvisionerInstance;
import org.sourceid.saml20.domain.InboundProvisioningUserRepositoryType;
import org.sourceid.saml20.domain.MaskedAttributeContract;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.scim.ScimVersion;
import org.sourceid.saml20.domain.scim.model.Schema;
import org.sourceid.saml20.domain.scim.model.Scim2Schema;

public class ScimUserProvisioning
implements Serializable {
    private static final long serialVersionUID = 1896331088426537L;
    private AttributeMapping writeUsersAttributeMapping;
    private boolean permanentlyDeleteUsersOnDelete;
    private AttributeMapping readUsersAttributeMapping;
    private MaskedAttributeContract readUsersAttributeContract;
    private AttributeMapping writeGroupsAttributeMapping;
    private AttributeMapping readGroupsAttributeMapping;
    private MaskedAttributeContract readGroupsAttributeContract;
    private InboundProvisioningUserRepositoryType userRepositoryType = InboundProvisioningUserRepositoryType.ACTIVE_DIRECTORY;
    private String identityStoreProvisionerId;
    private Schema customScim;
    private Scim2Schema customScim2Schema;
    private ScimVersion version = ScimVersion.SCIM11;
    private String documentationUri;

    public ScimUserProvisioning() {
        this(ScimVersion.SCIM11);
    }

    public ScimUserProvisioning(ScimVersion version) {
        this.writeUsersAttributeMapping = new AttributeMapping();
        this.readUsersAttributeMapping = new AttributeMapping();
        this.readUsersAttributeContract = new MaskedAttributeContract(Collections.emptySet());
        this.writeGroupsAttributeMapping = new AttributeMapping();
        this.readGroupsAttributeMapping = new AttributeMapping();
        this.readGroupsAttributeContract = new MaskedAttributeContract(Collections.emptySet());
        this.customScim = new Schema();
        this.customScim2Schema = new Scim2Schema();
        this.version = version;
    }

    public ScimUserProvisioning(ScimUserProvisioning copy) {
        this.permanentlyDeleteUsersOnDelete = copy.isPermanentlyDeleteUsersOnDelete();
        this.writeUsersAttributeMapping = new AttributeMapping(copy.getWriteUsersAttributeMapping());
        this.writeGroupsAttributeMapping = new AttributeMapping(copy.getWriteGroupsAttributeMapping());
        this.readUsersAttributeMapping = new AttributeMapping(copy.getReadUsersAttributeMapping());
        this.readUsersAttributeContract = new MaskedAttributeContract(copy.getReadUsersAttributeContract());
        this.readGroupsAttributeMapping = new AttributeMapping(copy.getReadGroupsAttributeMapping());
        this.readGroupsAttributeContract = new MaskedAttributeContract(copy.getReadGroupsAttributeContract());
        this.userRepositoryType = copy.getUserRepositoryType();
        this.identityStoreProvisionerId = copy.getIdentityStoreProvisionerId();
        this.version = copy.getVersion();
        this.customScim = copy.getCustomScim();
        this.customScim2Schema = copy.getCustomScim2Schema();
        this.documentationUri = copy.getDocumentationUri();
    }

    public AttributeMapping getWriteUsersAttributeMapping() {
        return this.writeUsersAttributeMapping;
    }

    public void setWriteUsersAttributeMapping(AttributeMapping writeUsersAttributeMapping) {
        this.writeUsersAttributeMapping = writeUsersAttributeMapping;
    }

    public AttributeMapping getReadUsersAttributeMapping() {
        return this.readUsersAttributeMapping;
    }

    public void setReadUsersAttributeMapping(AttributeMapping readUsersAttributeMapping) {
        this.readUsersAttributeMapping = readUsersAttributeMapping;
    }

    public MaskedAttributeContract getReadUsersAttributeContract() {
        return this.readUsersAttributeContract;
    }

    public void setReadUsersAttributeContract(MaskedAttributeContract readUsersAttributeContract) {
        this.readUsersAttributeContract = readUsersAttributeContract;
    }

    public boolean isPermanentlyDeleteUsersOnDelete() {
        return this.permanentlyDeleteUsersOnDelete;
    }

    public void setPermanentlyDeleteUsersOnDelete(boolean permanentlyDeleteUsersOnDelete) {
        this.permanentlyDeleteUsersOnDelete = permanentlyDeleteUsersOnDelete;
    }

    public InboundProvisioningUserRepositoryType getUserRepositoryType() {
        return this.userRepositoryType;
    }

    public void setUserRepositoryType(InboundProvisioningUserRepositoryType userRepositoryType) {
        this.userRepositoryType = userRepositoryType;
    }

    public String getIdentityStoreProvisionerId() {
        return this.identityStoreProvisionerId;
    }

    public void setIdentityStoreProvisionerId(String identityStoreProvisionerId) {
        this.identityStoreProvisionerId = identityStoreProvisionerId;
    }

    public IdentityStoreProvisionerInstance getIdentityStoreProvisioner() {
        return (IdentityStoreProvisionerInstance)MgmtFactory.getIdentityStoreProvisionerManager().getInstance(this.identityStoreProvisionerId);
    }

    public AttributeMapping getWriteGroupsAttributeMapping() {
        return this.writeGroupsAttributeMapping;
    }

    public void setWriteGroupsAttributeMapping(AttributeMapping writeGroupsAttributeMapping) {
        this.writeGroupsAttributeMapping = writeGroupsAttributeMapping;
    }

    public AttributeMapping getReadGroupsAttributeMapping() {
        return this.readGroupsAttributeMapping;
    }

    public void setReadGroupsAttributeMapping(AttributeMapping readGroupsAttributeMapping) {
        this.readGroupsAttributeMapping = readGroupsAttributeMapping;
    }

    public MaskedAttributeContract getReadGroupsAttributeContract() {
        return this.readGroupsAttributeContract;
    }

    public void setReadGroupsAttributeContract(MaskedAttributeContract readGroupsAttributeContract) {
        this.readGroupsAttributeContract = readGroupsAttributeContract;
    }

    public Schema getCustomScim() {
        return this.customScim;
    }

    public void setCustomScim(Schema customScim) {
        this.customScim = customScim;
    }

    public Scim2Schema getCustomScim2Schema() {
        return this.customScim2Schema;
    }

    public void setCustomScim2Schema(Scim2Schema customScim) {
        this.customScim2Schema = customScim;
    }

    public ScimVersion getVersion() {
        return this.version;
    }

    public void setVersion(ScimVersion version) {
        this.version = version;
    }

    public String getDocumentationUri() {
        return this.documentationUri;
    }

    public void setDocumentationUri(String documentationUri) {
        this.documentationUri = documentationUri;
    }
}

