/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.OAuth2AdministrativeUser;

public final class AdminAuthUtil {
    private static final String UNABLE_TO_PROCESS_THE_SCOPE_CLAIM = "Unable to process the scope claim.";
    private static final Log log = LogFactory.getLog(AdminAuthUtil.class);

    private AdminAuthUtil() {
        throw new UnsupportedOperationException("not allowed");
    }

    public static String getProperty(Properties properties, String propertyName, boolean isRequired, String propertyFriendlyName) {
        boolean isPropertyNameEmpty = StringUtils.isEmpty((String)propertyName);
        if (isRequired && isPropertyNameEmpty) {
            String name = StringUtils.isEmpty((String)propertyFriendlyName) ? propertyName : propertyFriendlyName;
            String error = "'" + name + "' is required.";
            log.debug((Object)error);
            throw new RuntimeException(error);
        }
        if (isPropertyNameEmpty) {
            return null;
        }
        return properties.getProperty(propertyName);
    }

    public static String getURLProperty(Properties properties, String propertyName, boolean isRequired, String propertyFriendlyName) {
        String value = AdminAuthUtil.getProperty(properties, propertyName, isRequired, propertyFriendlyName);
        if (!StringUtils.isEmpty((String)value)) {
            AdminAuthUtil.validUrl(value, propertyFriendlyName);
        }
        return value;
    }

    private static void validUrl(String value, String friendlyName) {
        try {
            new URI(value);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URL value " + value + " for: " + friendlyName);
        }
    }

    public static Map<String, Set<String>> getRoleValues(Properties properties) {
        HashMap<String, Set<String>> roleMap = new HashMap<String, Set<String>>();
        roleMap.put("admin", AdminAuthUtil.getRoleValues(properties, "role.admin", "Administrator Role", true));
        roleMap.put("cryptoManager", AdminAuthUtil.getRoleValues(properties, "role.cryptoManager", "Crypto Administrator Role", true));
        roleMap.put("auditor", AdminAuthUtil.getRoleValues(properties, "role.auditor", "Auditor Role", false));
        roleMap.put("userAdmin", AdminAuthUtil.getRoleValues(properties, "role.userAdmin", "User Administrator Role", true));
        roleMap.put("expressionAdmin", AdminAuthUtil.getRoleValues(properties, "role.expressionAdmin", "Expression Administrator Role", true));
        roleMap.put("dataCollectionAdmin", AdminAuthUtil.getRoleValues(properties, "role.dataCollectionAdmin", "Data Collection Administrator Role", true));
        return roleMap;
    }

    private static Set<String> getRoleValues(Properties properties, String roleName, String friendlyName, boolean isRequired) {
        HashSet<String> searchValues = new HashSet<String>();
        String roleExpressionWithoutIndex = AdminAuthUtil.getProperty(properties, roleName, isRequired, friendlyName);
        if (roleExpressionWithoutIndex != null) {
            searchValues.add(roleExpressionWithoutIndex.trim());
            log.info((Object)(friendlyName + ": " + roleExpressionWithoutIndex));
        }
        int index = 1;
        String expression = AdminAuthUtil.getProperty(properties, roleName + "." + index, false, friendlyName);
        while (expression != null) {
            searchValues.add(expression.trim());
            log.info((Object)(friendlyName + "." + index + ": " + expression));
            expression = AdminAuthUtil.getProperty(properties, roleName + "." + ++index, false, friendlyName);
        }
        return searchValues;
    }

    public static void validateScopes(Object incomingScope, Collection<String> configuredScopes) throws IOException {
        if (configuredScopes != null && !configuredScopes.isEmpty()) {
            if (incomingScope == null || StringUtils.isEmpty((String)incomingScope.toString())) {
                String err = "No scope attribute to validate.";
                log.debug((Object)err);
                throw new IOException(err);
            }
            String[] incomingScopeArray = null;
            if (incomingScope instanceof String[]) {
                incomingScopeArray = (String[])incomingScope;
            } else if (incomingScope instanceof Collection) {
                Collection tmp = (Collection)incomingScope;
                ArrayList<String> scopes = new ArrayList<String>();
                for (Object e : tmp) {
                    if (e instanceof String) {
                        scopes.add((String)e);
                        continue;
                    }
                    log.debug((Object)UNABLE_TO_PROCESS_THE_SCOPE_CLAIM);
                    throw new IOException(UNABLE_TO_PROCESS_THE_SCOPE_CLAIM);
                }
                incomingScopeArray = scopes.toArray(scopes.toArray(new String[0]));
            } else if (incomingScope instanceof String) {
                incomingScopeArray = StringUtils.split((String)((String)incomingScope), (char)' ');
            } else {
                log.debug((Object)UNABLE_TO_PROCESS_THE_SCOPE_CLAIM);
            }
            if (incomingScopeArray == null || incomingScopeArray.length == 0) {
                String err = "No scope attribute to validate.";
                log.debug((Object)err);
                throw new IOException(err);
            }
            for (String scope : configuredScopes) {
                boolean exists = false;
                for (String string : incomingScopeArray) {
                    if (!string.equals(scope)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                String string = String.format("The bearer token does not contain the expected scope(s): '%s'", configuredScopes);
                log.debug((Object)string);
                throw new IOException(string);
            }
        }
    }

    public static AdministrativeUser createActiveAdminUser(String username, Map<String, Object> adminUserInfo, Map<String, Object> additionalUserInfo, String roleAttributeName, Map<String, Set<String>> roleMap) {
        AdministrativeUser user = new AdministrativeUser();
        user.setUserName(username);
        user.setActive(true);
        AdminAuthUtil.populateAdminUserRoles(user, adminUserInfo, additionalUserInfo, roleAttributeName, roleMap);
        return user;
    }

    public static OAuth2AdministrativeUser createActiveOAuthAdminUser(String username, Map<String, Object> adminUserInfo, String roleAttributeName, Map<String, Set<String>> roleMap) {
        return AdminAuthUtil.createActiveOAuthAdminUser(username, adminUserInfo, null, roleAttributeName, roleMap);
    }

    public static OAuth2AdministrativeUser createActiveOAuthAdminUser(String username, Map<String, Object> adminUserInfo, Map<String, Object> additionalUserInfo, String roleAttributeName, Map<String, Set<String>> roleMap) {
        OAuth2AdministrativeUser oAuth2AdministrativeUser = new OAuth2AdministrativeUser();
        oAuth2AdministrativeUser.setUserName(username);
        oAuth2AdministrativeUser.setActive(true);
        AdminAuthUtil.populateAdminUserRoles(oAuth2AdministrativeUser, adminUserInfo, additionalUserInfo, roleAttributeName, roleMap);
        if (adminUserInfo.containsKey("exp")) {
            Object expirationTime = adminUserInfo.get("exp");
            if (expirationTime instanceof Long) {
                oAuth2AdministrativeUser.setExpTime((Long)expirationTime);
            } else if (expirationTime instanceof Integer) {
                oAuth2AdministrativeUser.setExpTime(((Integer)expirationTime).longValue());
            }
        }
        if (adminUserInfo.containsKey(Parameters.CLIENT_ID)) {
            oAuth2AdministrativeUser.setClientId(adminUserInfo.get(Parameters.CLIENT_ID).toString());
        }
        return oAuth2AdministrativeUser;
    }

    private static void populateAdminUserRoles(AdministrativeUser userToPopulate, Map<String, Object> adminUserInfo, Map<String, Object> additionalUserInfo, String roleAttributeName, Map<String, Set<String>> roleMap) {
        if (AdminAuthUtil.hasRole("auditor", adminUserInfo, additionalUserInfo, roleAttributeName, roleMap)) {
            userToPopulate.setAuditor(true);
        } else {
            userToPopulate.setAdmin(AdminAuthUtil.hasRole("admin", adminUserInfo, additionalUserInfo, roleAttributeName, roleMap));
            userToPopulate.setCryptoManager(AdminAuthUtil.hasRole("cryptoManager", adminUserInfo, additionalUserInfo, roleAttributeName, roleMap));
            userToPopulate.setAdminManager(AdminAuthUtil.hasRole("userAdmin", adminUserInfo, additionalUserInfo, roleAttributeName, roleMap));
            userToPopulate.setExpressionAdmin(AdminAuthUtil.hasRole("expressionAdmin", adminUserInfo, additionalUserInfo, roleAttributeName, roleMap));
            userToPopulate.setDataCollectionAdmin(AdminAuthUtil.hasRole("dataCollectionAdmin", adminUserInfo, additionalUserInfo, roleAttributeName, roleMap));
        }
    }

    private static boolean hasRole(String roleName, Map<String, Object> adminUserInfo, Map<String, Object> additionalUserInfo, String roleAttributeName, Map<String, Set<String>> roleMap) {
        Set<String> adminRoleMap = roleMap.get(roleName);
        if (adminRoleMap != null) {
            for (String value : adminRoleMap) {
                if (!(adminUserInfo != null && adminUserInfo.containsKey(roleAttributeName) ? AdminAuthUtil.isMatching(value, adminUserInfo.get(roleAttributeName)) : additionalUserInfo != null && additionalUserInfo.containsKey(roleAttributeName) && AdminAuthUtil.isMatching(value, additionalUserInfo.get(roleAttributeName)))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMatching(String value, Object claimValueObject) {
        if (claimValueObject instanceof Collection) {
            for (Object o : (Collection)claimValueObject) {
                String claimValue = o instanceof byte[] ? Base64.encodeBase64String((byte[])((byte[])o)) : o.toString().trim();
                if (!claimValue.equals(value)) continue;
                return true;
            }
        } else {
            return claimValueObject.toString().equals(value);
        }
        return false;
    }
}

