/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.crypto.PkCert;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.common.dsig.VerificationException;
import org.sourceid.common.dsig.XmlSignatureUtil;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.w3c.dom.Node;

public class DsigUtil {
    private static TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
    private static Log log = LogFactory.getLog(DsigUtil.class);

    public static XmlObject validateAndCheckIfSigned(String rawXml) throws XmlException, InvalidXmlException, AlreadySignedException {
        Node node = XmlBeansUtil.parseToNode(rawXml);
        XmlObject xmlObject = XmlObject.Factory.parse((Node)node);
        XmlBeansUtil.validate(xmlObject);
        try {
            XmlSignatureVerifier verifier = new XmlSignatureVerifier(xmlObject);
            SignatureStatus signatureStatus = verifier.getSignatureStatus();
            if (signatureStatus != SignatureStatus.NOT_PRESENT) {
                throw new AlreadySignedException();
            }
        }
        catch (VerificationException e) {
            log.error((Object)"Problem attempting to see if xml was already signed.", (Throwable)e);
        }
        return xmlObject;
    }

    @Deprecated
    public static String signXml(XmlObject xmlObject, String signingAlgorithm, PkCert signWith, boolean includeKeyInfo, boolean includeKeyValue) throws SigningException {
        xmlObject = xmlObject.copy();
        PrivateKey privateKey = signWith.getPrivateKey();
        X509Certificate x509Certificate = signWith.getX509Certificate();
        XmlSignatureUtil.signXml(xmlObject, signingAlgorithm, privateKey, includeKeyInfo ? x509Certificate : null, true, false, includeKeyValue);
        return XmlBeansUtil.xmlText(xmlObject);
    }

    public static XmlSignatureVerifier createVerifier(XmlObject xmlObject) throws VerificationException {
        XmlSignatureVerifier xmlSignatureVerifier = new XmlSignatureVerifier(xmlObject);
        xmlSignatureVerifier.setTrustAnchors(trustedCAsManager.getAllTrustAnchors());
        return xmlSignatureVerifier;
    }

    public static class AlreadySignedException
    extends Exception {
    }
}

