/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.validation.CommonValidator;

public class IdUtil {
    public static String generatePluginConnectionId(String adapterId, String connectionId, PluginManager<?, ?> pluginMgr) {
        String id = (StringUtils.capitalize((String)adapterId) + StringUtils.capitalize((String)connectionId)).replaceAll("[^A-Za-z0-9]", "");
        if (IdUtil.isGeneratedPluginIdValid(id = StringUtils.substring((String)id, (int)0, (int)31), pluginMgr)) {
            return id;
        }
        return UUID.randomUUID().toString().toUpperCase().replaceAll("-", "");
    }

    private static boolean isGeneratedPluginIdValid(String id, PluginManager<?, ?> pluginMgr) {
        return CommonValidator.isValidAdapterInstanceId(id) && (pluginMgr == null || !pluginMgr.isDuplicateId(id));
    }
}

