/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.FragmentNodeVisitor;
import com.pingidentity.authnselection.MappingAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.X500Util;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.pingcommons.util.tree.PreOrderTraversal;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import com.pingidentity.sdk.util.AuthnSourceKeyUtil;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Token2TokenMapping;
import org.sourceid.a2a.domain.mgmt.Adapter2AdapterManager;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailType;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.JWKSEndpointSetting;
import org.sourceid.oauth20.domain.JwksSigningInstanceSettings;
import org.sourceid.oauth20.domain.UserKeyAttrMapping;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.ciba.domain.CibaServerPolicyManager;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AuthnSourceSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.BearerAccessTokenFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CertificateSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CustomSourceFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.JdbcDatastoreFieldDescriptor;
import org.sourceid.saml20.adapter.gui.LdapDatastoreFieldDescriptor;
import org.sourceid.saml20.adapter.gui.NotificationSenderFieldDescriptor;
import org.sourceid.saml20.adapter.gui.PasswordCredentialValidatorFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SecretReferenceFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeRequester;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigAbstract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.saml20.domain.mgmt.impl.AdapterUser;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.service.AccountLinkingService;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenPluginManager;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public final class InUseDetectionUtil {
    private static final Log log = LogFactory.getLog(InUseDetectionUtil.class);
    private static InUseDetectionUtil instance;
    public static final String PROVISIONERDS_ID = "ProvisionerDS";

    private InUseDetectionUtil() {
    }

    public static InUseDetectionUtil getInstance() {
        if (instance == null) {
            instance = new InUseDetectionUtil();
        }
        return instance;
    }

    public boolean isSslAuthCertInUse(Cert cert) {
        return this.isSslAuthCertInUse(cert.getAlias());
    }

    public boolean isSslAuthCertInUse(String certAlias) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        for (ConnectionBase connection : connectionManager.getAllConnections()) {
            SoapAuthInfo.CertAuthInfo certAuthInfo;
            String keyAlias;
            SoapAuthInfo outgoingSoapAuth = connection.getSoapAuthOut();
            if (outgoingSoapAuth == null || !outgoingSoapAuth.isHasCertEntry() || (keyAlias = (certAuthInfo = outgoingSoapAuth.getCertAuthInfo()).getAlias()) == null || !keyAlias.equals(certAlias)) continue;
            return true;
        }
        if (this.isCertUsedByTokenPlugins(certAlias, CertificateSelectionFieldDescriptor.class) || this.isCertUsedByAdapters(certAlias, CertificateSelectionFieldDescriptor.class)) {
            return true;
        }
        return this.isCertUsedByDataSources(certAlias);
    }

    public List<IdpConnection> getIdpConnectionsWithCertInUse(Cert cert) {
        LinkedList<IdpConnection> connectionsWithCertInUse = new LinkedList<IdpConnection>();
        String alias = cert.getAlias();
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        for (IdpConnection idp : connectionManager.getAllIdpConnections()) {
            if (!this.isCertUsedInConnection(idp, alias)) continue;
            connectionsWithCertInUse.add(idp);
        }
        return connectionsWithCertInUse;
    }

    public List<SpConnection> getSpConnectionsWithCertInUse(Cert cert) {
        LinkedList<SpConnection> connectionsWithCertInUse = new LinkedList<SpConnection>();
        String alias = cert.getAlias();
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        for (SpConnection sp : connectionManager.getAllSpConnections()) {
            if (!this.isCertUsedInConnection(sp, alias)) continue;
            connectionsWithCertInUse.add(sp);
        }
        return connectionsWithCertInUse;
    }

    private boolean isCertUsedInConnection(ConnectionBase connection, String certAlias) {
        SoapAuthInfo.CertAuthInfo certAuthInfo;
        String keyAlias;
        String signingKeyAlias = connection.getSigningKeyAlias();
        if (signingKeyAlias != null && signingKeyAlias.equals(certAlias)) {
            return true;
        }
        if (connection.getAltSigningKeyAliasToCertMap() != null && connection.getAltSigningKeyAliasToCertMap().keySet().stream().anyMatch(altSigningCertAlias -> altSigningCertAlias.equals(certAlias))) {
            return true;
        }
        for (Cert verificationCert : connection.getDsigVerificationCerts().getAllVerificationCerts()) {
            if (verificationCert.getAlias() == null || !verificationCert.getAlias().equals(certAlias)) continue;
            return true;
        }
        String decryptionCertAlias = connection.getEncryptionSettings().getDecryptionKeyAlias();
        String secondaryDecryptionCertAlias = connection.getEncryptionSettings().getSecondaryDecryptionKeyAlias();
        boolean isUsedAsPrimaryDecrypCert = this.isCertEquals(certAlias, decryptionCertAlias);
        boolean isUsedAsSecondaryDecrypCert = this.isCertEquals(certAlias, secondaryDecryptionCertAlias);
        if (isUsedAsPrimaryDecrypCert || isUsedAsSecondaryDecrypCert) {
            return true;
        }
        SoapAuthInfo outgoingSoapAuth = connection.getSoapAuthOut();
        return outgoingSoapAuth != null && outgoingSoapAuth.isHasCertEntry() && (keyAlias = (certAuthInfo = outgoingSoapAuth.getCertAuthInfo()).getAlias()) != null && keyAlias.equals(certAlias);
    }

    private boolean isCertEquals(String certAlias, String decryptionCertAlias) {
        boolean used = false;
        if (certAlias != null && decryptionCertAlias != null && certAlias.equals(decryptionCertAlias)) {
            used = true;
        }
        return used;
    }

    public boolean isCertUsedInServerSettings(String certAlias) {
        return certAlias != null && certAlias.equals(MetaDataFactory.getLocalMetaData().getMetadataSigningKeyAlias());
    }

    public boolean isDsigCertInUse(Cert dsigCert) {
        return this.isDsigCertInUse(dsigCert.getAlias());
    }

    public boolean isDsigCertInUse(String certAlias) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        for (ConnectionBase connection : connectionManager.getAllConnections()) {
            if (!this.isCertUsedInConnection(connection, certAlias)) continue;
            return true;
        }
        if (this.isCertUsedInServerSettings(certAlias)) {
            return true;
        }
        if (this.isCertUsedByAnyPlugin(certAlias, CertificateSelectionFieldDescriptor.class) || this.isCertUsedByTokenPlugins(certAlias, CertificateSelectionFieldDescriptor.class)) {
            return true;
        }
        JWKSEndpointSetting setting = MgmtFactory.getJWKSEndpointManager().getSetting();
        Set<String> activeIds = setting.getActiveIds();
        Set<String> previousIds = setting.getPreviousIds();
        if (activeIds.contains(certAlias) || previousIds.contains(certAlias)) {
            return true;
        }
        List<JwksSigningInstanceSettings> keySets = MgmtFactory.getJWKSSigningKeySetsManager().getAllKeySets();
        for (JwksSigningInstanceSettings keySet : keySets) {
            if (keySet.getOidcJWKSSigningKeySet() == null || !keySet.getOidcJWKSSigningKeySet().getActiveIds().contains(certAlias) && !keySet.getOidcJWKSSigningKeySet().getPreviousIds().contains(certAlias)) continue;
            return true;
        }
        return false;
    }

    public List<IdpConnection> getIdpConnectionsWithDSInUse(String id) {
        LinkedList<IdpConnection> inUse = new LinkedList<IdpConnection>();
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        for (IdpConnection idp : connectionManager.getAllIdpConnections()) {
            if (!this.isDataSourceInUseByIdpConnection(id, idp)) continue;
            inUse.add(idp);
        }
        return inUse;
    }

    public List<SpConnection> getSpConnectionsWithDSInUse(String id) {
        LinkedList<SpConnection> inUse = new LinkedList<SpConnection>();
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        for (SpConnection sp : connectionManager.getAllSpConnections()) {
            if (!this.isDataSourceInUseBySpConnection(id, sp)) continue;
            inUse.add(sp);
        }
        return inUse;
    }

    public List<ConfigurablePluginInstance> getPCVsWithDSInUse(String id) {
        LinkedList<ConfigurablePluginInstance> instances = new LinkedList<ConfigurablePluginInstance>();
        Collection credValInstances = MgmtFactory.getCredentialValidatorManager().getInstances();
        if (credValInstances != null) {
            for (ConfigurablePluginInstance credValInstance : credValInstances) {
                if (!this.isDataSourceUsedByPluginInstance(id, credValInstance)) continue;
                instances.add(credValInstance);
            }
        }
        return instances;
    }

    public List<OpenIdConnectProviderPolicy.PolicyGroup> getOpenIdConnectPolicyGroupsWithDSInUse(String id) {
        OpenIdConnectProviderPolicyManager connectProviderPolicyManager = GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        return connectProviderPolicyManager.getPolicyGroupsWithDSInUse(id);
    }

    public List<CibaServerPolicy.RequestHandlingPolicy> getCibaRequestHandlingPoliciesWithDSInUse(String id) {
        CibaServerPolicyManager mgr = GlobalRegistry.getService(CibaServerPolicyManager.class);
        return mgr.getPoliciesWithDSInUse(id);
    }

    public List<CibaServerPolicy.RequestHandlingPolicy> getCibaRequestHandlingPoliciesWithPCVInUse(String id) {
        CibaServerPolicyManager mgr = GlobalRegistry.getService(CibaServerPolicyManager.class);
        return mgr.getPoliciesWithPCVInUse(id);
    }

    public List<CibaServerPolicy.RequestHandlingPolicy> getCibaRequestHandlingPoliciesWithOOBAuthInUse(String id) {
        CibaServerPolicyManager mgr = GlobalRegistry.getService(CibaServerPolicyManager.class);
        return mgr.getPoliciesWithOOBAuthInUse(id);
    }

    public List<OpenIdConnectProviderPolicy.PolicyGroup> getOpenIdConnectPolicyGroupsWithAccessTokenMappingInUse(String accessTokenMappingId) {
        OpenIdConnectProviderPolicyManager connectProviderPolicyManager = GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        return this.getPolicyGroupsWithAccessTokenMappingInUse(connectProviderPolicyManager, accessTokenMappingId);
    }

    private List<OpenIdConnectProviderPolicy.PolicyGroup> getPolicyGroupsWithAccessTokenMappingInUse(OpenIdConnectProviderPolicyManager openIdConnectProviderPolicyManager, String accessTokenMappingId) {
        OpenIdConnectProviderPolicy policy = openIdConnectProviderPolicyManager.getPolicy();
        LinkedList<OpenIdConnectProviderPolicy.PolicyGroup> policyGroupsWithATMInUse = new LinkedList<OpenIdConnectProviderPolicy.PolicyGroup>();
        for (OpenIdConnectProviderPolicy.PolicyGroup group : policy.getPolicyGroups().values()) {
            if (group.getAccessTokenManagerId() == null || !group.getAccessTokenManagerId().equals(accessTokenMappingId)) continue;
            policyGroupsWithATMInUse.add(group);
        }
        return policyGroupsWithATMInUse;
    }

    public boolean isDataSourceInUse(DataSource ds) {
        OpenIdConnectProviderPolicyManager openIdConnectProviderPolicyManager;
        if (PROVISIONERDS_ID.equals(ds.getId())) {
            return true;
        }
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        Collection<IdpConnection> idpConns = connectionManager.getAllIdpConnections();
        ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
        if (moduleSupport.isDataSourceInUse(ds)) {
            return true;
        }
        String id = ds.getId();
        for (IdpConnection idpConnection : idpConns) {
            if (!this.isDataSourceInUseByIdpConnection(id, idpConnection)) continue;
            return true;
        }
        Collection<SpConnection> spConns = connectionManager.getAllSpConnections();
        for (SpConnection spConnection : spConns) {
            if (!this.isDataSourceInUseBySpConnection(id, spConnection)) continue;
            return true;
        }
        if (this.isDataSourceUsedByAdapters(id)) {
            return true;
        }
        if (this.isDataSourceUsedByTokenPlugins(id)) {
            return true;
        }
        if (this.isDataSourceInUseByLocalIdentities(id)) {
            return true;
        }
        if (this.isDataSourceInUseByAccessTokenMapping(id)) {
            return true;
        }
        Collection collection = MgmtFactory.getCredentialValidatorManager().getInstances();
        if (collection != null) {
            for (ConfigurablePluginInstance credValInstance : collection) {
                if (!this.isDataSourceUsedByPluginInstance(id, credValInstance)) continue;
                return true;
            }
        }
        if ((openIdConnectProviderPolicyManager = GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class)).isDataSourceInUse(id)) {
            return true;
        }
        CibaServerPolicyManager cibaServerPolicyManager = GlobalRegistry.getService(CibaServerPolicyManager.class);
        if (cibaServerPolicyManager.isDataSourceInUse(id)) {
            return true;
        }
        TokenExchangeProcessorPolicyManager tokenExchangeProcessorPolicyManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
        if (tokenExchangeProcessorPolicyManager.isDataSourceInUse(id)) {
            return true;
        }
        if (MgmtFactory.getAdapter2AdapterManager().isDataSourceInUse(id) || MgmtFactory.getApc2SpAdapterManager().isDataSourceInUse(id) || MgmtFactory.getToken2TokenManager().isDataSourceInUse(id) || MgmtFactory.getAuthzServerManager().isDataSourceInUse(id) || GlobalRegistry.getService(AccountLinkingService.class).isDataSourceInUse(id) || MgmtFactory.getAccessGrantManager().isDataSourceInUse(id) || MgmtFactory.getClientManager().isDataSourceInUse(id) || StateMgmtFactory.getSessionStorageManager().isDataSourceInUse(id) || MgmtFactory.getProcessorPolicy2TokenGeneratorManager().isDataSourceInUse(id)) {
            return true;
        }
        if (this.isDataSourceInUseByPolicyContracts(id)) {
            return true;
        }
        if (this.isDataSourceInUseByFragment(id)) {
            return true;
        }
        return this.isDataSourceUsedByKerberosRealms(id);
    }

    public boolean isDataSourceInUseByPolicyContracts(String id) {
        AuthnSelectionConfigManager authnSelectorConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
        Set<String> apcIds = authnSelectorConfigManager.getAuthnSelectionApcIds();
        for (String apcId : apcIds) {
            List<LinkedList<Tree.Node<AuthnSelectionAction>>> listOfPaths = authnSelectorConfigManager.getAuthnSelectionApcPaths(apcId);
            for (LinkedList<Tree.Node<AuthnSelectionAction>> path : listOfPaths) {
                boolean foundInUse;
                MappingAction apcMappingAction = (MappingAction)path.getLast().getData();
                if (apcMappingAction.getAttributeMapping().getAttributeSources() == null || !(foundInUse = apcMappingAction.getAttributeMapping().getAttributeSources().stream().anyMatch(source -> id.equals(source.getDataSourceId())))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDataSourceInUseByFragment(String dataSourceId) {
        List<AuthnSelectionTree> policyTrees = MgmtFactory.getAuthnSelectionConfigManager().getAuthnSelectionTrees();
        return policyTrees.stream().anyMatch(policyTree -> this.isDataSourceInUseByFragmentMapping(dataSourceId, (Tree<AuthnSelectionAction>)policyTree)) || MgmtFactory.getPolicyFragmentManager().isDataSourceInUse(dataSourceId);
    }

    public boolean isDataSourceInUseByFragmentMapping(String dataSourceId, Tree<AuthnSelectionAction> actionTree) {
        FragmentNodeVisitor fragmentNodeVisitor = new FragmentNodeVisitor();
        PreOrderTraversal traversal = new PreOrderTraversal();
        traversal.traverse(actionTree, (TraversalVisitor)fragmentNodeVisitor);
        for (Tree.Node<AuthnSelectionAction> node : fragmentNodeVisitor.getFragmentNodes()) {
            List<AttributeSource> attributeSources = ((FragmentAction)node.getData()).getAttributeMapping().getAttributeSources();
            if (attributeSources == null || !attributeSources.stream().anyMatch(attributeSource -> attributeSource.getDataSourceId().equals(dataSourceId))) continue;
            return true;
        }
        return false;
    }

    public boolean isDataSourceUsedByKerberosRealms(String id) {
        KerberosRealmManager kerberosRealmManager = MgmtFactory.getKerberosRealmManager();
        return kerberosRealmManager.getKerberosRealms().stream().filter(KerberosRealm::isLdapGatewayConnection).anyMatch(kerberosRealm -> id.equals(kerberosRealm.getLdapGatewayDatastoreId()));
    }

    public boolean isDataSourceInUseByLocalIdentities(String id) {
        return MgmtFactory.getLocalIdentityProfileManager().getProfiles().stream().anyMatch(profile -> profile.getDataStoreConfig() != null && profile.getDataStoreConfig().getAttributeSource().getDataSourceId().equals(id));
    }

    public boolean isDataSourceInUseByAccessTokenMapping(String id) {
        return !MgmtFactory.getAuthzServerManager().getUserKeyToAccessTokenMappingsWithDSInUse(id).isEmpty();
    }

    public boolean isDataSourceInUseByIdpConnection(String id, IdpConnection idp) {
        AttributeMapping mapping;
        List<OAuthAssertionGrantMapping> mappings;
        Object wsTrustMappings;
        ArrayList<AttributeMapping> attrMappings = new ArrayList<AttributeMapping>();
        Collection<TargetAttributeMapping> targetAttribMappings = idp.getTargetAttributeMappings();
        if (targetAttribMappings != null) {
            attrMappings.addAll(targetAttribMappings);
        }
        attrMappings.addAll(idp.getC2cContractMappings());
        if (idp.doesWsTrustSettingsExist() && (wsTrustMappings = idp.getWsTrustSettings().getAssertionToTokenMappingsMappings()) != null) {
            ArrayList<AttributeMapping> wsTrustAttrMappingList = new ArrayList<AttributeMapping>();
            Iterator iterator = wsTrustMappings.iterator();
            while (iterator.hasNext()) {
                TokenPluginAttributeMapping tokenPluginAttributeMapping = (TokenPluginAttributeMapping)iterator.next();
                wsTrustAttrMappingList.add(tokenPluginAttributeMapping.getAttributeMapping());
            }
            attrMappings.addAll(wsTrustAttrMappingList);
        }
        for (AttributeMapping mapping2 : attrMappings) {
            if (!this.isDataSourceUsedBy(mapping2, id)) continue;
            return true;
        }
        UserProvisioning userProvisioning = idp.getUserProvisioning();
        if (userProvisioning != null && userProvisioning.getAttributeSource().getDataSource().getId().equals(id)) {
            return true;
        }
        UserKeyAttrMapping userKeyAttrMapping = idp.getSsoToOAuthAttrMapping();
        if (userKeyAttrMapping != null && userKeyAttrMapping.getAttributeSource() != null && userKeyAttrMapping.getAttributeSource().getDataSource() != null && userKeyAttrMapping.getAttributeSource().getDataSource().getId().equals(id)) {
            return true;
        }
        if (idp.doesOAuthSettingsExist() && (mappings = idp.getOAuthSettings().getOAuthAssertionGrantMappingList()) != null) {
            for (OAuthAssertionGrantMapping mapping3 : mappings) {
                if (mapping3 == null || mapping3.getAttributeSource() == null || mapping3.getAttributeSource().getDataSource() == null || !mapping3.getAttributeSource().getDataSource().getId().equals(id)) continue;
                return true;
            }
        }
        return idp.doesInboundProvisioningExist() && (mapping = idp.getInboundProvisioning().getReadUsersAttributeMapping()) != null && mapping.getAttributeSource() != null && mapping.getAttributeSource().getDataSource() != null && mapping.getAttributeSource().getDataSource().getId().equals(id);
    }

    public boolean isDataSourceInUseBySpConnection(String id, SpConnection sp) {
        Collection<TokenPluginAttributeMapping> collection;
        List<AttributeMapping> attribMaps;
        ArrayList<AttributeMapping> attrMappings = new ArrayList<AttributeMapping>();
        for (AdapterToAssertionMapping adapterToAssertionMapping : sp.getAdapterMappings()) {
            attribMaps = adapterToAssertionMapping.getAttributeMappingList();
            attrMappings.addAll(attribMaps);
            attrMappings.add(adapterToAssertionMapping.getDefaultAttributeMapping());
        }
        for (C2cContractToAssertionMapping c2cContractToAssertionMapping : sp.getC2cMappings()) {
            attribMaps = c2cContractToAssertionMapping.getAttributeMappingList();
            attrMappings.addAll(attribMaps);
            attrMappings.add(c2cContractToAssertionMapping.getDefaultAttributeMapping());
        }
        AttributeRequester attributeRequester = sp.getAttributeRequester();
        if (attributeRequester != null) {
            AttributeMapping attributeMapping = attributeRequester.getAttributeMapping();
            attrMappings.add(attributeMapping);
        }
        if (sp.doesWsTrustSettingsExist() && (collection = sp.getWsTrustSettings().getTokenToAssertionMappings()) != null) {
            ArrayList<AttributeMapping> wsTrustAttrMappingList = new ArrayList<AttributeMapping>();
            for (TokenPluginAttributeMapping tokenPluginAttributeMapping : collection) {
                wsTrustAttrMappingList.add(tokenPluginAttributeMapping.getAttributeMapping());
            }
            attrMappings.addAll(wsTrustAttrMappingList);
        }
        for (AttributeMapping map : attrMappings) {
            if (!this.isDataSourceUsedBy(map, id)) continue;
            return true;
        }
        return false;
    }

    public boolean isDataSourceInUseByAttributeMapping(AttributeMapping attributeMapping, String dataSourceId) {
        if (dataSourceId == null) {
            return false;
        }
        List<AttributeSource> attributeSources = attributeMapping.getAttributeSources();
        return attributeSources != null && attributeSources.stream().anyMatch(attributeSource -> dataSourceId.equals(attributeSource.getDataSourceId()));
    }

    public List<ConfigurablePluginInstance> getAdapterSelectorInstancesWithCertInUse(String alias) {
        LinkedList<ConfigurablePluginInstance> instancesInUse = new LinkedList<ConfigurablePluginInstance>();
        for (ConfigurablePluginInstance instance : MgmtFactory.getAuthnSelectorManager().getInstances()) {
            if (!this.isCertUsedByPluginInstance(alias, instance, CertificateSelectionFieldDescriptor.class)) continue;
            instancesInUse.add(instance);
        }
        return instancesInUse;
    }

    public List<ConfigurablePluginInstance> getCredentialValidatorInstancesWithCertInUse(String alias) {
        LinkedList<ConfigurablePluginInstance> instancesInUse = new LinkedList<ConfigurablePluginInstance>();
        for (PasswordCredentialValidatorInstance instance : MgmtFactory.getCredentialValidatorManager().getInstances()) {
            if (!this.isCertUsedByPluginInstance(alias, instance, CertificateSelectionFieldDescriptor.class)) continue;
            instancesInUse.add(instance);
        }
        return instancesInUse;
    }

    public List<ConfigurablePluginInstance> getBearerAccessTokenMgmtPluginsWithCertInUse(String alias) {
        LinkedList<ConfigurablePluginInstance> instancesInUse = new LinkedList<ConfigurablePluginInstance>();
        LinkedList instances = new LinkedList();
        instances.addAll(MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances());
        for (ConfigurablePluginInstance instance : instances) {
            if (!this.isCertUsedByPluginInstance(alias, instance, CertificateSelectionFieldDescriptor.class)) continue;
            instancesInUse.add(instance);
        }
        return instancesInUse;
    }

    public List<ConfigurablePluginInstance> getSpAdaptersWithCertInUse(String alias) {
        LinkedList<ConfigurablePluginInstance> instancesInUse = new LinkedList<ConfigurablePluginInstance>();
        for (AuthnAdapterInstance instance : MgmtFactory.getSpAdapterManager().getInstances()) {
            if (!this.isCertUsedByPluginInstance(alias, instance, CertificateSelectionFieldDescriptor.class)) continue;
            instancesInUse.add(instance);
        }
        return instancesInUse;
    }

    public List<ConfigurablePluginInstance> getIdpAdaptersWithCertInUse(String alias) {
        LinkedList<ConfigurablePluginInstance> instancesInUse = new LinkedList<ConfigurablePluginInstance>();
        for (AuthnAdapterInstance instance : MgmtFactory.getIdpAdapterManager().getInstances()) {
            if (!this.isCertUsedByPluginInstance(alias, instance, CertificateSelectionFieldDescriptor.class)) continue;
            instancesInUse.add(instance);
        }
        return instancesInUse;
    }

    public List<ConfigurablePluginInstance> getTokenProcessorsWithCertInUse(String alias) {
        LinkedList<ConfigurablePluginInstance> instancesInUse = new LinkedList<ConfigurablePluginInstance>();
        for (TokenProcessorInstance instance : MgmtFactory.getTokenProcessorManager().getInstances()) {
            if (!this.isCertUsedByPluginInstance(alias, instance, CertificateSelectionFieldDescriptor.class)) continue;
            instancesInUse.add(instance);
        }
        return instancesInUse;
    }

    public List<DataSource> getDataSourcesWithCertInUse(String alias) {
        LinkedList<DataSource> instancesInUse = new LinkedList<DataSource>();
        Collection<LdapDataSource> ldapDsInstances = MgmtFactory.getDataSourceManager().getLdapDataSources();
        for (LdapDataSource ldapDsInstance : ldapDsInstances) {
            if (!StringUtils.equals((String)alias, (String)ldapDsInstance.getClientTlsCertificate())) continue;
            instancesInUse.add(ldapDsInstance);
        }
        Collection<CustomDataSource> customDsInstances = MgmtFactory.getDataSourceManager().getCustomDataSources();
        for (CustomDataSource customDsInstance : customDsInstances) {
            if (!this.isCertUsedByPluginInstance(alias, customDsInstance, CertificateSelectionFieldDescriptor.class)) continue;
            instancesInUse.add(customDsInstance);
        }
        return instancesInUse;
    }

    public List<ConfigurablePluginInstance> getTokenGeneratorsWithCertInUse(String alias) {
        LinkedList<ConfigurablePluginInstance> instancesInUse = new LinkedList<ConfigurablePluginInstance>();
        for (TokenGeneratorInstance instance : MgmtFactory.getTokenGeneratorManager().getInstances()) {
            if (!this.isCertUsedByPluginInstance(alias, instance, CertificateSelectionFieldDescriptor.class)) continue;
            instancesInUse.add(instance);
        }
        return instancesInUse;
    }

    private boolean isCertUsedByAnyPlugin(String alias, Class<? extends SelectFieldDescriptor> certFieldDescriptorClass) {
        LinkedList instances = new LinkedList();
        instances.addAll(MgmtFactory.getIdpAdapterManager().getInstances());
        instances.addAll(MgmtFactory.getSpAdapterManager().getInstances());
        instances.addAll(MgmtFactory.getTokenGeneratorManager().getInstances());
        instances.addAll(MgmtFactory.getTokenProcessorManager().getInstances());
        instances.addAll(MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances());
        instances.addAll(MgmtFactory.getAuthnSelectorManager().getInstances());
        instances.addAll(MgmtFactory.getCredentialValidatorManager().getInstances());
        for (ConfigurablePluginInstance pluginInstance : instances) {
            if (!this.isCertUsedByPluginInstance(alias, pluginInstance, certFieldDescriptorClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isCertUsedByAdapters(String alias, Class<? extends SelectFieldDescriptor> certFieldDescriptorClass) {
        for (AuthnAdapterInstance adapterInstance : MgmtFactory.getIdpAdapterManager().getInstances()) {
            if (!this.isCertUsedByPluginInstance(alias, adapterInstance, certFieldDescriptorClass)) continue;
            return true;
        }
        for (AuthnAdapterInstance adapterInstance : MgmtFactory.getSpAdapterManager().getInstances()) {
            if (!this.isCertUsedByPluginInstance(alias, adapterInstance, certFieldDescriptorClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isCertUsedByTokenPlugins(String alias, Class<? extends SelectFieldDescriptor> certFieldDescriptorClass) {
        if (this.isCertUsedByTokenPlugins(alias, TokenProcessorManager.class, certFieldDescriptorClass)) {
            return true;
        }
        return this.isCertUsedByTokenPlugins(alias, TokenGeneratorManager.class, certFieldDescriptorClass);
    }

    private boolean isCertUsedByTokenPlugins(String alias, Class<? extends TokenPluginManager<?>> tokenPluginManagerClass, Class<? extends SelectFieldDescriptor> certFieldDescriptorClass) {
        TokenPluginManager<?> tokenPluginManager = GlobalRegistry.getService(tokenPluginManagerClass);
        for (ConfigurablePluginInstance pluginInstance : tokenPluginManager.getInstances()) {
            if (!this.isCertUsedByPluginInstance(alias, pluginInstance, certFieldDescriptorClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isCertUsedByPluginInstance(String alias, ConfigurablePluginInstance pluginInstance, Class<? extends SelectFieldDescriptor> certFieldDescClass) {
        GuiConfigDescriptor guiConfigDescriptor;
        GuiConfigDescriptorBuilder guiDescriptorBuilder;
        Configuration configuration = ConfigurationUtil.createAdminCompositeConfiguration(pluginInstance);
        if (pluginInstance instanceof CustomDataSource) {
            CustomDataSource customDataSource = (CustomDataSource)pluginInstance;
            if (customDataSource.getDriver() == null) {
                MgmtFactory.getDataSourceManager().loadCustomDataSourceDriver(customDataSource);
            }
            guiDescriptorBuilder = customDataSource.getDriver().getSourceDescriptor().getGuiConfigDescriptorBuilder();
        } else {
            guiDescriptorBuilder = pluginInstance.getDescriptor().getGuiConfigDescriptorBuilder();
        }
        if (configuration == null) {
            guiConfigDescriptor = guiDescriptorBuilder.buildNewGuiDescriptor();
            configuration = new Configuration();
        } else {
            guiConfigDescriptor = guiDescriptorBuilder.buildConfiguredGuiDescriptor(configuration);
        }
        List fields = guiConfigDescriptor.getFields();
        boolean inUse = this.isCertUsedByFieldList(alias, fields, (FieldList)configuration, certFieldDescClass);
        List advanced = guiConfigDescriptor.getAdvancedFields();
        inUse = inUse || this.isCertUsedByFieldList(alias, advanced, configuration.getAdvancedFields(), certFieldDescClass);
        for (TableDescriptor tableDescriptor : guiConfigDescriptor.getTables()) {
            List rowFields = tableDescriptor.getRowFields();
            Table table = configuration.getTable(tableDescriptor.getName());
            for (Row row : table != null ? table.getRows() : Collections.emptyList()) {
                inUse = inUse || this.isCertUsedByFieldList(alias, rowFields, (FieldList)row, certFieldDescClass);
            }
        }
        return inUse;
    }

    private boolean isCertUsedByFieldList(String alias, List<FieldDescriptor> fieldDescriptors, FieldList fieldList, Class<? extends SelectFieldDescriptor> certFieldDescriptorClass) {
        HashSet<String> certFieldDescriptorNames = new HashSet<String>();
        for (FieldDescriptor guiField : fieldDescriptors) {
            if (!certFieldDescriptorClass.isInstance(guiField) || guiField.getName() == null) continue;
            certFieldDescriptorNames.add(guiField.getName());
        }
        for (Field configurationField : fieldList.getFields()) {
            String configurationFieldValue;
            String configurationFieldName = configurationField.getName();
            if (!certFieldDescriptorNames.contains(configurationFieldName) || (configurationFieldValue = configurationField.getValue()) == null || !configurationFieldValue.equals(alias)) continue;
            return true;
        }
        return false;
    }

    private boolean isCertUsedByDataSources(String alias) {
        for (LdapDataSource ldapDs : MgmtFactory.getDataSourceManager().getLdapDataSources()) {
            if (!StringUtils.equals((String)alias, (String)ldapDs.getClientTlsCertificate())) continue;
            return true;
        }
        for (CustomDataSource customDs : MgmtFactory.getDataSourceManager().getCustomDataSources()) {
            if (!this.isCertUsedByPluginInstance(alias, customDs, CertificateSelectionFieldDescriptor.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isDataSourceUsedByAdapters(String dataSourceId) {
        ArrayList<String> idpAdapterInstanceIds = new ArrayList<String>();
        for (IdpAuthnAdapterInstance adapterInstance : MgmtFactory.getIdpAdapterManager().getInstances()) {
            idpAdapterInstanceIds.add(adapterInstance.getId());
        }
        if (this.isDataSourceUsedByAdapter(dataSourceId, idpAdapterInstanceIds, Role.IDP)) {
            return true;
        }
        ArrayList<String> spAdapterInstanceIds = new ArrayList<String>();
        for (AuthnAdapterInstance adapterInstance : MgmtFactory.getSpAdapterManager().getInstances()) {
            spAdapterInstanceIds.add(adapterInstance.getId());
        }
        return this.isDataSourceUsedByAdapter(dataSourceId, spAdapterInstanceIds, Role.SP);
    }

    public List<AuthnAdapterInstance> getSpAdaptersWithDSInUse(String id) {
        LinkedList<AuthnAdapterInstance> instances = new LinkedList<AuthnAdapterInstance>();
        for (AuthnAdapterInstance adapterInstance : MgmtFactory.getSpAdapterManager().getInstances()) {
            if (!this.isDataSourceUsedByPluginInstance(id, adapterInstance)) continue;
            instances.add(adapterInstance);
        }
        return instances;
    }

    public List<IdpAuthnAdapterInstance> getIdpAdaptersWithDSInUse(String id) {
        LinkedList<IdpAuthnAdapterInstance> instances = new LinkedList<IdpAuthnAdapterInstance>();
        for (IdpAuthnAdapterInstance adapterInstance : MgmtFactory.getIdpAdapterManager().getInstances()) {
            if (!this.isDataSourceUsedByPluginInstance(id, adapterInstance)) continue;
            instances.add(adapterInstance);
        }
        return instances;
    }

    public List<Direct2SpAdapterMapping> getAdapter2AdapterMappingsWithDSInUse(String id) {
        return MgmtFactory.getAdapter2AdapterManager().getMappingsUsingDataSource(id);
    }

    public List<Token2TokenMapping> getToken2TokenMappingsWithDSInUse(String id) {
        return MgmtFactory.getToken2TokenManager().getMappingsUsingDataSource(id);
    }

    private boolean isDataSourceUsedByTokenPlugins(String dataSourceId) {
        if (this.isDataSourceUsedByTokenPlugins(dataSourceId, TokenProcessorManager.class)) {
            return true;
        }
        return this.isDataSourceUsedByTokenPlugins(dataSourceId, TokenGeneratorManager.class);
    }

    private boolean isDataSourceUsedByTokenPlugins(String dataSourceId, Class<? extends TokenPluginManager<?>> tokenPluginManagerClass) {
        TokenPluginManager<?> tokenPluginManager = GlobalRegistry.getService(tokenPluginManagerClass);
        for (ConfigurablePluginInstance pluginInstance : tokenPluginManager.getInstances()) {
            if (!this.isDataSourceUsedByPluginInstance(dataSourceId, pluginInstance)) continue;
            return true;
        }
        return false;
    }

    public List<ConfigurablePluginInstance> getTokenPluginsWithDSInUseString(String id, Class<? extends TokenPluginManager<?>> tokenPluginManagerClass) {
        LinkedList<ConfigurablePluginInstance> plugins = new LinkedList<ConfigurablePluginInstance>();
        TokenPluginManager<?> tokenPluginManager = GlobalRegistry.getService(tokenPluginManagerClass);
        for (ConfigurablePluginInstance pluginInstance : tokenPluginManager.getInstances()) {
            if (!this.isDataSourceUsedByPluginInstance(id, pluginInstance)) continue;
            plugins.add(pluginInstance);
        }
        return plugins;
    }

    private boolean isDataSourceUsedByAdapter(String dataSourceId, List<String> adapterInstanceIds, Role adapterRole) {
        for (String adapterInstanceId : adapterInstanceIds) {
            AuthnAdapterInstance adapterInstance = adapterRole == Role.IDP ? (AuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(adapterInstanceId) : (AuthnAdapterInstance)MgmtFactory.getSpAdapterManager().getInstance(adapterInstanceId);
            if (!this.isDataSourceUsedByPluginInstance(dataSourceId, adapterInstance)) continue;
            return true;
        }
        return false;
    }

    private boolean isDataSourceUsedByPluginInstance(String dataSourceId, ConfigurablePluginInstance pluginInstance) {
        Configuration configuration = ConfigurationUtil.createAdminCompositeConfiguration(pluginInstance);
        GuiConfigDescriptorBuilder guiDescriptorBuilder = pluginInstance.getDescriptor().getGuiConfigDescriptorBuilder();
        GuiConfigDescriptor guiConfigDescriptor = configuration == null ? guiDescriptorBuilder.buildNewGuiDescriptor() : guiDescriptorBuilder.buildConfiguredGuiDescriptor(configuration);
        ArrayList adapterGuiFields = new ArrayList();
        adapterGuiFields.addAll(guiConfigDescriptor.getFields());
        adapterGuiFields.addAll(guiConfigDescriptor.getAdvancedFields());
        ArrayList<FieldDescriptor> adapterDataStores = new ArrayList<FieldDescriptor>();
        for (Object field : adapterGuiFields) {
            if (!(field instanceof LdapDatastoreFieldDescriptor) && !(field instanceof JdbcDatastoreFieldDescriptor) && !(field instanceof CustomSourceFieldDescriptor)) continue;
            adapterDataStores.add((FieldDescriptor)field);
        }
        ArrayList configurationList = new ArrayList();
        configurationList.addAll(pluginInstance.getConfiguration().getFields());
        configurationList.addAll(pluginInstance.getConfiguration().getAdvancedFields().getFields());
        for (FieldDescriptor dataStoreGuiField : adapterDataStores) {
            for (Field field : configurationList) {
                String dataStoreGuiFieldName = dataStoreGuiField.getName();
                String configurationFieldName = field.getName();
                String configurationFieldValue = field.getValue();
                if (dataStoreGuiFieldName == null || !dataStoreGuiFieldName.equals(configurationFieldName) || configurationFieldValue == null || !configurationFieldValue.equals(dataSourceId)) continue;
                return true;
            }
        }
        if (pluginInstance instanceof IdpAuthnAdapterInstance) {
            AttributeMapping attributeMapping = ((IdpAuthnAdapterInstance)pluginInstance).getAttributeMapping();
            return this.isDataSourceUsedBy(attributeMapping, dataSourceId);
        }
        return false;
    }

    private boolean isDataSourceUsedBy(AttributeMapping attribMapping, String id) {
        List<AttributeSource> attribSources;
        boolean inUse = false;
        if (attribMapping != null && (attribSources = attribMapping.getAttributeSources()) != null) {
            for (AttributeSource attribSrc : attribSources) {
                DataSource ds;
                if (attribSrc == null || attribSrc.getType().equalsIgnoreCase(DataSource.DSType.None.getName()) || (ds = attribSrc.getDataSource()) == null || !ds.getId().equals(id)) continue;
                inUse = true;
            }
        }
        return inUse;
    }

    public boolean isTrustedCAUsedByOAuthClient(X509Certificate cert) {
        return !this.getClientsWithCertInUse(cert).isEmpty();
    }

    public List<Client> getClientsWithCertInUse(X509Certificate cert) {
        LinkedList<Client> clients = new LinkedList<Client>();
        try {
            boolean isCertExpired;
            ClientManager clientManager = GlobalRegistry.getService(ClientManager.class);
            TrustedCAsManager tcm = MgmtFactory.getTrustedCAsManager();
            Set<Cert> trustedCerts = tcm.getTrustedCAs();
            if (trustedCerts.size() == 1) {
                clients.addAll(clientManager.getClientsByTlsCertIssuer("Trust Any"));
            }
            if (!(isCertExpired = new Date().after(cert.getNotAfter()))) {
                clients.addAll(clientManager.getClientsByTlsCertIssuer(cert.getSubjectDN().getName()));
            }
        }
        catch (ClientManager.ClientManagementException e) {
            log.error((Object)e.getMessage());
        }
        return clients;
    }

    public boolean isCertInUseClientRegIssuerDefault(X509Certificate cert) {
        X500Principal configuredIssuerDn;
        String issuerDn = MgmtFactory.getClientSettingManager().getClientSetting().getClientCertIssuerDn();
        return issuerDn != null && !"Trust Any".equals(issuerDn) && X500Util.equals(configuredIssuerDn = new X500Principal(issuerDn), cert.getSubjectX500Principal());
    }

    public List<IdpAuthnAdapterInstance> getIdpAdapterInstancesUsingResource(PluginManagementSupport.PluginManagementType resourceType, String resourceInstanceId) {
        HashMap result = new HashMap();
        Collection allInstances = MgmtFactory.getIdpAdapterManager().getInstances();
        if (PluginManagementSupport.PluginManagementType.IDP_ADAPTER.equals((Object)resourceType)) {
            this.checkForChildReferences(allInstances, resourceInstanceId).forEach(instance -> result.put(instance.getId(), instance));
        }
        this.getPluginInstancesUsingResource(allInstances, resourceType, resourceInstanceId).forEach(instance -> result.put(instance.getId(), instance));
        return result.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<DataSource> getDataSourceInstancesUsingResource(PluginManagementSupport.PluginManagementType resourceType, String resourceInstanceId) {
        if (!PluginManagementSupport.PluginManagementType.SECRET_MANAGER.equals((Object)resourceType)) {
            return Collections.emptyList();
        }
        HashMap<String, DataSource> result = new HashMap<String, DataSource>();
        Collection<JdbcDataSource> jdbcDsInstances = MgmtFactory.getDataSourceManager().getJdbcDataSources();
        for (JdbcDataSource jdbcDataSource : jdbcDsInstances) {
            if (!StringUtils.equals((String)resourceInstanceId, (String)SecretReferenceUtil.getSecretManagerId((String)jdbcDataSource.getPassword()))) continue;
            result.put(jdbcDataSource.getId(), jdbcDataSource);
        }
        Collection<LdapDataSource> ldapDsInstances = MgmtFactory.getDataSourceManager().getLdapDataSources();
        for (LdapDataSource ldapDsInstance : ldapDsInstances) {
            if (!StringUtils.equals((String)resourceInstanceId, (String)SecretReferenceUtil.getSecretManagerId((String)ldapDsInstance.getCredentials()))) continue;
            result.put(ldapDsInstance.getId(), ldapDsInstance);
        }
        Collection collection = MgmtFactory.getCustomDataSourceManager().getInstances();
        this.getPluginInstancesUsingResource(collection, resourceType, resourceInstanceId).forEach(instance -> result.put(instance.getId(), instance));
        return new ArrayList<DataSource>(result.values());
    }

    public List<AuthorizationDetailType> getAuthorizationDetailTypesUsingResource(PluginManagementSupport.PluginManagementType resourceType, String resourceInstanceId) {
        if (!PluginManagementSupport.PluginManagementType.AUTHORIZATION_DETAIL_PROCESSOR.equals((Object)resourceType)) {
            return Collections.emptyList();
        }
        return MgmtFactory.getAuthorizationDetailTypesManager().getAllAuthorizationDetailTypes().stream().filter(type -> StringUtils.equals((String)resourceInstanceId, (String)type.getAuthorizationDetailProcessorId())).collect(Collectors.toList());
    }

    public List<TokenProcessorInstance> getTokenProcessorInstancesUsingResource(PluginManagementSupport.PluginManagementType resourceType, String resourceInstanceId) {
        HashMap result = new HashMap();
        Collection allInstances = MgmtFactory.getTokenProcessorManager().getInstances();
        if (PluginManagementSupport.PluginManagementType.TOKEN_PROCESSOR.equals((Object)resourceType)) {
            this.checkForChildReferences(allInstances, resourceInstanceId).forEach(instance -> result.put(instance.getId(), instance));
        }
        this.getPluginInstancesUsingResource(allInstances, resourceType, resourceInstanceId).forEach(instance -> result.put(instance.getId(), instance));
        return result.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<BearerAccessTokenMgmtPluginInstance> getAccessTokenManagersUsingResource(PluginManagementSupport.PluginManagementType resourceType, String resourceInstanceId) {
        HashMap result = new HashMap();
        Collection allInstances = MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances();
        if (PluginManagementSupport.PluginManagementType.ACCESS_TOKEN_MANAGEMENT.equals((Object)resourceType)) {
            this.checkForChildReferences(allInstances, resourceInstanceId).forEach(instance -> result.put(instance.getId(), instance));
        }
        this.getPluginInstancesUsingResource(allInstances, resourceType, resourceInstanceId).forEach(instance -> result.put(instance.getId(), instance));
        return result.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public <T extends BasePluginInstance> List<T> getPluginInstancesUsingAuthnSource(Collection<T> instances, AuthnSourceKey sourceKey) {
        FieldReferenceChecker<AuthnSourceSelectionFieldDescriptor> checker = new FieldReferenceChecker<AuthnSourceSelectionFieldDescriptor>(AuthnSourceSelectionFieldDescriptor.class, (descriptor, fieldValue) -> sourceKey.equals(AuthnSourceKeyUtil.storageKeyToSourceKey(fieldValue)));
        return this.getPluginInstancesUsingResource(instances, checker);
    }

    public <T extends ConfigurablePluginInstance> List<T> getPluginInstancesUsingResource(Collection<T> instances, FieldReferenceChecker checker) {
        LinkedList<ConfigurablePluginInstance> referencingInstances = new LinkedList<ConfigurablePluginInstance>();
        for (ConfigurablePluginInstance instance : instances) {
            if (!this.pluginInstanceUsesResource(instance, checker)) continue;
            referencingInstances.add(instance);
        }
        return referencingInstances;
    }

    public boolean pluginInstanceUsesResource(ConfigurablePluginInstance instance, FieldReferenceChecker checker) {
        Configuration configuration = ConfigurationUtil.createAdminCompositeConfiguration(instance);
        if (configuration == null) {
            return false;
        }
        GuiConfigDescriptor guiConfigDescriptor = null;
        PluginDescriptor pluginDescriptor = instance.getDescriptor();
        if (pluginDescriptor == null) {
            guiConfigDescriptor = instance.getGuiDescriptor();
        } else {
            GuiConfigDescriptorBuilder builder = instance.getDescriptor().getGuiConfigDescriptorBuilder();
            guiConfigDescriptor = builder.buildConfiguredGuiDescriptor(configuration);
        }
        return this.isResourceInUseByPluginFields(guiConfigDescriptor.getFields(), (FieldList)configuration, checker) || this.isResourceInUseByPluginFields(guiConfigDescriptor.getAdvancedFields(), (FieldList)configuration, checker) || this.isResourceInUseByPluginTables(guiConfigDescriptor.getTables(), configuration, checker);
    }

    public boolean isResourceInUseByPluginFields(List<FieldDescriptor> pluginFieldDescriptors, FieldList fieldList, FieldReferenceChecker checker) {
        if (pluginFieldDescriptors != null) {
            for (FieldDescriptor fieldDesc : pluginFieldDescriptors) {
                Field field;
                if (!checker.checkDescriptor(fieldDesc) || (field = fieldList.getField(fieldDesc.getName())) == null || !checker.checkFieldValue(fieldDesc, field.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private <T extends ConfigurablePluginInstance> List<T> checkForChildReferences(Collection<T> instances, String resourceInstanceId) {
        LinkedList<ConfigurablePluginInstance> childInstances = new LinkedList<ConfigurablePluginInstance>();
        for (ConfigurablePluginInstance instance : instances) {
            String parentId = instance.getParentId();
            if (parentId == null || !parentId.equals(resourceInstanceId)) continue;
            childInstances.add(instance);
        }
        return childInstances;
    }

    private <T extends ConfigurablePluginInstance> List<T> getPluginInstancesUsingResource(Collection<T> instances, PluginManagementSupport.PluginManagementType resourceType, String resourceInstanceId) {
        FieldReferenceChecker<FieldDescriptor> checker;
        BiPredicate<FieldDescriptor, String> valueChecker = (descriptor, fieldValue) -> StringUtils.equals((String)resourceInstanceId, (String)fieldValue);
        switch (resourceType) {
            case PCV: {
                checker = new FieldReferenceChecker<FieldDescriptor>(PasswordCredentialValidatorFieldDescriptor.class, valueChecker);
                break;
            }
            case ACCESS_TOKEN_MANAGEMENT: {
                checker = new FieldReferenceChecker<FieldDescriptor>(BearerAccessTokenFieldDescriptor.class, valueChecker);
                break;
            }
            case NOTIFICATION_SENDER: {
                checker = new FieldReferenceChecker<FieldDescriptor>(NotificationSenderFieldDescriptor.class, valueChecker);
                break;
            }
            case SECRET_MANAGER: {
                valueChecker = (descriptor, fieldValue) -> StringUtils.equals((String)resourceInstanceId, (String)SecretReferenceUtil.getSecretManagerId((String)fieldValue));
                checker = new FieldReferenceChecker<FieldDescriptor>(SecretReferenceFieldDescriptor.class, valueChecker);
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        return this.getPluginInstancesUsingResource(instances, checker);
    }

    private boolean isResourceInUseByPluginTables(List<TableDescriptor> tableDescriptors, Configuration pluginConfiguration, FieldReferenceChecker checker) {
        if (tableDescriptors != null) {
            for (TableDescriptor tableDesc : tableDescriptors) {
                List rows;
                Table table;
                if (tableDesc.getRowFields() == null) continue;
                ArrayList<FieldDescriptor> matchingDescriptors = new ArrayList<FieldDescriptor>();
                for (FieldDescriptor descriptor : tableDesc.getRowFields()) {
                    if (!checker.checkDescriptor(descriptor)) continue;
                    matchingDescriptors.add(descriptor);
                }
                if (matchingDescriptors.isEmpty() || (table = pluginConfiguration.getTable(tableDesc.getName())) == null || (rows = table.getRows()) == null) continue;
                for (Row row : rows) {
                    if (!this.isResourceInUseByPluginFields(matchingDescriptors, (FieldList)row, checker)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<SpConnection> getSpConnectionsWithInstanceInUse(PluginManagementSupport.PluginManagementType resourceType, String instanceId) {
        if (resourceType == PluginManagementSupport.PluginManagementType.IDP_ADAPTER) {
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            return connectionManager.getSpConnectionsUsingAdapterInstance(instanceId);
        }
        return Collections.emptyList();
    }

    public Collection<Affiliation> getSpAffiliationsWithInstanceInUse(String entityId) {
        return MgmtFactory.getConnectionManager().getAffiliationsUsingSpConnection(entityId);
    }

    public List<IdpConnection> getIdpConnectionsWithInstanceInUse(PluginManagementSupport.PluginManagementType resourceType, String instanceId) {
        if (resourceType == PluginManagementSupport.PluginManagementType.SP_ADAPTER) {
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            return connectionManager.getIdpConnectionsUsingAdapterInstance(instanceId);
        }
        if (resourceType == PluginManagementSupport.PluginManagementType.IDENTITY_STORE_PROVISIONER) {
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            return connectionManager.getIdpConnectionsUsingIdentityStoreProvisionerInstance(instanceId);
        }
        return Collections.emptyList();
    }

    public List<Direct2SpAdapterMapping> getAdapter2AdapterWithAdapterInstanceInUse(PluginManagementSupport.PluginManagementType resourceType, String instanceId) {
        if (resourceType == PluginManagementSupport.PluginManagementType.IDP_ADAPTER) {
            Adapter2AdapterManager adapter2AdapterManager = MgmtFactory.getAdapter2AdapterManager();
            return adapter2AdapterManager.getMappingsUsingSource(instanceId);
        }
        if (resourceType == PluginManagementSupport.PluginManagementType.SP_ADAPTER) {
            Adapter2AdapterManager adapter2AdapterManager = MgmtFactory.getAdapter2AdapterManager();
            return adapter2AdapterManager.getMappingsUsingTarget(instanceId);
        }
        return Collections.emptyList();
    }

    public List<AuthnSelectionTree> getAuthnSelectionTreesWithAdapterInstanceInUse(PluginManagementSupport.PluginManagementType resourceType, String instanceId) {
        if (resourceType == PluginManagementSupport.PluginManagementType.IDP_ADAPTER) {
            AuthnSelectionConfigManager authnSelectorConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
            return authnSelectorConfigManager.getAuthnSelectionTreesUsingAuthnSource(new AdapterAuthnSourceKey(instanceId));
        }
        return Collections.emptyList();
    }

    public List<AuthnSelectionTree> getAuthnSelectionTreesWithConnectionInUse(String connectionId) {
        AuthnSelectionConfigManager authnSelectorConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
        return authnSelectorConfigManager.getAuthnSelectionTreesUsingAuthnSource(new IdpConnAuthnSourceKey(connectionId));
    }

    public List<AuthnSelectionTree> getAuthnSelectionTreesWithFragmentInUse(String fragmentId) {
        AuthnSelectionConfigManager authnSelectorConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
        return authnSelectorConfigManager.getAuthnSelectionTreesUsingFragment(fragmentId);
    }

    public List<AuthnSelectionTree> getAuthnSelectionTreesWithPolicyContractInUse(String contractId) {
        AuthnSelectionConfigManager authnSelectorConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
        return authnSelectorConfigManager.getAuthnSelectionTreesUsingPolicyContract(contractId);
    }

    public List<AuthnSelectionTree> getAuthnSelectionTreesWithLocalIdentityInUse(String localIdentityId) {
        AuthnSelectionConfigManager authnSelectorConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
        return authnSelectorConfigManager.getAuthnSelectionTreesUsingLocalIdentity(localIdentityId);
    }

    public List<PolicyFragment> getFragmentsWithAdapterInstanceInUse(PluginManagementSupport.PluginManagementType resourceType, String instanceId) {
        if (resourceType == PluginManagementSupport.PluginManagementType.IDP_ADAPTER) {
            return MgmtFactory.getPolicyFragmentManager().getFragmentsUsingAuthnSource(new AdapterAuthnSourceKey(instanceId));
        }
        return Collections.emptyList();
    }

    public List<PolicyFragment> getFragmentsWithConnectionInUse(String connectionId) {
        return MgmtFactory.getPolicyFragmentManager().getFragmentsUsingAuthnSource(new IdpConnAuthnSourceKey(connectionId));
    }

    public List<PolicyFragment> getFragmentsWithFragmentInUse(String fragmentId) {
        return MgmtFactory.getPolicyFragmentManager().getFragmentsUsingFragment(fragmentId);
    }

    public List<PolicyFragment> getFragmentsWithPolicyContractInUse(String contractId) {
        return MgmtFactory.getPolicyFragmentManager().getFragmentsUsingPolicyContract(contractId);
    }

    public List<PolicyFragment> getFragmentsWithLocalIdentityInUse(String localIdentityId) {
        return MgmtFactory.getPolicyFragmentManager().getFragmentsUsingLocalIdentity(localIdentityId);
    }

    public List<PolicyFragment> getFragmentsWithDataSourceInUse(String dataSourceId) {
        return MgmtFactory.getPolicyFragmentManager().getFragmentsUsingDataSource(dataSourceId);
    }

    public boolean isDefaultAdapterForAuthnSelection(PluginManagementSupport.PluginManagementType resourceType, String instanceId) {
        if (resourceType == PluginManagementSupport.PluginManagementType.IDP_ADAPTER) {
            AuthnSelectionConfigManager authnSelectorConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
            return authnSelectorConfigManager.getDefaultAuthnSourceKeys().contains(new AdapterAuthnSourceKey(instanceId));
        }
        return false;
    }

    public boolean isDefaultConnectionForAuthnSelection(String connectionId) {
        AuthnSelectionConfigManager authnSelectorConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
        return authnSelectorConfigManager.getDefaultAuthnSourceKeys().contains(new IdpConnAuthnSourceKey(connectionId));
    }

    public UserKeyAttrMapping getAdapterToUserKeyMappingWithAdapterInstanceInUse(String instanceId) {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        return authzServerManager.getAdapterToUserKeyMapping(instanceId);
    }

    public List<AuthnAdapterInstance> getCompositeAdaptersUsingInstance(String instanceId) {
        LinkedList<AuthnAdapterInstance> instances = new LinkedList<AuthnAdapterInstance>();
        for (AuthnAdapterInstance instance : MgmtFactory.getIdpAdapterManager().getInstances()) {
            IdpAuthenticationAdapter adapter = MgmtFactory.getAdapterManager().getIdpAuthnAdapter(instance.getId());
            if (!(adapter instanceof AdapterUser) || !((AdapterUser)adapter).isInUse(instanceId)) continue;
            instances.add(instance);
        }
        return instances;
    }

    public List<String> getDNWithIdpConnectionInUse(IdpConnection conn) {
        return MgmtFactory.getDNtoIdPMappingsManager().getDNUsingConnection(conn);
    }

    public boolean isPolicyUsedWithAnyClients(String policyID) {
        return this.isPolicyUsedWithAnyClients(policyID, null);
    }

    public boolean isPolicyUsedWithAnyClients(String policyID, String defaultPolicyID) {
        return !this.getClientsUsingPolicy(policyID, defaultPolicyID).isEmpty();
    }

    public boolean isPolicyUsedInClientSettings(String policyID) {
        boolean isPolicyInUse = this.getPoliciesCount() > 1 ? this.isPolicyUsedInClientSettings(policyID, this.getDefaultPolicyId()) : this.isPolicyUsedInClientSettings(policyID, null);
        return isPolicyInUse;
    }

    public boolean isPolicyUsedInClientSettings(String policyID, String defaultPolicyID) {
        if (policyID == null) {
            return false;
        }
        ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
        if (clientSetting == null) {
            return false;
        }
        String clientSettingPolicyGroupId = clientSetting.getPolicyGroupId();
        return policyID.equals(clientSettingPolicyGroupId) || clientSetting.isEnableDynamicClientRegistration() && StringUtils.isBlank((String)clientSettingPolicyGroupId) && policyID.equals(defaultPolicyID);
    }

    public boolean isCibaPolicyUsedInClientSettings(String policyID) {
        boolean isCibaPolicyInUse = this.getCibaPoliciesCount() > 1 ? this.isCibaPolicyUsedInClientSettings(policyID, this.getDefaultPolicyId()) : this.isCibaPolicyUsedInClientSettings(policyID, null);
        return isCibaPolicyInUse;
    }

    public boolean isCibaPolicyUsedInClientSettings(String policyID, String defaultPolicyID) {
        if (policyID == null) {
            return false;
        }
        ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
        if (clientSetting == null) {
            return false;
        }
        String clientSettingDefaultId = clientSetting.getCibaPolicyId();
        return policyID.equals(clientSettingDefaultId) || clientSetting.isEnableDynamicClientRegistration() && StringUtils.isBlank((String)clientSettingDefaultId) && policyID.equals(defaultPolicyID);
    }

    public boolean isCibaPolicyUsedWithAnyClients(String policyID) {
        return this.isCibaPolicyUsedWithAnyClients(policyID, null);
    }

    public boolean isCibaPolicyUsedWithAnyClients(String policyID, String defaultPolicyID) {
        return !this.getClientsUsingCibaPolicy(policyID, defaultPolicyID).isEmpty();
    }

    public boolean isAuthnApiApplicationUsed(String appId, String defaultAppId) {
        return !this.getAuthnPoliciesUsingAuthnApiApp(appId).isEmpty() || appId.equals(defaultAppId);
    }

    public List<Client> getClientsUsingPolicy(String policyID) {
        return this.getClientsUsingPolicy(policyID, null);
    }

    public List<Client> getClientsUsingPolicy(String policyID, String defaultPolicyID) {
        ClientManager clientManager = GlobalRegistry.getService(ClientManager.class);
        LinkedList<Client> clientsUsingPolicy = new LinkedList<Client>();
        try {
            if (defaultPolicyID != null && defaultPolicyID.equals(policyID)) {
                clientsUsingPolicy.addAll(clientManager.getClientsByPolicyGroupId(null));
            }
            clientsUsingPolicy.addAll(clientManager.getClientsByPolicyGroupId(policyID));
        }
        catch (ClientManager.ClientManagementException e) {
            log.error((Object)e.getMessage());
        }
        return clientsUsingPolicy;
    }

    public List<Client> getClientsUsingCibaPolicy(String policyID, String defaultPolicyID) {
        ClientManager clientManager = GlobalRegistry.getService(ClientManager.class);
        LinkedList<Client> clientsUsingPolicy = new LinkedList<Client>();
        try {
            if (defaultPolicyID != null && defaultPolicyID.equals(policyID)) {
                clientsUsingPolicy.addAll(clientManager.getClientsByCIBAPolicyId(null));
            }
            clientsUsingPolicy.addAll(clientManager.getClientsByCIBAPolicyId(policyID));
        }
        catch (ClientManager.ClientManagementException e) {
            log.error((Object)e.getMessage());
        }
        return clientsUsingPolicy;
    }

    public List<String> getAuthnPoliciesUsingAuthnApiApp(String appId) {
        AuthnSelectionConfigManager configManager = MgmtFactory.getAuthnSelectionConfigManager();
        return configManager.getAuthnSelectionTrees().stream().filter(tree -> appId.equals(tree.getOverrideAuthnApiApplicationId())).map(AuthnSelectionTree::getName).collect(Collectors.toList());
    }

    private String getDefaultPolicyId() {
        OpenIdConnectProviderPolicyManager OICPolicyManager = GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        return OICPolicyManager.getDefaultPolicyId();
    }

    private int getPoliciesCount() {
        OpenIdConnectProviderPolicyManager OICPolicyManager = GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        if (OICPolicyManager.getPolicy() != null) {
            return OICPolicyManager.getPolicy().getPolicyGroups().size();
        }
        return 0;
    }

    private int getCibaPoliciesCount() {
        CibaServerPolicyManager manager = GlobalRegistry.getService(CibaServerPolicyManager.class);
        if (manager.getCibaServerPolicy() != null && manager.getCibaServerPolicy().getRequestHandlingPolicies() != null) {
            return manager.getCibaServerPolicy().getRequestHandlingPolicies().size();
        }
        return 0;
    }

    private String getDefaultCibaPolicyId() {
        CibaServerPolicyManager manager = GlobalRegistry.getService(CibaServerPolicyManager.class);
        return manager.getCibaServerPolicy().getDefaultRequestHandlingPolicyId();
    }

    public List<IdpAuthnAdapterInstance> getIdpAdaptersWithLocalIdentityInUse(String id) {
        LinkedList<IdpAuthnAdapterInstance> instances = new LinkedList<IdpAuthnAdapterInstance>();
        Collection idpAdapters = MgmtFactory.getIdpAdapterManager().getInstances();
        for (IdpAuthnAdapterInstance idpAdapter : idpAdapters) {
            Field lipField = idpAdapter.getConfiguration().getField("Local Identity Profile");
            if (lipField == null || !lipField.getValue().equalsIgnoreCase(id)) continue;
            instances.add(idpAdapter);
        }
        return instances;
    }

    public List<IdpAuthnAdapterInstance> getIdpAdaptersWithApcInUse(String id) {
        LinkedList<IdpAuthnAdapterInstance> instances = new LinkedList<IdpAuthnAdapterInstance>();
        Collection adapters = MgmtFactory.getIdpAdapterManager().getInstances();
        for (IdpAuthnAdapterInstance adapter : adapters) {
            Field field = adapter.getConfiguration().getField("Password Reset Policy Contract");
            if (field == null || !id.equalsIgnoreCase(field.getValue())) {
                field = adapter.getConfiguration().getField("Change Password Policy Contract");
            }
            if (field == null || !field.getValue().equalsIgnoreCase(id)) continue;
            instances.add(adapter);
        }
        return instances;
    }

    public boolean isContractInUse(String id, ConnectionManager connectionManager) {
        if (StringUtils.isNotBlank((String)id)) {
            for (SpConnection spConnection : connectionManager.getFilteredSpConnections()) {
                String connectionContractId;
                if (!spConnection.doesWsTrustSettingsExist() || !spConnection.getWsTrustSettings().isRequestContractDefined() || !id.equals(connectionContractId = spConnection.getWsTrustSettings().getRequestContractId())) continue;
                return true;
            }
        }
        return false;
    }

    public List<AuthnApiApplication> getAuthnApiApplicationsUsingClient(String clientId) {
        ArrayList<AuthnApiApplication> result = new ArrayList<AuthnApiApplication>();
        if (!MgmtFactory.getAuthnApiManager().getSettings().isRestrictAccessToRedirectlessMode()) {
            return result;
        }
        for (AuthnApiApplication app : MgmtFactory.getAuthnApiManager().getApiApplications()) {
            if (app.getClientIdForRedirectlessMode() == null || !app.getClientIdForRedirectlessMode().equals(clientId)) continue;
            result.add(app);
        }
        result.sort(Comparator.comparing(AuthnApiApplication::getName));
        return result;
    }

    public List<PasswordCredentialValidatorInstance> getPCVInstancesUsingResource(Collection<PasswordCredentialValidatorInstance> instances, PluginManagementSupport.PluginManagementType resourceType, String resourceInstanceId) {
        HashMap result = new HashMap();
        if (PluginManagementSupport.PluginManagementType.PCV.equals((Object)resourceType)) {
            result.putAll(this.checkForChildReferences(instances, resourceInstanceId).stream().collect(Collectors.toMap(ConfigAbstract::getId, Function.identity())));
        }
        result.putAll(this.getPluginInstancesUsingResource(instances, resourceType, resourceInstanceId).stream().collect(Collectors.toMap(ConfigAbstract::getId, Function.identity())));
        return new ArrayList<PasswordCredentialValidatorInstance>(result.values());
    }

    public List<PasswordCredentialValidatorInstance> getPCVInstancesUsingResource(PluginManagementSupport.PluginManagementType resourceType, String resourceInstanceId) {
        return this.getPCVInstancesUsingResource(MgmtFactory.getCredentialValidatorManager().getInstances(), resourceType, resourceInstanceId);
    }

    public static class FieldReferenceChecker<T extends FieldDescriptor> {
        private final Class<? extends FieldDescriptor> descriptorClass;
        private BiPredicate<T, String> fieldValueChecker;

        public FieldReferenceChecker(Class<T> descriptorClass, BiPredicate<T, String> fieldValueChecker) {
            this.descriptorClass = descriptorClass;
            this.fieldValueChecker = fieldValueChecker;
        }

        public boolean checkDescriptor(FieldDescriptor descriptor) {
            return this.descriptorClass.isInstance(descriptor);
        }

        public boolean checkFieldValue(T descriptor, String fieldValue) {
            return this.fieldValueChecker.test(descriptor, fieldValue);
        }
    }
}

