/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.captcha.ReCaptchaV2InvisiblePluginHelper;
import com.pingidentity.email.SmtpNotificationPluginHelper;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.CaptchaProviderInstance;
import org.sourceid.saml20.domain.CaptchaSettings;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.CaptchaManager;
import org.sourceid.saml20.domain.mgmt.CaptchaProviderPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;
import org.sourceid.websso.authn.AuthnPolicyUtil;

public class InitMigrationUtil {
    private static final Log log = LogFactory.getLog(InitMigrationUtil.class);
    private static final NotificationPublisherPluginManager NOTI_PUB_PLUGIN_MGR = MgmtFactory.getNotificationPublisherPluginManager();
    private static final NotificationMgr NOTIFICATION_MGR = MgmtFactory.getNotificationMgr();
    private static final AuthnSelectionConfigManager AUTHN_POLICY_CONFIG_MGR = MgmtFactory.getAuthnSelectionConfigManager();
    private static final CaptchaProviderPluginManager CAPTCHA_PROVIDER_PLUGIN_MGR = MgmtFactory.getCaptchaProviderPluginManager();
    private static final CaptchaManager CAPTCHA_MGR = MgmtFactory.getCaptchaManager();

    public static void addPolicyIdToAuthnPolicies() {
        if (MgmtFactory.getMediator().isConsole()) {
            List<AuthnSelectionTree> existingAuthnSelectionTreeList = AUTHN_POLICY_CONFIG_MGR.getAuthnSelectionTrees();
            LinkedList<AuthnSelectionTree> newAuthnSelectionTreeList = new LinkedList<AuthnSelectionTree>();
            boolean hasPolicyUpdates = false;
            for (AuthnSelectionTree policy : existingAuthnSelectionTreeList) {
                AuthnSelectionTree copiedTree = AuthnSelectionTree.copyTree(policy);
                newAuthnSelectionTreeList.add(copiedTree);
                if (!StringUtils.isBlank((String)copiedTree.getId())) continue;
                copiedTree.setId(AuthnPolicyUtil.getDefault().generateId());
                hasPolicyUpdates = true;
            }
            if (hasPolicyUpdates) {
                log.info((Object)"Some authentication policies did not have a policy ID and a new identifier was generated for them.");
                AUTHN_POLICY_CONFIG_MGR.setAuthnSelectionTrees(newAuthnSelectionTreeList);
            }
        }
    }

    public static void createDefaultNotificationPublisher() {
        boolean hasEmailSettings;
        NotificationSenderPluginInstance defaultNotificationSender = (NotificationSenderPluginInstance)NOTI_PUB_PLUGIN_MGR.getDefaultInstance();
        NotificationSettings notificationSettings = NOTIFICATION_MGR.getNotificationSettings();
        boolean bl = hasEmailSettings = notificationSettings != null && notificationSettings.isNotificationEmailSettingsPopulated();
        if (defaultNotificationSender != null) {
            log.info((Object)"No default SMTP notification publisher created. A default notification publisher already defined.");
            return;
        }
        if (!hasEmailSettings) {
            log.info((Object)"No default SMTP notification publisher created. No previous SMTP settings (Email Configuration) exist.");
            return;
        }
        PluginDescriptor stmpNotificationPublisherDescriptor = InitMigrationUtil.getPluginDescriptorForSmtp();
        Configuration configuration = SmtpNotificationPluginHelper.translateNotificationSettings(notificationSettings);
        if (stmpNotificationPublisherDescriptor != null) {
            NOTI_PUB_PLUGIN_MGR.saveInstance(InitMigrationUtil.createNotificationSenderPluginInstance(stmpNotificationPublisherDescriptor, configuration));
            notificationSettings.clearEmailServerSettings();
            NOTIFICATION_MGR.saveNotificationSettings(notificationSettings);
            log.info((Object)"Default SMTP notification publisher with ID 'MigratedSmtpSettings' created. Legacy SMTP settings (Email Configuration) removed.");
        } else {
            log.error((Object)"Could not create default SMTP notification publisher to replace SMTP settings (Email Configuration). No SMTP notification publisher descriptor found.");
        }
    }

    public static NotificationSenderPluginInstance createNotificationSenderPluginInstance(PluginDescriptor stmpNotificationPublisherDescriptor, Configuration configuration) {
        NotificationSenderPluginInstance notificationSenderPluginInstance = new NotificationSenderPluginInstance();
        notificationSenderPluginInstance.setDescriptor(stmpNotificationPublisherDescriptor);
        notificationSenderPluginInstance.setConfiguration(configuration);
        notificationSenderPluginInstance.setName("Migrated SMTP Settings");
        notificationSenderPluginInstance.setId("MigratedSmtpSettings");
        notificationSenderPluginInstance.setDefaultInstance(true);
        return notificationSenderPluginInstance;
    }

    public static PluginDescriptor getPluginDescriptorForSmtp() {
        for (PluginDescriptor pluginDescriptor : NOTI_PUB_PLUGIN_MGR.getInstalledDescriptors()) {
            if (!"SMTP Notification Publisher".equals(pluginDescriptor.getType())) continue;
            return pluginDescriptor;
        }
        return null;
    }

    public static void createDefaultCaptchaProvider() {
        CaptchaProviderInstance defaultCaptchaProvider = (CaptchaProviderInstance)CAPTCHA_PROVIDER_PLUGIN_MGR.getDefaultInstance();
        CaptchaSettings captchaSettings = CAPTCHA_MGR.getCaptchaSettings();
        if (defaultCaptchaProvider != null) {
            log.info((Object)"No default reCAPTCHA v2 Invisible CAPTCHA provider created. A default CAPTCHA provider is already defined.");
            return;
        }
        if (captchaSettings == null || !captchaSettings.hasCaptchaSettings()) {
            log.info((Object)"No default reCAPTCHA v2 Invisible CAPTCHA provider created. No previous CAPTCHA settings exist.");
            return;
        }
        PluginDescriptor reCaptchaV2InvisibleDescriptor = InitMigrationUtil.getPluginDescriptorForReCaptchaV2Invisible();
        Configuration configuration = ReCaptchaV2InvisiblePluginHelper.toConfiguration(captchaSettings);
        if (reCaptchaV2InvisibleDescriptor != null) {
            CAPTCHA_PROVIDER_PLUGIN_MGR.saveInstance(InitMigrationUtil.createCaptchaProviderInstance(reCaptchaV2InvisibleDescriptor, configuration));
            captchaSettings.clearCaptchaSettings();
            CAPTCHA_MGR.saveCaptchaSettings(captchaSettings);
            log.info((Object)"Default reCAPTCHA v2 Invisible CAPTCHA provider with ID 'MigratedReCaptchaV2Settings' created. Legacy CAPTCHA settings removed.");
        } else {
            log.error((Object)"Could not create reCAPTCHA v2 Invisible CAPTCHA provider to replace CAPTCHA settings. No reCAPTCHA v2 Invisible descriptor found.");
        }
    }

    public static CaptchaProviderInstance createCaptchaProviderInstance(PluginDescriptor reCaptchaV2InvisibleDescriptor, Configuration configuration) {
        CaptchaProviderInstance captchaProviderInstance = new CaptchaProviderInstance();
        captchaProviderInstance.setDescriptor(reCaptchaV2InvisibleDescriptor);
        captchaProviderInstance.setConfiguration(configuration);
        captchaProviderInstance.setName("Migrated reCAPTCHA v2 Invisible Settings");
        captchaProviderInstance.setId("MigratedReCaptchaV2Settings");
        captchaProviderInstance.setDefaultInstance(true);
        return captchaProviderInstance;
    }

    public static PluginDescriptor getPluginDescriptorForReCaptchaV2Invisible() {
        for (PluginDescriptor pluginDescriptor : CAPTCHA_PROVIDER_PLUGIN_MGR.getInstalledDescriptors()) {
            if (!"reCAPTCHA v2 Invisible".equals(pluginDescriptor.getType())) continue;
            return pluginDescriptor;
        }
        return null;
    }
}

