/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.Obfuscator;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.sourceid.saml20.domain.KerberosKeySet;

public final class KerberosKeySetUtil {
    private KerberosKeySetUtil() {
    }

    public static String toEncryptedKeySet(KerberosKeySet kerberosKeySet) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return Obfuscator.obfuscate(objectMapper.writeValueAsString((Object)new SerializableKerberosKeySet(kerberosKeySet)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unexpected error serializing Kerberos keys", e);
        }
    }

    public static KerberosKeySet fromEncryptedKeySet(Instant deactivatedAt, String encryptedKeySet) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String deobfuscated = Obfuscator.deobfuscate(encryptedKeySet);
            SerializableKerberosKeySet serializableKerberosKeySet = (SerializableKerberosKeySet)objectMapper.readerFor(SerializableKerberosKeySet.class).readValue(deobfuscated);
            return new KerberosKeySet(deactivatedAt, serializableKerberosKeySet.getKerberosKeys(), serializableKerberosKeySet.getUsername(), serializableKerberosKeySet.getRealmName(), serializableKerberosKeySet.getHashedPassword());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unexpected error deserializing Kerberos keys", e);
        }
    }

    private static class SerializableKerberosKey {
        private String principalName;
        private int principalNameType;
        private String keyBytesB64;
        private int keyType;
        private int versionNumber;

        public SerializableKerberosKey() {
        }

        public SerializableKerberosKey(KerberosKey key) {
            this.principalName = key.getPrincipal().getName();
            this.principalNameType = key.getPrincipal().getNameType();
            this.keyType = key.getKeyType();
            this.versionNumber = key.getVersionNumber();
            this.keyBytesB64 = B64.encode((byte[])key.getEncoded());
        }

        public KerberosKey toKerberosKey() {
            KerberosPrincipal principal = new KerberosPrincipal(this.principalName, this.principalNameType);
            return new KerberosKey(principal, B64.decodeToBytes((String)this.keyBytesB64), this.keyType, this.versionNumber);
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        public void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        public int getPrincipalNameType() {
            return this.principalNameType;
        }

        public void setPrincipalNameType(int principalNameType) {
            this.principalNameType = principalNameType;
        }

        public String getKeyBytesB64() {
            return this.keyBytesB64;
        }

        public void setKeyBytesB64(String keyBytesB64) {
            this.keyBytesB64 = keyBytesB64;
        }

        public int getKeyType() {
            return this.keyType;
        }

        public void setKeyType(int keyType) {
            this.keyType = keyType;
        }

        public int getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(int versionNumber) {
            this.versionNumber = versionNumber;
        }
    }

    private static class SerializableKerberosKeySet {
        private String username;
        private String realmName;
        private String hashedPassword;
        private List<SerializableKerberosKey> keys;

        public SerializableKerberosKeySet() {
        }

        public SerializableKerberosKeySet(KerberosKeySet kerberosKeySet) {
            this.username = kerberosKeySet.getUsername();
            this.realmName = kerberosKeySet.getRealmName();
            this.hashedPassword = kerberosKeySet.getHashedPassword();
            this.keys = kerberosKeySet.getKeys().stream().map(SerializableKerberosKey::new).collect(Collectors.toList());
        }

        public String getUsername() {
            return this.username;
        }

        public String getRealmName() {
            return this.realmName;
        }

        public String getHashedPassword() {
            return this.hashedPassword;
        }

        @JsonIgnore
        public Set<KerberosKey> getKerberosKeys() {
            if (this.keys == null) {
                return null;
            }
            return this.keys.stream().map(key -> key.toKerberosKey()).collect(Collectors.toSet());
        }

        public List<SerializableKerberosKey> getKeys() {
            return this.keys;
        }

        public void setKeys(List<SerializableKerberosKey> keys) {
            this.keys = keys;
        }
    }
}

