/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.mgmt.AdminAPIAuthManager;
import org.sourceid.saml20.domain.mgmt.AdminAuthManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class MenuAuthUtil {
    private MenuAuthUtil() {
    }

    public static boolean isAdminFunctionsVisible(AdministrativeUser user) {
        return MenuAuthUtil.isAdminVisible(user) || MgmtFactory.getAdminUserManager().allowAddUser() || MenuAuthUtil.isEmailVisible(user);
    }

    public static boolean isAdminVisible(AdministrativeUser user) {
        return user.isAdmin() || user.isAuditor();
    }

    private static boolean isEmailVisible(AdministrativeUser user) {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        if (user.isAuditor()) {
            return true;
        }
        if (user.isAdminManager() && settings.isEnableAccountChangesNotification()) {
            return true;
        }
        return user.isAdmin() && (settings.isEnableEmailNotification() || settings.isEnableCertificateExpirationNotification());
    }

    public static boolean isAcctManagementVisible(AdministrativeUser user) {
        if (AdminAuthManager.getInstance().isNative()) {
            return true;
        }
        if (!AdminAuthManager.getInstance().isNative() && AdminAPIAuthManager.getInstance().isNative()) {
            return user.isAdminManager();
        }
        return false;
    }

    public static boolean isSystemVisible(AdministrativeUser user) {
        return MenuAuthUtil.isAdminVisible(user) || MenuAuthUtil.isAcctManagementVisible(user);
    }

    public static boolean isLicenseManagementVisible(AdministrativeUser user) {
        return user.isAdmin() || user.isAdminManager();
    }

    public static boolean isAuthorizedForConfigurationArchiveManagement(AdministrativeUser user) {
        boolean isNativeAuth = AdminAuthManager.getInstance().isNative();
        return user.isAdmin() && user.isCryptoManager() && user.isAdminManager() && user.isExpressionAdmin() && (user.isDataCollectionAdmin() || !isNativeAuth);
    }

    public static boolean isCollectSupportDataVisible(AdministrativeUser user) {
        return user.isDataCollectionAdmin() && user.isAdmin() && user.isCryptoManager() && user.isAdminManager();
    }

    public static boolean isPassiveAdminNode() {
        return MgmtFactory.getAdminNodeConfigManager().isPassiveNode();
    }
}

