/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlIDUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.GDate;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.GDurationSpecification;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.common.dsig.XmlSignatureUtil;
import org.sourceid.protocol.dsig10.xml.KeyInfoType;
import org.sourceid.protocol.dsig10.xml.X509DataType;
import org.sourceid.saml1x.bindings.Saml1xBindingURIs;
import org.sourceid.saml1x.xmlbinding.metadata.SourceIDDocument;
import org.sourceid.saml20.bindings.BindingURIs;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeRequester;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.ConnectionExpirationData;
import org.sourceid.saml20.domain.ContactInfo;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.Endpoints;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.IncomingBindings;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.util.BrowserSsoCompareUtil;
import org.sourceid.saml20.domain.util.ImportingMetadataDir;
import org.sourceid.saml20.domain.util.MetaDataInfo;
import org.sourceid.saml20.domain.util.MetadataConnections;
import org.sourceid.saml20.domain.util.MetadataExportException;
import org.sourceid.saml20.domain.util.MetadataImportException;
import org.sourceid.saml20.domain.util.UpdateMetadataUtil;
import org.sourceid.saml20.domain.util.metadataimport.InvalidXmlException;
import org.sourceid.saml20.domain.util.metadataimport.NoMatchingProtocolException;
import org.sourceid.saml20.domain.util.metadataimport.NoSuitableConnectionException;
import org.sourceid.saml20.metadata.EndpointUtil;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.xmlbinding.metadata.AttributeAuthorityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.EndpointType;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ExtensionsType;
import org.sourceid.saml20.xmlbinding.metadata.IDPSSODescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.KeyDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.KeyTypes;
import org.sourceid.saml20.xmlbinding.metadata.SPSSODescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.SSODescriptorType;
import org.sourceid.util.BaseUrlUtil;
import org.sourceid.websso.Protocol;

public class MetadataImportExportUtil {
    private static final Log log = LogFactory.getLog(MetadataImportExportUtil.class);
    private static final int VALID_UNTIL_DEFAULT = 24;
    private static DSignRotationSettingsManager dSignRotationManager = MgmtFactory.getDSignRotationSettingsManager();
    private static PkCertManager dsigPkCertManager = MgmtFactory.getDsigPkCertManager();

    public static Collection<ConnectionBase> importMetadata(String xml) throws MetadataImportException {
        Collection<ConnectionBase> connList = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(Util.utf8bytes(xml));){
            MetadataConnections metadataConns = MetadataImportExportUtil.importMetadataConnections(bais);
            if (metadataConns != null) {
                connList = metadataConns.getConnections();
            }
        }
        catch (IOException e) {
            throw new MetadataImportException(e);
        }
        return connList;
    }

    public static List<ConnectionBase> importMetadata(InputStream inputStream) throws MetadataImportException {
        ArrayList<ConnectionBase> connections = new ArrayList<ConnectionBase>();
        MetadataConnections metadataConnections = MetadataImportExportUtil.importMetadataConnections(inputStream);
        if (metadataConnections != null) {
            Collection<ConnectionBase> importedMetadata = metadataConnections.getConnections();
            connections = new ArrayList<ConnectionBase>(importedMetadata);
        }
        return connections;
    }

    private static MetadataConnections importMetadataConnections(InputStream inputStream) throws MetadataImportException {
        MetadataConnections metadataConnections = null;
        ArrayList<ConnectionBase> connList = new ArrayList<ConnectionBase>();
        Long validUntil = null;
        try {
            ImportingMetadataDir importMetadata = MetadataImportExportUtil.getMetadataDir(inputStream);
            connList.addAll(importMetadata.getIdpConnections());
            connList.addAll(importMetadata.getSpConnections());
            validUntil = importMetadata.getCacheUntil();
            metadataConnections = new MetadataConnections(connList, validUntil);
        }
        catch (RuntimeException e) {
            log.error((Object)"Exception in importMetadata(...)", (Throwable)e);
            throw new MetadataImportException(e);
        }
        return metadataConnections;
    }

    public static ConnectionBase importSingleConnection(InputStream inputStream, ImportExpectedConnectionType expectedType, Protocol expectedProtocol) throws MetadataImportException {
        boolean isUpdatingExistingConnectionMetadata = false;
        ConnectionBase importedConnection = MetadataImportExportUtil.generateConnectionFromMetadata(inputStream, expectedType, expectedProtocol, isUpdatingExistingConnectionMetadata);
        return importedConnection;
    }

    public static ConnectionBase generateConnectionFromMetadata(InputStream inputStream, ImportExpectedConnectionType expectedType, Protocol expectedProtocol, boolean updatingExistingConnectionMetadata) throws MetadataImportException {
        ConnectionBase importedConnection = MetadataImportExportUtil.getMetadataConnection(inputStream, expectedType);
        MetadataImportExportUtil.updateConnectionProtocol(importedConnection, expectedProtocol);
        importedConnection.setSourceIdOnDisk(null);
        importedConnection.setEntityIdOnDisk(null);
        return importedConnection;
    }

    public static MetadataConnections generateConnectionsFromMetadata(InputStream inputStream, ImportExpectedConnectionType expectedType, Protocol expectedProtocol) throws MetadataImportException {
        MetadataConnections metadataConnections = MetadataImportExportUtil.getMetadataConnections(inputStream, expectedType, expectedProtocol);
        Collection<ConnectionBase> importedConnections = metadataConnections.getConnections();
        if (importedConnections.size() == 0) {
            throw new NoSuitableConnectionException();
        }
        metadataConnections.setConnections(importedConnections);
        return metadataConnections;
    }

    public static void updateConnectionProtocol(ConnectionBase importedConnection, Protocol expectedProtocol) throws NoMatchingProtocolException {
        Set<Protocol> supportedProtocols = importedConnection.getProtocolsSupportedByPartner();
        MetadataImportExportUtil.checkProtocolSupportedByConnection(supportedProtocols, expectedProtocol);
        importedConnection.setProtocol(expectedProtocol);
        if (supportedProtocols != null) {
            MetadataImportExportUtil.filterBindingsForGivenProtocol(importedConnection, expectedProtocol);
        }
    }

    private static ConnectionBase getMetadataConnection(InputStream inputStream, ImportExpectedConnectionType expectedType) throws InvalidXmlException {
        Collection<ConnectionBase> connectionList;
        try {
            connectionList = MetadataImportExportUtil.importMetadataConnections(inputStream).getConnections();
        }
        catch (MetadataImportException e) {
            throw new InvalidXmlException(e);
        }
        ConnectionBase importedConnection = null;
        MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
        for (ConnectionBase connection : connectionList) {
            if (connection instanceof IdpConnection && MetadataLocalHelper.isEnableSp(metadataLocal) && (expectedType == ImportExpectedConnectionType.IDP || expectedType == ImportExpectedConnectionType.ANY) && !connection.doesWsTrustSettingsExist()) {
                importedConnection = connection;
                break;
            }
            if (!(connection instanceof SpConnection) || !MetadataLocalHelper.isEnableIdp(metadataLocal) || expectedType != ImportExpectedConnectionType.SP && expectedType != ImportExpectedConnectionType.ANY || connection.doesWsTrustSettingsExist()) continue;
            importedConnection = connection;
            break;
        }
        return importedConnection;
    }

    private static MetadataConnections getMetadataConnections(InputStream inputStream, ImportExpectedConnectionType expectedType, Protocol expectedProtocol) throws InvalidXmlException, NoMatchingProtocolException, NoSuitableConnectionException {
        Collection<Object> connectionList = new ArrayList();
        ArrayList<ConnectionBase> importedConnections = new ArrayList<ConnectionBase>();
        MetadataConnections metadataConnections = null;
        HashMap<String, Protocol> supportedPartnerProtocol = new HashMap<String, Protocol>();
        boolean unsupportedProtocolExists = false;
        metadataConnections = MetadataImportExportUtil.getAllConnections(inputStream);
        if (metadataConnections != null && metadataConnections.getConnections() != null) {
            connectionList = metadataConnections.getConnections();
        }
        MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
        for (ConnectionBase connectionBase : connectionList) {
            if (connectionBase.doesWsTrustSettingsExist()) continue;
            Set<Protocol> supportedProtocols = connectionBase.getProtocolsSupportedByPartner();
            boolean isConnectionOfExpectedType = false;
            try {
                if (connectionBase instanceof IdpConnection && MetadataLocalHelper.isEnableSp(metadataLocal) && (expectedType == ImportExpectedConnectionType.IDP || expectedType == ImportExpectedConnectionType.ANY)) {
                    isConnectionOfExpectedType = true;
                } else if (connectionBase instanceof SpConnection && MetadataLocalHelper.isEnableIdp(metadataLocal) && (expectedType == ImportExpectedConnectionType.SP || expectedType == ImportExpectedConnectionType.ANY)) {
                    isConnectionOfExpectedType = true;
                }
                if (!isConnectionOfExpectedType) continue;
                if (expectedProtocol != null) {
                    MetadataImportExportUtil.updateConnectionProtocol(connectionBase, expectedProtocol);
                }
                connectionBase.setSourceIdOnDisk(null);
                connectionBase.setEntityIdOnDisk(null);
                importedConnections.add(connectionBase);
            }
            catch (NoMatchingProtocolException e) {
                unsupportedProtocolExists = true;
                if (supportedProtocols == null) continue;
                for (Protocol protocol : supportedProtocols) {
                    supportedPartnerProtocol.put(protocol.getLabel(), protocol);
                }
            }
        }
        if (connectionList.size() > 0 && importedConnections.size() == 0 && unsupportedProtocolExists) {
            throw new NoMatchingProtocolException(supportedPartnerProtocol.values());
        }
        metadataConnections.setConnections(importedConnections);
        return metadataConnections;
    }

    public static MetadataConnections getAllConnections(InputStream inputStream) throws InvalidXmlException, NoSuitableConnectionException {
        MetadataConnections metadataConnections = null;
        try {
            metadataConnections = MetadataImportExportUtil.importMetadataConnections(inputStream);
        }
        catch (MetadataImportException e) {
            throw new InvalidXmlException(e);
        }
        if (metadataConnections != null && (metadataConnections.getConnections() == null || metadataConnections.getConnections().isEmpty())) {
            throw new NoSuitableConnectionException();
        }
        return metadataConnections;
    }

    private static void checkProtocolSupportedByConnection(Set<Protocol> supportedProtocols, Protocol expectedProtocol) throws NoMatchingProtocolException {
        if (supportedProtocols != null && !supportedProtocols.isEmpty() && !supportedProtocols.contains(expectedProtocol)) {
            throw new NoMatchingProtocolException(new ArrayList<Protocol>(supportedProtocols));
        }
    }

    public static ConnectionBase mergeConnections(ConnectionBase sourceConnection, ConnectionBase metadataConnection) {
        MetadataImportExportUtil.mergeConnectionName(sourceConnection, metadataConnection);
        if (sourceConnection instanceof IdpConnection) {
            MetadataImportExportUtil.mergeIdpConnection((IdpConnection)sourceConnection, (IdpConnection)metadataConnection);
        } else if (sourceConnection instanceof SpConnection) {
            MetadataImportExportUtil.mergeSpConnection((SpConnection)sourceConnection, (SpConnection)metadataConnection);
        }
        metadataConnection.setCreationTime(sourceConnection.getCreationTime());
        return sourceConnection;
    }

    private static boolean mergeConnectionName(ConnectionBase sourceConnection, ConnectionBase metadataConnection) {
        boolean nameUpdated = false;
        String metadatadatEntityId = metadataConnection.getEntityId();
        if (sourceConnection.getName() == null) {
            String metadataConnectionName = metadataConnection.getName();
            if (StringUtils.isNotBlank((String)metadataConnectionName)) {
                sourceConnection.setName(metadataConnectionName);
            } else {
                sourceConnection.setName(metadatadatEntityId);
            }
            nameUpdated = true;
        }
        return nameUpdated;
    }

    private static Collection<AdapterToAssertionMapping> copyAdapterMapping(Collection<AdapterToAssertionMapping> copyMappings) {
        ArrayList<AdapterToAssertionMapping> clonedAdapterMapping = new ArrayList<AdapterToAssertionMapping>();
        for (AdapterToAssertionMapping copyMapping : copyMappings) {
            if (copyMapping == null) continue;
            clonedAdapterMapping.add(new AdapterToAssertionMapping(copyMapping));
        }
        return clonedAdapterMapping;
    }

    private static synchronized void mergeSpConnection(SpConnection sourceConnection, SpConnection metadataConnection) {
        MetadataImportExportUtil.mergeContactInfo(sourceConnection, metadataConnection);
        Collection<AdapterToAssertionMapping> copyMapings = MetadataImportExportUtil.copyAdapterMapping(sourceConnection.getAdapterMappings());
        sourceConnection.setAdapterMappings(copyMapings);
        MetadataImportExportUtil.mergeBasicBrowserSSOConfig(sourceConnection, metadataConnection, true);
        MetadataImportExportUtil.mergeCredentials(sourceConnection, metadataConnection);
    }

    public static void mergeBasicBrowserSSOConfig(ConnectionBase sourceConnection, ConnectionBase metadataConnection, boolean mergeAdapterMapping) {
        sourceConnection.setProtocol(metadataConnection.getProtocol());
        try {
            MetadataImportExportUtil.mergeBindingsAndSamlProfiles(sourceConnection, metadataConnection);
        }
        catch (MalformedURLException e) {
            log.debug((Object)("Invalid URL: " + e));
        }
        if (mergeAdapterMapping) {
            MetadataImportExportUtil.mergeAttributeContract(sourceConnection, metadataConnection);
        }
        sourceConnection.setAttributeContract(metadataConnection.getAttributeContract());
    }

    private static void mergeAttributeContract(ConnectionBase sourceConnection, ConnectionBase metadataConnection) {
        AttributeContract srcAttrContract = sourceConnection.getAttributeContract();
        AttributeContract metadataAttrContract = metadataConnection.getAttributeContract();
        Map<String, BrowserSsoCompareUtil.Change> changes = BrowserSsoCompareUtil.compareAttribute(srcAttrContract, metadataAttrContract, BrowserSsoCompareUtil.Change.REMOVED);
        Map<String, BrowserSsoCompareUtil.Change> addedChanges = BrowserSsoCompareUtil.compareAttribute(metadataAttrContract, srcAttrContract, BrowserSsoCompareUtil.Change.ADDED);
        if (addedChanges.size() > 0) {
            changes.putAll(addedChanges);
        }
        if (srcAttrContract != null && sourceConnection instanceof SpConnection) {
            Collection<AdapterToAssertionMapping> originalAdapterMappings = ((SpConnection)sourceConnection).getAdapterMappings();
            ArrayList<AdapterToAssertionMapping> srcAdapterMappings = new ArrayList<AdapterToAssertionMapping>(originalAdapterMappings);
            Collection<C2cContractToAssertionMapping> originalC2cMappings = ((SpConnection)sourceConnection).getC2cMappings();
            ArrayList<C2cContractToAssertionMapping> srcC2cMappings = new ArrayList<C2cContractToAssertionMapping>(originalC2cMappings);
            for (String attributeContractChange : changes.keySet()) {
                for (AdapterToAssertionMapping adapterMapping : srcAdapterMappings) {
                    AttributeMapping attributeMapping = adapterMapping.getDefaultAttributeMapping();
                    AttributeMapping updatedAttrMapping = MetadataImportExportUtil.updateAdapterC2CAttrMapping(metadataAttrContract, changes, attributeContractChange, attributeMapping, SourceType.ADAPTER);
                    adapterMapping.setDefaultAttributeMapping(updatedAttrMapping);
                }
                for (C2cContractToAssertionMapping c2cMapping : srcC2cMappings) {
                    AttributeMapping c2cAttributeMapping = c2cMapping.getDefaultAttributeMapping();
                    AttributeMapping updatedC2cAttributeMapping = MetadataImportExportUtil.updateAdapterC2CAttrMapping(metadataAttrContract, changes, attributeContractChange, c2cAttributeMapping, SourceType.AUTHENTICATION_POLICY_CONTRACT);
                    c2cMapping.setDefaultAttributeMapping(updatedC2cAttributeMapping);
                }
            }
        }
    }

    private static AttributeMapping updateAdapterC2CAttrMapping(AttributeContract metadataAttrContract, Map<String, BrowserSsoCompareUtil.Change> changes, String attributeContractChange, AttributeMapping attributeMappings, SourceType sourceType) {
        AttributeMapping attributeMapping = new AttributeMapping(attributeMappings);
        Set<String> adapterMappedAttrs = attributeMappings.getAttributeMapping().keySet();
        for (String adapterMappedAttr : adapterMappedAttrs) {
            BrowserSsoCompareUtil.Change attrChange = changes.get(adapterMappedAttr);
            if (attrChange == null || !attrChange.equals((Object)BrowserSsoCompareUtil.Change.REMOVED)) continue;
            attributeMapping.removeAttributeMapping(adapterMappedAttr);
        }
        for (BrowserSsoCompareUtil.Change attrChange : changes.values()) {
            if (!attrChange.equals((Object)BrowserSsoCompareUtil.Change.ADDED)) continue;
            attributeMapping.addAttributeMapping(attributeContractChange, sourceType, null);
        }
        return attributeMapping;
    }

    private static void mergeBindingsAndSamlProfiles(ConnectionBase sourceConnection, ConnectionBase metadataConnection) throws MalformedURLException {
        String sourceConnectionBaseURL;
        IndexedEndpoints mergedConnACSEndpoints = new IndexedEndpoints();
        if (metadataConnection.getBaseUrl() != null) {
            sourceConnection.setBaseUrl(metadataConnection.getBaseUrl());
        }
        Protocol connectionProtocol = sourceConnection.getProtocol();
        String string = sourceConnectionBaseURL = sourceConnection.getBaseUrl() == null ? "" : sourceConnection.getBaseUrl().toString();
        if (sourceConnection instanceof IdpConnection) {
            List<Endpoint> mergedConnSSOEndpoints = UpdateMetadataUtil.mergeSSOEndpoints(sourceConnection, metadataConnection, sourceConnectionBaseURL, connectionProtocol);
            if (mergedConnSSOEndpoints.size() == 0) {
                sourceConnection.getEnabledProfiles().setSpInitiatedSSOEnabled(false);
            }
            ((IdpConnection)sourceConnection).getSingleSignOnServices().setEndpoints(mergedConnSSOEndpoints);
        } else if (sourceConnection instanceof SpConnection) {
            SpConnection metadataSPConnection = (SpConnection)metadataConnection;
            SpConnection sourceSPConnection = (SpConnection)sourceConnection;
            if (connectionProtocol.equals(Protocol.SAML20)) {
                mergedConnACSEndpoints = UpdateMetadataUtil.mergeIndexedEndpoints(sourceSPConnection.getAssertionConsumerServiceEndpoints(), metadataSPConnection.getAssertionConsumerServiceEndpoints(), sourceConnectionBaseURL);
            } else if (connectionProtocol.equals(Protocol.SAML11) || connectionProtocol.equals(Protocol.SAML10)) {
                mergedConnACSEndpoints = UpdateMetadataUtil.mergeIndexedEndpoints(sourceSPConnection.getAssertionConsumerServiceEndpoints(), metadataSPConnection.getAssertionConsumerServiceEndpoints(), sourceConnectionBaseURL);
            }
            ((SpConnection)sourceConnection).setAssertionConsumerServiceEndpoints(mergedConnACSEndpoints);
        }
        ArrayList<Endpoint> sourceConnSLOEndpoints = sourceConnection.getSingleLogoutServices() != null ? sourceConnection.getSingleLogoutServices().getEndpoints() : new ArrayList();
        ArrayList<Endpoint> metadataConnSLOEndpoints = metadataConnection.getSingleLogoutServices() != null ? metadataConnection.getSingleLogoutServices().getEndpoints() : new ArrayList();
        List<Endpoint> mergedConnSLOEndpoints = UpdateMetadataUtil.mergeEndpoints(sourceConnSLOEndpoints, metadataConnSLOEndpoints, sourceConnectionBaseURL, connectionProtocol);
        if (mergedConnSLOEndpoints.size() == 0) {
            sourceConnection.getEnabledProfiles().setSpInitiatedSLOEnabled(false);
            sourceConnection.getEnabledProfiles().setIdpInitiatedSLOEnabled(false);
        }
        sourceConnection.getSingleLogoutServices().setEndpoints(mergedConnSLOEndpoints);
        IndexedEndpoints mergedConnARSEndpoints = UpdateMetadataUtil.mergeIndexedEndpoints(sourceConnection.getArtifactResolutionServices(), metadataConnection.getArtifactResolutionServices(), sourceConnectionBaseURL);
        sourceConnection.setArtifactResolutionServices(mergedConnARSEndpoints);
    }

    private static void mergeIdpConnection(IdpConnection sourceConnection, IdpConnection metadataConnection) {
        MetadataImportExportUtil.mergeContactInfo(sourceConnection, metadataConnection);
        MetadataImportExportUtil.mergeBasicBrowserSSOConfig(sourceConnection, metadataConnection, true);
        MetadataImportExportUtil.mergeCredentials(sourceConnection, metadataConnection);
    }

    private static void mergeCredentials(ConnectionBase sourceConnection, ConnectionBase metadataConnection) {
        MetadataImportExportUtil.mergeVerificationCert(sourceConnection, metadataConnection);
        MetadataImportExportUtil.mergeEncryptionCert(sourceConnection, metadataConnection);
    }

    public static boolean mergeVerificationCert(ConnectionBase sourceConnection, ConnectionBase metadataConnection) {
        boolean verifyCertUpdated = false;
        sourceConnection.setDsigVerificationExpectedIssuerDN(metadataConnection.getDsigVerificationExpectedIssuerDN());
        sourceConnection.setDsigVerificationExpectedSubjectDN(metadataConnection.getDsigVerificationExpectedSubjectDN());
        if (metadataConnection.getDsigVerificationCerts() != null) {
            ConnectionCerts metadataCerts = metadataConnection.getDsigVerificationCerts();
            ConnectionCerts existingCerts = sourceConnection.getDsigVerificationCerts();
            HashSet<Cert> newMetadataCerts = new HashSet<Cert>();
            List<Cert> metadataActiveCerts = metadataCerts.getActiveVerificationCerts();
            if (metadataActiveCerts != null && !metadataActiveCerts.isEmpty()) {
                if (existingCerts.getActiveVerificationCerts() == null || existingCerts.getActiveVerificationCerts().isEmpty()) {
                    sourceConnection.getDsigVerificationCerts().setActiveVerificationCerts(metadataActiveCerts);
                    verifyCertUpdated = true;
                } else {
                    for (Cert metadataCert : metadataActiveCerts) {
                        Cert connectionCert = MetadataImportExportUtil.getExistingCert(existingCerts.getActiveVerificationCerts(), metadataCert);
                        if (connectionCert == null) {
                            connectionCert = MetadataImportExportUtil.getExistingCert(new ArrayList<Cert>(existingCerts.getAllVerificationCerts()), metadataCert);
                            verifyCertUpdated = true;
                            if (connectionCert == null) {
                                newMetadataCerts.add(metadataCert);
                                continue;
                            }
                            newMetadataCerts.add(connectionCert);
                            continue;
                        }
                        newMetadataCerts.add(connectionCert);
                    }
                    if (verifyCertUpdated) {
                        ConnectionCerts updatedCerts = MetadataImportExportUtil.prepareNewConnectionCerts();
                        int newCertsCount = newMetadataCerts.size();
                        if (newCertsCount == 1) {
                            updatedCerts.setActiveVerificationCert((Cert)newMetadataCerts.iterator().next());
                            updatedCerts.setSecondaryVerificationCert(existingCerts.getActiveVerificationCert());
                        } else if (newCertsCount > 1) {
                            updatedCerts.setActiveVerificationCerts(new ArrayList<Cert>(newMetadataCerts));
                        }
                        sourceConnection.setDsigVerificationCerts(updatedCerts);
                    }
                }
            }
        }
        return verifyCertUpdated;
    }

    private static ConnectionCerts prepareNewConnectionCerts() {
        ConnectionCerts updatedCerts = new ConnectionCerts();
        updatedCerts.setOtherVerificationCerts(null);
        return updatedCerts;
    }

    private static Cert getExistingCert(List<Cert> existingCerts, Cert newCert) {
        for (Cert connectionCert : existingCerts) {
            if (!newCert.getFingerPrint(HashAlgorithm.SHA256).equals(connectionCert.getFingerPrint(HashAlgorithm.SHA256))) continue;
            return connectionCert;
        }
        return null;
    }

    public static boolean mergeEncryptionCert(ConnectionBase sourceConnection, ConnectionBase metadataConnection) {
        EncryptionSettings sourceEncryptionSettings;
        boolean encryptionCertUpdated = false;
        EncryptionSettings metadataEncryptionSettings = metadataConnection.getEncryptionSettings();
        if (metadataEncryptionSettings != null && (sourceEncryptionSettings = sourceConnection.getEncryptionSettings()) != null && sourceEncryptionSettings.getEncryptionPolicy().isEncryptionEnabled()) {
            Cert metadataEncryptionCert = metadataEncryptionSettings.getEncryptionCert();
            if (metadataEncryptionCert != null && (sourceEncryptionSettings.getEncryptionCert() == null || sourceEncryptionSettings.getEncryptionCert() != null && !sourceEncryptionSettings.getEncryptionCert().equals(metadataEncryptionCert))) {
                encryptionCertUpdated = true;
                metadataEncryptionCert.setAlias(null);
                sourceEncryptionSettings.setEncryptionCert(metadataEncryptionCert);
            }
            sourceConnection.setEncryptionSettings(sourceEncryptionSettings);
        }
        return encryptionCertUpdated;
    }

    public static boolean mergeContactInfo(ConnectionBase sourceConnection, ConnectionBase metadataConnection) {
        boolean contactChanged = false;
        ContactInfo metadataContactInfo = metadataConnection.getContactInfo();
        ContactInfo sourceContactInfo = sourceConnection.getContactInfo();
        if (sourceContactInfo == null) {
            if (metadataContactInfo != null) {
                sourceConnection.setContactInfo(metadataContactInfo);
                contactChanged = true;
            }
        } else if (metadataContactInfo != null) {
            String metadataName;
            String srcName = MetadataImportExportUtil.mergeFirstLastName(sourceContactInfo.getFirstName(), sourceContactInfo.getLastName());
            if (MetadataImportExportUtil.isMerge(srcName, metadataName = MetadataImportExportUtil.mergeFirstLastName(metadataContactInfo.getFirstName(), metadataContactInfo.getLastName()))) {
                sourceContactInfo.setFirstName(metadataContactInfo.getFirstName());
                sourceContactInfo.setLastName(metadataContactInfo.getLastName());
                contactChanged = true;
            }
            if (MetadataImportExportUtil.isMerge(sourceContactInfo.getEmail(), metadataContactInfo.getEmail())) {
                sourceContactInfo.setEmail(metadataContactInfo.getEmail());
                contactChanged = true;
            }
            if (MetadataImportExportUtil.isMerge(sourceContactInfo.getCompany(), metadataContactInfo.getCompany())) {
                sourceContactInfo.setCompany(metadataContactInfo.getCompany());
                contactChanged = true;
            }
            if (MetadataImportExportUtil.isMerge(sourceContactInfo.getPhone(), metadataContactInfo.getPhone())) {
                sourceContactInfo.setPhone(metadataContactInfo.getPhone());
                contactChanged = true;
            }
        }
        return contactChanged;
    }

    private static String mergeFirstLastName(String firstName, String lastName) {
        StringBuilder fullName = new StringBuilder();
        if (StringUtils.isNotBlank((String)firstName)) {
            fullName.append(firstName);
        }
        if (StringUtils.isNotBlank((String)lastName)) {
            fullName.append(" " + lastName);
        }
        return fullName.toString();
    }

    private static boolean isMerge(String sourceValue, String mergeValue) {
        boolean isMerge = false;
        if (StringUtils.isNotBlank((String)mergeValue)) {
            if (StringUtils.isBlank((String)sourceValue)) {
                isMerge = true;
            } else if (!sourceValue.equals(mergeValue)) {
                isMerge = true;
            }
        }
        return isMerge;
    }

    public static void populateMetaDataInfoWithConnection(MetaDataInfo info, ConnectionBase conn) {
        info.setProtocol(conn.getProtocol());
        info.setContract(conn.getAttributeContract());
        String connectionSigningAlias = conn.getSigningKeyAlias();
        String connectionSecondarySigningAlias = conn.getSecondarySigningKeyAlias();
        if (connectionSigningAlias != null) {
            info.setSigningCert(dsigPkCertManager.getPkCert(connectionSigningAlias));
            PkCert pendingCert = MetadataImportExportUtil.getPendingSigningCert(connectionSigningAlias);
            if (pendingCert != null) {
                info.setSecondarySigningCert(pendingCert);
            } else if (connectionSecondarySigningAlias != null && MetadataImportExportUtil.allowAlternativeSigningCert(connectionSigningAlias, dSignRotationManager)) {
                info.setSecondarySigningCert(dsigPkCertManager.getPkCert(connectionSecondarySigningAlias));
            }
        }
        IncomingBindings incomingBindings = conn.getIncomingBindings();
        incomingBindings.doSet("urn:oasis:names:tc:SAML:2.0:bindings:PAOS", false);
        info.setBindings(incomingBindings);
        info.setProfiles(conn.getEnabledProfiles());
        info.setXmlEncryptionCert(MetadataImportExportUtil.getDecryptionCert(conn));
        info.setIncludeArtifactEndpoint(conn.usesBindingsOutbound("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01"));
        String sourceId = conn instanceof SpConnection && (conn.getProtocol() == Protocol.SAML10 || conn.getProtocol() == Protocol.SAML11) ? conn.getDefaultVirtualIdentity().getVirtualSourceIdString() : "";
        info.setSourceId(sourceId);
        AttributeRequester attributeRequester = null;
        if (conn instanceof SpConnection) {
            attributeRequester = ((SpConnection)conn).getAttributeRequester();
        }
        info.setAttributeRequester(attributeRequester);
        if (attributeRequester == null) {
            info.setExportAttrSvcEndpoint(false);
        }
        info.setPartnerEntityId(conn.getEntityId());
        info.setPartnerBaseUrl(conn.getBaseUrl() == null ? null : conn.getBaseUrl().toString());
        if (conn instanceof SpConnection) {
            info.setSubjectNameFormat(((SpConnection)conn).getNameIdFormat());
        }
        if (conn instanceof SpConnection) {
            info.setWantAuthnRequestsSigned(((SpConnection)conn).isAuthnRequestsSigned());
        }
        if (info.getVirtualEntityId() == null && conn.getDefaultVirtualIdentity() != null) {
            boolean multipleVsids = false;
            int count = 0;
            for (VirtualIdentity virtualId : conn.getVirtualIdentities()) {
                if (virtualId.getVirtualEntityId(DomainMode.CONFIGTIME) != null) {
                    ++count;
                }
                if (count <= 1) continue;
                multipleVsids = true;
                break;
            }
            info.setVirtualEntityId(conn.getDefaultVirtualIdentity(), multipleVsids);
        }
        Date connValidityDate = conn.getConnMetadataValidityDate();
        info.setCacheUntil(connValidityDate);
    }

    private static PkCert getPendingSigningCert(String connectionSigningAlias) {
        PkCert pendingCert = null;
        DSignRotationSetting signingRotaitonSettings = dSignRotationManager.getRotationSetting(connectionSigningAlias);
        if (signingRotaitonSettings != null && signingRotaitonSettings.getPendingCertAlias() != null) {
            String pendingCertAlias = signingRotaitonSettings.getPendingCertAlias();
            pendingCert = dsigPkCertManager.getPkCert(pendingCertAlias);
        }
        return pendingCert;
    }

    public static Cert getDecryptionCert(ConnectionBase connection) {
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        String selectedDecryptionKeyAlias = encryptionSettings.getDecryptionKeyAlias();
        PkCertManager certManager = MgmtFactory.getDsigPkCertManager();
        return selectedDecryptionKeyAlias != null && certManager != null ? certManager.getPkCert(selectedDecryptionKeyAlias) : null;
    }

    public static byte[] getMetaDataRawBytes(MetaDataInfo mdi, String signingAlgorithm, PkCert signingCert, boolean includeKeyInfo, PathUtil pathUtil, boolean includeKeyValue) {
        return MetadataImportExportUtil.getMetaDataRawBytes(mdi, signingAlgorithm, signingCert, includeKeyInfo, pathUtil, includeKeyValue, false);
    }

    public static byte[] getMetaDataRawBytes(MetaDataInfo mdi, String signingAlgorithm, PkCert signingCert, boolean includeKeyInfo, PathUtil pathUtil, boolean includeKeyValue, boolean omitTransientElements) {
        EntityDescriptorDocument metadata = MetadataImportExportUtil.exportMetadataDoc(mdi, pathUtil, omitTransientElements);
        try {
            if (signingCert != null) {
                PrivateKey signingKey = signingCert.getPrivateKey();
                try {
                    XmlSignatureUtil.signXml((XmlObject)metadata, signingAlgorithm, signingKey, signingCert.getX509Certificate(), includeKeyInfo, false, includeKeyValue);
                }
                catch (SigningException se) {
                    log.error((Object)"Trouble signing the metadata", (Throwable)se);
                    return "".getBytes("UTF-8");
                }
            }
            return XmlBeansUtil.xmlText((XmlObject)metadata).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Affiliation> importAffiliation(InputStream inputStream) throws MetadataImportException {
        ArrayList<Affiliation> affiliationList = new ArrayList<Affiliation>();
        try {
            ImportingMetadataDir metadata = MetadataImportExportUtil.getMetadataDir(inputStream);
            List<String> affiliationIdList = metadata.getAffiliationIds();
            for (String affiliationId : affiliationIdList) {
                Affiliation affiliation = metadata.getAffiliation(affiliationId);
                affiliationList.add(affiliation);
            }
        }
        catch (RuntimeException ex) {
            log.info((Object)("Exception in importing SP Affiliations " + ex.getMessage()));
            throw new MetadataImportException(ex.getMessage(), ex);
        }
        return affiliationList;
    }

    public static void filterBindingsForGivenProtocol(ConnectionBase importedConnection, Protocol expectedProtocol) {
        IndexedEndpoints arsIndexedEndPoints = importedConnection.getArtifactResolutionServices();
        IndexedEndpoints filteredArtifactResolutionServices = MetadataImportExportUtil.filterByBinding(arsIndexedEndPoints, expectedProtocol, null);
        importedConnection.setArtifactResolutionServices(filteredArtifactResolutionServices);
        EndpointGroup sloEndpointGroup = importedConnection.getSingleLogoutServices();
        EndpointGroup filteredSloEndpointGroup = MetadataImportExportUtil.filterByBinding(sloEndpointGroup, expectedProtocol, null);
        importedConnection.setSingleLogoutServices(filteredSloEndpointGroup);
        if (importedConnection instanceof IdpConnection) {
            EndpointGroup filteredSsoEndpointGroup = MetadataImportExportUtil.getFilteredSsoEndpoints(expectedProtocol, importedConnection);
            ((IdpConnection)importedConnection).setSingleSignOnServices(filteredSsoEndpointGroup);
        }
        if (importedConnection instanceof SpConnection) {
            IndexedEndpoints filteredAcsEndpoints = MetadataImportExportUtil.getFilteredAcsEndpoints(expectedProtocol, importedConnection);
            ((SpConnection)importedConnection).setAssertionConsumerServiceEndpoints(filteredAcsEndpoints);
        }
    }

    private static EndpointGroup getFilteredSsoEndpoints(Protocol expectedProtocol, ConnectionBase importedConnection) {
        IdpConnection idpConnection = (IdpConnection)importedConnection;
        EndpointGroup ssoEndpointGroup = idpConnection.getSingleSignOnServices();
        if (expectedProtocol == Protocol.SAML10 || expectedProtocol == Protocol.SAML11 && ssoEndpointGroup != null && ssoEndpointGroup.getEndpoints().size() == 1) {
            return ssoEndpointGroup;
        }
        EndpointGroup filteredSsoEndpointGroup = MetadataImportExportUtil.filterByBinding(ssoEndpointGroup, expectedProtocol, null);
        return filteredSsoEndpointGroup;
    }

    private static IndexedEndpoints getFilteredAcsEndpoints(Protocol expectedProtocol, ConnectionBase importedConnection) {
        SpConnection idpConnection = (SpConnection)importedConnection;
        IndexedEndpoints acsEndpoints = idpConnection.getAssertionConsumerServiceEndpoints();
        IndexedEndpoints filteredAcsEndpointGroup = MetadataImportExportUtil.filterByBinding(acsEndpoints, expectedProtocol, null);
        return filteredAcsEndpointGroup;
    }

    public static void setAbsoluteUrls(Endpoints endpoints, PathUtil pathUtil) {
        MetadataImportExportUtil.setAbsoluteUrls(endpoints, null, pathUtil, new MetaDataInfo());
    }

    private static void setValidityPeriod(EntityDescriptorType entityDescriptorType, Date connValidUntil, ConnectionExpirationData connExpirationData) {
        GDuration connValidDuration = connExpirationData.getCacheGDuration();
        GDuration cachedDuration = MetadataImportExportUtil.getCachedUntil(connValidDuration, connValidUntil);
        if (cachedDuration == null) {
            Calendar validUntilTime = Util.getUtcCalendar();
            validUntilTime.add(10, 24);
            entityDescriptorType.setValidUntil(validUntilTime);
        } else {
            entityDescriptorType.setCacheDuration(cachedDuration);
        }
    }

    public static void setValidityPeriod(EntityDescriptorType entityDescriptorType) {
        MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
        ConnectionExpirationData connExpirationData = MetadataLocalHelper.getConnectionExpirationData(metadataLocal);
        if (connExpirationData != null && connExpirationData.getCacheGDuration() != null) {
            entityDescriptorType.setCacheDuration(connExpirationData.getCacheGDuration());
        } else {
            Calendar validUntilTime = Util.getUtcCalendar();
            validUntilTime.add(10, 24);
            entityDescriptorType.setValidUntil(validUntilTime);
        }
    }

    private static boolean addPendingCertForSigningCert(SSODescriptorType ssoDescriptorType, Cert cert) {
        String pendingCertAlias;
        String certAlias;
        DSignRotationSetting rotationSetting;
        boolean addedPendingCert = false;
        if (cert != null && (rotationSetting = dSignRotationManager.getRotationSetting(certAlias = cert.getAlias())) != null && rotationSetting.isEnableCertRotation() && (pendingCertAlias = rotationSetting.getPendingCertAlias()) != null) {
            long expiryTime = cert.getX509Certificate().getNotAfter().getTime();
            boolean hasBufferStarted = rotationSetting.hasBufferTimeStarted(expiryTime, rotationSetting.getRotationBufferMins());
            PkCert digCert = dsigPkCertManager.getPkCert(pendingCertAlias);
            if (digCert != null && hasBufferStarted) {
                MetadataImportExportUtil.addDsigCert(ssoDescriptorType, digCert);
                addedPendingCert = true;
            }
        }
        return addedPendingCert;
    }

    public static void addDsigCert(SSODescriptorType ssoDescriptorType, Cert cert) {
        MetadataImportExportUtil.addCert(ssoDescriptorType, cert, KeyTypes.SIGNING);
    }

    public static EntityDescriptorDocument exportMetadataDoc(MetaDataInfo mdi, PathUtil pathUtil, boolean omitTransientElements) {
        IDPSSODescriptorType ssoDescType;
        ConnectionUtil connectionUtil = new ConnectionUtil();
        MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
        EntityDescriptorDocument myMetadata = EntityDescriptorDocument.Factory.newInstance();
        EntityDescriptorType entityDescriptorType = myMetadata.addNewEntityDescriptor();
        if (!omitTransientElements) {
            ConnectionExpirationData connExpiryData = MetadataLocalHelper.getConnectionExpirationData(metadataLocal);
            entityDescriptorType.setID(XmlIDUtil.createID());
            MetadataImportExportUtil.setValidityPeriod(entityDescriptorType, mdi.getCacheUntil(), connExpiryData);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        if (mdi.getVirtualEntityId() == null) {
            MetadataImportExportUtil.setEntityId(mdi.getProtocol(), entityDescriptorType, metadataLocal);
        } else {
            String virtualServerId = mdi.getVirtualEntityId().getVirtualEntityId(DomainMode.CONFIGTIME);
            if (virtualServerId == null) {
                MetadataImportExportUtil.setEntityId(mdi.getProtocol(), entityDescriptorType, metadataLocal);
            } else {
                entityDescriptorType.setEntityID(virtualServerId);
                if (mdi.hasMultipleVsids()) {
                    pathParams.put("vsid", virtualServerId);
                }
            }
        }
        if (mdi.isExportIDPRole()) {
            String subjectNameFormat;
            IDPSSODescriptorType idpSsoDescType;
            ssoDescType = idpSsoDescType = entityDescriptorType.addNewIDPSSODescriptor();
            idpSsoDescType.setProtocolSupportEnumeration(mdi.getProtocol().getProtoSupportList());
            idpSsoDescType.setWantAuthnRequestsSigned(mdi.isWantAuthnRequestsSigned());
            if (mdi.getSourceId() != null && !"".equals(mdi.getSourceId())) {
                SourceIDDocument sourceDoc = SourceIDDocument.Factory.newInstance();
                sourceDoc.setSourceID(mdi.getSourceId().toLowerCase());
                ExtensionsType extType = idpSsoDescType.addNewExtensions();
                SourceIDDocument.SourceID sourceID = sourceDoc.xgetSourceID();
                XmlBeansUtil.setChildren((XmlObject)extType, new XmlObject[]{sourceID});
            }
            connectionUtil.fillInContactInfo(entityDescriptorType, metadataLocal.getContactInfo());
            if (mdi.getContract() != null) {
                connectionUtil.fillInIdpAttributeTypes(idpSsoDescType, mdi.getContract());
            }
            if (mdi.getProtocol() == Protocol.SAML20) {
                MetadataImportExportUtil.setSaml2IdPEndpoints(idpSsoDescType, metadataLocal, pathParams, pathUtil, mdi);
            } else {
                MetadataImportExportUtil.setSaml1xIdPEndpoints(idpSsoDescType, pathParams, pathUtil, mdi);
            }
            if (mdi.isExportAttrSvcEndpoint()) {
                MetadataImportExportUtil.setAttrSvcEndpoint(mdi, entityDescriptorType, metadataLocal);
            }
            if ((subjectNameFormat = mdi.getSubjectNameFormat()) != null) {
                idpSsoDescType.addNameIDFormat(subjectNameFormat);
            }
        } else {
            SPSSODescriptorType spSsoDescType = entityDescriptorType.addNewSPSSODescriptor();
            ssoDescType = spSsoDescType;
            spSsoDescType.setProtocolSupportEnumeration(mdi.getProtocol().getProtoSupportList());
            connectionUtil.fillInContactInfo(entityDescriptorType, metadataLocal.getContactInfo());
            if (mdi.getContract() != null) {
                connectionUtil.fillInAttributeConsumingServiceType(spSsoDescType, mdi.getContract());
            }
            if (mdi.getProtocol() == Protocol.SAML20) {
                boolean includeArtifactEndpoint = mdi.isIncludeArtifactEndpoint();
                MetadataImportExportUtil.setSaml2SpEndpoints(spSsoDescType, metadataLocal, includeArtifactEndpoint, pathParams, pathUtil, mdi);
            } else {
                MetadataImportExportUtil.setSaml1xSpEndpoints(spSsoDescType, pathParams, pathUtil, mdi);
            }
        }
        MetadataImportExportUtil.handlePrimarySecondaryVerificationCertificate(mdi, (SSODescriptorType)ssoDescType);
        if (mdi.getXmlEncryptionCert() != null) {
            MetadataImportExportUtil.setEncryptionCert((SSODescriptorType)ssoDescType, mdi.getXmlEncryptionCert(), mdi.getExpectedEncryptionMethod());
        }
        return myMetadata;
    }

    private static void handlePrimarySecondaryVerificationCertificate(MetaDataInfo mdi, SSODescriptorType ssoDescType) {
        if (ssoDescType == null) {
            return;
        }
        Cert primaryCert = mdi.getSigningCert();
        Cert secondaryCert = mdi.getSecondarySigningCert();
        if (primaryCert != null) {
            boolean addedPendingSecondaryCert;
            MetadataImportExportUtil.addDsigCert(ssoDescType, primaryCert);
            if (!MetadataImportExportUtil.addPendingCertForSigningCert(ssoDescType, primaryCert) && secondaryCert != null && !(addedPendingSecondaryCert = MetadataImportExportUtil.addPendingCertForSigningCert(ssoDescType, secondaryCert))) {
                MetadataImportExportUtil.addDsigCert(ssoDescType, secondaryCert);
            }
        } else if (secondaryCert != null) {
            MetadataImportExportUtil.addDsigCert(ssoDescType, secondaryCert);
            MetadataImportExportUtil.addPendingCertForSigningCert(ssoDescType, secondaryCert);
        }
    }

    private static ImportingMetadataDir getMetadataDir(InputStream inputStream) throws MetadataImportException {
        return new ImportingMetadataDir(inputStream);
    }

    private static void setAttrSvcEndpoint(MetaDataInfo mdi, EntityDescriptorType entityDescriptorType, MetadataLocal metadataLocal) {
        AttributeAuthorityDescriptorType attrAuthorityDescType = entityDescriptorType.addNewAttributeAuthorityDescriptor();
        attrAuthorityDescType.setProtocolSupportEnumeration(mdi.getProtocol().getProtoSupportList());
        EndpointType attrSvcType = attrAuthorityDescType.addNewAttributeService();
        String endpointPrefix = MetadataImportExportUtil.getEndpointPrefix(mdi);
        attrSvcType.setLocation(endpointPrefix + metadataLocal.getAttributeService());
        attrSvcType.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
    }

    private static void setSaml1xIdPEndpoints(IDPSSODescriptorType idpSsoDescType, Map<String, Object> pathParams, PathUtil pathUtil, MetaDataInfo mdi) {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        if (mdi.isIncludeArtifactEndpoint()) {
            IndexedEndpoints arss = new IndexedEndpoints();
            arss.setEndpoint(0, new Endpoint("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", localMetaData.getSaml1xSoapEndpoint()));
            MetadataImportExportUtil.setAbsoluteUrls(arss, pathParams, pathUtil, mdi);
            if (mdi.isUseSecondaryPortForSoapChannel()) {
                MetadataImportExportUtil.useSecondaryPort(arss, mdi);
            }
            idpSsoDescType.setArtifactResolutionServiceArray(EndpointUtil.toIndexedEndpointTypes(arss));
        }
        EndpointGroup ssoEnds = new EndpointGroup(new Endpoint("", localMetaData.getSaml1xIsxEndpoint()));
        EndpointGroup ssoEndpoints = MetadataImportExportUtil.applyBindingsRestriction(ssoEnds, mdi.getBindings());
        MetadataImportExportUtil.setAbsoluteUrls(ssoEndpoints, pathParams, pathUtil, mdi);
        idpSsoDescType.setSingleSignOnServiceArray(EndpointUtil.toEndpointTypes(ssoEndpoints));
    }

    private static void setSaml2IdPEndpoints(IDPSSODescriptorType idpSsoDescType, MetadataLocal metadataLocal, Map<String, Object> pathParams, PathUtil pathUtil, MetaDataInfo mdi) {
        IndexedEndpoints arss = metadataLocal.getIdpArtifactResolutionServices();
        if (arss != null && mdi.isIncludeArtifactEndpoint()) {
            MetadataImportExportUtil.setAbsoluteUrls(arss, pathParams, pathUtil, mdi);
            if (mdi.isUseSecondaryPortForSoapChannel()) {
                MetadataImportExportUtil.useSecondaryPort(arss, mdi);
            }
            idpSsoDescType.setArtifactResolutionServiceArray(EndpointUtil.toIndexedEndpointTypes(arss));
        }
        boolean SLOEnabled = mdi.getProfiles().isIdpInitiatedSLOEnabled() || mdi.getProfiles().isSpInitiatedSLOEnabled();
        boolean SSOEnabled = mdi.getProfiles().isSpInitiatedSSOEnabled();
        if (SLOEnabled && metadataLocal.getIdpSingleLogoutServices() != null) {
            EndpointGroup singleLogoutServices = metadataLocal.getIdpSingleLogoutServices();
            singleLogoutServices = MetadataImportExportUtil.applyBindingsRestriction(singleLogoutServices, mdi.getBindings());
            MetadataImportExportUtil.setAbsoluteUrls(singleLogoutServices, pathParams, pathUtil, mdi);
            idpSsoDescType.setSingleLogoutServiceArray(EndpointUtil.toEndpointTypes(singleLogoutServices));
        }
        if (SSOEnabled) {
            EndpointGroup ssoEndpoints = MetadataImportExportUtil.applyBindingsRestriction(metadataLocal.getSingleSignOnServices(), mdi.getBindings());
            MetadataImportExportUtil.setAbsoluteUrls(ssoEndpoints, pathParams, pathUtil, mdi);
            idpSsoDescType.setSingleSignOnServiceArray(EndpointUtil.toEndpointTypes(ssoEndpoints));
        }
    }

    private static void setSaml1xSpEndpoints(SPSSODescriptorType spSsoDescType, Map<String, Object> pathParams, PathUtil pathUtil, MetaDataInfo mdi) {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        IndexedEndpoints ssoEndpoints = new IndexedEndpoints();
        ssoEndpoints.setEndpoint(0, new Endpoint("urn:oasis:names:tc:SAML:1.0:profiles:browser-post", localMetaData.getSaml1xAcsEndpoint()));
        ssoEndpoints.setEndpoint(1, new Endpoint("urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", localMetaData.getSaml1xAcsEndpoint()));
        IndexedEndpoints acsEndpoints = MetadataImportExportUtil.applyBindingsRestriction(ssoEndpoints, mdi.getBindings());
        MetadataImportExportUtil.setAbsoluteUrls(acsEndpoints, pathParams, pathUtil, mdi);
        spSsoDescType.setAssertionConsumerServiceArray(EndpointUtil.toIndexedEndpointTypes(acsEndpoints));
    }

    private static void setSaml2SpEndpoints(SPSSODescriptorType spSsoDescType, MetadataLocal metadataLocal, boolean includeArtifact, Map<String, Object> pathParams, PathUtil pathUtil, MetaDataInfo mdi) {
        boolean SLOEnabled;
        IndexedEndpoints arss = metadataLocal.getSpArtifactResolutionServices();
        if (arss != null && includeArtifact) {
            MetadataImportExportUtil.setAbsoluteUrls(arss, pathParams, pathUtil, mdi);
            if (mdi.isUseSecondaryPortForSoapChannel()) {
                MetadataImportExportUtil.useSecondaryPort(arss, mdi);
            }
            spSsoDescType.setArtifactResolutionServiceArray(EndpointUtil.toIndexedEndpointTypes(arss));
        }
        boolean bl = SLOEnabled = mdi.getProfiles().isIdpInitiatedSLOEnabled() || mdi.getProfiles().isSpInitiatedSLOEnabled();
        if (SLOEnabled && metadataLocal.getSpSingleLogoutServices() != null) {
            EndpointGroup singleLogoutServices = metadataLocal.getSpSingleLogoutServices();
            singleLogoutServices = MetadataImportExportUtil.applyBindingsRestriction(singleLogoutServices, mdi.getBindings());
            MetadataImportExportUtil.setAbsoluteUrls(singleLogoutServices, pathParams, pathUtil, mdi);
            spSsoDescType.setSingleLogoutServiceArray(EndpointUtil.toEndpointTypes(singleLogoutServices));
        }
        IndexedEndpoints acsEndpoints = MetadataImportExportUtil.applyBindingsRestriction(metadataLocal.getAssertionConsumerServices(), mdi.getBindings());
        MetadataImportExportUtil.setAbsoluteUrls(acsEndpoints, pathParams, pathUtil, mdi);
        spSsoDescType.setAssertionConsumerServiceArray(EndpointUtil.toIndexedEndpointTypes(acsEndpoints));
    }

    private static void setEntityId(Protocol protocol, EntityDescriptorType entityDescriptorType, MetadataLocal metadataLocal) {
        switch (protocol) {
            case SAML10: 
            case SAML11: {
                entityDescriptorType.setEntityID(metadataLocal.getSaml1xId());
                break;
            }
            case SAML20: {
                entityDescriptorType.setEntityID(metadataLocal.getEntityId());
                break;
            }
        }
    }

    private static String makeEndpointPrefix(String systemUrl) {
        String retV = "";
        if (!StringUtils.isBlank((String)systemUrl) && (retV = systemUrl.trim()).length() > 0 && retV.charAt(retV.length() - 1) == '/') {
            retV = retV.substring(0, retV.length() - 1);
        }
        return retV;
    }

    private static void setAbsoluteUrls(Endpoints endpoints, Map<String, Object> pathParams, PathUtil pathUtil, MetaDataInfo mdi) {
        String endpointPrefix = MetadataImportExportUtil.getEndpointPrefix(mdi);
        for (Endpoint endpoint : endpoints.getEndpoints()) {
            String fullLocation = pathUtil.encodeParamMap(endpoint.getFullLocation(), pathParams);
            if (!endpoint.getFullLocation().startsWith("http")) {
                endpoint.setLocation(endpointPrefix + fullLocation);
                continue;
            }
            endpoint.setLocation(fullLocation);
        }
    }

    private static void useSecondaryPort(IndexedEndpoints arsEndpts, MetaDataInfo mdi) {
        String secondaryPort;
        Map<Integer, Endpoint> endpointsMap = arsEndpts.getEndpointsMap();
        Collection<Endpoint> endpoints = endpointsMap.values();
        String defaultEndpointPrefix = MetadataImportExportUtil.getEndpointPrefix(mdi);
        String primaryPort = PropertyInfo.getRuntimeHttpsPort();
        if (!StringUtils.isEmpty((String)primaryPort)) {
            primaryPort = primaryPort.trim();
        }
        if (!StringUtils.isEmpty((String)(secondaryPort = System.getProperty("pf.secondary.https.port")))) {
            secondaryPort = secondaryPort.trim();
        }
        if (!(StringUtils.isEmpty((String)defaultEndpointPrefix) || StringUtils.isEmpty((String)secondaryPort) || "-1".equals(secondaryPort) || "0".equals(secondaryPort) || StringUtils.isEmpty((String)primaryPort))) {
            for (Endpoint endpoint : endpoints) {
                String loc = endpoint.getLocation();
                endpoint.setLocation(loc.replaceFirst(primaryPort, secondaryPort));
            }
        }
    }

    private static String getEndpointPrefix(MetaDataInfo mdi) {
        String endpoint = null;
        endpoint = mdi.getVirtualHostName() != null ? BaseUrlUtil.getCurrentBaseUrl(MetaDataFactory.getLocalMetaData().getBaseUrl(), mdi.getVirtualHostName()) : BaseUrlUtil.getCurrentBaseUrl(MetaDataFactory.getLocalMetaData().getBaseUrl());
        return MetadataImportExportUtil.makeEndpointPrefix(endpoint);
    }

    private static EndpointGroup applyBindingsRestriction(EndpointGroup endpointGroup, IncomingBindings allowedBindings) {
        EndpointGroup retEndpointGroup = endpointGroup;
        if (allowedBindings != null) {
            Collection endpoints = endpointGroup.getEndpoints();
            retEndpointGroup = new EndpointGroup();
            ArrayList<Endpoint> newEndpoints = new ArrayList<Endpoint>();
            for (Endpoint endpoint : endpoints) {
                if (!allowedBindings.checkBinding(endpoint.getBinding())) continue;
                newEndpoints.add(endpoint);
            }
            retEndpointGroup.setEndpoints(newEndpoints);
        }
        return retEndpointGroup;
    }

    private static IndexedEndpoints applyBindingsRestriction(IndexedEndpoints endpoints, IncomingBindings allowedBindings) {
        IndexedEndpoints resultEndpoints = endpoints;
        if (allowedBindings != null) {
            resultEndpoints = new IndexedEndpoints();
            Map<Integer, Endpoint> map = endpoints.getEndpointsMap();
            Integer last = null;
            for (Map.Entry<Integer, Endpoint> entry : map.entrySet()) {
                Integer index = entry.getKey();
                Endpoint endpoint = entry.getValue();
                if (!allowedBindings.checkBinding(endpoint.getBinding())) continue;
                resultEndpoints.setEndpoint(index, endpoint);
                last = index;
            }
            Integer defaultIdx = endpoints.getDefaultIndex();
            if (defaultIdx != null && resultEndpoints.getEndpoint(defaultIdx) != null) {
                resultEndpoints.setDefault(defaultIdx);
            } else if (last != null) {
                resultEndpoints.setDefault(last);
            }
        }
        return resultEndpoints;
    }

    private static KeyDescriptorType addCert(SSODescriptorType ssoDescType, Cert cert, KeyTypes.Enum use) {
        KeyDescriptorType keyDescriptorType = ssoDescType.addNewKeyDescriptor();
        keyDescriptorType.setUse(use);
        KeyInfoType keyInfoType = keyDescriptorType.addNewKeyInfo();
        X509DataType x509DataType = keyInfoType.addNewX509Data();
        try {
            x509DataType.addX509Certificate(cert.getX509Certificate().getEncoded());
        }
        catch (CertificateEncodingException ex) {
            String msg = "Exception setting cert for " + use + " " + ex.getMessage();
            log.info((Object)msg);
            throw new MetadataExportException(msg, ex);
        }
        return keyDescriptorType;
    }

    private static void setEncryptionCert(SSODescriptorType ssoDescriptorType, Cert cert, String expectedEncryptionMethod) {
        KeyDescriptorType keyDescriptorType = MetadataImportExportUtil.addCert(ssoDescriptorType, cert, KeyTypes.ENCRYPTION);
        if (expectedEncryptionMethod != null) {
            keyDescriptorType.addNewEncryptionMethod().setAlgorithm(expectedEncryptionMethod);
        }
    }

    private static EndpointGroup filterByBinding(EndpointGroup endPoints, Protocol expectedProtocol, Set<String> excludeBindingSet) {
        EndpointGroup result = endPoints;
        Set<String> validBindingSet = MetadataImportExportUtil.getValidBindings(expectedProtocol, excludeBindingSet);
        result = MetadataImportExportUtil.filterIt(endPoints, validBindingSet);
        return result;
    }

    private static IndexedEndpoints filterByBinding(IndexedEndpoints indexedEndPoints, Protocol expectedProtocol, Set<String> excludeBindingSet) {
        IndexedEndpoints result = indexedEndPoints;
        Set<String> validBindingSet = MetadataImportExportUtil.getValidBindings(expectedProtocol, excludeBindingSet);
        result = MetadataImportExportUtil.filterIt(indexedEndPoints, validBindingSet);
        return result;
    }

    private static Set<String> getValidBindings(Protocol expectedProtocol, Set<String> excludeBindingSet) {
        HashSet<String> validBindingSet = new HashSet();
        if (expectedProtocol == Protocol.SAML10 || expectedProtocol == Protocol.SAML11) {
            validBindingSet = new HashSet<String>(Saml1xBindingURIs.getBindingSet());
        } else if (expectedProtocol == Protocol.SAML20) {
            validBindingSet = new HashSet<String>(BindingURIs.getBindingSet());
        }
        if (excludeBindingSet != null) {
            validBindingSet.removeAll(excludeBindingSet);
        }
        return validBindingSet;
    }

    private static IndexedEndpoints filterIt(IndexedEndpoints indexedEndPoints, Set<String> bindingUriSet) {
        IndexedEndpoints endPoints = new IndexedEndpoints();
        Integer firstValidBindingIndex = null;
        if (indexedEndPoints != null) {
            for (Map.Entry<Integer, Endpoint> entry : indexedEndPoints.getEndpointsMap().entrySet()) {
                Integer index = entry.getKey();
                Endpoint endpoint = entry.getValue();
                if (!bindingUriSet.contains(endpoint.getBinding())) continue;
                endPoints.setEndpoint(index, endpoint);
                if (firstValidBindingIndex != null) continue;
                firstValidBindingIndex = index;
            }
            Integer defaultIndex = indexedEndPoints.getDefaultIndex();
            if (defaultIndex != null && endPoints.getEndpoint(defaultIndex) != null) {
                endPoints.setDefault(defaultIndex);
            } else if (firstValidBindingIndex != null) {
                endPoints.setDefault(firstValidBindingIndex);
            }
        }
        return endPoints;
    }

    private static EndpointGroup filterIt(EndpointGroup endPointGrp, Set<String> bindingUriSet) {
        EndpointGroup filteredEndPoints = new EndpointGroup();
        if (endPointGrp != null) {
            ArrayList<Endpoint> list = new ArrayList<Endpoint>();
            for (Endpoint endpoint : endPointGrp.getEndpoints()) {
                if (!bindingUriSet.contains(endpoint.getBinding())) continue;
                list.add(endpoint);
            }
            filteredEndPoints.setEndpoints(list);
        }
        return filteredEndPoints;
    }

    public static GDuration getCachedUntil(GDuration localCachedDuration, Date connValidUntil) {
        Date curDate;
        Date metadtaValidUntil = null;
        Date localValidUntilDate = MetadataImportExportUtil.convertGdateToDate(localCachedDuration);
        GDuration cachedDuration = null;
        metadtaValidUntil = connValidUntil == null ? localValidUntilDate : (localValidUntilDate.after(connValidUntil) ? connValidUntil : localValidUntilDate);
        if (metadtaValidUntil != null && metadtaValidUntil.after(curDate = new Date())) {
            int millisecondsDiff = (int)(metadtaValidUntil.getTime() - curDate.getTime());
            cachedDuration = new GDuration(1, 0, 0, 0, 0, millisecondsDiff / 60000, 0, null);
        }
        return cachedDuration;
    }

    private static Date convertGdateToDate(GDuration gduration) {
        Calendar calender = Calendar.getInstance();
        GDate base = new GDate(calender);
        GDate localCacheGDate = base.add((GDurationSpecification)gduration);
        Date localCacheValidUntil = localCacheGDate.getDate();
        return localCacheValidUntil;
    }

    public static boolean allowAlternativeSigningCert(String primaryCertAlias, DSignRotationSettingsManager dSignRotaionManager) {
        DSignRotationSetting rotationSetting = dSignRotaionManager.getRotationSetting(primaryCertAlias);
        return rotationSetting == null || !rotationSetting.isEnableCertRotation();
    }

    public static enum ImportExpectedConnectionType {
        IDP,
        SP,
        ANY;

    }
}

