/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.websso.Protocol;

public class UpdateMetadataUtil {
    public static List<Endpoint> mergeSSOEndpoints(ConnectionBase sourceConnection, ConnectionBase metadataConnection, String sourceConnectionBaseURL, Protocol connectionProtocol) {
        List<Endpoint> mergedConnSSOEndpoints = new ArrayList<Endpoint>();
        if (sourceConnection instanceof IdpConnection) {
            IdpConnection sourceIdpConnection = (IdpConnection)sourceConnection;
            IdpConnection metadataIdpConnection = (IdpConnection)metadataConnection;
            HashSet<Endpoint> sourceConnSSOEndpoints = sourceIdpConnection.getSingleSignOnServices() != null ? sourceIdpConnection.getSingleSignOnServices().getEndpoints() : new HashSet();
            HashSet<Endpoint> metadataConnSSOEndpoints = metadataIdpConnection.getSingleSignOnServices() != null ? metadataIdpConnection.getSingleSignOnServices().getEndpoints() : new HashSet();
            mergedConnSSOEndpoints = UpdateMetadataUtil.mergeEndpoints(sourceConnSSOEndpoints, metadataConnSSOEndpoints, sourceConnectionBaseURL, connectionProtocol);
        }
        return mergedConnSSOEndpoints;
    }

    public static IndexedEndpoints mergeIndexedEndpoints(IndexedEndpoints sourceIndexedEndpoints, IndexedEndpoints metadataIndexedEndpoints, String sourceBaseURL) {
        Endpoint defaultEndpoint;
        IndexedEndpoints mergedConnEndpoints = new IndexedEndpoints();
        Map<Integer, Endpoint> metadataEndpoints = metadataIndexedEndpoints.getEndpointsMap();
        Integer metadataDefaulIndex = metadataIndexedEndpoints.getDefaultIndex();
        Integer srcDefaultIndex = sourceIndexedEndpoints.getDefaultIndex();
        Integer mergedDefaultIndex = null;
        Set<String> existingBindings = UpdateMetadataUtil.getConfiguredBindings(sourceIndexedEndpoints.getEndpoints());
        block0: for (Map.Entry<Integer, Endpoint> indexedMetadataEndpoint : metadataEndpoints.entrySet()) {
            Endpoint endpoint = indexedMetadataEndpoint.getValue();
            for (String existingBinding : existingBindings) {
                if (!endpoint.getBinding().equals(existingBinding)) continue;
                String location = UpdateMetadataUtil.updateEndpointDomain(sourceBaseURL, endpoint);
                endpoint.setLocation(location);
                mergedConnEndpoints.setEndpoint(indexedMetadataEndpoint.getKey(), endpoint);
                continue block0;
            }
        }
        if (metadataDefaulIndex != null) {
            mergedDefaultIndex = metadataDefaulIndex;
        } else if (srcDefaultIndex != null) {
            mergedDefaultIndex = srcDefaultIndex;
        }
        if (mergedDefaultIndex != null && (defaultEndpoint = mergedConnEndpoints.getEndpoint(mergedDefaultIndex)) != null) {
            mergedConnEndpoints.setDefault(mergedDefaultIndex);
        }
        return mergedConnEndpoints;
    }

    private static Set<String> getConfiguredBindings(Collection<Endpoint> sourceEndpoints) {
        HashSet<String> existingBindings = new HashSet<String>();
        for (Endpoint sourceEndpoint : sourceEndpoints) {
            existingBindings.add(sourceEndpoint.getBinding());
        }
        return existingBindings;
    }

    public static List<Endpoint> mergeEndpoints(Collection<Endpoint> sourceConnEndpoints, Collection<Endpoint> metadataConnEndpoints, String sourceBaseURL, Protocol connectionProtocol) {
        ArrayList<Endpoint> mergedConnEndpoints = new ArrayList<Endpoint>();
        Set<String> existingBindings = UpdateMetadataUtil.getConfiguredBindings(sourceConnEndpoints);
        block0: for (Endpoint metadataConnEndpoint : metadataConnEndpoints) {
            String metadataEndpointBinding = metadataConnEndpoint.getBinding();
            if (connectionProtocol.equals(Protocol.SAML20)) {
                for (String existingBinding : existingBindings) {
                    if (!existingBinding.equals(metadataEndpointBinding)) continue;
                    String metadataEndpointLocation = UpdateMetadataUtil.updateEndpointDomain(sourceBaseURL, metadataConnEndpoint);
                    metadataConnEndpoint.setLocation(metadataEndpointLocation);
                    mergedConnEndpoints.add(metadataConnEndpoint);
                    continue block0;
                }
                continue;
            }
            if (!connectionProtocol.equals(Protocol.SAML10) && !connectionProtocol.equals(Protocol.SAML11)) continue;
            String metadataEndpointLocation = UpdateMetadataUtil.updateEndpointDomain(sourceBaseURL, metadataConnEndpoint);
            if (!StringUtils.isEmpty((String)metadataEndpointLocation)) {
                metadataConnEndpoint.setLocation(metadataEndpointLocation);
            }
            mergedConnEndpoints.add(metadataConnEndpoint);
            break;
        }
        return mergedConnEndpoints;
    }

    private static String updateEndpointDomain(String sourceBaseURL, Endpoint metadataConnEndpoint) {
        String endpointLocation = metadataConnEndpoint.getLocation();
        boolean noBaseURL = StringUtils.isEmpty((String)sourceBaseURL);
        String metadataEndpointLocation = metadataConnEndpoint.getFullLocation();
        if (noBaseURL) {
            endpointLocation = metadataConnEndpoint.getFullLocation();
        } else if (!StringUtils.isEmpty((String)metadataEndpointLocation)) {
            if (metadataEndpointLocation.contains(sourceBaseURL)) {
                int indexOfCommonURL = metadataEndpointLocation.indexOf(sourceBaseURL);
                if (indexOfCommonURL == 0) {
                    endpointLocation = metadataEndpointLocation.substring(sourceBaseURL.length());
                }
            } else {
                endpointLocation = metadataConnEndpoint.getFullLocation();
            }
        }
        return endpointLocation;
    }
}

