/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util.api;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.util.api.ConversionToXmlSupport;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;

public class ConnectionSerializer {
    private Log log = LogFactory.getLog(this.getClass());
    private ConnectionBase connectionBase;
    private ConversionToXmlSupport conversionSupport = new ConversionToXmlSupport();

    public ConnectionSerializer(ConnectionBase connectionBase) {
        this.connectionBase = connectionBase;
    }

    public EntityDescriptorDocument serializeToXmlBean() {
        EntityDescriptorType entityDescType = this.conversionSupport.toEntityDescriptorType(this.connectionBase);
        EntityDescriptorDocument entityDescDoc = EntityDescriptorDocument.Factory.newInstance();
        entityDescDoc.setEntityDescriptor(entityDescType);
        return entityDescDoc;
    }

    public byte[] serializeToBytes() {
        EntityDescriptorDocument entityDescDoc = this.serializeToXmlBean();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            XmlOptions options = XmlBeansUtil.getXmlOptions();
            options.setSavePrettyPrint();
            entityDescDoc.save((OutputStream)os, options);
        }
        catch (IOException e) {
            this.log.error((Object)"IO Problem in serializeToBytes", (Throwable)e);
        }
        return os.toByteArray();
    }
}

