/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util.api;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.adapter.sp.authn.SpAuthenticationAdapter;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.util.api.ConversionSupport;
import org.sourceid.saml20.domain.util.api.SoapAuthSupport;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AltSigningKeyPairReferencesType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.C2CContractMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.C2CContractToAssertionMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.CertType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ConnectionModuleType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.DependenciesType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.DsigAliasesType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.EncryptionType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.EntityExtensionType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ExtensionsType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.KeyPairReferenceType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.PFIdpWsTrustRoleDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.PFSpWsTrustRoleDescriptorType;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.plugin.generate.TokenGenerator;
import org.sourceid.wstrust.plugin.process.TokenProcessor;

class ConversionFromXmlSupport
extends ConversionSupport {
    private final AdapterManager adapterManager = MgmtFactory.getAdapterManager();
    private final TokenGeneratorManager tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
    private final TokenProcessorManager tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
    private final C2cContractManager c2cContractManager = MgmtFactory.getC2cContractManager();
    private final List<String> problems;

    public ConversionFromXmlSupport(List<String> probs) {
        this.problems = probs;
    }

    public List<String> getProblems() {
        return this.problems;
    }

    @Override
    public ConnectionBase toConn(EntityDescriptorType entityDescriptorType) {
        ConnectionBase connectionBase = super.toConn(entityDescriptorType);
        DependenciesType dependenciesType = this.getDependenciesType(entityDescriptorType);
        this.readSoapAuthFromXml(dependenciesType, connectionBase);
        this.readModulesFromXml(dependenciesType, connectionBase);
        return connectionBase;
    }

    @Override
    protected void setSystemIdOnConn(ConnectionBase connBase, String id) {
    }

    private void readSoapAuthFromXml(DependenciesType dependenciesType, ConnectionBase conn) {
        if (dependenciesType.isSetSoapAuth()) {
            PkCertManager sslAuthPkCertManager = MgmtFactory.getSslAuthPkCertManager();
            PkCert outPkCert = this.getPkCert(dependenciesType.getSSLAuthKeyPairReference(), sslAuthPkCertManager);
            Cert inCert = this.getCert(dependenciesType.getSSLAuthVerificationCert());
            SoapAuthSupport soapAuthSupport = new SoapAuthSupport(dependenciesType.getSoapAuth(), inCert, outPkCert);
            SoapAuthInfo incoming = soapAuthSupport.getIncoming(this.SOAP_PROVIDER_ID);
            conn.setSoapAuthIn(incoming);
            SoapAuthInfo outgoing = soapAuthSupport.getOutgoing(this.SOAP_PROVIDER_ID);
            conn.setSoapAuthOut(outgoing);
        }
    }

    private void readModulesFromXml(DependenciesType dependenciesType, ConnectionBase conn) {
        ConnectionModuleType[] connectionModuleArray = dependenciesType.getConnectionModuleArray();
        if (connectionModuleArray != null && connectionModuleArray.length > 0) {
            ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
            for (ConnectionModuleType dataType : connectionModuleArray) {
                String configurationClassName = dataType.getModuleClass();
                ExtensionsType extensionsType = dataType.getData();
                ConnectionModuleConfiguration moduleConfiguration = moduleSupport.createConfigurationForImport(configurationClassName, extensionsType.toString(), conn.getRoleType(), conn.getEntityId());
                conn.addConnectionModuleConfiguration(moduleConfiguration);
            }
        }
    }

    @Override
    protected void processDigitialSignatureAliases(EntityDescriptorType entityDescriptorType, ConnectionBase connBase) {
        Cert secondary;
        DependenciesType dependenciesType = this.getDependenciesType(entityDescriptorType);
        KeyPairReferenceType signingKeyPairReference = dependenciesType.getSigningKeyPairReference();
        PkCert signingPkCert = this.getPkCert(signingKeyPairReference, MgmtFactory.getDsigPkCertManager());
        EntityExtensionType entityExtType = this.getEntityExtType(entityDescriptorType);
        DsigAliasesType dsigAliases = null;
        if (entityExtType != null) {
            dsigAliases = entityExtType.getDigitialSignatureAliases();
        }
        if (signingPkCert != null) {
            AltSigningKeyPairReferencesType altSigningKeyPairReferencesType;
            connBase.setSigningKeyAlias(signingPkCert.getAlias());
            connBase.setSigningKey(signingPkCert);
            connBase.setIncludeCertInXmlSigs(dsigAliases != null && dsigAliases.getIncludeX509InXmlSig());
            connBase.setIncludeRawKeyInXmlSigs(dsigAliases != null && dsigAliases.getIncludeRawKeyInXmlSig());
            if (dsigAliases != null && dsigAliases.getSigningAlgorithm() != null) {
                connBase.setSigningAlgorithm(dsigAliases.getSigningAlgorithm());
            }
            if ((altSigningKeyPairReferencesType = dependenciesType.getAltSigningKeyPairs()) != null) {
                for (KeyPairReferenceType altSigningKeyPair : altSigningKeyPairReferencesType.getAltSigningKeyPairReferenceArray()) {
                    PkCert altSigningPkCert = this.getPkCert(altSigningKeyPair, MgmtFactory.getDsigPkCertManager());
                    if (altSigningPkCert == null) continue;
                    connBase.addAltSigningKeyAlias(altSigningPkCert.getAlias(), altSigningPkCert);
                }
            }
        }
        ConnectionCerts dsigVerificationCerts = connBase.getDsigVerificationCerts();
        Cert primary = this.getCert(dependenciesType.getDsigVerificationCert());
        if (primary != null) {
            dsigVerificationCerts.setActiveVerificationCert(primary);
        }
        if ((secondary = this.getCert(dependenciesType.getSecondaryDsigVerificationCert())) != null) {
            dsigVerificationCerts.setSecondaryVerificationCert(secondary);
        }
    }

    @Override
    protected void getEncryptionKeysFromXml(EncryptionType encryptionType, EncryptionSettings encryptionSettings, EntityDescriptorType entityDescriptorType, Set<Cert> certs) {
        Cert encCert;
        PkCert secondaryDecryptPkCert;
        PkCertManager dsigPkCertManager = MgmtFactory.getDsigPkCertManager();
        DependenciesType dependenciesType = this.getDependenciesType(entityDescriptorType);
        KeyPairReferenceType decryptionKeyPairReference = dependenciesType.getDecryptionKeyPairReference();
        KeyPairReferenceType secondaryDecryptionKeyPairRef = dependenciesType.getSecondaryDecryptionKeyPairReference();
        PkCert decryptPkCert = this.getPkCert(decryptionKeyPairReference, dsigPkCertManager);
        if (decryptPkCert != null) {
            encryptionSettings.setDecryptionKeyAlias(decryptPkCert.getAlias());
            encryptionSettings.setDecryptionPkCert(decryptPkCert);
        }
        if ((secondaryDecryptPkCert = this.getPkCert(secondaryDecryptionKeyPairRef, dsigPkCertManager)) != null) {
            encryptionSettings.setSecondaryDecryptionKeyAlias(secondaryDecryptPkCert.getAlias());
            encryptionSettings.setSecondaryDecryptionPkCert(secondaryDecryptPkCert);
        }
        if ((encCert = this.getCert(dependenciesType.getEncryptionCert())) != null) {
            encryptionSettings.setEncryptionCert(encCert);
        }
    }

    private Cert getCert(CertType certType) {
        if (certType != null && certType.isSetBase64EncodedCert()) {
            byte[] bytes = certType.getBase64EncodedCert();
            try {
                return Cert.importCert(bytes);
            }
            catch (CertificateException e) {
                this.problems.add("Unable to import certificate " + e);
            }
        }
        return null;
    }

    private PkCert getPkCert(KeyPairReferenceType keyPairReferenceType, PkCertManager pkCertManager) {
        if (keyPairReferenceType != null && keyPairReferenceType.isSetMD5Fingerprint()) {
            String md5Fingerprint = keyPairReferenceType.getMD5Fingerprint();
            Set<PkCert> pkCerts = pkCertManager.getPkCerts();
            for (PkCert pkCert : pkCerts) {
                if (!pkCert.getFingerPrint(HashAlgorithm.MD5).equalsIgnoreCase(md5Fingerprint)) continue;
                return pkCert;
            }
            this.problems.add("No key pair found with a certificate matching md5 fingerprint of " + md5Fingerprint);
        }
        return null;
    }

    @Override
    protected void setDatasrcIdOnAttrSrc(AttributeSource attribSource, String dataSourceId) {
        super.setDatasrcIdOnAttrSrc(attribSource, dataSourceId);
        if (attribSource.getDataSource() == null) {
            this.problems.add("No datasource found with id: " + dataSourceId);
        }
    }

    @Override
    protected void setSpAdapterInstanceId(TargetAttributeMapping targetAttrMap, String adapterInstanceId) {
        super.setSpAdapterInstanceId(targetAttrMap, adapterInstanceId);
        SpAuthenticationAdapter spAuthnAdapter = this.adapterManager.getSpAuthnAdapter(adapterInstanceId);
        if (spAuthnAdapter == null && targetAttrMap.getConnectionOverrideInstance() == null) {
            this.problems.add("No SP adapter found for adapter instance ID: " + adapterInstanceId);
        }
    }

    @Override
    protected void setIdpAdapterInstanceID(AdapterToAssertionMapping adapterToAssertionMapping, String adapterInstanceId) {
        super.setIdpAdapterInstanceID(adapterToAssertionMapping, adapterInstanceId);
        IdpAuthenticationAdapter idpAuthnAdapter = this.adapterManager.getIdpAuthnAdapter(adapterInstanceId);
        if (idpAuthnAdapter == null && adapterToAssertionMapping.getConnectionOverrideInstance() == null) {
            this.problems.add("No IDP adapter found for adapter instance ID: " + adapterInstanceId);
        }
    }

    @Override
    protected void setC2cContractToAssertionMappingId(C2CContractToAssertionMappingType mappingType, C2cContractToAssertionMapping c2cContractToAssertionMapping) {
        String savedContractName;
        String savedContractId = mappingType.getC2CContractId();
        String contractId = this.findBestContractId(savedContractId, savedContractName = mappingType.getC2CContractName());
        if (contractId == null) {
            this.problems.add("No Authentication Policy Contract found with name: " + savedContractName);
        } else {
            c2cContractToAssertionMapping.setContractId(contractId);
        }
    }

    @Override
    protected void setC2cContractAttributeMappingId(C2CContractMappingType mappingType, C2cContractAttributeMapping mapping) {
        String savedContractName;
        String savedContractId = mappingType.getC2CContractId();
        String contractId = this.findBestContractId(savedContractId, savedContractName = mappingType.getC2CContractName());
        if (contractId == null) {
            this.problems.add("No Authentication Policy Contract found with name: " + savedContractName);
        } else {
            mapping.setContractId(contractId);
        }
    }

    private String findBestContractId(String savedContractId, String savedContractName) {
        if (savedContractId != null) {
            C2cContract contract = this.c2cContractManager.getContract(savedContractId);
            if (contract == null) {
                Collection<C2cContract> contracts = this.c2cContractManager.getContracts();
                for (C2cContract currContract : contracts) {
                    if (!currContract.getName().equals(savedContractName)) continue;
                    return currContract.getId();
                }
            } else {
                return savedContractId;
            }
        }
        return null;
    }

    @Override
    protected void fillWsTrustIdpSettings(SpConnection spConn, PFSpWsTrustRoleDescriptorType pfSpWsTrustRoleDescriptorType) {
        super.fillWsTrustIdpSettings(spConn, pfSpWsTrustRoleDescriptorType);
        for (TokenPluginAttributeMapping mapping : spConn.getWsTrustSettings().getTokenToAssertionMappings()) {
            String pluginId = mapping.getPluginId();
            TokenProcessor<SecurityToken> tokenProcessor = this.tokenProcessorManager.getTokenProcessor(mapping.getPluginId());
            if (tokenProcessor != null || mapping.getConnectionOverrideInstance() != null) continue;
            this.problems.add("No Token Processor found for token instance ID: " + pluginId);
        }
    }

    @Override
    protected void fillWsTrustSpSettings(IdpConnection idpConn, PFIdpWsTrustRoleDescriptorType idpWsTrustRoleDescriptorType) {
        super.fillWsTrustSpSettings(idpConn, idpWsTrustRoleDescriptorType);
        for (TokenPluginAttributeMapping mapping : idpConn.getWsTrustSettings().getAssertionToTokenMappingsMappings()) {
            String pluginId = mapping.getPluginId();
            TokenGenerator tokenGenerator = this.tokenGeneratorManager.getTokenGenerator(mapping.getPluginId());
            if (tokenGenerator != null || mapping.getConnectionOverrideInstance() != null) continue;
            this.problems.add("No Token Generator found for token instance ID: " + pluginId);
        }
    }

    @Override
    protected DependenciesType getDependenciesType(EntityExtensionType eext) {
        DependenciesType dependenciesType;
        if (eext == null) {
            String msg = "This looks like plain metadata xml because no EntityExtension element was found.  Only fully serialized PingFederate connections, not basic metadata, can be be imported via this mechanism.  Metadata obtained from partners should be imported during connection creation.";
            if (!this.problems.contains(msg)) {
                this.problems.add(msg);
            }
            dependenciesType = DependenciesType.Factory.newInstance();
        } else {
            dependenciesType = super.getDependenciesType(eext);
        }
        return dependenciesType;
    }
}

