/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util.api;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.config.soapauth.xml.SoapAuth;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.util.api.ConversionSupport;
import org.sourceid.saml20.domain.util.api.SoapAuthSupport;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AltSigningKeyPairReferencesType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.CertType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.DependenciesType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.DsigAliasesType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.EntityExtensionType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.KeyPairReferenceType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.RoleExtensionType;

class ConversionToXmlSupport
extends ConversionSupport {
    private Log log = LogFactory.getLog(this.getClass());

    ConversionToXmlSupport() {
    }

    public EntityDescriptorType toEntityDescriptorType(ConnectionBase conn) {
        EntityDescriptorType entityDescType = conn instanceof IdpConnection ? this.toEntityDescriptorType((IdpConnection)conn) : this.toEntityDescriptorType((SpConnection)conn);
        DependenciesType dependenciesType = this.getDependenciesType(entityDescType);
        this.writeSoapAuthToXml(dependenciesType, conn);
        return entityDescType;
    }

    private void writeSoapAuthToXml(DependenciesType dependenciesType, ConnectionBase conn) {
        SoapAuthInfo.CertAuthInfo certAuthInfo;
        SoapAuth soapAuth = dependenciesType.addNewSoapAuth();
        soapAuth.addNewIncoming();
        soapAuth.addNewOutgoing();
        SoapAuthSupport soapAuthSupport = new SoapAuthSupport(soapAuth);
        SoapAuthInfo soapAuthIn = conn.getSoapAuthIn();
        soapAuthIn.setEntityId(this.SOAP_PROVIDER_ID);
        soapAuthSupport.setIncoming(soapAuthIn);
        if (soapAuthIn.isHasCertEntry() && !(certAuthInfo = soapAuthIn.getCertAuthInfo()).isAnchored()) {
            X509Certificate x509 = certAuthInfo.getCert();
            this.setCert(new Cert(null, x509), dependenciesType.addNewSSLAuthVerificationCert());
        }
        SoapAuthInfo soapAuthOut = conn.getSoapAuthOut();
        soapAuthOut.setEntityId(this.SOAP_PROVIDER_ID);
        soapAuthSupport.setOutgoing(soapAuthOut);
        if (soapAuthOut.isHasCertEntry()) {
            SoapAuthInfo.CertAuthInfo certAuthInfo2 = soapAuthOut.getCertAuthInfo();
            PkCertManager sslAuthPkCertManager = MgmtFactory.getSslAuthPkCertManager();
            PkCert pkCert = sslAuthPkCertManager.getPkCert(certAuthInfo2.getAlias());
            this.setKeyPair(pkCert, dependenciesType.addNewSSLAuthKeyPairReference());
        }
    }

    @Override
    protected void setIdOnXmlBean(EntityDescriptorType entityDescriptorType, ConnectionBase connBase) {
    }

    @Override
    protected void setLastModOnXml(ConnectionBase connBase, RoleExtensionType roleExtensionType) {
    }

    @Override
    protected void fillInDsigAlias(EntityExtensionType eext, ConnectionBase connBase) {
        DsigAliasesType dsigAliasesType = eext.addNewDigitialSignatureAliases();
        String signingAlgorithm = connBase.getSigningAlgorithm();
        if (!StringUtils.isBlank((String)signingAlgorithm)) {
            dsigAliasesType.setSigningAlgorithm(signingAlgorithm);
        }
        dsigAliasesType.setIncludeX509InXmlSig(connBase.isIncludeCertInXmlSigs());
        dsigAliasesType.setIncludeRawKeyInXmlSig(connBase.isIncludeRawKeyInXmlSigs());
        DependenciesType depsType = this.getDependenciesType(eext);
        ConnectionCerts verifCerts = connBase.getDsigVerificationCerts();
        this.setCert(verifCerts.getActiveVerificationCert(), depsType.addNewDsigVerificationCert());
        this.setCert(verifCerts.getSecondaryVerificationCert(), depsType.addNewSecondaryDsigVerificationCert());
        this.setKeyPair(connBase.getSigningPkCert(), depsType.addNewSigningKeyPairReference());
        if (MapUtils.isNotEmpty(connBase.getAltSigningKeyAliasToCertMap())) {
            AltSigningKeyPairReferencesType altSigningKeyPairReferencesType = depsType.addNewAltSigningKeyPairs();
            for (Map.Entry<String, PkCert> altSigningKeyEntry : connBase.getAltSigningKeyAliasToCertMap().entrySet()) {
                PkCert altSigningCert = altSigningKeyEntry.getValue();
                if (altSigningCert == null) continue;
                this.setKeyPair(altSigningCert, altSigningKeyPairReferencesType.addNewAltSigningKeyPairReference());
            }
        }
    }

    private void setCert(Cert cert, CertType certType) {
        if (cert != null) {
            certType.setBase64EncodedCert(cert.getEncoded());
        }
    }

    private void setKeyPair(PkCert pkCert, KeyPairReferenceType keyPairRefType) {
        if (pkCert != null) {
            keyPairRefType.setMD5Fingerprint(pkCert.getFingerPrint(HashAlgorithm.MD5));
        }
    }

    @Override
    protected void fillInEncryptionAliases(EncryptionSettings encryptionSettings, EntityExtensionType eext) {
        DependenciesType dependenciesType = this.getDependenciesType(eext);
        this.setCert(encryptionSettings.getEncryptionCert(), dependenciesType.addNewEncryptionCert());
        this.setKeyPair(encryptionSettings.getDecryptionPkCert(), dependenciesType.addNewDecryptionKeyPairReference());
        this.setKeyPair(encryptionSettings.getSecondaryDecryptionPkCert(), dependenciesType.addNewSecondaryDecryptionKeyPairReference());
    }

    @Override
    protected void fillInModules(EntityExtensionType eext, ConnectionBase connBase) {
        ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
        DependenciesType dependenciesType = this.getDependenciesType(eext);
        moduleSupport.getConfigurationsForExport(dependenciesType, connBase.getEntityId(), connBase.getRoleType());
    }
}

