/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util.api.filesystem;

import com.pingidentity.common.util.SimpleFileUtil;
import com.pingidentity.common.util.TimerTaskBase;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.pingcommons.util.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.api.ConnectionMigrationMgr;

public class ConnectionImporter
extends TimerTaskBase {
    private Log log = LogFactory.getLog(this.getClass());
    private final SysDirInfo sysDirInfo = MgmtFactory.getSysDirInfo();
    public static final String CONN_DEPLOYER_DIR = "connection-deployer";
    private ConnectionMigrationMgr connectionMigrationMgr = new ConnectionMigrationMgr();

    @Override
    public void doTask() throws Exception {
        if (MgmtFactory.getAdminNodeConfigManager().isEnabledAndPassiveNode()) {
            return;
        }
        File dir = new File(this.sysDirInfo.getDataDirectory(), CONN_DEPLOYER_DIR);
        File[] files = dir.listFiles(f -> f.isFile() && f.getName().endsWith(".xml"));
        if (files != null && files.length > 0) {
            for (File f2 : files) {
                this.processFile(f2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFile(File file) {
        FileInputStream fis = null;
        try {
            this.log.info((Object)("Processing connection import/save from file " + file));
            fis = new FileInputStream(file);
            ConnectionBase conn = this.connectionMigrationMgr.saveConnection(fis, true);
            this.log.info((Object)(conn.getName() + " (name) " + conn.getEntityId() + " (entityId) saved from " + file));
        }
        catch (Exception e) {
            try {
                this.log.error((Object)("Unable to import/save connection from file " + file), (Throwable)e);
            }
            catch (Throwable throwable) {
                Closer.close(fis);
                SimpleFileUtil.renameWithDateExt(file);
                throw throwable;
            }
            Closer.close((Closeable)fis);
            SimpleFileUtil.renameWithDateExt(file);
        }
        Closer.close((Closeable)fis);
        SimpleFileUtil.renameWithDateExt(file);
    }
}

