/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util.filter;

import java.util.ArrayList;
import java.util.Collection;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.util.filter.FilterCriteria;

public class ConnectionFilter {
    private FilterCriteria criteria;

    public ConnectionFilter(FilterCriteria criteria) {
        this.criteria = criteria;
    }

    public Collection<ConnectionBase> filter(Collection<? extends ConnectionBase> conns) {
        ArrayList<ConnectionBase> filtered = new ArrayList<ConnectionBase>(conns.size());
        for (ConnectionBase connectionBase : conns) {
            boolean include = this.criteria.hasProtocol(connectionBase.getProtocol());
            include &= this.criteria.hasRole(connectionBase.getRoleType());
            include &= this.criteria.matchActive(connectionBase.isActive());
            boolean isAttributeQueryEnabled = false;
            if (connectionBase instanceof SpConnection) {
                isAttributeQueryEnabled = ((SpConnection)connectionBase).getAttributeRequester() != null;
            } else if (connectionBase instanceof IdpConnection) {
                isAttributeQueryEnabled = ((IdpConnection)connectionBase).getAttributeAuthority() != null;
            }
            EnabledProfiles enabledProfiles = connectionBase.getEnabledProfiles();
            include &= this.criteria.matchIdpInitSSO(enabledProfiles.isIdpInitiatedSSOEnabled());
            include &= this.criteria.matchSpInitSSO(enabledProfiles.isSpInitiatedSSOEnabled());
            if (!(include &= this.criteria.matchAttributeQuery(isAttributeQueryEnabled))) continue;
            filtered.add(connectionBase);
        }
        return filtered;
    }
}

