/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.util.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public class FilterCriteria {
    private Set<Protocol> protocols;
    private Set<Role> roles;
    private Boolean active;
    private Boolean idpInitSSO;
    private Boolean spInitSSO;
    private Boolean attributeQuery;

    public void setProtocols(Protocol ... protocols) {
        this.protocols = new HashSet<Protocol>(Arrays.asList(protocols));
    }

    public void setRoles(Role ... roles) {
        this.roles = new HashSet<Role>(Arrays.asList(roles));
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setIdpInitSSO(Boolean idpInitSSO) {
        this.idpInitSSO = idpInitSSO;
    }

    public void setSpInitSSO(Boolean spInitSSO) {
        this.spInitSSO = spInitSSO;
    }

    public void setAttributeQuery(Boolean attributeQuery) {
        this.attributeQuery = attributeQuery;
    }

    boolean matchActive(boolean isActive) {
        return this.matchBoolean(this.active, isActive);
    }

    boolean matchIdpInitSSO(boolean idpInit) {
        return this.matchBoolean(this.idpInitSSO, idpInit);
    }

    boolean matchSpInitSSO(boolean spInit) {
        return this.matchBoolean(this.spInitSSO, spInit);
    }

    boolean hasRole(Role role) {
        return this.roles == null || this.roles.contains((Object)role);
    }

    boolean hasProtocol(Protocol protocol) {
        return this.protocols == null || this.protocols.contains(protocol);
    }

    private boolean matchBoolean(Boolean b, boolean value) {
        return b == null || b == value;
    }

    boolean matchAttributeQuery(boolean query) {
        return this.matchBoolean(this.attributeQuery, query);
    }
}

