/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.validation;

import com.pingidentity.pingcommons.http.uri.HttpUri;
import com.pingidentity.pingcommons.http.uri.HttpUriFactory;
import com.pingidentity.pingcommons.http.uri.InvalidHttpUriException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ExpressionMatchHandler;
import org.sourceid.saml20.domain.RedirectValidationUriAllowlistEntry;
import org.sourceid.saml20.domain.UrlWhitelistEntry;
import org.sourceid.saml20.domain.WhitelistData;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.validation.RedirectValidation;
import org.sourceid.util.UriValidationUtil;

public class RedirectValidationImpl
implements RedirectValidation {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String WILDCARD = "*";
    private static final HttpUriFactory HTTP_URI_FACTORY = HttpUriFactory.createRedirectUriFactory((HttpUriFactory.Params)HttpUriFactory.DEFUALT_PARAMS);

    @Override
    public void doValidate(WhitelistData whitelistData, String validateMeUrl) throws InvalidRedirectValidationException {
        block15: {
            if (this.preValidateTarget(whitelistData, validateMeUrl)) {
                try {
                    URI targetUri = new URI(validateMeUrl);
                    String host = targetUri.getHost() != null ? targetUri.getHost().toLowerCase() : "";
                    String scheme = targetUri.getScheme() != null ? targetUri.getScheme().toLowerCase() : "";
                    UrlWhitelistEntry matchedEntry = null;
                    HashMap<String, UrlWhitelistEntry> matchedEntries = new HashMap<String, UrlWhitelistEntry>();
                    for (UrlWhitelistEntry entry : whitelistData.getEntries()) {
                        String domainPattern = entry.getValidDomain().toLowerCase();
                        boolean matchedDomain = false;
                        if (domainPattern.startsWith(WILDCARD)) {
                            if (host.endsWith(domainPattern.substring(WILDCARD.length()))) {
                                matchedDomain = true;
                            }
                        } else if (domainPattern.equals(host)) {
                            matchedDomain = true;
                        }
                        if (!matchedDomain) continue;
                        HttpUri entryUri = HTTP_URI_FACTORY.create("http://www.test.com" + entry.getValidPath());
                        if (!StringUtils.isBlank((String)entry.getValidPath()) && !Objects.equals(entryUri.getPath(), targetUri.getRawPath()) && (!"/".equals(entry.getValidPath()) || !StringUtils.isEmpty((String)targetUri.getRawPath())) || !entry.isAllowQueryAndFragment() && (!Objects.equals(entryUri.getQuery(), targetUri.getQuery()) || !Objects.equals(entryUri.getFragment(), targetUri.getFragment()))) continue;
                        matchedEntries.put(domainPattern, entry);
                    }
                    if (!matchedEntries.isEmpty()) {
                        ExpressionMatchHandler expressionMatcher = new ExpressionMatchHandler(matchedEntries.keySet(), false);
                        String bestMatchedDomain = expressionMatcher.getBestMatchedExpression(host);
                        if (((UrlWhitelistEntry)matchedEntries.get(bestMatchedDomain)).isRequireHttps() && !"https".equals(scheme)) {
                            throw new InvalidRedirectValidationException("Redirect Validation failed: https is required.");
                        }
                        matchedEntry = (UrlWhitelistEntry)matchedEntries.get(bestMatchedDomain);
                    }
                    RedirectValidationUriAllowlistEntry matchedUriEntry = null;
                    if (whitelistData.getRedirectValidationUriAllowlistEntries() != null) {
                        for (RedirectValidationUriAllowlistEntry entry : whitelistData.getRedirectValidationUriAllowlistEntries()) {
                            if (!UriValidationUtil.compareAsUris(validateMeUrl.toLowerCase(), entry.getValidUri().toLowerCase(), entry.isAllowQueryAndFragment(), entry.isAllowQueryAndFragment())) continue;
                            matchedUriEntry = entry;
                            break;
                        }
                    }
                    if (matchedEntry != null) {
                        this.log.debug((Object)("Redirect URL '" + validateMeUrl + "' matched whitelist entry " + matchedEntry));
                        break block15;
                    }
                    if (matchedUriEntry != null) {
                        this.log.debug((Object)("Redirect URI '" + validateMeUrl + "' matched allowlist entry " + matchedUriEntry));
                        break block15;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.format("Redirect Validation failed on %s.  ", validateMeUrl));
                    sb.append("It must match one of the defined domain/path patterns.");
                    this.log.error((Object)sb.toString());
                    throw new InvalidRedirectValidationException("Redirect link doesn't match any expected values.");
                }
                catch (InvalidHttpUriException e) {
                    throw new InvalidRedirectValidationException("Redirect Validation failed while executing: " + e);
                }
                catch (URISyntaxException e) {
                    throw new InvalidRedirectValidationException("Invalid redirect URI syntax: " + e);
                }
            }
        }
    }

    public boolean preValidateTarget(WhitelistData whitelistData, String validateMeUrl) {
        List<String> defaultURLs = whitelistData.getDefaultURLs();
        for (String defaultURL : defaultURLs) {
            if (!validateMeUrl.equals(defaultURL)) continue;
            return false;
        }
        return true;
    }
}

